/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.estate.daemon.PageContext;
import com.yqbsoft.laser.service.estate.dao.EstReportMapper;
import com.yqbsoft.laser.service.estate.model.EstReport;
import com.yqbsoft.laser.service.estate.service.EstPublicPoolService;
import com.yqbsoft.laser.service.estate.service.impl.Queue;
import com.yqbsoft.laser.service.estate.service.impl.semaphore.service.ExecuteRunnable;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CheckPublicPoolCustomerServiceImpl
extends BaseServiceImpl
implements ExecuteRunnable<EstReport> {
    private EstReportMapper estReportMapper;
    @Autowired
    private EstPublicPoolService estPublicPoolService;
    private Queue<EstReport> reportsQueue;

    public void setEstReportMapper(EstReportMapper estReportMapper) {
        this.estReportMapper = estReportMapper;
    }

    public Queue<EstReport> getReportsQueue() {
        return this.reportsQueue;
    }

    public void setReportsQueue(Queue<EstReport> reportsQueue) {
        this.reportsQueue = reportsQueue;
    }

    private void updateCheckCustomerRecyclingBatch(List<EstReport> extractionOrderReports) {
        try {
            for (EstReport report : extractionOrderReports) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("userCode", report.getUserCode());
                param.put("projectCode", report.getProjectCode());
                param.put("tenantCode", report.getTenantCode());
                this.estPublicPoolService.automaticInitPublicPool(param);
                param.put("reportCode", report.getReportCode());
                this.estPublicPoolService.batchCheckPublicPoolCustomer(param);
                this.logger.info("estate.CheckPublicPoolCustomerService.checkCustomerRecyclingBatch ThreadID: " + this.createUUIDString());
                this.logger.info("customerRecycling reportCode:" + report.getReportCode() + " / memberCode: " + report.getMemberCode());
            }
        }
        catch (Exception ex) {
            this.logger.error("CheckPublicPoolCustomerServiceImpl.updateCheckCustomerRecyclingBatch ex: " + ex);
        }
    }

    @Override
    public void setExecuteParm(Map<String, Object> parm) {
    }

    private List<EstReport> queryCheckRecyclingCustomerModel(Map<String, Object> pararm) {
        try {
            return this.estReportMapper.queryCheckRecyclingCustomer(pararm);
        }
        catch (Exception e) {
            this.logger.error("CheckPublicPoolCustomerServiceImpl.queryCheckRecyclingCustomerModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<EstReport> loadData(PageContext pageContext) {
        HashMap<String, Object> pararm = new HashMap<String, Object>();
        pararm.put("start", pageContext.getStart());
        pararm.put("rows", pageContext.getSize());
        List<EstReport> estReports = this.queryCheckRecyclingCustomerModel(pararm);
        if (ListUtil.isEmpty(estReports)) {
            return estReports;
        }
        return estReports;
    }

    @Override
    public void process(List<EstReport> dataList) {
        if (ListUtil.isEmpty(dataList)) {
            return;
        }
        this.updateCheckCustomerRecyclingBatch(dataList);
    }
}

