/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.estate.daemon.PageContext;
import com.yqbsoft.laser.service.estate.dao.EstReportMapper;
import com.yqbsoft.laser.service.estate.model.EstReport;
import com.yqbsoft.laser.service.estate.service.EstPublicPoolService;
import com.yqbsoft.laser.service.estate.service.impl.Queue;
import com.yqbsoft.laser.service.estate.service.impl.semaphore.service.ExecuteRunnable;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerRecyclingServiceImpl
extends BaseServiceImpl
implements ExecuteRunnable<EstReport> {
    private EstReportMapper estReportMapper;
    @Autowired
    private EstPublicPoolService estPublicPoolService;
    private Queue<EstReport> reportsQueue;
    int begin = 0;
    int end = 0;
    int size = 0;

    public void setEstReportMapper(EstReportMapper estReportMapper) {
        this.estReportMapper = estReportMapper;
    }

    public Queue<EstReport> getReportsQueue() {
        return this.reportsQueue;
    }

    public void setReportsQueue(Queue<EstReport> reportsQueue) {
        this.reportsQueue = reportsQueue;
    }

    public List<EstReport> extractionOrder(List<EstReport> estReports) {
        if (estReports == null || estReports.size() <= 0) {
            return null;
        }
        if (estReports != null && estReports.size() > 0) {
            for (EstReport estRep : estReports) {
                if (!StringUtils.isNotBlank((String)estRep.getRoleCode()) || !estRep.getRoleCode().equals("0001001")) continue;
                HashMap<String, String> parmMap = new HashMap<String, String>();
                parmMap.put("memberCode", estRep.getMemberCode());
                parmMap.put("projectCode", estRep.getProjectCode());
                parmMap.put("roleCode", "0001003");
            }
            return estReports;
        }
        return null;
    }

    @Transactional
    private void updateCustomerRecyclingBatch(List<EstReport> extractionOrderReports) {
        for (EstReport report : extractionOrderReports) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("userCode", report.getUserCode());
            param.put("projectCode", report.getProjectCode());
            param.put("tenantCode", report.getTenantCode());
            this.estPublicPoolService.automaticInitPublicPool(param);
            param.put("reportCode", report.getReportCode());
            this.estPublicPoolService.customerRecyclingMember(param);
            this.logger.info("estate.CustomerRecyclingService.updateCustomerRecyclingBatch ThreadID: " + this.createUUIDString());
            this.logger.info("customerRecycling reportCode:" + report.getReportCode() + " / memberCode: " + report.getMemberCode());
        }
        if (extractionOrderReports != null && extractionOrderReports.size() > 0) {
            this.customerRecyclingBatchUpdateModel(extractionOrderReports);
        }
    }

    private void customerRecyclingBatchUpdateModel(List<EstReport> extractionOrderReports) {
        if (extractionOrderReports == null) {
            return;
        }
        try {
            this.estReportMapper.customerRecyclingBatchUpdate(extractionOrderReports);
        }
        catch (Exception e) {
            throw new ApiException("CheckPublicPoolCustomerServiceImpl.updateAssigningHistoryModel.ex", (Throwable)e);
        }
    }

    @Override
    public void setExecuteParm(Map<String, Object> parm) {
        this.begin = Integer.valueOf(String.valueOf(parm.get("begin")));
        this.end = Integer.valueOf(String.valueOf(parm.get("end")));
        this.size = Integer.valueOf(String.valueOf(parm.get("size")));
    }

    @Override
    public List<EstReport> loadData(PageContext pageContext) {
        HashMap<String, Object> pararm = new HashMap<String, Object>();
        pararm.put("start", pageContext.getStart());
        pararm.put("rows", pageContext.getSize());
        List<EstReport> estReports = this.recyclingCustomerTestingModel(pararm);
        if (ListUtil.isEmpty(estReports)) {
            return estReports;
        }
        return estReports;
    }

    private List<EstReport> recyclingCustomerTestingModel(Map<String, Object> pararm) {
        try {
            return this.estReportMapper.recyclingCustomerTesting(pararm);
        }
        catch (Exception e) {
            this.logger.error("CustomerRecyclingServiceImpl.queryFlowLinkModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public void process(List<EstReport> dataList) {
        if (ListUtil.isEmpty(dataList)) {
            return;
        }
        this.updateCustomerRecyclingBatch(dataList);
    }
}

