/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstAssigningHistoryMapper;
import com.yqbsoft.laser.service.estate.domain.EstAssigningHistoryDomain;
import com.yqbsoft.laser.service.estate.model.EstAssigningHistory;
import com.yqbsoft.laser.service.estate.service.EstAssigningHistoryService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstAssigningHistoryServiceImpl
extends BaseServiceImpl
implements EstAssigningHistoryService {
    public static final String SYS_CODE = "estate.EstAssigningHistoryServiceImpl";
    private EstAssigningHistoryMapper estAssigningHistoryMapper;

    public void setEstAssigningHistoryMapper(EstAssigningHistoryMapper estAssigningHistoryMapper) {
        this.estAssigningHistoryMapper = estAssigningHistoryMapper;
    }

    private Date getSysDate() {
        try {
            return this.estAssigningHistoryMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstAssigningHistoryServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAssigningHistory(EstAssigningHistoryDomain estAssigningHistoryDomain) {
        if (estAssigningHistoryDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setAssigningHistoryDefault(EstAssigningHistory estAssigningHistory) {
        if (estAssigningHistory == null) {
            return;
        }
        if (estAssigningHistory.getDataState() == null) {
            estAssigningHistory.setDataState(0);
        }
        if (estAssigningHistory.getGmtCreate() == null) {
            estAssigningHistory.setGmtCreate(this.getSysDate());
        }
        estAssigningHistory.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estAssigningHistory.getAssigningHistoryCode())) {
            estAssigningHistory.setAssigningHistoryCode(this.createUUIDString());
        }
    }

    private int getAssigningHistoryMaxCode() {
        int code = 0;
        try {
            return this.estAssigningHistoryMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstAssigningHistoryServiceImpl.getAssigningHistoryMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAssigningHistoryUpdataDefault(EstAssigningHistory estAssigningHistory) {
        if (estAssigningHistory == null) {
            return;
        }
        estAssigningHistory.setGmtModified(this.getSysDate());
    }

    private void saveAssigningHistoryModel(EstAssigningHistory estAssigningHistory) throws ApiException {
        if (estAssigningHistory == null) {
            return;
        }
        try {
            this.estAssigningHistoryMapper.insert(estAssigningHistory);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.saveAssigningHistoryModel.ex", (Throwable)e);
        }
    }

    private EstAssigningHistory getAssigningHistoryModelById(Integer assigningHistoryId) {
        if (assigningHistoryId == null) {
            return null;
        }
        try {
            return this.estAssigningHistoryMapper.selectByPrimaryKey(assigningHistoryId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstAssigningHistoryServiceImpl.getAssigningHistoryModelById", (Throwable)e);
            return null;
        }
    }

    public EstAssigningHistory getAssigningHistoryModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estAssigningHistoryMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstAssigningHistoryServiceImpl.getAssigningHistoryModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delAssigningHistoryModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estAssigningHistoryMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.delAssigningHistoryModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.delAssigningHistoryModelByCode.num");
        }
    }

    private void deleteAssigningHistoryModel(Integer assigningHistoryId) throws ApiException {
        if (assigningHistoryId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estAssigningHistoryMapper.deleteByPrimaryKey(assigningHistoryId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.deleteAssigningHistoryModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.deleteAssigningHistoryModel.num");
        }
    }

    private void updateAssigningHistoryModel(EstAssigningHistory estAssigningHistory) throws ApiException {
        if (estAssigningHistory == null) {
            return;
        }
        try {
            this.estAssigningHistoryMapper.updateByPrimaryKeySelective(estAssigningHistory);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.updateAssigningHistoryModel.ex", (Throwable)e);
        }
    }

    private void updateStateAssigningHistoryModel(Integer assigningHistoryId, Integer dataState, Integer oldDataState) throws ApiException {
        if (assigningHistoryId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assigningHistoryId", assigningHistoryId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estAssigningHistoryMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.updateStateAssigningHistoryModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.updateStateAssigningHistoryModel.null");
        }
    }

    private EstAssigningHistory makeAssigningHistory(EstAssigningHistoryDomain estAssigningHistoryDomain, EstAssigningHistory estAssigningHistory) {
        if (estAssigningHistoryDomain == null) {
            return null;
        }
        if (estAssigningHistory == null) {
            estAssigningHistory = new EstAssigningHistory();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estAssigningHistory, (Object)estAssigningHistoryDomain);
            return estAssigningHistory;
        }
        catch (Exception e) {
            this.logger.error("estate.EstAssigningHistoryServiceImpl.makeAssigningHistory", (Throwable)e);
            return null;
        }
    }

    private List<EstAssigningHistory> queryAssigningHistoryModelPage(Map<String, Object> parammap) {
        try {
            return this.estAssigningHistoryMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstAssigningHistoryServiceImpl.queryAssigningHistoryModel", (Throwable)e);
            return null;
        }
    }

    private int countAssigningHistory(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estAssigningHistoryMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstAssigningHistoryServiceImpl.countAssigningHistory", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveAssigningHistory(EstAssigningHistoryDomain estAssigningHistoryDomain) throws ApiException {
        String msg = this.checkAssigningHistory(estAssigningHistoryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.saveAssigningHistory.checkAssigningHistory", msg);
        }
        EstAssigningHistory estAssigningHistory = this.makeAssigningHistory(estAssigningHistoryDomain, null);
        this.setAssigningHistoryDefault(estAssigningHistory);
        this.saveAssigningHistoryModel(estAssigningHistory);
    }

    @Override
    public void updateAssigningHistoryState(Integer assigningHistoryId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateAssigningHistoryModel(assigningHistoryId, dataState, oldDataState);
    }

    @Override
    public void updateAssigningHistory(EstAssigningHistoryDomain estAssigningHistoryDomain) throws ApiException {
        String msg = this.checkAssigningHistory(estAssigningHistoryDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.updateAssigningHistory.checkAssigningHistory", msg);
        }
        EstAssigningHistory oldEstAssigningHistory = this.getAssigningHistoryModelById(estAssigningHistoryDomain.getAssigningHistoryId());
        if (oldEstAssigningHistory == null) {
            throw new ApiException("estate.EstAssigningHistoryServiceImpl.updateAssigningHistory.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstAssigningHistory estAssigningHistory = this.makeAssigningHistory(estAssigningHistoryDomain, oldEstAssigningHistory);
        this.setAssigningHistoryUpdataDefault(estAssigningHistory);
        this.updateAssigningHistoryModel(estAssigningHistory);
    }

    @Override
    public EstAssigningHistory getAssigningHistory(Integer assigningHistoryId) {
        return this.getAssigningHistoryModelById(assigningHistoryId);
    }

    @Override
    public void deleteAssigningHistory(Integer assigningHistoryId) throws ApiException {
        this.deleteAssigningHistoryModel(assigningHistoryId);
    }

    @Override
    public QueryResult<EstAssigningHistory> queryAssigningHistoryPage(Map<String, Object> map) {
        List<EstAssigningHistory> estAssigningHistoryList = this.queryAssigningHistoryModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAssigningHistory(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estAssigningHistoryList);
        return queryResult;
    }

    @Override
    public EstAssigningHistory getAssigningHistoryByCode(Map<String, Object> map) {
        return this.getAssigningHistoryModelByCode(map);
    }

    @Override
    public void delAssigningHistoryByCode(Map<String, Object> map) throws ApiException {
        this.delAssigningHistoryModelByCode(map);
    }
}

