/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstCommissionMapper;
import com.yqbsoft.laser.service.estate.domain.EstCommissionDomain;
import com.yqbsoft.laser.service.estate.model.EstCommission;
import com.yqbsoft.laser.service.estate.service.EstCommissionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstCommissionServiceImpl
extends BaseServiceImpl
implements EstCommissionService {
    private static final String SYS_CODE = "estate.EstCommissionServiceImpl";
    private EstCommissionMapper estCommissionMapper;

    public void setEstCommissionMapper(EstCommissionMapper estCommissionMapper) {
        this.estCommissionMapper = estCommissionMapper;
    }

    private Date getSysDate() {
        try {
            return this.estCommissionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstCommissionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCommission(EstCommissionDomain estCommissionDomain) {
        if (estCommissionDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setCommissionDefault(EstCommission estCommission) {
        if (estCommission == null) {
            return;
        }
        if (estCommission.getDataState() == null) {
            estCommission.setDataState(0);
        }
        if (estCommission.getGmtCreate() == null) {
            estCommission.setGmtCreate(this.getSysDate());
        }
        estCommission.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estCommission.getCommissionCode())) {
            estCommission.setCommissionCode(this.createUUIDString());
        }
    }

    private int getCommissionMaxCode() {
        int code = 0;
        try {
            return this.estCommissionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstCommissionServiceImpl.getCommissionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCommissionUpdataDefault(EstCommission estCommission) {
        if (estCommission == null) {
            return;
        }
        estCommission.setGmtModified(this.getSysDate());
    }

    private void saveCommissionModel(EstCommission estCommission) throws ApiException {
        if (estCommission == null) {
            return;
        }
        try {
            this.estCommissionMapper.insert(estCommission);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCommissionServiceImpl.saveCommissionModel.ex", (Throwable)e);
        }
    }

    private EstCommission getCommissionModelById(Integer commissionId) {
        if (commissionId == null) {
            return null;
        }
        try {
            return this.estCommissionMapper.selectByPrimaryKey(commissionId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCommissionServiceImpl.getCommissionModelById", (Throwable)e);
            return null;
        }
    }

    public EstCommission getCommissionModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estCommissionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCommissionServiceImpl.getCommissionModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delCommissionModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estCommissionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCommissionServiceImpl.delCommissionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstCommissionServiceImpl.delCommissionModelByCode.num");
        }
    }

    private void deleteCommissionModel(Integer commissionId) throws ApiException {
        if (commissionId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estCommissionMapper.deleteByPrimaryKey(commissionId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCommissionServiceImpl.deleteCommissionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstCommissionServiceImpl.deleteCommissionModel.num");
        }
    }

    private void updateCommissionModel(EstCommission estCommission) throws ApiException {
        if (estCommission == null) {
            return;
        }
        try {
            this.estCommissionMapper.updateByPrimaryKeySelective(estCommission);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCommissionServiceImpl.updateCommissionModel.ex", (Throwable)e);
        }
    }

    private void updateStateCommissionModel(Integer commissionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (commissionId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commissionId", commissionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estCommissionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCommissionServiceImpl.updateStateCommissionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstCommissionServiceImpl.updateStateCommissionModel.null");
        }
    }

    private EstCommission makeCommission(EstCommissionDomain estCommissionDomain, EstCommission estCommission) {
        if (estCommissionDomain == null) {
            return null;
        }
        if (estCommission == null) {
            estCommission = new EstCommission();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estCommission, (Object)estCommissionDomain);
            return estCommission;
        }
        catch (Exception e) {
            this.logger.error("estate.EstCommissionServiceImpl.makeCommission", (Throwable)e);
            return null;
        }
    }

    private List<EstCommission> queryCommissionModelPage(Map<String, Object> parammap) {
        try {
            return this.estCommissionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCommissionServiceImpl.queryCommissionModel", (Throwable)e);
            return null;
        }
    }

    private int countCommission(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estCommissionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCommissionServiceImpl.countCommission", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveCommission(EstCommissionDomain estCommissionDomain) throws ApiException {
        String msg = this.checkCommission(estCommissionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstCommissionServiceImpl.saveCommission.checkCommission", msg);
        }
        EstCommission estCommission = this.makeCommission(estCommissionDomain, null);
        this.setCommissionDefault(estCommission);
        this.saveCommissionModel(estCommission);
        return estCommission.getCommissionCode();
    }

    @Override
    public void updateCommissionState(Integer commissionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCommissionModel(commissionId, dataState, oldDataState);
    }

    @Override
    public void updateCommission(EstCommissionDomain estCommissionDomain) throws ApiException {
        String msg = this.checkCommission(estCommissionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstCommissionServiceImpl.updateCommission.checkCommission", msg);
        }
        EstCommission oldEstCommission = this.getCommissionModelById(estCommissionDomain.getCommissionId());
        if (oldEstCommission == null) {
            throw new ApiException("estate.EstCommissionServiceImpl.updateCommission.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstCommission estCommission = this.makeCommission(estCommissionDomain, oldEstCommission);
        this.setCommissionUpdataDefault(estCommission);
        this.updateCommissionModel(estCommission);
    }

    @Override
    public EstCommission getCommission(Integer commissionId) {
        return this.getCommissionModelById(commissionId);
    }

    @Override
    public void deleteCommission(Integer commissionId) throws ApiException {
        this.deleteCommissionModel(commissionId);
    }

    @Override
    public QueryResult<EstCommission> queryCommissionPage(Map<String, Object> map) {
        List<EstCommission> estCommissionList = this.queryCommissionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCommission(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estCommissionList);
        return queryResult;
    }

    @Override
    public EstCommission getCommissionByCode(Map<String, Object> map) {
        return this.getCommissionModelByCode(map);
    }

    @Override
    public void delCommissionByCode(Map<String, Object> map) throws ApiException {
        this.delCommissionModelByCode(map);
    }
}

