/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.github.pagehelper.PageInfo;
import com.yqbsoft.laser.service.domain.client.pte.domian.RequestObject;
import com.yqbsoft.laser.service.domain.client.pte.domian.VdFaccountInner;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.dd.DdEntity;
import com.yqbsoft.laser.service.esb.core.dd.DdTransUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.EstateConstants;
import com.yqbsoft.laser.service.estate.dao.EstCustomerCapitalMapper;
import com.yqbsoft.laser.service.estate.domain.EstCustomerCapitalDomain;
import com.yqbsoft.laser.service.estate.model.EstCustomerCapital;
import com.yqbsoft.laser.service.estate.service.EstCustomerCapitalService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.time.DateUtils;

public class EstCustomerCapitalServiceImpl
extends BaseServiceImpl
implements EstCustomerCapitalService {
    public static final String SYS_CODE = "estate.EstCustomerCapitalServiceImpl";
    public static final String DDFALGSETTINGKEY = "DdFalgSetting-key";
    private EstCustomerCapitalMapper estCustomerCapitalMapper;

    public void setEstCustomerCapitalMapper(EstCustomerCapitalMapper estCustomerCapitalMapper) {
        this.estCustomerCapitalMapper = estCustomerCapitalMapper;
    }

    private Date getSysDate() {
        try {
            return this.estCustomerCapitalMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCustomerCapital(EstCustomerCapitalDomain estCustomerCapitalDomain) {
        if (estCustomerCapitalDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setCustomerCapitalDefault(EstCustomerCapital estCustomerCapital) {
        if (estCustomerCapital == null) {
            return;
        }
        if (estCustomerCapital.getDataState() == null) {
            estCustomerCapital.setDataState(0);
        }
        if (estCustomerCapital.getGmtCreate() == null) {
            estCustomerCapital.setGmtCreate(this.getSysDate());
        }
        estCustomerCapital.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estCustomerCapital.getCustomerCapitalCode())) {
            estCustomerCapital.setCustomerCapitalCode(this.createUUIDString());
        }
    }

    private int getCustomerCapitalMaxCode() {
        int code = 0;
        try {
            return this.estCustomerCapitalMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.getCustomerCapitalMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCustomerCapitalUpdataDefault(EstCustomerCapital estCustomerCapital) {
        if (estCustomerCapital == null) {
            return;
        }
        estCustomerCapital.setGmtModified(this.getSysDate());
    }

    private int saveCustomerCapitalModel(EstCustomerCapital estCustomerCapital) throws ApiException {
        if (estCustomerCapital == null) {
            return 0;
        }
        try {
            return this.estCustomerCapitalMapper.insert(estCustomerCapital);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.saveCustomerCapitalModel.ex", (Throwable)e);
        }
    }

    private EstCustomerCapital getCustomerCapitalModelById(Integer customerCapitalId) {
        if (customerCapitalId == null) {
            return null;
        }
        try {
            return this.estCustomerCapitalMapper.selectByPrimaryKey(customerCapitalId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.getCustomerCapitalModelById", (Throwable)e);
            return null;
        }
    }

    public EstCustomerCapital getCustomerCapitalModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estCustomerCapitalMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.getCustomerCapitalModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delCustomerCapitalModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estCustomerCapitalMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.delCustomerCapitalModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.delCustomerCapitalModelByCode.num");
        }
    }

    private void deleteCustomerCapitalModel(Integer customerCapitalId) throws ApiException {
        if (customerCapitalId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estCustomerCapitalMapper.deleteByPrimaryKey(customerCapitalId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.deleteCustomerCapitalModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.deleteCustomerCapitalModel.num");
        }
    }

    private int updateCustomerCapitalModel(EstCustomerCapital estCustomerCapital) throws ApiException {
        if (estCustomerCapital == null) {
            return 0;
        }
        try {
            return this.estCustomerCapitalMapper.updateByPrimaryKeySelective(estCustomerCapital);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.updateCustomerCapitalModel.ex", (Throwable)e);
        }
    }

    private int updateStateCustomerCapitalModel(Integer customerCapitalId, Integer dataState, Integer oldDataState) throws ApiException {
        if (customerCapitalId == null || dataState == null) {
            return 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerCapitalId", customerCapitalId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estCustomerCapitalMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.updateStateCustomerCapitalModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.updateStateCustomerCapitalModel.null");
        }
        return i;
    }

    private EstCustomerCapital makeCustomerCapital(EstCustomerCapitalDomain estCustomerCapitalDomain, EstCustomerCapital estCustomerCapital) {
        if (estCustomerCapitalDomain == null) {
            return null;
        }
        if (estCustomerCapital == null) {
            estCustomerCapital = new EstCustomerCapital();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estCustomerCapital, (Object)estCustomerCapitalDomain);
            return estCustomerCapital;
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.makeCustomerCapital", (Throwable)e);
            return null;
        }
    }

    private List<EstCustomerCapital> queryCustomerCapitalModelPage(Map<String, Object> parammap) {
        try {
            return this.estCustomerCapitalMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.queryCustomerCapitalModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<EstCustomerCapital> queryCustomerCapitalList(Map<String, Object> parammap) {
        return this.queryCustomerCapitalListModel(parammap);
    }

    private List<EstCustomerCapital> queryCustomerCapitalListModel(Map<String, Object> parammap) {
        try {
            return this.estCustomerCapitalMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.queryCustomerCapitalList", (Throwable)e);
            return null;
        }
    }

    private int countCustomerCapital(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estCustomerCapitalMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.countCustomerCapital", (Throwable)e);
        }
        return i;
    }

    @Override
    public Boolean saveCustomerCapital(EstCustomerCapitalDomain estCustomerCapitalDomain) throws ApiException {
        String msg = this.checkCustomerCapital(estCustomerCapitalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.saveCustomerCapital.checkCustomerCapital", msg);
        }
        EstCustomerCapital estCustomerCapital = this.makeCustomerCapital(estCustomerCapitalDomain, null);
        this.setCustomerCapitalDefault(estCustomerCapital);
        estCustomerCapital.setNextBatchUpdateDate(DateUtils.addDays((Date)new Date(), (int)1));
        int i = this.saveCustomerCapitalModel(estCustomerCapital);
        if (i > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean updateCustomerCapitalState(Integer customerCapitalId, Integer dataState, Integer oldDataState) throws ApiException {
        int i = this.updateStateCustomerCapitalModel(customerCapitalId, dataState, oldDataState);
        if (i > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean updateCustomerCapital(EstCustomerCapitalDomain estCustomerCapitalDomain) throws ApiException {
        String msg = this.checkCustomerCapital(estCustomerCapitalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.updateCustomerCapital.checkCustomerCapital", msg);
        }
        EstCustomerCapital oldEstCustomerCapital = this.getCustomerCapitalModelById(estCustomerCapitalDomain.getCustomerCapitalId());
        if (oldEstCustomerCapital == null) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.updateCustomerCapital.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstCustomerCapital estCustomerCapital = this.makeCustomerCapital(estCustomerCapitalDomain, oldEstCustomerCapital);
        this.setCustomerCapitalUpdataDefault(estCustomerCapital);
        int i = this.updateCustomerCapitalModel(estCustomerCapital);
        if (i > 0) {
            return true;
        }
        return false;
    }

    @Override
    public EstCustomerCapital getCustomerCapital(Integer customerCapitalId) {
        return this.getCustomerCapitalModelById(customerCapitalId);
    }

    @Override
    public void deleteCustomerCapital(Integer customerCapitalId) throws ApiException {
        this.deleteCustomerCapitalModel(customerCapitalId);
    }

    @Override
    public QueryResult<EstCustomerCapital> queryCustomerCapitalPage(Map<String, Object> map) {
        List<EstCustomerCapital> estCustomerCapitalList = this.queryCustomerCapitalModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCustomerCapital(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estCustomerCapitalList);
        return queryResult;
    }

    @Override
    public EstCustomerCapital getCustomerCapitalByCode(Map<String, Object> map) {
        return this.getCustomerCapitalModelByCode(map);
    }

    @Override
    public void delCustomerCapitalByCode(Map<String, Object> map) throws ApiException {
        this.delCustomerCapitalModelByCode(map);
    }

    @Override
    public QueryResult<Map<String, Object>> queryCapitalReserveInfo(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        PageInfo<Map<String, Object>> estCustomerCapitalPage = this.queryCapitalReserveInfoModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.valueOf(String.valueOf(estCustomerCapitalPage.getTotal())).intValue());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estCustomerCapitalPage.getList());
        return queryResult;
    }

    private PageInfo<Map<String, Object>> queryCapitalReserveInfoModel(Map<String, Object> map) {
        try {
            this.startPage(map);
            List<Map<String, Object>> mapList = this.estCustomerCapitalMapper.queryCapitalReserveInfo(map);
            return this.getPageInfo(mapList);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.queryCustomerCapitalModel", (Throwable)e);
            return null;
        }
    }

    private int countCapitalReserveInfoModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estCustomerCapitalMapper.countCapitalReserveInfo(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.countCapitalReserveInfoModel", (Throwable)e);
        }
        return i;
    }

    @Override
    public void batchFlushArrivalByoundDate() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Integer rcByoundContant = Integer.valueOf(DisUtil.getMap((String)DDFALGSETTINGKEY, (String)"00000000-estate-rcByoundContant"));
        Integer rgByoundContant = Integer.valueOf(DisUtil.getMap((String)DDFALGSETTINGKEY, (String)"00000000-estate-rgByoundContant"));
        Integer cjByoundContant = Integer.valueOf(DisUtil.getMap((String)DDFALGSETTINGKEY, (String)"00000000-estate-cjByoundContant"));
        Integer byoundUpdateNum = Integer.valueOf(DisUtil.getMap((String)DDFALGSETTINGKEY, (String)"00000000-estate-byoundUpdateNum"));
        Date date = new Date();
        map.put("nextBatchUpdateDate", DateUtil.getDateString((Date)date, (String)"yyyy-MM-dd"));
        map.put("dataState", 0);
        int count = this.countCustomerCapital(map);
        map.put("rcByoundContant", rcByoundContant);
        map.put("rgByoundContant", rgByoundContant);
        map.put("cjByoundContant", cjByoundContant);
        map.put("byoundUpdateNum", byoundUpdateNum);
        map.put("newNextBatchUpdateDate", DateUtil.getAfterDate((Date)date, (int)1, (String)"yyyy-MM-dd"));
        if (count > 0) {
            if (count / byoundUpdateNum > 0) {
                while (count > 0) {
                    this.batchFlushArrivalByoundDateModel(map);
                    count -= byoundUpdateNum.intValue();
                }
            } else {
                this.batchFlushArrivalByoundDateModel(map);
            }
        } else {
            this.logger.info("ImsgTaskServiceImpl.batchTransferToPushmsgHistory.\u65e0\u9700\u8981\u66f4\u65b0\u7684\u50ac\u7f34\u8bb0\u5f55");
        }
    }

    private int batchFlushArrivalByoundDateModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estCustomerCapitalMapper.batchFlushArrivalByoundDate(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.batchFlushArrivalByoundDateModel", (Throwable)e);
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.batchFlushArrivalByoundDateModel", "\u5ba2\u6237\u50ac\u7f34\u6a21\u5757\u6279\u91cf\u4fee\u6539\u8d85\u671f\u5929\u6570\u5931\u8d25");
        }
        if (i < 1) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.batchFlushArrivalByoundDateModel", "\u5ba2\u6237\u50ac\u7f34\u6a21\u5757\u6279\u91cf\u4fee\u6539\u8d85\u671f\u5929\u6570\u5931\u8d25-\u5f71\u54cd\u6570\u636e\u884c\u4e3a0");
        }
        return i;
    }

    @Override
    public Boolean updateCustomerCapitalStateByReserveUnitCode(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return false;
        }
        int success = this.updateCustomerCapitalStateByReserveUnitCodeModel(map);
        if (success < 1) {
            return false;
        }
        return true;
    }

    private int updateCustomerCapitalStateByReserveUnitCodeModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estCustomerCapitalMapper.updateCustomerCapitalStateByReserveUnitCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.updateCustomerCapitalStateByReserveUnitCodeModel", (Throwable)e);
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.updateCustomerCapitalStateByReserveUnitCodeModel", "\u4f63\u91d1\u6570\u636e\u72b6\u6001\u66f4\u65b0\u51fa\u9519");
        }
        return i;
    }

    private boolean transferCommission(Integer customerCapitalId) throws ApiException {
        int i = 0;
        try {
            i = this.updateStateCustomerCapitalModel(customerCapitalId, EstateConstants.ORDER_STATE_WAITINT, EstateConstants.ORDER_STATE_WAIT);
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.transferCommission", (Throwable)e);
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.transferCommission", "\u4f63\u91d1\u6570\u636e\u72b6\u6001\u66f4\u65b0\u51fa\u9519");
        }
        if (i == 0) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.transferCommission", "\u4f63\u91d1\u6570\u636e\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u5212\u8d26\u7ec8\u6b62");
        }
        EstCustomerCapital customerCapital = this.getCustomerCapital(customerCapitalId);
        String reserveUnitCode = customerCapital.getReserveUnitCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reserveUnitCode", reserveUnitCode);
        map.put("membership", 0);
        Object remark = "";
        List<Map<String, Object>> mapList = this.estCustomerCapitalMapper.queryCapitalReserveInfo(map);
        if (ListUtil.isNotEmpty(mapList)) {
            Map<String, Object> merber = mapList.get(0);
            remark = merber.get("memberName");
        }
        String userCode = customerCapital.getUserCode();
        String merberCode = "";
        String tenantCode = customerCapital.getTenantCode();
        BigDecimal shouldReceivables = BigDecimal.ZERO;
        if (StringUtils.isNotBlank((String)customerCapital.getUserCode())) {
            Map<String, Object> mbUserInfoMap = this.getMbUserInfoByBroker(userCode, tenantCode);
            merberCode = String.valueOf(mbUserInfoMap.get("merberCode"));
            shouldReceivables = customerCapital.getShouldReceivables();
            List ddList = DdTransUtil.getDdList((String)"EstCustomerCapital-fttp");
            if (ListUtil.isNotEmpty((Collection)ddList)) {
                for (DdEntity ddEntity : ddList) {
                    BigDecimal small = new BigDecimal(ddEntity.getDdValue());
                    BigDecimal big = new BigDecimal(ddEntity.getDdRemark());
                    BigDecimal fttp = new BigDecimal(ddEntity.getDdCode());
                    if (small == null || big == null || fttp == null || shouldReceivables.compareTo(small) <= 0 || shouldReceivables.compareTo(big) > 0) continue;
                    BigDecimal bigDecimal = new BigDecimal(1);
                    shouldReceivables = shouldReceivables.multiply(bigDecimal.subtract(fttp));
                    break;
                }
            }
        }
        if (StringUtils.isBlank((String)merberCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.transferCommission", "\u83b7\u53d6\u7ecf\u7eaa\u4eba\u5931\u8d25\uff0c\u4f63\u91d1\u8f6c\u7ed3\u4f59\u7ec8\u6b62");
        }
        boolean flag = false;
        try {
            String faccountInner = this.getFaccountInnerByCode("925", tenantCode);
            ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
            RequestObject obj = new RequestObject();
            obj.setUserCode(faccountInner);
            obj.setFaccountId(faccountInner);
            obj.setFchannelCode("0" + "925".substring(0, 1));
            obj.setFchannelClassifyCode("925");
            obj.setMoney(shouldReceivables);
            obj.setTenantCode(tenantCode);
            obj.setPartnerCode(merberCode);
            obj.setUserPcode(merberCode);
            obj.setRequestType("04");
            obj.setRemark("\u63a8\u8350\u5ba2\u6237\uff1a" + remark);
            paramMap.put("requestObject", JsonUtil.buildNormalBinder().toJson((Object)obj));
            String ptradeSeqno = this.internalInvoke("pte.ptrade.saveTransfer", paramMap);
            paramMap.clear();
            paramMap.put("tenantCode", tenantCode);
            paramMap.put("ptradeSeqno", ptradeSeqno);
            String successState = DisUtil.getMap((String)DDFALGSETTINGKEY, (String)"00000000-pte-ptradeSuccess");
            if (StringUtils.isBlank((String)successState)) {
                successState = "3,4,5";
            }
            paramMap.put("dataState", successState);
            String checkFlag = this.internalInvoke("pte.ptrade.checkPtradeSuccess", paramMap);
            if ("true".equals(checkFlag)) {
                this.logger.debug(SYS_CODE, (Object)"pte.ptrade.saveTransfer success");
                flag = true;
            } else {
                this.logger.debug(SYS_CODE, (Object)"pte.ptrade.saveTransfer fail");
            }
            if (flag) {
                this.updateFttpCustomerCapitalModel(customerCapitalId, EstateConstants.ORDER_STATE_SUCCESS, EstateConstants.ORDER_STATE_WAITINT, shouldReceivables);
                return flag;
            }
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.marketingOrderService.updateMarketingOrderState", "\u8d44\u91d1\u72b6\u6001\u66f4\u65b0\u51fa\u9519\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c");
        }
        catch (ApiException e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.transferCommission", (Object)e.getMessage());
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.transferCommission", "\u4f63\u91d1\u8f6c\u7ed3\u4f59\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u64cd\u4f5c");
        }
    }

    private String getFaccountInnerByCode(String faccountType, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", tenantCode);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(pmap));
        String result = this.internalInvoke("vd.faccountInner.queryFaccountInnerList", postParm);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!");
        }
        List vdFaccountInner = (List)JsonUtil.buildNormalBinder().getJsonToList(result, VdFaccountInner.class);
        if (ListUtil.isEmpty((Collection)vdFaccountInner)) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.savePtrade.setMerchant", (Object)"\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!");
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.savePtrade.setMerchant", "\u672a\u67e5\u8be2\u5230\u8d26\u6237\u4fe1\u606f!");
        }
        return ((VdFaccountInner)vdFaccountInner.get(0)).getFaccountInnerNo();
    }

    private int updateFttpCustomerCapitalModel(Integer customerCapitalId, Integer dataState, Integer oldDataState, BigDecimal preTaxAmount) throws ApiException {
        if (customerCapitalId == null || dataState == null) {
            return 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customerCapitalId", customerCapitalId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("preTaxAmount", preTaxAmount);
        int i = 0;
        try {
            i = this.estCustomerCapitalMapper.updateFttpCustomerCapital(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.updateFttpCustomerCapitalModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstCustomerCapitalServiceImpl.updateFttpCustomerCapitalModel.null");
        }
        return i;
    }

    private Map<String, Object> getMbUserInfoByBroker(String mbuserCode, String tenantCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("mbuserCode", mbuserCode);
        parmMap.put("dataState", 0);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("mm.merber.getMbuserByCode", postParm);
        Map teamInfoMaps = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
        if (teamInfoMaps == null) {
            return null;
        }
        return teamInfoMaps;
    }

    @Override
    public Boolean updateCustomerCapitalCommission(Integer customerCapitalId) throws ApiException {
        if (customerCapitalId == null) {
            return false;
        }
        boolean success = this.transferCommission(customerCapitalId);
        return success;
    }

    @Override
    public List<Map<String, Object>> getCustomerCapitalGroup(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        List<Map<String, Object>> mapList = this.countCustomerCapitalModel(map);
        return mapList;
    }

    private List<Map<String, Object>> countCustomerCapitalModel(Map<String, Object> map) {
        try {
            List<Map<String, Object>> mapList = this.estCustomerCapitalMapper.countCustomerCapital(map);
            return mapList;
        }
        catch (Exception e) {
            this.logger.error("estate.EstCustomerCapitalServiceImpl.queryCustomerCapitalModel", (Throwable)e);
            return null;
        }
    }
}

