/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.EstateConstants;
import com.yqbsoft.laser.service.estate.dao.EstFlowLinkMapper;
import com.yqbsoft.laser.service.estate.dao.EstReserveUnitMapper;
import com.yqbsoft.laser.service.estate.domain.EstCustomerCapitalDomain;
import com.yqbsoft.laser.service.estate.domain.EstFlowLinkDomain;
import com.yqbsoft.laser.service.estate.domain.EstIntentionDomain;
import com.yqbsoft.laser.service.estate.domain.EstStateDomain;
import com.yqbsoft.laser.service.estate.model.EstCustomerCapital;
import com.yqbsoft.laser.service.estate.model.EstFlowLink;
import com.yqbsoft.laser.service.estate.model.EstIntention;
import com.yqbsoft.laser.service.estate.model.EstPaymentDetails;
import com.yqbsoft.laser.service.estate.model.EstReserveUnit;
import com.yqbsoft.laser.service.estate.model.UserBean;
import com.yqbsoft.laser.service.estate.service.EstCustomerCapitalService;
import com.yqbsoft.laser.service.estate.service.EstFlowLinkService;
import com.yqbsoft.laser.service.estate.service.EstIntentionService;
import com.yqbsoft.laser.service.estate.service.EstPaymentDetailsService;
import com.yqbsoft.laser.service.estate.service.EstReportService;
import com.yqbsoft.laser.service.estate.service.EstStateService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class EstFlowLinkServiceImpl
extends BaseServiceImpl
implements EstFlowLinkService {
    public static final String SYS_CODE = "estate.EstFlowLinkServiceImpl";
    private EstFlowLinkMapper estFlowLinkMapper;
    @Autowired
    private EstPaymentDetailsService estPaymentDetailsService;
    @Autowired
    private EstReserveUnitMapper estReserveUnitMapper;
    @Autowired
    private EstIntentionService estIntentionService;
    @Autowired
    private EstCustomerCapitalService estCustomerCapitalService;
    @Autowired
    private EstReportService estReportService;
    @Autowired
    private EstStateService estStateService;

    public void setEstFlowLinkMapper(EstFlowLinkMapper estFlowLinkMapper) {
        this.estFlowLinkMapper = estFlowLinkMapper;
    }

    private Date getSysDate() {
        try {
            return this.estFlowLinkMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFlowLink(EstFlowLinkDomain estFlowLinkDomain) {
        if (estFlowLinkDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFlowLinkDefault(EstFlowLink estFlowLink) {
        if (estFlowLink == null) {
            return;
        }
        if (estFlowLink.getDataState() == null) {
            estFlowLink.setDataState(0);
        }
        if (estFlowLink.getGmtCreate() == null) {
            estFlowLink.setGmtCreate(this.getSysDate());
        }
        estFlowLink.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estFlowLink.getFlowLinkCode())) {
            estFlowLink.setFlowLinkCode(this.createUUIDString());
        }
    }

    private int getFlowLinkMaxCode() {
        int code = 0;
        try {
            return this.estFlowLinkMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.getFlowLinkMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFlowLinkUpdataDefault(EstFlowLink estFlowLink) {
        if (estFlowLink == null) {
            return;
        }
        estFlowLink.setGmtModified(this.getSysDate());
    }

    private void saveFlowLinkModel(EstFlowLink estFlowLink) throws ApiException {
        if (estFlowLink == null) {
            return;
        }
        try {
            this.estFlowLinkMapper.insert(estFlowLink);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.saveFlowLinkModel.ex", (Throwable)e);
        }
    }

    private EstFlowLink getFlowLinkModelById(Integer flowLinkId) {
        if (flowLinkId == null) {
            return null;
        }
        try {
            return this.estFlowLinkMapper.selectByPrimaryKey(flowLinkId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.getFlowLinkModelById", (Throwable)e);
            return null;
        }
    }

    public EstFlowLink getFlowLinkModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estFlowLinkMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.getFlowLinkModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFlowLinkModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estFlowLinkMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.delFlowLinkModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.delFlowLinkModelByCode.num");
        }
    }

    private void deleteFlowLinkModel(Integer flowLinkId) throws ApiException {
        if (flowLinkId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estFlowLinkMapper.deleteByPrimaryKey(flowLinkId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.deleteFlowLinkModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.deleteFlowLinkModel.num");
        }
    }

    private void updateFlowLinkModel(EstFlowLink estFlowLink) throws ApiException {
        if (estFlowLink == null) {
            return;
        }
        try {
            this.estFlowLinkMapper.updateByPrimaryKeySelective(estFlowLink);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.updateFlowLinkModel.ex", (Throwable)e);
        }
    }

    private void updateStateFlowLinkModel(Integer flowLinkId, Integer dataState, Integer oldDataState) throws ApiException {
        if (flowLinkId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowLinkId", flowLinkId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estFlowLinkMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.updateStateFlowLinkModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.updateStateFlowLinkModel.null");
        }
    }

    private EstFlowLink makeFlowLink(EstFlowLinkDomain estFlowLinkDomain, EstFlowLink estFlowLink) {
        if (estFlowLinkDomain == null) {
            return null;
        }
        if (estFlowLink == null) {
            estFlowLink = new EstFlowLink();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estFlowLink, (Object)estFlowLinkDomain);
            return estFlowLink;
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.makeFlowLink", (Throwable)e);
            return null;
        }
    }

    private List<EstFlowLink> queryFlowLinkModelPage(Map<String, Object> parammap) {
        try {
            return this.estFlowLinkMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.queryFlowLinkModel", (Throwable)e);
            return null;
        }
    }

    private int countFlowLink(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estFlowLinkMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.countFlowLink", (Throwable)e);
        }
        return i;
    }

    @Override
    public EstFlowLink saveFlowLink(EstFlowLinkDomain estFlowLinkDomain) throws ApiException {
        String msg = this.checkFlowLink(estFlowLinkDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.saveFlowLink.checkFlowLink", msg);
        }
        EstFlowLink estFlowLink = this.makeFlowLink(estFlowLinkDomain, null);
        this.setFlowLinkDefault(estFlowLink);
        this.saveFlowLinkModel(estFlowLink);
        return estFlowLink;
    }

    @Override
    public void updateFlowLinkState(Integer flowLinkId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFlowLinkModel(flowLinkId, dataState, oldDataState);
    }

    @Override
    public void updateFlowLink(EstFlowLinkDomain estFlowLinkDomain) throws ApiException {
        String msg = this.checkFlowLink(estFlowLinkDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.updateFlowLink.checkFlowLink", msg);
        }
        EstFlowLink oldEstFlowLink = this.getFlowLinkModelById(estFlowLinkDomain.getFlowLinkId());
        if (oldEstFlowLink == null) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.updateFlowLink.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstFlowLink estFlowLink = this.makeFlowLink(estFlowLinkDomain, oldEstFlowLink);
        this.setFlowLinkUpdataDefault(estFlowLink);
        this.updateFlowLinkModel(estFlowLink);
    }

    @Override
    public EstFlowLink getFlowLink(Integer flowLinkId) {
        return this.getFlowLinkModelById(flowLinkId);
    }

    @Override
    public void deleteFlowLink(Integer flowLinkId) throws ApiException {
        this.deleteFlowLinkModel(flowLinkId);
    }

    @Override
    public QueryResult<EstFlowLink> queryFlowLinkPage(Map<String, Object> map) {
        List<EstFlowLink> estFlowLinkList = this.queryFlowLinkModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFlowLink(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estFlowLinkList);
        return queryResult;
    }

    @Override
    public EstFlowLink getFlowLinkByCode(Map<String, Object> map) {
        return this.getFlowLinkModelByCode(map);
    }

    @Override
    public void delFlowLinkByCode(Map<String, Object> map) throws ApiException {
        this.delFlowLinkModelByCode(map);
    }

    @Override
    public void transferApplyFor(Map<String, Object> map) {
        this.approvalStatusUpdate(map);
    }

    @Override
    public void approvalThrough(Map<String, Object> map) {
        this.approvalStatusUpdate(map);
    }

    @Override
    public void approvalReject(Map<String, Object> map) {
        this.approvalStatusUpdate(map);
    }

    private void approvalStatusUpdate(Map<String, Object> map) {
        try {
            String flowLinkCode = (String)map.get("flowLinkCode");
            Integer approvalStatus = Integer.parseInt(String.valueOf(map.get("approvalStatus")));
            String userCode = (String)map.get("userCode");
            String userName = (String)map.get("userName");
            String approvalDateTime = (String)map.get("approvalDateTime");
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("flowLinkCode", flowLinkCode);
            EstFlowLink estFlowLink = this.getFlowLinkByCode(parmMap);
            if (estFlowLink == null) {
                throw new ApiException("estate.EstFlowLinkServiceImpl.approvalStatusUpdate.estFlowLink=null", "\u6570\u636e\u4e3a\u7a7a");
            }
            parmMap = new HashMap();
            parmMap.put("reserveUnitCode", estFlowLink.getReserveUnitCode());
            parmMap.put("tenantCode", estFlowLink.getTenantCode());
            EstReserveUnit estReserveUnit = this.estReserveUnitMapper.getByCode(parmMap);
            if (StringUtils.isNotBlank((String)userCode) && StringUtils.isNotBlank((String)userName) && StringUtils.isNotBlank((String)approvalDateTime)) {
                estFlowLink.setUserCode(userCode);
                estFlowLink.setUserName(userName);
                estFlowLink.setAuditDate(DateUtil.getDateToString((String)approvalDateTime, (String)"yyyyMMdd hhmmss"));
            }
            estFlowLink.setApprovalStatus(approvalStatus);
            this.setAuditorByNodeCode(flowLinkCode, estFlowLink);
            if ((estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.RETREAT_REGISTRATION.getFlowLinkType()) || estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.RETREAT_SUBSCRIPTION.getFlowLinkType()) || estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.RETREAT_DEAL.getFlowLinkType())) && estFlowLink.getApprovalStatus().equals(EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_THROUGH.getApprovalStatus())) {
                if (this.forIfUnlockHouseUpdate(estReserveUnit)) {
                    this.unlockHouseUpdate(estReserveUnit, estFlowLink.getTenantCode());
                    estReserveUnit.setDataState(0);
                    this.estReserveUnitMapper.updateByPrimaryKey(estReserveUnit);
                }
                this.forIfWithdrawalUpdate(estReserveUnit);
            }
            this.updateFlowLinkModel(estFlowLink);
            this.changeIntentionContent(approvalStatus, estFlowLink, estReserveUnit);
            this.riseApplyForRefuse(estFlowLink, estReserveUnit);
            if (this.forIfUnlockHouseUpdate(estReserveUnit) && estFlowLink.getApprovalStatus().equals(EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_REJECT.getApprovalStatus())) {
                this.unlockHouseUpdate(estReserveUnit, estFlowLink.getTenantCode());
            }
            this.saveCapitalRecord(userName, estFlowLink, estReserveUnit);
        }
        catch (Exception ex) {
            this.logger.error("approvalStatusUpdate.", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    @Override
    public void executeCapitalRecordRepair(Map<String, Object> map) {
        try {
            String reserveUnitCode = (String)map.get("reserveUnitCode");
            String tenantCode = (String)map.get("tenantCode");
            if (StringUtils.isBlankLoop((String[])new String[]{reserveUnitCode, tenantCode})) {
                throw new ApiException("estate.EstFlowLinkServiceImpl.executeCapitalRecordRepair.map=null", "\u6570\u636e\u4e3a\u7a7a");
            }
            EstReserveUnit estReserveUnit = this.getReserveUnitByCode(reserveUnitCode, tenantCode);
            if (estReserveUnit == null) {
                return;
            }
            String userCode = estReserveUnit.getUserCode();
            UserBean userBean = this.getUser(userCode, estReserveUnit.getTenantCode());
            String userName = userBean.getUserRelname();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("reserveUnitCode", reserveUnitCode);
            param.put("approvalStatus", EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_THROUGH.getApprovalStatus());
            param.put("tenantCode", tenantCode);
            List<EstFlowLink> estFlowLinkList = this.queryApproveThroughFLinkModel(param);
            if (ListUtil.isEmpty(estFlowLinkList)) {
                return;
            }
            for (EstFlowLink estFlowLink : estFlowLinkList) {
                this.saveCapitalRecord(userName, estFlowLink, estReserveUnit);
            }
        }
        catch (Exception ex) {
            this.logger.error("estate.EstFlowLinkServiceImpl.executeCapitalRecordRepair.ex", (Throwable)ex);
            throw new ApiException("estate.EstFlowLinkServiceImpl.executeCapitalRecordRepair.ex", (Throwable)ex);
        }
    }

    public EstFlowLink getFlowLinkLastModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estFlowLinkMapper.getLastByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.getFlowLinkLastModelByCode", (Throwable)e);
            return null;
        }
    }

    private void saveCapitalRecord(String userName, EstFlowLink estFlowLink, EstReserveUnit estReserveUnit) {
        try {
            if (this.checkIfSaveCustomerCapital(estFlowLink.getFlowLinkType(), estReserveUnit.getReserveUnitType(), estFlowLink.getOperationType()) && estFlowLink.getApprovalStatus().equals(EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_THROUGH.getApprovalStatus())) {
                BigDecimal shouldReceivables = BigDecimal.ZERO;
                if (estFlowLink.getFlowLinkType() <= EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType()) {
                    Integer capitalType = 0;
                    if (estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.REGISTRATION.getFlowLinkType()) || estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.RETREAT_REGISTRATION.getFlowLinkType())) {
                        shouldReceivables = estReserveUnit.getEarnestMoney();
                        capitalType = 1;
                    } else {
                        shouldReceivables = estReserveUnit.getDeposit();
                        capitalType = 2;
                    }
                    if (estFlowLink.getFlowLinkType().intValue() == EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType()) {
                        this.saveCommissionCapital(estReserveUnit, estFlowLink);
                        this.saveDownPaymentCapital(estReserveUnit, estFlowLink);
                        this.saveBalancePaymentCapital(estReserveUnit, estFlowLink);
                        EstFlowLink estFlowLink2 = this.getLast2FlowLink(estFlowLink.getReserveUnitCode(), EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_THROUGH, estFlowLink.getTenantCode());
                        if (EstateConstants.FlowLinkOperationTypeEnum.DEAL.getOperationType() == estFlowLink.getOperationType().intValue() || estFlowLink2 != null && EstateConstants.FlowLinkTypeEnum.REGISTRATION.getFlowLinkType() == estFlowLink2.getFlowLinkType().intValue() && this.checkCapitalRecord(estReserveUnit.getReserveUnitCode(), estReserveUnit.getUserCode(), shouldReceivables, estReserveUnit.getProjectCode(), estFlowLink.getTenantCode())) {
                            this.saveCustomerCapital(estReserveUnit.getReserveUnitCode(), estReserveUnit.getUserCode(), userName, shouldReceivables, estFlowLink.getFlowLinkType(), capitalType, estFlowLink.getReserveUnitType(), estReserveUnit.getProjectCode(), estFlowLink.getTenantCode());
                        }
                    } else {
                        this.saveCustomerCapital(estReserveUnit.getReserveUnitCode(), estReserveUnit.getUserCode(), userName, shouldReceivables, estFlowLink.getFlowLinkType(), capitalType, estFlowLink.getReserveUnitType(), estReserveUnit.getProjectCode(), estFlowLink.getTenantCode());
                    }
                } else {
                    Integer flowLType = -1;
                    if (estFlowLink.getFlowLinkType().intValue() == EstateConstants.FlowLinkOperationTypeEnum.RETREAT_REGISTRATION.getOperationType()) {
                        flowLType = EstateConstants.FlowLinkTypeEnum.REGISTRATION.getFlowLinkType();
                    }
                    if (estFlowLink.getFlowLinkType().intValue() == EstateConstants.FlowLinkOperationTypeEnum.RETREAT_SUBSCRIPTION.getOperationType()) {
                        flowLType = EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType();
                    }
                    if (estFlowLink.getFlowLinkType().intValue() == EstateConstants.FlowLinkOperationTypeEnum.RETREAT_DEAL.getOperationType()) {
                        flowLType = EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType();
                    }
                    this.updateCustomerCapital(estReserveUnit.getReserveUnitCode(), estReserveUnit.getUserCode(), flowLType, estFlowLink.getFlowLinkType(), estFlowLink.getTenantCode());
                }
            } else {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("afterUpdateCode", estReserveUnit.getReserveUnitCode());
                param.put("tenantCode", estFlowLink.getTenantCode());
                EstReserveUnit oldReserveUnit = this.estReserveUnitMapper.getByCode(param);
                if (oldReserveUnit == null || oldReserveUnit.getDataState() != -1) {
                    return;
                }
                param.remove("afterUpdateCode");
                param.put("reserveUnitCode", oldReserveUnit.getReserveUnitCode());
                List<EstCustomerCapital> customerCapitalList = this.estCustomerCapitalService.queryCustomerCapitalList(param);
                if (ListUtil.isEmpty(customerCapitalList)) {
                    return;
                }
                for (EstCustomerCapital customerCapital : customerCapitalList) {
                    if (Integer.valueOf(customerCapital.getFlowLinkType()) > EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType()) continue;
                    if (EstateConstants.FlowLinkTypeEnum.REGISTRATION.getFlowLinkType() == customerCapital.getCapitalType().intValue() && EstateConstants.FlowLinkTypeEnum.REGISTRATION.getFlowLinkType() == estFlowLink.getReserveUnitType().intValue()) {
                        customerCapital.setShouldReceivables(estReserveUnit.getEarnestMoney());
                    }
                    if (EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType() == customerCapital.getCapitalType().intValue() && (EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType() == estFlowLink.getReserveUnitType().intValue() || EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType() == estFlowLink.getReserveUnitType().intValue())) {
                        customerCapital.setShouldReceivables(estReserveUnit.getDeposit());
                    }
                    if ((3 == customerCapital.getCapitalType() || 4 == customerCapital.getCapitalType()) && EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType() == estReserveUnit.getReserveUnitType().intValue()) {
                        EstPaymentDetails estPaymentDetails = this.getPaymentDetailsByCode(estReserveUnit.getReserveUnitCode(), estReserveUnit.getTenantCode());
                        if (estPaymentDetails == null) {
                            this.logger.error("estate.EstFlowLinkServiceImpl.saveCapitalRecord error, estPaymentDetails is null");
                            return;
                        }
                        BigDecimal[] houseCapital = this.getCapitalDiff(estReserveUnit, estPaymentDetails);
                        if (houseCapital == null || houseCapital.length < 1) {
                            this.logger.error("estate.EstFlowLinkServiceImpl.saveCapitalRecord error, houseCapital.length < 1 is null");
                            return;
                        }
                        if (3 == customerCapital.getCapitalType()) {
                            customerCapital.setShouldReceivables(houseCapital[0]);
                        }
                        if (4 == customerCapital.getCapitalType()) {
                            customerCapital.setShouldReceivables(houseCapital[1]);
                        }
                    }
                    customerCapital.setReserveUnitCode(estReserveUnit.getReserveUnitCode());
                    this.estCustomerCapitalService.updateCustomerCapital(this.makeCustomerCapital(customerCapital, null));
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("saveCapitalRecord.", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private EstFlowLink getLast2FlowLink(String reserveUnitCode, EstateConstants.FlowLinkApprovalStatusEnum approvalStatus, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reserveUnitCode", reserveUnitCode);
        param.put("approvalStatus", approvalStatus.getApprovalStatus());
        param.put("tenantCode", tenantCode);
        param.put("limit2", true);
        return this.getFlowLinkLastModelByCode(param);
    }

    private boolean checkCapitalRecord(String reserveUnitCode, String userCode, BigDecimal shouldReceivables, String projectCode, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reserveUnitCode", reserveUnitCode);
        param.put("userCode", userCode);
        param.put("flowLinkType", EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType());
        param.put("capitalType", EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType());
        param.put("reserveUnitType", EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType());
        param.put("projectCode", projectCode);
        param.put("tenantCode", tenantCode);
        List<EstCustomerCapital> estCustomerCapitalList = this.estCustomerCapitalService.queryCustomerCapitalList(param);
        if (ListUtil.isEmpty(estCustomerCapitalList)) {
            param.put("flowLinkType", EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType());
            param.put("reserveUnitType", EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType());
            estCustomerCapitalList = this.estCustomerCapitalService.queryCustomerCapitalList(param);
        }
        if (ListUtil.isNotEmpty(estCustomerCapitalList)) {
            for (EstCustomerCapital customerCapital : estCustomerCapitalList) {
                customerCapital.setShouldReceivables(shouldReceivables);
                this.estCustomerCapitalService.updateCustomerCapital(this.makeCustomerCapital(customerCapital, null));
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean forIfUnlockHouseUpdate(EstReserveUnit estReserveUnit) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
        parmMap.put("order", true);
        List<EstFlowLink> estFlowLinkList = this.queryFlowLinkModelPage(parmMap);
        if (estFlowLinkList == null) return true;
        try {
            int i = 0;
            while (true) {
                if (i >= estFlowLinkList.size()) {
                    return true;
                }
                if (estFlowLinkList.get(i).getFlowLinkType() < estReserveUnit.getReserveUnitType()) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            this.logger.error("forIfWithdrawalUpdate.", (Throwable)ex);
        }
        return true;
    }

    private void forIfWithdrawalUpdate(EstReserveUnit estReserveUnit) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
        parmMap.put("order", true);
        List<EstFlowLink> estFlowLinkList = this.queryFlowLinkModelPage(parmMap);
        if (estFlowLinkList != null) {
            try {
                int i = 0;
                while (i < estFlowLinkList.size()) {
                    if (estFlowLinkList.get(i).getReserveUnitType() < estReserveUnit.getReserveUnitType() && estFlowLinkList.get(i).getApprovalStatus().equals(EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_THROUGH.getApprovalStatus())) {
                        estReserveUnit.setReserveUnitType(estFlowLinkList.get(i).getReserveUnitType());
                        this.estReserveUnitMapper.updateByPrimaryKey(estReserveUnit);
                        this.unlockHouseUpdate(estReserveUnit, estReserveUnit.getTenantCode());
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                this.logger.error("forIfWithdrawalUpdate.", (Throwable)ex);
            }
        }
    }

    private void riseApplyForRefuse(EstFlowLink estFlowLink, EstReserveUnit estReserveUnit) {
        if ((estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.REGISTRATION.getFlowLinkType()) || estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType()) || estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType())) && estFlowLink.getApprovalStatus().equals(EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_REJECT.getApprovalStatus())) {
            if (estFlowLink.getOperationType().equals(EstateConstants.FlowLinkOperationTypeEnum.CHANGE_APPLICATION.getOperationType())) {
                return;
            }
            this.forIfWithdrawalUpdate(estReserveUnit);
        }
    }

    private void changeIntentionContent(Integer approvalStatus, EstFlowLink estFlowLink, EstReserveUnit estReserveUnit) {
        try {
            if (estFlowLink.getFlowLinkType() <= EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType() && approvalStatus.equals(EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_THROUGH.getApprovalStatus())) {
                HashMap<String, Object> parmMap = new HashMap<String, Object>();
                parmMap.put("memberCode", estReserveUnit.getMemberCode());
                parmMap.put("projectCode", estReserveUnit.getProjectCode());
                parmMap.put("tenantCode", estReserveUnit.getTenantCode());
                EstIntention estIntention = this.estIntentionService.getIntentionByCode(parmMap);
                if (estIntention != null) {
                    UserBean userBean = this.getUser(estReserveUnit.getUserCode(), estReserveUnit.getTenantCode());
                    EstStateDomain estStateDomain = new EstStateDomain();
                    if (estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.REGISTRATION.getFlowLinkType()) && EstateConstants.FlowLinkTypeEnum.REGISTRATION.getFlowLinkType() > Integer.parseInt(estIntention.getIntentionContent())) {
                        estIntention.setIntentionContent("3");
                    }
                    String houseTag = this.getHouseTag(estReserveUnit);
                    if (estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType())) {
                        if (EstateConstants.FlowLinkTypeEnum.SUBSCRIPTION.getFlowLinkType() > Integer.parseInt(estIntention.getIntentionContent())) {
                            estIntention.setIntentionContent("4");
                        }
                        estStateDomain.setStateContent("\u8ba4\u8d2d");
                        if (StringUtils.isNotBlank((String)houseTag)) {
                            estStateDomain.setStateRemark(houseTag);
                        }
                    }
                    if (estFlowLink.getFlowLinkType().equals(EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType())) {
                        if (EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType() > Integer.parseInt(estIntention.getIntentionContent())) {
                            estIntention.setIntentionContent("5");
                        }
                        estStateDomain.setStateContent("\u6210\u4ea4");
                        if (StringUtils.isNotBlank((String)houseTag)) {
                            estStateDomain.setStateRemark(houseTag);
                        }
                    }
                    this.estIntentionService.updateIntention(this.makeIntention(estIntention, null));
                    this.setStateDomain(estReserveUnit, userBean, estStateDomain);
                    if (StringUtils.isNotBlank((String)estStateDomain.getStateContent())) {
                        this.saveSysState(estStateDomain);
                    }
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("estate.EstFlowLinkServiceImpl.changeIntentionContent", (Throwable)ex);
        }
    }

    private String getHouseTag(EstReserveUnit estReserveUnit) {
        String houseTag = "";
        if (StringUtils.isNotBlank((String)estReserveUnit.getBuildingNumber())) {
            houseTag = String.valueOf(houseTag) + estReserveUnit.getBuildingNumber();
        }
        if (StringUtils.isNotBlank((String)estReserveUnit.getUnitNumber())) {
            houseTag = String.valueOf(houseTag) + estReserveUnit.getUnitNumber();
        }
        if (StringUtils.isNotBlank((String)estReserveUnit.getRoomNumber())) {
            houseTag = String.valueOf(houseTag) + estReserveUnit.getRoomNumber();
        }
        return houseTag;
    }

    private void setStateDomain(EstReserveUnit estReserveUnit, UserBean userBean, EstStateDomain estStateDomain) {
        estStateDomain.setUserCode(estReserveUnit.getUserCode());
        if (userBean != null) {
            estStateDomain.setUserName(userBean.getUserRelname());
        }
        estStateDomain.setMemberCode(estReserveUnit.getMemberCode());
        estStateDomain.setProjectCode(estReserveUnit.getProjectCode());
        estStateDomain.setTenantCode(estReserveUnit.getTenantCode());
    }

    private void saveSysState(EstStateDomain estStateDomain) {
        estStateDomain.setStateType(EstateConstants.STATE_TYPE_2);
        this.estStateService.saveState(estStateDomain);
    }

    private EstIntentionDomain makeIntention(EstIntention estIntention, EstIntentionDomain estIntentionDomain) {
        if (estIntention == null) {
            return null;
        }
        if (estIntentionDomain == null) {
            estIntentionDomain = new EstIntentionDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estIntentionDomain, (Object)estIntention);
            return estIntentionDomain;
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.makeIntention", (Throwable)e);
            return null;
        }
    }

    public void unlockHouseUpdate(EstReserveUnit estReserveUnit, String tenantCode) {
        try {
            if (estReserveUnit == null) {
                return;
            }
            String houseCode = estReserveUnit.getHouseCode();
            if (StringUtils.isNotBlank((String)houseCode)) {
                HashMap<String, Object> parmMap = new HashMap<String, Object>();
                parmMap.put("houseCode", houseCode);
                parmMap.put("tenantCode", tenantCode);
                parmMap.put("dataState", 0);
                parmMap.put("oldDataState", estReserveUnit.getReserveUnitType());
                HashMap<String, String> postParm = new HashMap<String, String>();
                postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
                this.internalInvoke("pt.project.updateHouseByCode", postParm);
            }
        }
        catch (Exception ex) {
            this.logger.error("estate.EstFlowLinkServiceImpl.unlockHouseUpdate", (Throwable)ex);
        }
    }

    private void setAuditorByNodeCode(String opBillCode, EstFlowLink estFlowLink) {
        String nodeCode = this.parmFlowLinkSys(estFlowLink.getFlowLinkType(), estFlowLink.getTenantCode());
        boolean cacheFlag = false;
        String json = DisUtil.get((String)(String.valueOf(opBillCode) + nodeCode));
        if (StringUtils.isNotBlank((String)json)) {
            Object approveMap1 = JsonUtil.buildNonNullBinder().getJsonToObject(json, Object.class);
            Map approveMap = (Map)JsonUtil.buildNonNullBinder().getJsonToMap(approveMap1.toString(), String.class, Object.class);
            if (MapUtil.isNotEmpty((Map)approveMap)) {
                this.getApproveInfo(estFlowLink, approveMap);
                cacheFlag = true;
            }
        }
        if (!cacheFlag) {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("dataOpDateOrder", true);
            parmMap.put("opBillcode", opBillCode);
            parmMap.put("nodeCode", nodeCode);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
            String nodeInfoList = this.internalInvoke("wf.workflow.queryApproveList", map);
            if (StringUtils.isNotBlank((String)nodeCode)) {
                ArrayList mapList = (ArrayList)JsonUtil.buildNonNullBinder().getJsonToList(nodeInfoList, Map.class);
                if (mapList != null && mapList.size() > 0) {
                    for (Map mapResult : mapList) {
                        Integer dataBillstate;
                        if (!mapResult.containsKey("dataBillstate") || (dataBillstate = Integer.valueOf(String.valueOf(mapResult.get("dataBillstate")))) != 1 && dataBillstate != 2) continue;
                        this.getApproveInfo(estFlowLink, mapResult);
                        break;
                    }
                } else {
                    estFlowLink.setAuditDate(new Date());
                }
            }
        }
    }

    private void getApproveInfo(EstFlowLink estFlowLink, Map<String, Object> mapResult) {
        String userAname = (String)mapResult.get("userAname");
        String userACode = (String)mapResult.get("userAcode");
        String dataOpdate = (String)mapResult.get("dataOpdate");
        estFlowLink.setAuditDate(new Date());
        if (StringUtils.isNotBlank((String)userAname)) {
            estFlowLink.setUserName(userAname);
        }
        if (StringUtils.isNotBlank((String)userACode)) {
            estFlowLink.setUserCode(userACode);
        }
        if (StringUtils.isNotBlank((String)dataOpdate)) {
            estFlowLink.setAuditDate(DateUtil.getDateToString((String)dataOpdate, (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    private String parmFlowLinkSys(int flowLinkType, String tenantCode) {
        String unqKey = "workflow";
        if (flowLinkType == 1) {
            return this.getFalgSettingInfo(unqKey, "rcNode", tenantCode).split("\\|")[0];
        }
        if (flowLinkType == 2) {
            return this.getFalgSettingInfo(unqKey, "rgNode", tenantCode).split("\\|")[0];
        }
        if (flowLinkType == 3) {
            return this.getFalgSettingInfo(unqKey, "cjNode", tenantCode).split("\\|")[0];
        }
        if (flowLinkType == 4) {
            return this.getFalgSettingInfo(unqKey, "trcNode", tenantCode).split("\\|")[0];
        }
        if (flowLinkType == 5) {
            return this.getFalgSettingInfo(unqKey, "trgNode", tenantCode).split("\\|")[0];
        }
        if (flowLinkType == 6) {
            return this.getFalgSettingInfo(unqKey, "tcjNode", tenantCode).split("\\|")[0];
        }
        return null;
    }

    private String getFalgSettingInfo(String unqKey, String unqValue, String tenantCode) {
        String infoVal = DisUtil.getMap((String)"DdFalgSetting-key", (String)(String.valueOf(tenantCode) + "-" + unqKey + "-" + unqValue));
        if (StringUtils.isBlank((String)infoVal)) {
            infoVal = DisUtil.getMap((String)"DdFalgSetting-key", (String)("00000000-" + unqKey + "-" + unqValue));
        }
        return infoVal;
    }

    @Override
    public Map<String, Object> queryLatestFlowReserve(Map<String, Object> map) {
        Map<String, Object> flowLinkReserveMap = this.queryLatestFlowReserveModel(map);
        return flowLinkReserveMap;
    }

    private Map<String, Object> queryLatestFlowReserveModel(Map<String, Object> map) {
        try {
            return this.estFlowLinkMapper.queryLatestFlowReserve(map);
        }
        catch (Exception ex) {
            this.logger.error("estate.EstFlowLinkServiceImpl.unlockHouseUpdate", (Throwable)ex);
            return null;
        }
    }

    private boolean checkIfSaveCustomerCapital(Integer flowLinkType, Integer reserveUnitType, Integer operationType) {
        return operationType.intValue() != EstateConstants.FlowLinkOperationTypeEnum.CHANGE_APPLICATION.getOperationType();
    }

    private void saveCustomerCapital(String reserveUnitCode, String userCode, String userName, BigDecimal shouldReceivables, Integer flowLinkType, Integer capitalType, Integer reserveUnitType, String projectCode, String tenantCode) {
        boolean flag = this.checkCustomerCapital(reserveUnitCode, userCode, shouldReceivables, flowLinkType, capitalType, reserveUnitType, projectCode, tenantCode);
        if (flag) {
            return;
        }
        EstCustomerCapitalDomain estCustomerCapitalDomain = new EstCustomerCapitalDomain();
        estCustomerCapitalDomain.setCapitalType(capitalType);
        estCustomerCapitalDomain.setReserveUnitCode(reserveUnitCode);
        estCustomerCapitalDomain.setReserveUnitType(String.valueOf(reserveUnitType));
        estCustomerCapitalDomain.setUserCode(userCode);
        estCustomerCapitalDomain.setUserName(userName);
        estCustomerCapitalDomain.setOtherCode(projectCode);
        estCustomerCapitalDomain.setTenantCode(tenantCode);
        estCustomerCapitalDomain.setFlowLinkType(String.valueOf(flowLinkType));
        if (shouldReceivables == null) {
            shouldReceivables = BigDecimal.ZERO;
        }
        estCustomerCapitalDomain.setShouldReceivables(shouldReceivables);
        this.saveCustomerCapitalDomain(estCustomerCapitalDomain);
    }

    private boolean checkCustomerCapital(String reserveUnitCode, String userCode, BigDecimal shouldReceivables, Integer flowLinkType, Integer capitalType, Integer reserveUnitType, String projectCode, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reserveUnitCode", reserveUnitCode);
        param.put("userCode", userCode);
        param.put("capitalType", capitalType);
        param.put("projectCode", projectCode);
        param.put("tenantCode", tenantCode);
        List<EstCustomerCapital> estCustomerCapitalList = this.estCustomerCapitalService.queryCustomerCapitalList(param);
        if (ListUtil.isNotEmpty(estCustomerCapitalList)) {
            for (EstCustomerCapital customerCapital : estCustomerCapitalList) {
                customerCapital.setAlreadyReceivables(customerCapital.getShouldReceivables().subtract(customerCapital.getAlreadyReceivables()));
                customerCapital.setShouldReceivables(shouldReceivables);
                customerCapital.setReserveUnitType(String.valueOf(reserveUnitType));
                customerCapital.setFlowLinkType(String.valueOf(flowLinkType));
                this.estCustomerCapitalService.updateCustomerCapital(this.makeCustomerCapital(customerCapital, null));
            }
            return true;
        }
        return false;
    }

    private void saveCustomerCapital(String reserveUnitCode, String userCode, BigDecimal shouldReceivables, Integer flowLinkType, Integer reserveUnitType, Integer capitalType, String projectCode, String tenantCode) {
        boolean flag = this.checkCustomerCapital(reserveUnitCode, userCode, shouldReceivables, flowLinkType, capitalType, reserveUnitType, projectCode, tenantCode);
        if (flag) {
            return;
        }
        EstCustomerCapitalDomain estCustomerCapitalDomain = new EstCustomerCapitalDomain();
        estCustomerCapitalDomain.setReserveUnitCode(reserveUnitCode);
        estCustomerCapitalDomain.setReserveUnitType(String.valueOf(reserveUnitType));
        estCustomerCapitalDomain.setUserCode(userCode);
        estCustomerCapitalDomain.setOtherCode(projectCode);
        estCustomerCapitalDomain.setTenantCode(tenantCode);
        estCustomerCapitalDomain.setFlowLinkType(String.valueOf(flowLinkType));
        estCustomerCapitalDomain.setShouldReceivables(shouldReceivables);
        estCustomerCapitalDomain.setCapitalType(capitalType);
        if (shouldReceivables == null) {
            estCustomerCapitalDomain.setShouldReceivables(BigDecimal.ZERO);
        }
        this.saveCustomerCapitalDomain(estCustomerCapitalDomain);
    }

    private void saveCustomerCapitalDomain(EstCustomerCapitalDomain estCustomerCapitalDomain) {
        UserBean userBean = this.getUser(estCustomerCapitalDomain.getUserCode(), estCustomerCapitalDomain.getTenantCode());
        if (userBean != null) {
            estCustomerCapitalDomain.setUserName(userBean.getUserRelname());
        }
        estCustomerCapitalDomain.setNextBatchUpdateDate(new Date());
        estCustomerCapitalDomain.setAlreadyReceivables(BigDecimal.ZERO);
        estCustomerCapitalDomain.setBeyondDay("0");
        this.estCustomerCapitalService.saveCustomerCapital(estCustomerCapitalDomain);
    }

    private UserBean getUser(String userCode, String tenantCode) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("userCode", userCode);
        parmMap.put("tenantCode", tenantCode);
        String resultJson = this.internalInvoke("um.user.getUserByCode", parmMap);
        UserBean user = (UserBean)JsonUtil.buildNormalBinder().getJsonToObject(resultJson, UserBean.class);
        return user;
    }

    private void updateCustomerCapital(String reserveUnitCode, String userCode, Integer reserveUnitType, Integer flowLinkType, String tenantCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("reserveUnitCode", reserveUnitCode);
        parmMap.put("userCode", userCode);
        parmMap.put("reserveUnitType", String.valueOf(reserveUnitType));
        parmMap.put("tenantCode", tenantCode);
        QueryResult<EstCustomerCapital> customerCapitalQueryResult = this.estCustomerCapitalService.queryCustomerCapitalPage(parmMap);
        if (customerCapitalQueryResult != null && customerCapitalQueryResult.getRows() != null && customerCapitalQueryResult.getRows().size() > 0) {
            for (EstCustomerCapital customerCapital : customerCapitalQueryResult.getList()) {
                if (Integer.valueOf(customerCapital.getFlowLinkType()) > EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType()) continue;
                customerCapital.setShouldReceivables(customerCapital.getAlreadyReceivables());
                customerCapital.setAlreadyReceivables(BigDecimal.ZERO);
                customerCapital.setFlowLinkType(String.valueOf(flowLinkType));
                this.estCustomerCapitalService.updateCustomerCapital(this.makeCustomerCapital(customerCapital, null));
            }
        }
    }

    private EstCustomerCapitalDomain makeCustomerCapital(EstCustomerCapital estCustomerCapital, EstCustomerCapitalDomain estCustomerCapitalDomain) {
        if (estCustomerCapital == null) {
            return null;
        }
        if (estCustomerCapitalDomain == null) {
            estCustomerCapitalDomain = new EstCustomerCapitalDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estCustomerCapitalDomain, (Object)estCustomerCapital);
            return estCustomerCapitalDomain;
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.makeCustomerCapital", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<Map<String, Object>> queryApproveLinks(Map<String, Object> map) {
        List<Map<String, Object>> approveLinks = this.queryApproveLinksModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApproveLinks(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(approveLinks);
        return queryResult;
    }

    private List<Map<String, Object>> queryApproveLinksModel(Map<String, Object> map) {
        try {
            return this.estFlowLinkMapper.queryApproveLinks(map);
        }
        catch (Exception ex) {
            this.logger.error("estate.EstFlowLinkServiceImpl.queryApproveLinksModel", (Throwable)ex);
            return null;
        }
    }

    private int countApproveLinks(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estFlowLinkMapper.countApproveLinks(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.countApproveLinks", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<String> queryNotBackHouseUnitCode(Map<String, Object> map) throws ApiException {
        List<String> estFlowLinkList = this.queryNotBackHouseUnitCodeModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countNotBackHouseModel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estFlowLinkList);
        return queryResult;
    }

    @Override
    public void batchSaveCapitalRecord(Map<String, Object> map) {
        if (!map.containsKey("tenantCode")) {
            throw new ApiException("estate.EstFlowLinkServiceImpl.batchSaveCapitalRecord param null", "\u53c2\u6570\u6570\u636e\u4e3a\u7a7a");
        }
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("approvalStatus", EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_THROUGH.getApprovalStatus());
            param.put("tenantCode", map.get("tenantCode"));
            List<EstFlowLink> estFlowLinkList = this.queryApproveThroughFLinkModel(param);
            if (ListUtil.isEmpty(estFlowLinkList)) {
                return;
            }
            HashMap<String, EstReserveUnit> estReserveUnitMap = new HashMap<String, EstReserveUnit>();
            HashMap<String, UserBean> userBeanMap = new HashMap<String, UserBean>();
            for (EstFlowLink estFlowLink : estFlowLinkList) {
                EstReserveUnit estReserveUnit = null;
                if (estReserveUnitMap.containsKey(estFlowLink.getReserveUnitCode())) {
                    estReserveUnit = (EstReserveUnit)estReserveUnitMap.get(estFlowLink.getReserveUnitCode());
                } else {
                    estReserveUnit = this.getReserveUnitByCode(estFlowLink.getReserveUnitCode(), estFlowLink.getTenantCode());
                    if (estReserveUnit == null) continue;
                    estReserveUnitMap.put(estReserveUnit.getReserveUnitCode(), estReserveUnit);
                }
                UserBean userBean = null;
                if (userBeanMap.containsKey(estReserveUnit.getUserCode())) {
                    userBean = (UserBean)userBeanMap.get(estReserveUnit.getUserCode());
                } else {
                    String userCode = estReserveUnit.getUserCode();
                    userBean = this.getUser(userCode, estReserveUnit.getTenantCode());
                    userBeanMap.put(userCode, userBean);
                }
                String userName = userBean.getUserRelname();
                this.saveCapitalRecord(userName, estFlowLink, estReserveUnit);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private EstReserveUnit getReserveUnitByCode(String reserveUnitCode, String tenantCode) {
        HashMap<String, Object> pamap = new HashMap<String, Object>();
        pamap.put("reserveUnitCode", reserveUnitCode);
        pamap.put("tenantCode", tenantCode);
        return this.estReserveUnitMapper.getByCode(pamap);
    }

    private List<EstFlowLink> queryApproveThroughFLinkModel(Map<String, Object> map) {
        try {
            return this.estFlowLinkMapper.queryApproveThroughFLink(map);
        }
        catch (Exception ex) {
            this.logger.error("estate.EstFlowLinkServiceImpl.queryNotBackHouseUnitCodeModel", (Throwable)ex);
            return null;
        }
    }

    private List<String> queryNotBackHouseUnitCodeModel(Map<String, Object> map) {
        try {
            return this.estFlowLinkMapper.queryNotBackHouseUnitCode(map);
        }
        catch (Exception ex) {
            this.logger.error("estate.EstFlowLinkServiceImpl.queryNotBackHouseUnitCodeModel", (Throwable)ex);
            return null;
        }
    }

    private int countNotBackHouseModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estFlowLinkMapper.countNotBackHouse(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFlowLinkServiceImpl.countNotBackHouseModel", (Throwable)e);
        }
        return i;
    }

    private Map<String, Object> getMbUserInfoByBroker(String mbuserCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("mbuserCode", mbuserCode);
        parmMap.put("dataState", 0);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("mm.merber.getMbuserByCode", postParm);
        Map teamInfoMaps = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
        if (teamInfoMaps == null) {
            return null;
        }
        return teamInfoMaps;
    }

    private Map<String, Object> getHouseInfoByCode(String houseCode, String tenantCode) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("houseCode", houseCode);
        parmMap.put("tenantCode", tenantCode);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("pt.project.getHouseByCode", postParm);
        Map teamInfoMaps = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
        if (teamInfoMaps == null) {
            return null;
        }
        return teamInfoMaps;
    }

    private Map<String, Object> getBuildingInfoByCode(String buildingCode, String tenantCode) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("buildingCode", buildingCode);
        parmMap.put("tenantCode", tenantCode);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("pt.project.getBuildingByCode", postParm);
        Map teamInfoMaps = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
        if (teamInfoMaps == null) {
            return null;
        }
        return teamInfoMaps;
    }

    private void saveCommissionCapital(EstReserveUnit estReserveUnit, EstFlowLink estFlowLink) {
        String opBillcode = estReserveUnit.getOpBillcode();
        if (StringUtils.isBlank((String)opBillcode)) {
            return;
        }
        Map<String, Object> mbUserInfo = this.getMbUserInfoByBroker(opBillcode);
        BigDecimal commissionAmount = new BigDecimal(BigInteger.ZERO);
        String commission = "";
        Integer commissionType = null;
        Map<String, Object> houseInfoMap = this.getHouseInfoByCode(estReserveUnit.getHouseCode(), estReserveUnit.getTenantCode());
        Map<String, Object> buildingInfoMap = this.getBuildingInfoByCode(estReserveUnit.getHouseCode(), estReserveUnit.getTenantCode());
        if (MapUtil.isNotEmpty(buildingInfoMap)) {
            commission = (String)buildingInfoMap.get("commission");
            commissionType = (Integer)buildingInfoMap.get("commissionType");
        }
        if (MapUtil.isNotEmpty(houseInfoMap)) {
            commission = (String)houseInfoMap.get("commission");
            commissionType = (Integer)houseInfoMap.get("commissionType");
        }
        if (StringUtils.isBlank((String)commission) || commissionType == null) {
            return;
        }
        commissionAmount = commissionType == 1 ? new BigDecimal(commission) : new BigDecimal(commission).multiply(estReserveUnit.getTotalTransactionPrice()).divide(new BigDecimal(100));
        this.saveCustomerCapital(estReserveUnit.getReserveUnitCode(), opBillcode, String.valueOf(mbUserInfo.get("mbuserRelname")), commissionAmount, estFlowLink.getFlowLinkType(), 5, 9, estReserveUnit.getProjectCode(), String.valueOf(mbUserInfo.get("tenantCode")));
    }

    private void saveDownPaymentCapital(EstReserveUnit estReserveUnit, EstFlowLink estFlowLink) {
        BigDecimal downPayment = BigDecimal.ZERO;
        EstPaymentDetails estPaymentDetails = this.getPaymentDetailsByCode(estReserveUnit.getReserveUnitCode(), estFlowLink.getTenantCode());
        if (estPaymentDetails == null) {
            this.logger.error("estate.EstFlowLinkServiceImpl.saveDownPaymentCapital error, estPaymentDetails is null");
            return;
        }
        BigDecimal[] houseCapital = this.getCapitalDiff(estReserveUnit, estPaymentDetails);
        if (houseCapital == null || houseCapital.length < 1) {
            this.logger.error("estate.EstFlowLinkServiceImpl.getCapitalDiff error, houseCapital.length < 1 is null");
            return;
        }
        downPayment = houseCapital[0];
        this.saveCustomerCapital(estReserveUnit.getReserveUnitCode(), estReserveUnit.getUserCode(), downPayment, estFlowLink.getFlowLinkType(), estFlowLink.getReserveUnitType(), 3, estReserveUnit.getProjectCode(), estReserveUnit.getTenantCode());
    }

    private BigDecimal[] getCapitalDiff(EstReserveUnit estReserveUnit, EstPaymentDetails estPaymentDetails) {
        try {
            BigDecimal downPaymentAmount = BigDecimal.valueOf(estPaymentDetails.getDownPaymentAmount());
            BigDecimal payInBackAmount = BigDecimal.valueOf(estPaymentDetails.getDownPaymentAmount());
            if (estPaymentDetails.getPaymentDetailsType() == 1 || estPaymentDetails.getPaymentDetailsType() == 2) {
                payInBackAmount = payInBackAmount.subtract(estReserveUnit.getDeposit());
                if (estReserveUnit.getEarnestMoney() != null && estReserveUnit.getEarnestMoney().compareTo(BigDecimal.ZERO) == 1) {
                    payInBackAmount = payInBackAmount.subtract(estReserveUnit.getEarnestMoney());
                }
            } else if (estPaymentDetails.getPaymentDetailsType() == 3) {
                payInBackAmount = BigDecimal.ZERO;
            }
            BigDecimal totalTransactionPrice = estReserveUnit.getTotalTransactionPrice();
            BigDecimal loanAmount = totalTransactionPrice.subtract(downPaymentAmount);
            return new BigDecimal[]{payInBackAmount, loanAmount};
        }
        catch (Exception ex) {
            this.logger.error("estate.EstFlowLinkServiceImpl.getCapitalDiff ex: ", (Throwable)ex);
            return null;
        }
    }

    private void saveBalancePaymentCapital(EstReserveUnit estReserveUnit, EstFlowLink estFlowLink) {
        BigDecimal balancePayment = BigDecimal.ZERO;
        EstPaymentDetails estPaymentDetails = this.getPaymentDetailsByCode(estReserveUnit.getReserveUnitCode(), estFlowLink.getTenantCode());
        if (estPaymentDetails == null) {
            this.logger.error("estate.EstFlowLinkServiceImpl.saveDownPaymentCapital error, estPaymentDetails is null");
            return;
        }
        BigDecimal[] houseCapital = this.getCapitalDiff(estReserveUnit, estPaymentDetails);
        if (houseCapital == null || houseCapital.length < 2) {
            this.logger.error("estate.EstFlowLinkServiceImpl.getCapitalDiff error, houseCapital.length < 2 is null");
            return;
        }
        balancePayment = houseCapital[1];
        this.saveCustomerCapital(estReserveUnit.getReserveUnitCode(), estReserveUnit.getUserCode(), balancePayment, estFlowLink.getFlowLinkType(), estFlowLink.getReserveUnitType(), 4, estReserveUnit.getProjectCode(), estReserveUnit.getTenantCode());
    }

    private EstPaymentDetails getPaymentDetailsByCode(String reserveUnitCode, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("reserveUnitCode", reserveUnitCode);
        param.put("tenantCode", tenantCode);
        EstPaymentDetails estPaymentDetails = this.estPaymentDetailsService.getPaymentDetailsByCode(param);
        if (estPaymentDetails == null) {
            this.logger.error("estate.EstFlowLinkServiceImpl.getPaymentDetailsByCode is null");
            return null;
        }
        return estPaymentDetails;
    }

    @Override
    public Boolean updateTransforCommission(Map<String, Object> map) throws ApiException {
        List<EstCustomerCapital> customerCapitalList;
        if (MapUtil.isEmpty(map)) {
            return false;
        }
        String dataExamRemark = "";
        Integer dataExamState = null;
        boolean flag = true;
        if (map.containsKey("dataExamRemark")) {
            dataExamRemark = String.valueOf(map.get("dataExamRemark"));
        } else {
            flag = false;
        }
        if (map.containsKey("dataExamState")) {
            dataExamState = Integer.valueOf(String.valueOf(map.get("dataExamState")));
        } else {
            flag = false;
        }
        if (flag && ListUtil.isNotEmpty(customerCapitalList = this.estCustomerCapitalService.queryCustomerCapitalList(map))) {
            EstCustomerCapital estCustomerCapital = customerCapitalList.get(0);
            BigDecimal shouldReceivables = estCustomerCapital.getShouldReceivables();
            Integer customerCapitalId = estCustomerCapital.getCustomerCapitalId();
            if (shouldReceivables.compareTo(BigDecimal.ZERO) > 0) {
                Boolean success = this.estCustomerCapitalService.updateCustomerCapitalCommission(customerCapitalId);
                if (success.booleanValue()) {
                    EstReserveUnit estReserveUnit = this.estReserveUnitMapper.getByCode(map);
                    estReserveUnit.setDataExamRemark(dataExamRemark);
                    estReserveUnit.setDataExamState(dataExamState);
                    estReserveUnit.setDataExamDate(new Date());
                    int count = this.estReserveUnitMapper.updateByPrimaryKey(estReserveUnit);
                    if (count == 0) {
                        throw new ApiException("estate.EstFlowLinkServiceImpl.savePtrade.setMerchant", "\u5ba1\u6838\u4fee\u6539\u5931\u8d25!");
                    }
                    this.logger.info("estate.EstFlowLinkServiceImpl.updateTransforCommission", (Object)"\u4f63\u91d1\u8f6c\u6210\u529f");
                    return success;
                }
                this.logger.error("estate.EstFlowLinkServiceImpl.updateTransforCommission", (Object)"\u4f63\u91d1\u8f6c\u7ed3\u5931\u8d25");
            }
        }
        return false;
    }
}

