/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.github.pagehelper.PageInfo;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstFollowMapper;
import com.yqbsoft.laser.service.estate.domain.EstFollowDomain;
import com.yqbsoft.laser.service.estate.model.EstFollow;
import com.yqbsoft.laser.service.estate.model.EstReport;
import com.yqbsoft.laser.service.estate.service.EstFollowService;
import com.yqbsoft.laser.service.estate.service.EstReportService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class EstFollowServiceImpl
extends BaseServiceImpl
implements EstFollowService {
    public static final String SYS_CODE = "estate.EstFollowServiceImpl";
    private EstFollowMapper estFollowMapper;
    @Autowired
    private EstReportService estReportService;

    public void setEstFollowMapper(EstFollowMapper estFollowMapper) {
        this.estFollowMapper = estFollowMapper;
    }

    private Date getSysDate() {
        try {
            return this.estFollowMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFollow(EstFollowDomain estFollowDomain) {
        if (estFollowDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFollowDefault(EstFollow estFollow) {
        if (estFollow == null) {
            return;
        }
        if (estFollow.getDataState() == null) {
            estFollow.setDataState(0);
        }
        if (estFollow.getGmtCreate() == null) {
            estFollow.setGmtCreate(this.getSysDate());
        }
        estFollow.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estFollow.getFollowCode())) {
            estFollow.setFollowCode(this.createUUIDString());
        }
    }

    private int getFollowMaxCode() {
        int code = 0;
        try {
            return this.estFollowMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.getFollowMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFollowUpdataDefault(EstFollow estFollow) {
        if (estFollow == null) {
            return;
        }
        estFollow.setGmtModified(this.getSysDate());
    }

    private void saveFollowModel(EstFollow estFollow) throws ApiException {
        if (estFollow == null) {
            return;
        }
        try {
            this.estFollowMapper.insert(estFollow);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFollowServiceImpl.saveFollowModel.ex", (Throwable)e);
        }
    }

    private EstFollow getFollowModelById(Integer followId) {
        if (followId == null) {
            return null;
        }
        try {
            return this.estFollowMapper.selectByPrimaryKey(followId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.getFollowModelById", (Throwable)e);
            return null;
        }
    }

    public EstFollow getFollowModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estFollowMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.getFollowModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFollowModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estFollowMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFollowServiceImpl.delFollowModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstFollowServiceImpl.delFollowModelByCode.num");
        }
    }

    private void deleteFollowModel(Integer followId) throws ApiException {
        if (followId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estFollowMapper.deleteByPrimaryKey(followId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFollowServiceImpl.deleteFollowModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstFollowServiceImpl.deleteFollowModel.num");
        }
    }

    private void updateFollowModel(EstFollow estFollow) throws ApiException {
        if (estFollow == null) {
            return;
        }
        try {
            this.estFollowMapper.updateByPrimaryKeySelective(estFollow);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFollowServiceImpl.updateFollowModel.ex", (Throwable)e);
        }
    }

    private void updateStateFollowModel(Integer followId, Integer dataState, Integer oldDataState) throws ApiException {
        if (followId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("followId", followId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estFollowMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstFollowServiceImpl.updateStateFollowModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstFollowServiceImpl.updateStateFollowModel.null");
        }
    }

    private EstFollow makeFollow(EstFollowDomain estFollowDomain, EstFollow estFollow) {
        if (estFollowDomain == null) {
            return null;
        }
        if (estFollow == null) {
            estFollow = new EstFollow();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estFollow, (Object)estFollowDomain);
            return estFollow;
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.makeFollow", (Throwable)e);
            return null;
        }
    }

    private List<EstFollow> queryFollowModelPage(Map<String, Object> parammap) {
        try {
            return this.estFollowMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.queryFollowModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public Integer getCountFollow(Map<String, Object> map) {
        return this.countFollow(map);
    }

    private int countFollow(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estFollowMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.countFollow", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveFollow(EstFollowDomain estFollowDomain) throws ApiException {
        String msg = this.checkFollow(estFollowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstFollowServiceImpl.saveFollow.checkFollow", msg);
        }
        EstFollow estFollow = this.makeFollow(estFollowDomain, null);
        this.setFollowDefault(estFollow);
        this.saveFollowModel(estFollow);
    }

    @Override
    public void updateFollowState(Integer followId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFollowModel(followId, dataState, oldDataState);
    }

    @Override
    public void updateFollow(EstFollowDomain estFollowDomain) throws ApiException {
        String msg = this.checkFollow(estFollowDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstFollowServiceImpl.updateFollow.checkFollow", msg);
        }
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("followCode", estFollowDomain.getFollowCode());
        EstFollow oldEstFollow = this.getFollowByCode(parmMap);
        if (oldEstFollow == null) {
            throw new ApiException("estate.EstFollowServiceImpl.updateFollow.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstFollow estFollow = oldEstFollow;
        estFollow.setFollowRemark(estFollowDomain.getFollowRemark());
        this.setFollowUpdataDefault(estFollow);
        this.updateFollowModel(estFollow);
    }

    @Override
    public EstFollow getFollow(Integer followId) {
        return this.getFollowModelById(followId);
    }

    @Override
    public void deleteFollow(Integer followId) throws ApiException {
        this.deleteFollowModel(followId);
    }

    @Override
    public QueryResult<EstFollow> queryFollowPage(Map<String, Object> map) {
        List<EstFollow> estFollowList = this.queryFollowModelPage(map);
        Boolean appertainBool = MapUtil.getBoolean(map, (Object)"appertainBool");
        if (appertainBool != null && appertainBool.booleanValue()) {
            this.querySetAppertainByRpt(estFollowList);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFollow(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estFollowList);
        return queryResult;
    }

    private void querySetAppertainByRpt(List<EstFollow> estReports) {
        if (ListUtil.isEmpty(estReports)) {
            return;
        }
        for (EstFollow estFollow : estReports) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("reportCode", estFollow.getReportCode());
            paramMap.put("projectCode", estFollow.getProjectCode());
            paramMap.put("tenantCode", estFollow.getTenantCode());
            estFollow.setFollowTotal(this.countFollow(paramMap));
            EstReport estReport = this.estReportService.getReportByCode(paramMap);
            if (estReport == null) continue;
            estFollow.setMemberName(estReport.getMemberName());
            Map<String, Object> memberJson = this.getMemberInfo(estReport.getMemberCode(), estReport.getTenantCode());
            if (!MapUtil.isNotEmpty(memberJson)) continue;
            estFollow.setMemberPhone((String)memberJson.get("merberPhone"));
        }
    }

    private Map<String, Object> getMemberInfo(String memberCode, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("merberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> paramPost = new HashMap<String, String>();
        paramPost.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String resultJson = this.internalInvoke("mm.merber.getMerberByCode", paramPost);
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
    }

    @Override
    public EstFollow getFollowByCode(Map<String, Object> map) {
        return this.getFollowModelByCode(map);
    }

    @Override
    public void delFollowByCode(Map<String, Object> map) throws ApiException {
        this.delFollowModelByCode(map);
    }

    @Override
    public List<EstFollow> getFollowByUCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            List<EstFollow> estFollows = this.estFollowMapper.getByUCode(map);
            return estFollows;
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.getFollowModelByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<EstFollow> queryFollowList(Map<String, Object> map) {
        return this.estFollowMapper.query(map);
    }

    @Override
    public Long getToDayReturnVisitCount(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        map.put("followNextdate", new Date());
        return this.estFollowMapper.getToDayReturnVisitCount(map);
    }

    public PageInfo<EstReport> overdueNotFollowedUpListModel(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            this.startPage(map);
            List<EstReport> estReports = this.estFollowMapper.overdueNotFollowedUpList(map);
            return this.getPageInfo(estReports);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.overdueNotFollowedUpListModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<EstReport> overdueNotFollowedUpList(Map<String, Object> map) {
        map = this.getMemberCodeByPhoneNumber(map);
        PageInfo<EstReport> estReportPageInfo = this.overdueNotFollowedUpListModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.valueOf(String.valueOf(estReportPageInfo.getTotal())).intValue());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReportPageInfo.getList());
        return queryResult;
    }

    @Override
    public QueryResult<EstReport> followingUpList(Map<String, Object> map) {
        map = this.getMemberCodeByPhoneNumber(map);
        List<EstReport> estReports = this.estFollowMapper.followingUpList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFollow(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReports);
        return queryResult;
    }

    @Override
    public QueryResult<EstReport> waitingForFollowUpList(Map<String, Object> map) {
        map = this.getMemberCodeByPhoneNumber(map);
        map.put("queryEdateDay", this.queryWaitingFollowByEdateDay());
        List<EstReport> estReports = this.estFollowMapper.waitingForFollowUpList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.waitingForFollowUpCountModel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReports);
        return queryResult;
    }

    private int waitingForFollowUpCountModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estFollowMapper.waitingForFollowUpCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstFollowServiceImpl.countFollow", (Throwable)e);
        }
        return i;
    }

    @Override
    public Integer waitingForFollowUpCount(Map<String, Object> map) {
        map.put("queryEdateDay", this.queryWaitingFollowByEdateDay());
        return this.waitingForFollowUpCountModel(map);
    }

    @Override
    public Map<String, Object> getCountFollowList(Map<String, Object> map) {
        String tenantCode;
        List reportCodes = (List)map.get("reportCodes");
        String projectCode = (String)map.get("projectCode");
        if (StringUtils.isBlankLoop((String[])new String[]{projectCode, tenantCode = (String)map.get("tenantCode")}) || ListUtil.isEmpty((Collection)reportCodes)) {
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("projectCode", projectCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (String repCode : reportCodes) {
            paramMap.put("reportCode", repCode);
            Integer count = this.countFollow(paramMap);
            resultMap.put(repCode, Long.parseLong(String.valueOf(count)));
        }
        if (resultMap.size() <= 0) {
            return null;
        }
        return resultMap;
    }

    private Integer queryWaitingFollowByEdateDay() {
        Map falgSettingMap;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("flagSettingCode", "waitingFollowDay");
        String falgJsonObj = this.internalInvoke("dd.falgSetting.getFalgSettingByCode", param);
        if (StringUtils.isNotBlank((String)falgJsonObj) && (falgSettingMap = JsonUtil.getJsonToMap((String)falgJsonObj)) != null && falgSettingMap.size() > 0) {
            return Integer.valueOf((String)falgSettingMap.get("flagSettingInfo"));
        }
        return -10;
    }

    private Map<String, Object> getMemberCodeByPhoneNumber(Map<String, Object> map) {
        String likeVal = null;
        String tenantCode = null;
        if (map != null && map.size() > 0) {
            likeVal = (String)map.get("phoneNo");
            tenantCode = (String)map.get("tenantCode");
        }
        if (StringUtils.isBlank(likeVal) || StringUtils.isBlank(tenantCode)) {
            try {
                map.remove("phoneNo");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return map;
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("merberPhone", likeVal);
        param.put("tenantCode", tenantCode);
        String jsonObj = this.internalInvoke("mm.merber.getMerberByAllPhone", param);
        JsonUtil.getAllJsonUtil();
        Map memberMap = JsonUtil.getJsonToMap((String)jsonObj);
        if (memberMap != null && memberMap.size() > 0) {
            String memberCode = (String)memberMap.get("merberCode");
            map.put("memberCode", memberCode);
            return map;
        }
        map.put("memberCode", "###########");
        return map;
    }
}

