/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstIntentionMapper;
import com.yqbsoft.laser.service.estate.domain.EstIntentionDomain;
import com.yqbsoft.laser.service.estate.domain.EstIntentionReDomain;
import com.yqbsoft.laser.service.estate.model.EstIntention;
import com.yqbsoft.laser.service.estate.service.EstIntentionService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstIntentionServiceImpl
extends BaseServiceImpl
implements EstIntentionService {
    public static final String SYS_CODE = "estate.EstIntentionServiceImpl";
    private EstIntentionMapper estIntentionMapper;

    public void setEstIntentionMapper(EstIntentionMapper estIntentionMapper) {
        this.estIntentionMapper = estIntentionMapper;
    }

    private Date getSysDate() {
        try {
            return this.estIntentionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstIntentionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkIntention(EstIntentionDomain estIntentionDomain) {
        if (estIntentionDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setIntentionDefault(EstIntention estIntention) {
        if (estIntention == null) {
            return;
        }
        if (estIntention.getDataState() == null) {
            estIntention.setDataState(0);
        }
        if (estIntention.getGmtCreate() == null) {
            estIntention.setGmtCreate(this.getSysDate());
        }
        estIntention.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estIntention.getIntentionCode())) {
            estIntention.setIntentionCode(this.createUUIDString());
        }
    }

    private int getIntentionMaxCode() {
        int code = 0;
        try {
            return this.estIntentionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstIntentionServiceImpl.getIntentionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setIntentionUpdataDefault(EstIntention estIntention) {
        if (estIntention == null) {
            return;
        }
        estIntention.setGmtModified(this.getSysDate());
    }

    private void saveIntentionModel(EstIntention estIntention) throws ApiException {
        if (estIntention == null) {
            return;
        }
        try {
            this.estIntentionMapper.insert(estIntention);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstIntentionServiceImpl.saveIntentionModel.ex", (Throwable)e);
        }
    }

    private EstIntention getIntentionModelById(Integer intentionId) {
        if (intentionId == null) {
            return null;
        }
        try {
            return this.estIntentionMapper.selectByPrimaryKey(intentionId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstIntentionServiceImpl.getIntentionModelById", (Throwable)e);
            return null;
        }
    }

    public EstIntention getIntentionModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estIntentionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstIntentionServiceImpl.getIntentionModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delIntentionModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estIntentionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstIntentionServiceImpl.delIntentionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstIntentionServiceImpl.delIntentionModelByCode.num");
        }
    }

    private void deleteIntentionModel(Integer intentionId) throws ApiException {
        if (intentionId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estIntentionMapper.deleteByPrimaryKey(intentionId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstIntentionServiceImpl.deleteIntentionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstIntentionServiceImpl.deleteIntentionModel.num");
        }
    }

    private void updateIntentionModel(EstIntention estIntention) throws ApiException {
        if (estIntention == null) {
            return;
        }
        try {
            this.estIntentionMapper.updateByPrimaryKeySelective(estIntention);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstIntentionServiceImpl.updateIntentionModel.ex", (Throwable)e);
        }
    }

    private void updateStateIntentionModel(Integer intentionId, Integer dataState, Integer oldDataState) throws ApiException {
        if (intentionId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("intentionId", intentionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estIntentionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstIntentionServiceImpl.updateStateIntentionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstIntentionServiceImpl.updateStateIntentionModel.null");
        }
    }

    private EstIntention makeIntention(EstIntentionDomain estIntentionDomain, EstIntention estIntention) {
        if (estIntentionDomain == null) {
            return null;
        }
        if (estIntention == null) {
            estIntention = new EstIntention();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estIntention, (Object)estIntentionDomain);
            return estIntention;
        }
        catch (Exception e) {
            this.logger.error("estate.EstIntentionServiceImpl.makeIntention", (Throwable)e);
            return null;
        }
    }

    private List<EstIntention> queryIntentionModelPage(Map<String, Object> parammap) {
        try {
            return this.estIntentionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstIntentionServiceImpl.queryIntentionModel", (Throwable)e);
            return null;
        }
    }

    private int countIntention(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estIntentionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstIntentionServiceImpl.countIntention", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveIntention(EstIntentionDomain estIntentionDomain) throws ApiException {
        String msg = this.checkIntention(estIntentionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstIntentionServiceImpl.saveIntention.checkIntention", msg);
        }
        EstIntention estIntention = this.makeIntention(estIntentionDomain, null);
        this.setIntentionDefault(estIntention);
        this.saveIntentionModel(estIntention);
    }

    @Override
    public void updateIntentionState(Integer intentionId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateIntentionModel(intentionId, dataState, oldDataState);
    }

    @Override
    public void updateIntention(EstIntentionDomain estIntentionDomain) throws ApiException {
        String msg = this.checkIntention(estIntentionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstIntentionServiceImpl.updateIntention.checkIntention", msg);
        }
        EstIntention oldEstIntention = this.getIntentionModelById(estIntentionDomain.getIntentionId());
        if (oldEstIntention == null) {
            throw new ApiException("estate.EstIntentionServiceImpl.updateIntention.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstIntention estIntention = this.makeIntention(estIntentionDomain, oldEstIntention);
        this.setIntentionUpdataDefault(estIntention);
        this.updateIntentionModel(estIntention);
    }

    @Override
    public EstIntention getIntention(Integer intentionId) {
        return this.getIntentionModelById(intentionId);
    }

    @Override
    public void deleteIntention(Integer intentionId) throws ApiException {
        this.deleteIntentionModel(intentionId);
    }

    @Override
    public QueryResult<EstIntention> queryIntentionPage(Map<String, Object> map) {
        List<EstIntention> estIntentionList = this.queryIntentionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countIntention(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estIntentionList);
        return queryResult;
    }

    @Override
    public EstIntention getIntentionByCode(Map<String, Object> map) {
        return this.getIntentionModelByCode(map);
    }

    @Override
    public void delIntentionByCode(Map<String, Object> map) throws ApiException {
        this.delIntentionModelByCode(map);
    }

    @Override
    public List<Map<String, String>> saveBatchIntention(List<EstIntentionReDomain> list) throws ApiException {
        if (list == null) {
            return null;
        }
        ArrayList<Map<String, String>> retVals = new ArrayList<Map<String, String>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<EstIntention> estIntentions = new ArrayList<EstIntention>();
        String memberCode = "memberCode";
        String tenantCode = "tenantCode";
        String projectCode = "projectCode";
        for (EstIntentionReDomain estIntentionReDomain : list) {
            map.put(memberCode, estIntentionReDomain.getMemberCode());
            map.put(tenantCode, estIntentionReDomain.getTenantCode());
            map.put(projectCode, estIntentionReDomain.getProjectCode());
            EstIntention hasEstIntention = this.getIntentionByCode(map);
            if (hasEstIntention == null) {
                EstIntention estIntention = this.makeIntention(estIntentionReDomain, null);
                this.setIntentionDefault(estIntention);
                estIntentions.add(estIntention);
                continue;
            }
            if (estIntentionReDomain.getIntentionContent() == null || Integer.valueOf(estIntentionReDomain.getIntentionContent()) <= Integer.valueOf(hasEstIntention.getIntentionContent())) continue;
            hasEstIntention.setIntentionContent(estIntentionReDomain.getIntentionContent());
            this.updateIntentionModel(hasEstIntention);
        }
        if (estIntentions.size() > 0) {
            this.saveBatchIntentionModel(estIntentions);
        }
        return retVals;
    }

    private void saveBatchIntentionModel(List<EstIntention> estIntentions) throws ApiException {
        if (estIntentions == null) {
            return;
        }
        try {
            this.estIntentionMapper.insertBatch(estIntentions);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstIntentionServiceImpl.saveIntentionModel.ex", (Throwable)e);
        }
    }
}

