/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.github.pagehelper.PageInfo;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstPaymentDetailsMapper;
import com.yqbsoft.laser.service.estate.domain.EstPaymentDetailsDomain;
import com.yqbsoft.laser.service.estate.model.EstPaymentDetails;
import com.yqbsoft.laser.service.estate.model.EstReserveUnitMember;
import com.yqbsoft.laser.service.estate.service.EstPaymentDetailsService;
import com.yqbsoft.laser.service.estate.service.EstReserveUnitMemberService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EstPaymentDetailsServiceImpl
extends BaseServiceImpl
implements EstPaymentDetailsService {
    public static final String SYS_CODE = "estate.EstPaymentDetailsServiceImpl";
    private EstPaymentDetailsMapper estPaymentDetailsMapper;
    private EstReserveUnitMemberService estReserveUnitMemberService;

    public void setEstPaymentDetailsMapper(EstPaymentDetailsMapper estPaymentDetailsMapper) {
        this.estPaymentDetailsMapper = estPaymentDetailsMapper;
    }

    private Date getSysDate() {
        try {
            return this.estPaymentDetailsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPaymentDetails(EstPaymentDetailsDomain estPaymentDetailsDomain) {
        if (estPaymentDetailsDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPaymentDetailsDefault(EstPaymentDetails estPaymentDetails) {
        if (estPaymentDetails == null) {
            return;
        }
        if (estPaymentDetails.getDataState() == null) {
            estPaymentDetails.setDataState(0);
        }
        if (estPaymentDetails.getGmtCreate() == null) {
            estPaymentDetails.setGmtCreate(this.getSysDate());
        }
        estPaymentDetails.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estPaymentDetails.getPaymentDetailsCode())) {
            estPaymentDetails.setPaymentDetailsCode(this.createUUIDString());
        }
    }

    private int getPaymentDetailsMaxCode() {
        int code = 0;
        try {
            return this.estPaymentDetailsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.getPaymentDetailsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPaymentDetailsUpdataDefault(EstPaymentDetails estPaymentDetails) {
        if (estPaymentDetails == null) {
            return;
        }
        estPaymentDetails.setGmtModified(this.getSysDate());
    }

    private void savePaymentDetailsModel(EstPaymentDetails estPaymentDetails) throws ApiException {
        if (estPaymentDetails == null) {
            return;
        }
        try {
            this.estPaymentDetailsMapper.insert(estPaymentDetails);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.savePaymentDetailsModel.ex", (Throwable)e);
        }
    }

    private EstPaymentDetails getPaymentDetailsModelById(Integer paymentDetailsId) {
        if (paymentDetailsId == null) {
            return null;
        }
        try {
            return this.estPaymentDetailsMapper.selectByPrimaryKey(paymentDetailsId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.getPaymentDetailsModelById", (Throwable)e);
            return null;
        }
    }

    public EstPaymentDetails getPaymentDetailsModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estPaymentDetailsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.getPaymentDetailsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPaymentDetailsModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estPaymentDetailsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.delPaymentDetailsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.delPaymentDetailsModelByCode.num");
        }
    }

    private void deletePaymentDetailsModel(Integer paymentDetailsId) throws ApiException {
        if (paymentDetailsId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estPaymentDetailsMapper.deleteByPrimaryKey(paymentDetailsId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.deletePaymentDetailsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.deletePaymentDetailsModel.num");
        }
    }

    private void updatePaymentDetailsModel(EstPaymentDetails estPaymentDetails) throws ApiException {
        if (estPaymentDetails == null) {
            return;
        }
        try {
            this.estPaymentDetailsMapper.updateByPrimaryKeySelective(estPaymentDetails);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.updatePaymentDetailsModel.ex", (Throwable)e);
        }
    }

    private void updateStatePaymentDetailsModel(Integer paymentDetailsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (paymentDetailsId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("paymentDetailsId", paymentDetailsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estPaymentDetailsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.updateStatePaymentDetailsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.updateStatePaymentDetailsModel.null");
        }
    }

    private EstPaymentDetails makePaymentDetails(EstPaymentDetailsDomain estPaymentDetailsDomain, EstPaymentDetails estPaymentDetails) {
        if (estPaymentDetailsDomain == null) {
            return null;
        }
        if (estPaymentDetails == null) {
            estPaymentDetails = new EstPaymentDetails();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estPaymentDetails, (Object)estPaymentDetailsDomain);
            return estPaymentDetails;
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.makePaymentDetails", (Throwable)e);
            return null;
        }
    }

    private List<EstPaymentDetails> queryPaymentDetailsModelPage(Map<String, Object> parammap) {
        try {
            return this.estPaymentDetailsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.queryPaymentDetailsModel", (Throwable)e);
            return null;
        }
    }

    private int countPaymentDetails(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estPaymentDetailsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.countPaymentDetails", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePaymentDetails(EstPaymentDetailsDomain estPaymentDetailsDomain) throws ApiException {
        String msg = this.checkPaymentDetails(estPaymentDetailsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.savePaymentDetails.checkPaymentDetails", msg);
        }
        EstPaymentDetails estPaymentDetails = this.makePaymentDetails(estPaymentDetailsDomain, null);
        if (estPaymentDetails.getLoanTerm() == 0) {
            estPaymentDetails.setLoanTerm(null);
        }
        this.setPaymentDetailsDefault(estPaymentDetails);
        this.savePaymentDetailsModel(estPaymentDetails);
    }

    @Override
    public void updatePaymentDetailsState(Integer paymentDetailsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePaymentDetailsModel(paymentDetailsId, dataState, oldDataState);
    }

    @Override
    public void updatePaymentDetails(EstPaymentDetailsDomain estPaymentDetailsDomain) throws ApiException {
        String msg = this.checkPaymentDetails(estPaymentDetailsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.updatePaymentDetails.checkPaymentDetails", msg);
        }
        EstPaymentDetails oldEstPaymentDetails = this.getPaymentDetailsModelById(estPaymentDetailsDomain.getPaymentDetailsId());
        if (oldEstPaymentDetails == null) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.updatePaymentDetails.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstPaymentDetails estPaymentDetails = this.makePaymentDetails(estPaymentDetailsDomain, oldEstPaymentDetails);
        this.setPaymentDetailsUpdataDefault(estPaymentDetails);
        this.updatePaymentDetailsModel(estPaymentDetails);
    }

    @Override
    public EstPaymentDetails getPaymentDetails(Integer paymentDetailsId) {
        return this.getPaymentDetailsModelById(paymentDetailsId);
    }

    @Override
    public void deletePaymentDetails(Integer paymentDetailsId) throws ApiException {
        this.deletePaymentDetailsModel(paymentDetailsId);
    }

    @Override
    public QueryResult<EstPaymentDetails> queryPaymentDetailsPage(Map<String, Object> map) {
        List<EstPaymentDetails> estPaymentDetailsList = this.queryPaymentDetailsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPaymentDetails(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estPaymentDetailsList);
        return queryResult;
    }

    @Override
    public EstPaymentDetails getPaymentDetailsByCode(Map<String, Object> map) {
        return this.getPaymentDetailsModelByCode(map);
    }

    @Override
    public void delPaymentDetailsByCode(Map<String, Object> map) throws ApiException {
        this.delPaymentDetailsModelByCode(map);
    }

    @Override
    public QueryResult<Map<String, Object>> queryPaymentDetailsAndreserveUnit(Map<String, Object> map) throws ApiException {
        PageInfo<Map<String, Object>> estPaymentDetailsPageList = this.queryPaymentDetailsAndreserveUnitModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.valueOf(String.valueOf(estPaymentDetailsPageList.getTotal())).intValue());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estPaymentDetailsPageList.getList());
        return queryResult;
    }

    private List<EstReserveUnitMember> getReserveUnitCodeByPhone(Map<String, Object> map) {
        QueryResult<EstReserveUnitMember> sup;
        if (map != null && map.get("memberPhone") != null && !"".equals(map.get("memberPhone")) && (sup = this.estReserveUnitMemberService.queryReserveUnitMemberPage(map)) != null) {
            List member = sup.getList();
            HashSet<String> set = new HashSet<String>();
            for (EstReserveUnitMember em : member) {
                set.add(em.getReserveUnitCode());
            }
            if (ListUtil.isNotEmpty(set)) {
                map.put("reserveUnitCodes", set);
            }
        }
        return null;
    }

    private PageInfo<Map<String, Object>> queryPaymentDetailsAndreserveUnitModel(Map<String, Object> map) {
        try {
            this.startPage(map);
            List<Map<String, Object>> mapList = this.estPaymentDetailsMapper.queryPaymentDetailsAndreserveUnit(map);
            return this.getPageInfo(mapList);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.queryPaymentDetails", (Throwable)e);
            return null;
        }
    }

    private int countPaymentDetailsAndreserveUnitModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estPaymentDetailsMapper.countPaymentDetailsAndreserveUnit(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.countPaymentDetailsAndreserveUnitModel", (Throwable)e);
        }
        return i;
    }

    @Override
    public QueryResult<String> queryPdReserveUnitCodeAtLastHandle(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        this.getReserveUnitCodeByPhone(map);
        List<String> reserveUnitCodes = this.queryPdReserveUnitCodeAtLastHandleModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.queryPdReserveUnitCodeAtLastHandleCountModel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(reserveUnitCodes);
        return queryResult;
    }

    private List<String> queryPdReserveUnitCodeAtLastHandleModel(Map<String, Object> map) {
        try {
            return this.estPaymentDetailsMapper.queryPdReserveUnitCodeAtLastHandle(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.queryPdReserveUnitCodeAtLastHandleModel", (Throwable)e);
            return null;
        }
    }

    private int queryPdReserveUnitCodeAtLastHandleCountModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estPaymentDetailsMapper.queryPdReserveUnitCodeAtLastHandleCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPaymentDetailsServiceImpl.queryPdReserveUnitCodeAtLastHandleCountModel", (Throwable)e);
        }
        return i;
    }

    public void setEstReserveUnitMemberService(EstReserveUnitMemberService estReserveUnitMemberService) {
        this.estReserveUnitMemberService = estReserveUnitMemberService;
    }

    @Override
    public Boolean updatePaymentDetailsAcceptHandle(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("paymentDetailsCode", map.get("paymentDetailsCode"));
        List<EstPaymentDetails> list = this.queryPaymentDetailsModelPage(m);
        if (ListUtil.isEmpty(list)) {
            return false;
        }
        this.updatePaymentDetailsAcceptHandleModel(map);
        return true;
    }

    private void updatePaymentDetailsAcceptHandleModel(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.estPaymentDetailsMapper.updatePaymentDetailsAcceptHandle(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.updatePaymentDetailsModel.ex", "\u4fee\u6539\u5931\u8d25");
        }
        if (i < 1) {
            throw new ApiException("estate.EstPaymentDetailsServiceImpl.updatePaymentDetailsInfluence\u2014\u20140", "\u4fee\u6539\u5931\u8d25");
        }
    }

    @Override
    public EstPaymentDetails getPaymentDetailsByReserveUnitCode(Map<String, Object> map) {
        List<EstPaymentDetails> paymentDetails = this.queryPaymentDetailsModelPage(map);
        if (ListUtil.isNotEmpty(paymentDetails)) {
            return paymentDetails.get(0);
        }
        return null;
    }
}

