/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstPosterMapper;
import com.yqbsoft.laser.service.estate.domain.EstPosterDomain;
import com.yqbsoft.laser.service.estate.model.EstPoster;
import com.yqbsoft.laser.service.estate.service.EstPosterService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstPosterServiceImpl
extends BaseServiceImpl
implements EstPosterService {
    public static final String SYS_CODE = "estate.EstPosterServiceImpl";
    private EstPosterMapper estPosterMapper;

    public void setEstPosterMapper(EstPosterMapper estPosterMapper) {
        this.estPosterMapper = estPosterMapper;
    }

    private Date getSysDate() {
        try {
            return this.estPosterMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPosterServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPoster(EstPosterDomain estPosterDomain) {
        if (estPosterDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPosterDefault(EstPoster estPoster) {
        if (estPoster == null) {
            return;
        }
        if (estPoster.getDataState() == null) {
            estPoster.setDataState(0);
        }
        if (estPoster.getGmtCreate() == null) {
            estPoster.setGmtCreate(this.getSysDate());
        }
        estPoster.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estPoster.getPosterCode())) {
            estPoster.setPosterCode(this.createUUIDString());
        }
    }

    private int getPosterMaxCode() {
        int code = 0;
        try {
            return this.estPosterMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPosterServiceImpl.getPosterMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPosterUpdataDefault(EstPoster estPoster) {
        if (estPoster == null) {
            return;
        }
        estPoster.setGmtModified(this.getSysDate());
    }

    private void savePosterModel(EstPoster estPoster) throws ApiException {
        if (estPoster == null) {
            return;
        }
        try {
            this.estPosterMapper.insert(estPoster);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPosterServiceImpl.savePosterModel.ex", (Throwable)e);
        }
    }

    private EstPoster getPosterModelById(Integer posterId) {
        if (posterId == null) {
            return null;
        }
        try {
            return this.estPosterMapper.selectByPrimaryKey(posterId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPosterServiceImpl.getPosterModelById", (Throwable)e);
            return null;
        }
    }

    public EstPoster getPosterModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estPosterMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPosterServiceImpl.getPosterModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPosterModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estPosterMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPosterServiceImpl.delPosterModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPosterServiceImpl.delPosterModelByCode.num");
        }
    }

    private void deletePosterModel(Integer posterId) throws ApiException {
        if (posterId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estPosterMapper.deleteByPrimaryKey(posterId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPosterServiceImpl.deletePosterModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPosterServiceImpl.deletePosterModel.num");
        }
    }

    private void updatePosterModel(EstPoster estPoster) throws ApiException {
        if (estPoster == null) {
            return;
        }
        try {
            this.estPosterMapper.updateByPrimaryKeySelective(estPoster);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPosterServiceImpl.updatePosterModel.ex", (Throwable)e);
        }
    }

    private void updateStatePosterModel(Integer posterId, Integer dataState, Integer oldDataState) throws ApiException {
        if (posterId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("posterId", posterId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estPosterMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPosterServiceImpl.updateStatePosterModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstPosterServiceImpl.updateStatePosterModel.null");
        }
    }

    private EstPoster makePoster(EstPosterDomain estPosterDomain, EstPoster estPoster) {
        if (estPosterDomain == null) {
            return null;
        }
        if (estPoster == null) {
            estPoster = new EstPoster();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estPoster, (Object)estPosterDomain);
            return estPoster;
        }
        catch (Exception e) {
            this.logger.error("estate.EstPosterServiceImpl.makePoster", (Throwable)e);
            return null;
        }
    }

    private List<EstPoster> queryPosterModelPage(Map<String, Object> parammap) {
        try {
            return this.estPosterMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPosterServiceImpl.queryPosterModel", (Throwable)e);
            return null;
        }
    }

    private int countPoster(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estPosterMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPosterServiceImpl.countPoster", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePoster(EstPosterDomain estPosterDomain) throws ApiException {
        String msg = this.checkPoster(estPosterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPosterServiceImpl.savePoster.checkPoster", msg);
        }
        EstPoster estPoster = this.makePoster(estPosterDomain, null);
        this.setPosterDefault(estPoster);
        this.savePosterModel(estPoster);
    }

    @Override
    public void updatePosterState(Integer posterId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePosterModel(posterId, dataState, oldDataState);
    }

    @Override
    public void updatePoster(EstPosterDomain estPosterDomain) throws ApiException {
        String msg = this.checkPoster(estPosterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPosterServiceImpl.updatePoster.checkPoster", msg);
        }
        EstPoster oldEstPoster = this.getPosterModelById(estPosterDomain.getPosterId());
        if (oldEstPoster == null) {
            throw new ApiException("estate.EstPosterServiceImpl.updatePoster.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstPoster estPoster = this.makePoster(estPosterDomain, oldEstPoster);
        this.setPosterUpdataDefault(estPoster);
        this.updatePosterModel(estPoster);
    }

    @Override
    public EstPoster getPoster(Integer posterId) {
        return this.getPosterModelById(posterId);
    }

    @Override
    public void deletePoster(Integer posterId) throws ApiException {
        this.deletePosterModel(posterId);
    }

    @Override
    public QueryResult<EstPoster> queryPosterPage(Map<String, Object> map) {
        List<EstPoster> estPosterList = this.queryPosterModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPoster(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estPosterList);
        return queryResult;
    }

    @Override
    public EstPoster getPosterByCode(Map<String, Object> map) {
        return this.getPosterModelByCode(map);
    }

    @Override
    public void delPosterByCode(Map<String, Object> map) throws ApiException {
        this.delPosterModelByCode(map);
    }
}

