/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.dd.DdTransUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.EstateConstants;
import com.yqbsoft.laser.service.estate.dao.EstPropertyMgmtMapper;
import com.yqbsoft.laser.service.estate.domain.EstPropertyMgmtDomain;
import com.yqbsoft.laser.service.estate.model.EstPropertyMgmt;
import com.yqbsoft.laser.service.estate.model.EstReserveUnit;
import com.yqbsoft.laser.service.estate.service.EstPropertyMgmtService;
import com.yqbsoft.laser.service.estate.service.EstReceivablesRecordService;
import com.yqbsoft.laser.service.estate.service.EstReserveUnitService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class EstPropertyMgmtServiceImpl
extends BaseServiceImpl
implements EstPropertyMgmtService {
    public static final String SYS_CODE = "estate.EstPropertyMgmtServiceImpl";
    private EstPropertyMgmtMapper estPropertyMgmtMapper;
    public EstReserveUnitService estReserveUnitService;
    private EstReceivablesRecordService estReceivablesRecordService;

    public void setEstPropertyMgmtMapper(EstPropertyMgmtMapper estPropertyMgmtMapper) {
        this.estPropertyMgmtMapper = estPropertyMgmtMapper;
    }

    public void setEstReserveUnitService(EstReserveUnitService estReserveUnitService) {
        this.estReserveUnitService = estReserveUnitService;
    }

    public void setEstReceivablesRecordService(EstReceivablesRecordService estReceivablesRecordService) {
        this.estReceivablesRecordService = estReceivablesRecordService;
    }

    private Date getSysDate() {
        try {
            return this.estPropertyMgmtMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPropertyMgmtServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPropertyMgmt(EstPropertyMgmtDomain estPropertyMgmtDomain) {
        if (estPropertyMgmtDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPropertyMgmtDefault(EstPropertyMgmt estPropertyMgmt) {
        if (estPropertyMgmt == null) {
            return;
        }
        if (estPropertyMgmt.getDataState() == null) {
            estPropertyMgmt.setDataState(0);
        }
        if (estPropertyMgmt.getGmtCreate() == null) {
            estPropertyMgmt.setGmtCreate(this.getSysDate());
        }
        estPropertyMgmt.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estPropertyMgmt.getPropertyMgmtCode())) {
            estPropertyMgmt.setPropertyMgmtCode(this.createUUIDString());
        }
    }

    private int getPropertyMgmtMaxCode() {
        int code = 0;
        try {
            return this.estPropertyMgmtMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPropertyMgmtServiceImpl.getPropertyMgmtMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPropertyMgmtUpdataDefault(EstPropertyMgmt estPropertyMgmt) {
        if (estPropertyMgmt == null) {
            return;
        }
        estPropertyMgmt.setGmtModified(this.getSysDate());
    }

    private void savePropertyMgmtModel(EstPropertyMgmt estPropertyMgmt) throws ApiException {
        if (estPropertyMgmt == null) {
            return;
        }
        try {
            this.estPropertyMgmtMapper.insert(estPropertyMgmt);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.savePropertyMgmtModel.ex", (Throwable)e);
        }
    }

    private EstPropertyMgmt getPropertyMgmtModelById(Integer propertyMgmtId) {
        if (propertyMgmtId == null) {
            return null;
        }
        try {
            return this.estPropertyMgmtMapper.selectByPrimaryKey(propertyMgmtId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPropertyMgmtServiceImpl.getPropertyMgmtModelById", (Throwable)e);
            return null;
        }
    }

    public EstPropertyMgmt getPropertyMgmtModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estPropertyMgmtMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPropertyMgmtServiceImpl.getPropertyMgmtModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPropertyMgmtModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estPropertyMgmtMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.delPropertyMgmtModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.delPropertyMgmtModelByCode.num");
        }
    }

    private void deletePropertyMgmtModel(Integer propertyMgmtId) throws ApiException {
        if (propertyMgmtId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estPropertyMgmtMapper.deleteByPrimaryKey(propertyMgmtId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.deletePropertyMgmtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.deletePropertyMgmtModel.num");
        }
    }

    private void updatePropertyMgmtModel(EstPropertyMgmt estPropertyMgmt) throws ApiException {
        if (estPropertyMgmt == null) {
            return;
        }
        try {
            this.estPropertyMgmtMapper.updateByPrimaryKeySelective(estPropertyMgmt);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.updatePropertyMgmtModel.ex", (Throwable)e);
        }
    }

    private void updateStatePropertyMgmtModel(Integer propertyMgmtId, Integer dataState, Integer oldDataState) throws ApiException {
        if (propertyMgmtId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propertyMgmtId", propertyMgmtId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estPropertyMgmtMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.updateStatePropertyMgmtModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.updateStatePropertyMgmtModel.null");
        }
    }

    private EstPropertyMgmt makePropertyMgmt(EstPropertyMgmtDomain estPropertyMgmtDomain, EstPropertyMgmt estPropertyMgmt) {
        if (estPropertyMgmtDomain == null) {
            return null;
        }
        if (estPropertyMgmt == null) {
            estPropertyMgmt = new EstPropertyMgmt();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estPropertyMgmt, (Object)estPropertyMgmtDomain);
            return estPropertyMgmt;
        }
        catch (Exception e) {
            this.logger.error("estate.EstPropertyMgmtServiceImpl.makePropertyMgmt", (Throwable)e);
            return null;
        }
    }

    private List<EstPropertyMgmt> queryPropertyMgmtModelPage(Map<String, Object> parammap) {
        try {
            return this.estPropertyMgmtMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPropertyMgmtServiceImpl.queryPropertyMgmtModel", (Throwable)e);
            return null;
        }
    }

    private int countPropertyMgmt(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estPropertyMgmtMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPropertyMgmtServiceImpl.countPropertyMgmt", (Throwable)e);
        }
        return i;
    }

    @Override
    public String savePropertyMgmt(EstPropertyMgmtDomain estPropertyMgmtDomain) throws ApiException {
        String msg = this.checkPropertyMgmt(estPropertyMgmtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.savePropertyMgmt.checkPropertyMgmt", msg);
        }
        EstPropertyMgmt estPropertyMgmt = this.makePropertyMgmt(estPropertyMgmtDomain, null);
        this.setPropertyMgmtDefault(estPropertyMgmt);
        this.savePropertyMgmtModel(estPropertyMgmt);
        return estPropertyMgmt.getPropertyMgmtCode();
    }

    @Override
    public void updatePropertyMgmtState(Integer propertyMgmtId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePropertyMgmtModel(propertyMgmtId, dataState, oldDataState);
    }

    @Override
    public void updatePropertyMgmt(EstPropertyMgmtDomain estPropertyMgmtDomain) throws ApiException {
        String msg = this.checkPropertyMgmt(estPropertyMgmtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.updatePropertyMgmt.checkPropertyMgmt", msg);
        }
        EstPropertyMgmt oldEstPropertyMgmt = this.getPropertyMgmtModelById(estPropertyMgmtDomain.getPropertyMgmtId());
        if (oldEstPropertyMgmt == null) {
            throw new ApiException("estate.EstPropertyMgmtServiceImpl.updatePropertyMgmt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstPropertyMgmt estPropertyMgmt = this.makePropertyMgmt(estPropertyMgmtDomain, oldEstPropertyMgmt);
        this.setPropertyMgmtUpdataDefault(estPropertyMgmt);
        this.updatePropertyMgmtModel(estPropertyMgmt);
    }

    @Override
    public EstPropertyMgmt getPropertyMgmt(Integer propertyMgmtId) {
        return this.getPropertyMgmtModelById(propertyMgmtId);
    }

    @Override
    public void deletePropertyMgmt(Integer propertyMgmtId) throws ApiException {
        this.deletePropertyMgmtModel(propertyMgmtId);
    }

    @Override
    public QueryResult<EstPropertyMgmt> queryPropertyMgmtPage(Map<String, Object> map) {
        List<EstPropertyMgmt> estPropertyMgmtList = this.queryPropertyMgmtModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPropertyMgmt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estPropertyMgmtList);
        return queryResult;
    }

    @Override
    public EstPropertyMgmt getPropertyMgmtByCode(Map<String, Object> map) {
        return this.getPropertyMgmtModelByCode(map);
    }

    @Override
    public void delPropertyMgmtByCode(Map<String, Object> map) throws ApiException {
        this.delPropertyMgmtModelByCode(map);
    }

    @Override
    public void batchCheckBreachContractBuilding(Map<String, Object> map) {
    }

    private Map<String, Object> getBuildingInfo(String buildingCode, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("buildingCode", buildingCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> postParam = new HashMap<String, String>();
        postParam.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        String resultJson = this.internalInvoke("pt.project.getBuildingByCode", postParam);
        if (StringUtils.isNotBlank((String)resultJson)) {
            return (Map)JsonUtil.buildNonNullBinder().getJsonToMap(resultJson, String.class, Object.class);
        }
        return null;
    }

    @Override
    public void batchInitBuildingPropertyMgmt(Map<String, Object> map) {
        String buildingCode = String.valueOf(map.get("buildingCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        if (StringUtils.isBlank((String)buildingCode)) {
            return;
        }
        Map<String, Object> buildingMapResult = this.getBuildingInfo(buildingCode, tenantCode);
        if (buildingMapResult == null) {
            return;
        }
        String projectCode = String.valueOf(buildingMapResult.get("projectCode"));
        List ddEntities = DdTransUtil.getDdList((String)"PropertyMgmt-elevatorFee-");
        List<EstReserveUnit> estReserveUnitList = this.queryReserveUnitListByBuildingCode(buildingCode, projectCode, tenantCode);
        if (ListUtil.isEmpty(estReserveUnitList)) {
            return;
        }
        for (EstReserveUnit reserveUnit : estReserveUnitList) {
            this.batchInputBreachHandoverHouse(buildingMapResult, reserveUnit);
            this.batchInputPropertyMgmtFee(buildingMapResult, reserveUnit);
            this.batchInputPropertyMgmtDecorationFee(buildingMapResult, reserveUnit);
        }
    }

    private void batchInputBreachHandoverHouse(Map<String, Object> buildingMap, EstReserveUnit reserveUnit) {
        String buildingRatioStr = String.valueOf(buildingMap.get("buildingRatio"));
        BigDecimal buildingRatio = buildingRatioStr != null ? new BigDecimal(buildingRatioStr) : BigDecimal.ZERO;
        Date buildingHandoverDate = null;
        try {
            buildingHandoverDate = DateUtils.parseDate((String)buildingMap.get("buildingHandoverDate").toString(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (buildingHandoverDate == null || reserveUnit.getHandoverDate() == null) {
            return;
        }
        if (DateUtil.checkMax((Date)buildingHandoverDate, (Date)reserveUnit.getHandoverDate())) {
            EstPropertyMgmtDomain estPropertyMgmtDomain = this.setEstPropertyMgmtDomain(reserveUnit);
            estPropertyMgmtDomain.setOverdueDays(DateUtils.getBetweenDays((Date)reserveUnit.getHandoverDate(), (Date)buildingHandoverDate));
            BigDecimal totalRatio = buildingRatio.multiply(new BigDecimal(estPropertyMgmtDomain.getOverdueDays()));
            estPropertyMgmtDomain.setTotalAmount(reserveUnit.getTotalTransactionPrice().multiply(totalRatio));
            estPropertyMgmtDomain.setPropertyMgmtType(EstateConstants.PROPERTY_MGMT_TYPE_1);
            estPropertyMgmtDomain.setHandoverDate(reserveUnit.getHandoverDate());
            estPropertyMgmtDomain.setActualHandoverDate(buildingHandoverDate);
            estPropertyMgmtDomain.setCostStatus(0);
            this.savePropertyMgmt(estPropertyMgmtDomain);
        }
    }

    private void batchInputPropertyMgmtFee(Map<String, Object> buildingMap, EstReserveUnit reserveUnit) {
        ScriptEngine scriptEngine = new ScriptEngineManager().getEngineByName("JavaScript");
        Date buildingHandoverDate = null;
        try {
            buildingHandoverDate = DateUtils.parseDate((String)buildingMap.get("buildingHandoverDate").toString(), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String formula = DdTransUtil.getDdValue((String)"PropertyMgmt-formula-PMF");
        String elevatorCost = DdTransUtil.getDdValue((String)"PropertyMgmt-formula-EF");
        String commonCost = DdTransUtil.getDdValue((String)"PropertyMgmt-formula-CF");
        String junkFees = DdTransUtil.getDdValue((String)"PropertyMgmt-formula-GF");
        String twoPressureFee = DdTransUtil.getDdValue((String)"PropertyMgmt-formula-TPF");
        EstPropertyMgmtDomain estPropertyMgmtDomain = this.setEstPropertyMgmtDomain(reserveUnit);
        HashMap<String, String> inwardCollectionExtMap = new HashMap<String, String>();
        formula = formula.replace("x", reserveUnit.getContractArea());
        try {
            estPropertyMgmtDomain.setPropertyServiceFeeAmount(new BigDecimal(String.valueOf(scriptEngine.eval(formula))));
            elevatorCost = elevatorCost.replace("x", reserveUnit.getContractArea());
            inwardCollectionExtMap.put("elevatorCost", String.valueOf(scriptEngine.eval(elevatorCost)));
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        inwardCollectionExtMap.put("commonCost", commonCost);
        inwardCollectionExtMap.put("junkFees", junkFees);
        inwardCollectionExtMap.put("twoPressureFee", twoPressureFee);
        inwardCollectionExtMap.put("totalAmount", String.valueOf(new BigDecimal((String)inwardCollectionExtMap.get("elevatorCost")).add(new BigDecimal((String)inwardCollectionExtMap.get("commonCost"))).add(new BigDecimal((String)inwardCollectionExtMap.get("junkFees"))).add(new BigDecimal((String)inwardCollectionExtMap.get("twoPressureFee")))));
        estPropertyMgmtDomain.setInwardCollectionExt(JsonUtil.getAllJsonUtil().toJson(inwardCollectionExtMap));
        BigDecimal totalAmount = estPropertyMgmtDomain.getPropertyServiceFeeAmount().add(new BigDecimal((String)inwardCollectionExtMap.get("totalAmount")));
        String buildingRatioStr = String.valueOf(buildingMap.get("buildingRatio"));
        BigDecimal buildingRatio = buildingRatioStr != null ? new BigDecimal(buildingRatioStr) : BigDecimal.ZERO;
        long betweenDays = DateUtils.getBetweenDays((Date)reserveUnit.getHandoverDate(), (Date)buildingHandoverDate);
        BigDecimal totalRatio = buildingRatio.multiply(new BigDecimal(betweenDays));
        estPropertyMgmtDomain.setAmountPayable(totalAmount.subtract(reserveUnit.getTotalTransactionPrice().multiply(totalRatio)));
        estPropertyMgmtDomain.setTotalAmount(totalAmount);
        estPropertyMgmtDomain.setPropertyMgmtType(EstateConstants.PROPERTY_MGMT_TYPE_2);
        estPropertyMgmtDomain.setHandoverDate(reserveUnit.getHandoverDate());
        estPropertyMgmtDomain.setActualHandoverDate(buildingHandoverDate);
        estPropertyMgmtDomain.setPropertyPaymentDate(buildingHandoverDate);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(buildingHandoverDate);
        calendar.add(1, 1);
        estPropertyMgmtDomain.setPropertyPaymentPeriod(calendar.getTime());
        this.savePropertyMgmt(estPropertyMgmtDomain);
    }

    private void batchInputPropertyMgmtDecorationFee(Map<String, Object> buildingMap, EstReserveUnit reserveUnit) {
        String decorationDeposit = DdTransUtil.getDdValue((String)"PropertyMgmt-formula-DD");
        String decorationGF = DdTransUtil.getDdValue((String)"PropertyMgmt-formula-DGF");
        String decorationGHF = DdTransUtil.getDdValue((String)"PropertyMgmt-formula-DGHF");
        EstPropertyMgmtDomain estPropertyMgmtDomain = this.setEstPropertyMgmtDomain(reserveUnit);
        estPropertyMgmtDomain.setPropertyMgmtType(EstateConstants.PROPERTY_MGMT_TYPE_3);
        this.savePropertyMgmt(estPropertyMgmtDomain);
    }

    private EstPropertyMgmtDomain setEstPropertyMgmtDomain(EstReserveUnit reserveUnit) {
        EstPropertyMgmtDomain estPropertyMgmtDomain = new EstPropertyMgmtDomain();
        estPropertyMgmtDomain.setReportCode(reserveUnit.getReportCode());
        estPropertyMgmtDomain.setReserveUnitCode(reserveUnit.getReserveUnitCode());
        estPropertyMgmtDomain.setProjectCode(reserveUnit.getProjectCode());
        estPropertyMgmtDomain.setMemberCode(reserveUnit.getMemberCode());
        estPropertyMgmtDomain.setUnitNumber(reserveUnit.getUnitNumber());
        estPropertyMgmtDomain.setUnitCode(reserveUnit.getUnitCode());
        estPropertyMgmtDomain.setBuildingNumber(reserveUnit.getBuildingNumber());
        estPropertyMgmtDomain.setRoomNumber(reserveUnit.getRoomNumber());
        estPropertyMgmtDomain.setHouseCode(reserveUnit.getHouseCode());
        estPropertyMgmtDomain.setHouseType(reserveUnit.getHouseType());
        estPropertyMgmtDomain.setCostStatus(0);
        estPropertyMgmtDomain.setTenantCode(reserveUnit.getTenantCode());
        return estPropertyMgmtDomain;
    }

    private List<EstReserveUnit> queryReserveUnitListByBuildingCode(String buildingCode, String projectCode, String tenantCode) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("flowLinkType", EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType());
        paramMap.put("approvalStatus", EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_THROUGH.getApprovalStatus());
        paramMap.put("buildingCode", buildingCode);
        paramMap.put("projectCode", projectCode);
        paramMap.put("tenantCode", tenantCode);
        List<EstReserveUnit> estReserveUnitList = this.estReserveUnitService.queryByFlowLink(paramMap);
        if (ListUtil.isNotEmpty(estReserveUnitList)) {
            return estReserveUnitList;
        }
        return null;
    }
}

