/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstPublicPoolMapper;
import com.yqbsoft.laser.service.estate.dao.EstPublicPoolOpMapper;
import com.yqbsoft.laser.service.estate.domain.EstPublicPoolOpDomain;
import com.yqbsoft.laser.service.estate.model.EstPublicPool;
import com.yqbsoft.laser.service.estate.model.EstPublicPoolOp;
import com.yqbsoft.laser.service.estate.model.UserBean;
import com.yqbsoft.laser.service.estate.service.EstPublicPoolOpService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class EstPublicPoolOpServiceImpl
extends BaseServiceImpl
implements EstPublicPoolOpService {
    public static final String SYS_CODE = "estate.EstPublicPoolOpServiceImpl";
    private EstPublicPoolOpMapper estPublicPoolOpMapper;
    @Autowired
    private EstPublicPoolMapper estPublicPoolMapper;

    public void setEstPublicPoolOpMapper(EstPublicPoolOpMapper estPublicPoolOpMapper) {
        this.estPublicPoolOpMapper = estPublicPoolOpMapper;
    }

    private Date getSysDate() {
        try {
            return this.estPublicPoolOpMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolOpServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPublicPoolOp(EstPublicPoolOpDomain estPublicPoolOpDomain) {
        if (estPublicPoolOpDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPublicPoolOpDefault(EstPublicPoolOp estPublicPoolOp) {
        if (estPublicPoolOp == null) {
            return;
        }
        if (estPublicPoolOp.getDataState() == null) {
            estPublicPoolOp.setDataState(0);
        }
        if (estPublicPoolOp.getGmtCreate() == null) {
            estPublicPoolOp.setGmtCreate(this.getSysDate());
        }
        estPublicPoolOp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estPublicPoolOp.getPublicPoolOpCode())) {
            estPublicPoolOp.setPublicPoolOpCode(this.createUUIDString());
        }
    }

    private int getPublicPoolOpMaxCode() {
        int code = 0;
        try {
            return this.estPublicPoolOpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolOpServiceImpl.getPublicPoolOpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPublicPoolOpUpdataDefault(EstPublicPoolOp estPublicPoolOp) {
        if (estPublicPoolOp == null) {
            return;
        }
        estPublicPoolOp.setGmtModified(this.getSysDate());
    }

    private void savePublicPoolOpModel(EstPublicPoolOp estPublicPoolOp) throws ApiException {
        if (estPublicPoolOp == null) {
            return;
        }
        try {
            this.estPublicPoolOpMapper.insert(estPublicPoolOp);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.savePublicPoolOpModel.ex", (Throwable)e);
        }
    }

    private EstPublicPoolOp getPublicPoolOpModelById(Integer publicPoolOpId) {
        if (publicPoolOpId == null) {
            return null;
        }
        try {
            return this.estPublicPoolOpMapper.selectByPrimaryKey(publicPoolOpId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolOpServiceImpl.getPublicPoolOpModelById", (Throwable)e);
            return null;
        }
    }

    public EstPublicPoolOp getPublicPoolOpModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estPublicPoolOpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolOpServiceImpl.getPublicPoolOpModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPublicPoolOpModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estPublicPoolOpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.delPublicPoolOpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.delPublicPoolOpModelByCode.num");
        }
    }

    private void deletePublicPoolOpModel(Integer publicPoolOpId) throws ApiException {
        if (publicPoolOpId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estPublicPoolOpMapper.deleteByPrimaryKey(publicPoolOpId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.deletePublicPoolOpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.deletePublicPoolOpModel.num");
        }
    }

    private void updatePublicPoolOpModel(EstPublicPoolOp estPublicPoolOp) throws ApiException {
        if (estPublicPoolOp == null) {
            return;
        }
        try {
            this.estPublicPoolOpMapper.updateByPrimaryKeySelective(estPublicPoolOp);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.updatePublicPoolOpModel.ex", (Throwable)e);
        }
    }

    private void updateStatePublicPoolOpModel(Integer publicPoolOpId, Integer dataState, Integer oldDataState) throws ApiException {
        if (publicPoolOpId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("publicPoolOpId", publicPoolOpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estPublicPoolOpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.updateStatePublicPoolOpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.updateStatePublicPoolOpModel.null");
        }
    }

    private EstPublicPoolOp makePublicPoolOp(EstPublicPoolOpDomain estPublicPoolOpDomain, EstPublicPoolOp estPublicPoolOp) {
        if (estPublicPoolOpDomain == null) {
            return null;
        }
        if (estPublicPoolOp == null) {
            estPublicPoolOp = new EstPublicPoolOp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estPublicPoolOp, (Object)estPublicPoolOpDomain);
            return estPublicPoolOp;
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolOpServiceImpl.makePublicPoolOp", (Throwable)e);
            return null;
        }
    }

    private List<EstPublicPoolOp> queryPublicPoolOpModelPage(Map<String, Object> parammap) {
        try {
            return this.estPublicPoolOpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolOpServiceImpl.queryPublicPoolOpModel", (Throwable)e);
            return null;
        }
    }

    private int countPublicPoolOp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estPublicPoolOpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolOpServiceImpl.countPublicPoolOp", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePublicPoolOp(EstPublicPoolOpDomain estPublicPoolOpDomain) throws ApiException {
        String msg = this.checkPublicPoolOp(estPublicPoolOpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.savePublicPoolOp.checkPublicPoolOp", msg);
        }
        EstPublicPoolOp estPublicPoolOp = this.makePublicPoolOp(estPublicPoolOpDomain, null);
        this.setPublicPoolOpDefault(estPublicPoolOp);
        this.savePublicPoolOpModel(estPublicPoolOp);
    }

    @Override
    public void updatePublicPoolOpState(Integer publicPoolOpId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePublicPoolOpModel(publicPoolOpId, dataState, oldDataState);
    }

    @Override
    public void updatePublicPoolOp(EstPublicPoolOpDomain estPublicPoolOpDomain) throws ApiException {
        String msg = this.checkPublicPoolOp(estPublicPoolOpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.updatePublicPoolOp.checkPublicPoolOp", msg);
        }
        EstPublicPoolOp oldEstPublicPoolOp = this.getPublicPoolOpModelById(estPublicPoolOpDomain.getPublicPoolOpId());
        if (oldEstPublicPoolOp == null) {
            throw new ApiException("estate.EstPublicPoolOpServiceImpl.updatePublicPoolOp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstPublicPoolOp estPublicPoolOp = this.makePublicPoolOp(estPublicPoolOpDomain, oldEstPublicPoolOp);
        this.setPublicPoolOpUpdataDefault(estPublicPoolOp);
        this.updatePublicPoolOpModel(estPublicPoolOp);
    }

    @Override
    public EstPublicPoolOp getPublicPoolOp(Integer publicPoolOpId) {
        return this.getPublicPoolOpModelById(publicPoolOpId);
    }

    @Override
    public void deletePublicPoolOp(Integer publicPoolOpId) throws ApiException {
        this.deletePublicPoolOpModel(publicPoolOpId);
    }

    @Override
    public QueryResult<EstPublicPoolOp> queryPublicPoolOpPage(Map<String, Object> map) {
        List<EstPublicPoolOp> estPublicPoolOpList = this.queryPublicPoolOpModelPage(map);
        this.setPublicPoolOpName(estPublicPoolOpList, map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPublicPoolOp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estPublicPoolOpList);
        return queryResult;
    }

    private void setPublicPoolOpName(List<EstPublicPoolOp> estPublicPoolOpList, Map<String, Object> map) {
        String tenantCode = String.valueOf(map.get("tenantCode"));
        String roleCode = String.valueOf(map.get("roleCode"));
        ArrayList<String> userCodes = new ArrayList<String>();
        for (EstPublicPoolOp estPublicPoolOp : estPublicPoolOpList) {
            userCodes.add(estPublicPoolOp.getOpBillno());
        }
        List<UserBean> userBeanList = this.getUserList(userCodes, tenantCode);
        if (userBeanList != null && userBeanList.size() > 0) {
            Iterator<EstPublicPoolOp> publicPoolOpIterator = estPublicPoolOpList.iterator();
            while (publicPoolOpIterator.hasNext()) {
                EstPublicPoolOp estPublicPoolOp = publicPoolOpIterator.next();
                for (UserBean user : userBeanList) {
                    if (!user.getRoleCode().equals(roleCode)) {
                        publicPoolOpIterator.remove();
                        continue;
                    }
                    if (!estPublicPoolOp.getOpBillno().equals(user.getUserCode())) continue;
                    estPublicPoolOp.setOpName(user.getUserRelname());
                }
            }
        } else if (StringUtils.isNotBlank((String)roleCode)) {
            estPublicPoolOpList = new ArrayList<EstPublicPoolOp>();
        }
    }

    private List<UserBean> getUserList(List<String> userCodes, String tenantCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("userCodes", userCodes);
        parmMap.put("tenantCode", tenantCode);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("um.user.queryUserList", postParm);
        List userList = (List)JsonUtil.buildNormalBinder().getJsonToList(resultJson, UserBean.class);
        if (userList == null || userList.size() <= 0) {
            return null;
        }
        return userList;
    }

    private Map<String, Object> getTeamInfo(String userCode, String tenantCode) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("userCode", userCode);
        parmMap.put("tenantCode", tenantCode);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("um.user.getDirectManagerByCode", postParm);
        if (StringUtils.isNotBlank((String)resultJson)) {
            return (Map)JsonUtil.buildNonNullBinder().getJsonToMap(resultJson, String.class, Object.class);
        }
        return null;
    }

    @Override
    public void automaticInitPublicPoolOp(Map<String, Object> map) {
        if (Integer.valueOf(String.valueOf(map.get("publicPoolType"))) > 2) {
            return;
        }
        String projectCode = String.valueOf(map.get("projectCode"));
        String roleCode = String.valueOf(map.get("roleCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("roleCode", roleCode);
        parmMap.put("tenantCode", tenantCode);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("um.user.queryUserList", postParm);
        List userList = (List)JsonUtil.buildNormalBinder().getJsonToList(resultJson, UserBean.class);
        if (userList == null || userList.size() <= 0) {
            return;
        }
        for (UserBean user : userList) {
            Map<String, Object> teamMap = this.getTeamInfo(user.getUserCode(), tenantCode);
            if (teamMap == null || teamMap.size() <= 0) continue;
            String teamCode = "";
            String managerCode = "";
            String teamName = "";
            teamCode = String.valueOf(teamMap.get("teamCode"));
            managerCode = String.valueOf(teamMap.get("userCode"));
            teamName = String.valueOf(teamMap.get("teamName"));
            EstPublicPoolOp estPublicPoolOp = this.getEstPublicPoolOp(projectCode, teamCode);
            HashMap<String, Object> querypOpMap = new HashMap<String, Object>();
            querypOpMap.put("opBillno", managerCode);
            EstPublicPoolOp estPublicPoolOpManager = this.estPublicPoolOpMapper.getByCode(querypOpMap);
            if (estPublicPoolOp != null) {
                return;
            }
            int publicPoolType = 0;
            if (user.getRoleCode().equals("0001001")) {
                publicPoolType = 1;
            }
            if (user.getRoleCode().equals("0001003")) {
                publicPoolType = 2;
            }
            if (estPublicPoolOpManager != null) continue;
            this.saveRelationPublicPool(String.valueOf(teamName) + "-" + teamMap.get("userName"), managerCode, null, publicPoolType, 1, tenantCode);
        }
    }

    private EstPublicPoolOp getEstPublicPoolOp(String projectCode, String opBillno) {
        HashMap<String, Object> querypOpMap = new HashMap<String, Object>();
        querypOpMap.put("opBillno", opBillno);
        querypOpMap.put("projectCode", projectCode);
        return this.estPublicPoolOpMapper.getByCode(querypOpMap);
    }

    @Transactional
    private void saveRelationPublicPool(String publicPoolName, String userCode, String parentCode, int publicPoolType, int publicPoolOpType, String tenantCode) {
        EstPublicPool estPublicPool = new EstPublicPool(publicPoolName, publicPoolType, tenantCode);
        this.setPublicPoolDefault(estPublicPool);
        this.estPublicPoolMapper.insert(estPublicPool);
        this.savePublicPoolOp(new EstPublicPoolOpDomain(estPublicPool.getPublicPoolCode(), userCode, parentCode, publicPoolOpType, tenantCode));
    }

    private void setPublicPoolDefault(EstPublicPool estPublicPool) {
        if (estPublicPool == null) {
            return;
        }
        if (estPublicPool.getDataState() == null) {
            estPublicPool.setDataState(0);
        }
        if (estPublicPool.getGmtCreate() == null) {
            estPublicPool.setGmtCreate(this.getSysDate());
        }
        estPublicPool.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estPublicPool.getPublicPoolCode())) {
            estPublicPool.setPublicPoolCode(this.createUUIDString());
        }
    }

    @Override
    public EstPublicPoolOp getPublicPoolOpByCode(Map<String, Object> map) {
        return this.getPublicPoolOpModelByCode(map);
    }

    @Override
    public void delPublicPoolOpByCode(Map<String, Object> map) throws ApiException {
        this.delPublicPoolOpModelByCode(map);
    }
}

