/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstPublicPoolRptMapper;
import com.yqbsoft.laser.service.estate.domain.EstPublicPoolRptDomain;
import com.yqbsoft.laser.service.estate.model.EstPublicPoolRpt;
import com.yqbsoft.laser.service.estate.service.EstPublicPoolRptService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstPublicPoolRptServiceImpl
extends BaseServiceImpl
implements EstPublicPoolRptService {
    public static final String SYS_CODE = "estate.EstPublicPoolRptServiceImpl";
    private EstPublicPoolRptMapper estPublicPoolRptMapper;

    public void setEstPublicPoolRptMapper(EstPublicPoolRptMapper estPublicPoolRptMapper) {
        this.estPublicPoolRptMapper = estPublicPoolRptMapper;
    }

    private Date getSysDate() {
        try {
            return this.estPublicPoolRptMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolRptServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPublicPoolRpt(EstPublicPoolRptDomain estPublicPoolRptDomain) {
        if (estPublicPoolRptDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPublicPoolRptDefault(EstPublicPoolRpt estPublicPoolRpt) {
        if (estPublicPoolRpt == null) {
            return;
        }
        if (estPublicPoolRpt.getDataState() == null) {
            estPublicPoolRpt.setDataState(0);
        }
        if (estPublicPoolRpt.getGmtCreate() == null) {
            estPublicPoolRpt.setGmtCreate(this.getSysDate());
        }
        estPublicPoolRpt.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estPublicPoolRpt.getPublicPoolRptCode())) {
            estPublicPoolRpt.setPublicPoolRptCode(this.createUUIDString());
        }
    }

    private int getPublicPoolRptMaxCode() {
        int code = 0;
        try {
            return this.estPublicPoolRptMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolRptServiceImpl.getPublicPoolRptMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPublicPoolRptUpdataDefault(EstPublicPoolRpt estPublicPoolRpt) {
        if (estPublicPoolRpt == null) {
            return;
        }
        estPublicPoolRpt.setGmtModified(this.getSysDate());
    }

    private void savePublicPoolRptModel(EstPublicPoolRpt estPublicPoolRpt) throws ApiException {
        if (estPublicPoolRpt == null) {
            return;
        }
        try {
            this.estPublicPoolRptMapper.insert(estPublicPoolRpt);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.savePublicPoolRptModel.ex", (Throwable)e);
        }
    }

    private EstPublicPoolRpt getPublicPoolRptModelById(Integer publicPoolRptId) {
        if (publicPoolRptId == null) {
            return null;
        }
        try {
            return this.estPublicPoolRptMapper.selectByPrimaryKey(publicPoolRptId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolRptServiceImpl.getPublicPoolRptModelById", (Throwable)e);
            return null;
        }
    }

    public EstPublicPoolRpt getPublicPoolRptModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estPublicPoolRptMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolRptServiceImpl.getPublicPoolRptModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPublicPoolRptModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estPublicPoolRptMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.delPublicPoolRptModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.delPublicPoolRptModelByCode.num");
        }
    }

    private void deletePublicPoolRptModel(Integer publicPoolRptId) throws ApiException {
        if (publicPoolRptId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estPublicPoolRptMapper.deleteByPrimaryKey(publicPoolRptId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.deletePublicPoolRptModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.deletePublicPoolRptModel.num");
        }
    }

    private void updatePublicPoolRptModel(EstPublicPoolRpt estPublicPoolRpt) throws ApiException {
        if (estPublicPoolRpt == null) {
            return;
        }
        try {
            this.estPublicPoolRptMapper.updateByPrimaryKeySelective(estPublicPoolRpt);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.updatePublicPoolRptModel.ex", (Throwable)e);
        }
    }

    private void updateStatePublicPoolRptModel(Integer publicPoolRptId, Integer dataState, Integer oldDataState) throws ApiException {
        if (publicPoolRptId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("publicPoolRptId", publicPoolRptId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estPublicPoolRptMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.updateStatePublicPoolRptModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.updateStatePublicPoolRptModel.null");
        }
    }

    private EstPublicPoolRpt makePublicPoolRpt(EstPublicPoolRptDomain estPublicPoolRptDomain, EstPublicPoolRpt estPublicPoolRpt) {
        if (estPublicPoolRptDomain == null) {
            return null;
        }
        if (estPublicPoolRpt == null) {
            estPublicPoolRpt = new EstPublicPoolRpt();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estPublicPoolRpt, (Object)estPublicPoolRptDomain);
            return estPublicPoolRpt;
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolRptServiceImpl.makePublicPoolRpt", (Throwable)e);
            return null;
        }
    }

    private List<EstPublicPoolRpt> queryPublicPoolRptModelPage(Map<String, Object> parammap) {
        try {
            return this.estPublicPoolRptMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolRptServiceImpl.queryPublicPoolRptModel", (Throwable)e);
            return null;
        }
    }

    private List<EstPublicPoolRpt> queryPublicPoolRptByOpModelPage(Map<String, Object> parammap) {
        try {
            return this.estPublicPoolRptMapper.queryPublicPoolRptByOpPage(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolRptServiceImpl.queryPublicPoolRptModel", (Throwable)e);
            return null;
        }
    }

    private int countPublicPoolRpt(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estPublicPoolRptMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolRptServiceImpl.countPublicPoolRpt", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePublicPoolRpt(EstPublicPoolRptDomain estPublicPoolRptDomain) throws ApiException {
        String msg = this.checkPublicPoolRpt(estPublicPoolRptDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.savePublicPoolRpt.checkPublicPoolRpt", msg);
        }
        EstPublicPoolRpt estPublicPoolRpt = this.makePublicPoolRpt(estPublicPoolRptDomain, null);
        this.setPublicPoolRptDefault(estPublicPoolRpt);
        this.savePublicPoolRptModel(estPublicPoolRpt);
    }

    @Override
    public void updatePublicPoolRptState(Integer publicPoolRptId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePublicPoolRptModel(publicPoolRptId, dataState, oldDataState);
    }

    @Override
    public void updatePublicPoolRpt(EstPublicPoolRptDomain estPublicPoolRptDomain) throws ApiException {
        String msg = this.checkPublicPoolRpt(estPublicPoolRptDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.updatePublicPoolRpt.checkPublicPoolRpt", msg);
        }
        EstPublicPoolRpt oldEstPublicPoolRpt = this.getPublicPoolRptModelById(estPublicPoolRptDomain.getPublicPoolRptId());
        if (oldEstPublicPoolRpt == null) {
            throw new ApiException("estate.EstPublicPoolRptServiceImpl.updatePublicPoolRpt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstPublicPoolRpt estPublicPoolRpt = this.makePublicPoolRpt(estPublicPoolRptDomain, oldEstPublicPoolRpt);
        this.setPublicPoolRptUpdataDefault(estPublicPoolRpt);
        this.updatePublicPoolRptModel(estPublicPoolRpt);
    }

    @Override
    public EstPublicPoolRpt getPublicPoolRpt(Integer publicPoolRptId) {
        return this.getPublicPoolRptModelById(publicPoolRptId);
    }

    @Override
    public void deletePublicPoolRpt(Integer publicPoolRptId) throws ApiException {
        this.deletePublicPoolRptModel(publicPoolRptId);
    }

    @Override
    public QueryResult<EstPublicPoolRpt> queryPublicPoolRptPage(Map<String, Object> map) {
        List<EstPublicPoolRpt> estPublicPoolRptList = this.queryPublicPoolRptModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPublicPoolRpt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estPublicPoolRptList);
        return queryResult;
    }

    @Override
    public QueryResult<EstPublicPoolRpt> queryPublicPoolRptByOpPage(Map<String, Object> map) {
        List<EstPublicPoolRpt> estPublicPoolRptList = this.queryPublicPoolRptByOpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPublicPoolRpt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estPublicPoolRptList);
        return queryResult;
    }

    @Override
    public EstPublicPoolRpt getPublicPoolRptByCode(Map<String, Object> map) {
        return this.getPublicPoolRptModelByCode(map);
    }

    @Override
    public void delPublicPoolRptByCode(Map<String, Object> map) throws ApiException {
        this.delPublicPoolRptModelByCode(map);
    }
}

