/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.PageHelper;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstPublicPoolMapper;
import com.yqbsoft.laser.service.estate.dao.EstPublicPoolOpMapper;
import com.yqbsoft.laser.service.estate.dao.EstPublicPoolRptMapper;
import com.yqbsoft.laser.service.estate.dao.EstReportMapper;
import com.yqbsoft.laser.service.estate.domain.EstPublicPoolDomain;
import com.yqbsoft.laser.service.estate.domain.EstPublicPoolOpDomain;
import com.yqbsoft.laser.service.estate.domain.EstPublicPoolReDomain;
import com.yqbsoft.laser.service.estate.domain.EstPublicPoolRptDomain;
import com.yqbsoft.laser.service.estate.model.EstPublicPool;
import com.yqbsoft.laser.service.estate.model.EstPublicPoolOp;
import com.yqbsoft.laser.service.estate.model.EstPublicPoolRpt;
import com.yqbsoft.laser.service.estate.model.EstReport;
import com.yqbsoft.laser.service.estate.model.UserBean;
import com.yqbsoft.laser.service.estate.service.EstPublicPoolOpService;
import com.yqbsoft.laser.service.estate.service.EstPublicPoolRptService;
import com.yqbsoft.laser.service.estate.service.EstPublicPoolService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class EstPublicPoolServiceImpl
extends BaseServiceImpl
implements EstPublicPoolService {
    public static final String SYS_CODE = "estate.EstPublicPoolServiceImpl";
    private EstPublicPoolMapper estPublicPoolMapper;
    @Autowired
    private EstPublicPoolOpMapper estPublicPoolOpMapper;
    @Autowired
    private EstPublicPoolOpService estPublicPoolOpService;
    @Autowired
    private EstPublicPoolRptMapper estPublicPoolRptMapper;
    @Autowired
    private EstPublicPoolRptService estPublicPoolRptService;
    @Autowired
    private EstReportMapper estReportMapper;

    public void setEstPublicPoolMapper(EstPublicPoolMapper estPublicPoolMapper) {
        this.estPublicPoolMapper = estPublicPoolMapper;
    }

    private Date getSysDate() {
        try {
            return this.estPublicPoolMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkPublicPool(EstPublicPoolDomain estPublicPoolDomain) {
        if (estPublicPoolDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPublicPoolDefault(EstPublicPool estPublicPool) {
        if (estPublicPool == null) {
            return;
        }
        if (estPublicPool.getDataState() == null) {
            estPublicPool.setDataState(0);
        }
        if (estPublicPool.getGmtCreate() == null) {
            estPublicPool.setGmtCreate(this.getSysDate());
        }
        estPublicPool.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estPublicPool.getPublicPoolCode())) {
            estPublicPool.setPublicPoolCode(this.createUUIDString());
        }
    }

    private int getPublicPoolMaxCode() {
        int code = 0;
        try {
            return this.estPublicPoolMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolServiceImpl.getPublicPoolMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPublicPoolUpdataDefault(EstPublicPool estPublicPool) {
        if (estPublicPool == null) {
            return;
        }
        estPublicPool.setGmtModified(this.getSysDate());
    }

    private void savePublicPoolModel(EstPublicPool estPublicPool) throws ApiException {
        if (estPublicPool == null) {
            return;
        }
        try {
            this.estPublicPoolMapper.insert(estPublicPool);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.savePublicPoolModel.ex", (Throwable)e);
        }
    }

    private EstPublicPool getPublicPoolModelById(Integer publicPoolId) {
        if (publicPoolId == null) {
            return null;
        }
        try {
            return this.estPublicPoolMapper.selectByPrimaryKey(publicPoolId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolServiceImpl.getPublicPoolModelById", (Throwable)e);
            return null;
        }
    }

    public EstPublicPool getPublicPoolModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estPublicPoolMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolServiceImpl.getPublicPoolModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPublicPoolModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estPublicPoolMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.delPublicPoolModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.delPublicPoolModelByCode.num");
        }
    }

    private void deletePublicPoolModel(Integer publicPoolId) throws ApiException {
        if (publicPoolId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estPublicPoolMapper.deleteByPrimaryKey(publicPoolId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.deletePublicPoolModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.deletePublicPoolModel.num");
        }
    }

    private void updatePublicPoolModel(EstPublicPool estPublicPool) throws ApiException {
        if (estPublicPool == null) {
            return;
        }
        try {
            this.estPublicPoolMapper.updateByPrimaryKeySelective(estPublicPool);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.updatePublicPoolModel.ex", (Throwable)e);
        }
    }

    private void updateStatePublicPoolModel(Integer publicPoolId, Integer dataState, Integer oldDataState) throws ApiException {
        if (publicPoolId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("publicPoolId", publicPoolId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estPublicPoolMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.updateStatePublicPoolModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.updateStatePublicPoolModel.null");
        }
    }

    private EstPublicPool makePublicPool(EstPublicPoolDomain estPublicPoolDomain, EstPublicPool estPublicPool) {
        if (estPublicPoolDomain == null) {
            return null;
        }
        if (estPublicPool == null) {
            estPublicPool = new EstPublicPool();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estPublicPool, (Object)estPublicPoolDomain);
            return estPublicPool;
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolServiceImpl.makePublicPool", (Throwable)e);
            return null;
        }
    }

    private List<EstPublicPool> queryPublicPoolModelPage(Map<String, Object> parammap) {
        try {
            return this.estPublicPoolMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolServiceImpl.queryPublicPoolModel", (Throwable)e);
            return null;
        }
    }

    private List<EstPublicPool> queryPublicPoolByOpModelPage(Map<String, Object> parammap) {
        try {
            return this.estPublicPoolMapper.queryPublicPoolByOpPage(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolServiceImpl.queryPublicPoolModel", (Throwable)e);
            return null;
        }
    }

    private int countPublicPool(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estPublicPoolMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolServiceImpl.countPublicPool", (Throwable)e);
        }
        return i;
    }

    @Override
    public void savePublicPool(EstPublicPoolDomain estPublicPoolDomain) throws ApiException {
        String msg = this.checkPublicPool(estPublicPoolDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.savePublicPool.checkPublicPool", msg);
        }
        EstPublicPool estPublicPool = this.makePublicPool(estPublicPoolDomain, null);
        this.setPublicPoolDefault(estPublicPool);
        this.savePublicPoolModel(estPublicPool);
    }

    @Override
    public void updatePublicPoolState(Integer publicPoolId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePublicPoolModel(publicPoolId, dataState, oldDataState);
    }

    @Override
    public void updatePublicPool(EstPublicPoolDomain estPublicPoolDomain) throws ApiException {
        String msg = this.checkPublicPool(estPublicPoolDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.updatePublicPool.checkPublicPool", msg);
        }
        EstPublicPool oldEstPublicPool = this.getPublicPoolModelById(estPublicPoolDomain.getPublicPoolId());
        if (oldEstPublicPool == null) {
            throw new ApiException("estate.EstPublicPoolServiceImpl.updatePublicPool.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstPublicPool estPublicPool = this.makePublicPool(estPublicPoolDomain, oldEstPublicPool);
        this.setPublicPoolUpdataDefault(estPublicPool);
        this.updatePublicPoolModel(estPublicPool);
    }

    @Override
    public EstPublicPool getPublicPool(Integer publicPoolId) {
        return this.getPublicPoolModelById(publicPoolId);
    }

    @Override
    public void deletePublicPool(Integer publicPoolId) throws ApiException {
        this.deletePublicPoolModel(publicPoolId);
    }

    @Override
    public QueryResult<EstPublicPool> queryPublicPoolPage(Map<String, Object> map) {
        String projectCode = String.valueOf(map.get("projectCode"));
        List<EstPublicPool> estPublicPoolList = this.queryPublicPoolModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPublicPool(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estPublicPoolList);
        this.setPublicPoolRptCount((QueryResult<EstPublicPool>)queryResult, map);
        return queryResult;
    }

    @Override
    public QueryResult<EstPublicPool> queryPublicPoolByOpPage(Map<String, Object> map) {
        String projectCode = String.valueOf(map.get("projectCode"));
        List<EstPublicPool> estPublicPoolList = this.queryPublicPoolByOpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPublicPool(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estPublicPoolList);
        this.setPublicPoolRptCount((QueryResult<EstPublicPool>)queryResult, map);
        return queryResult;
    }

    @Override
    public void adminBetAssigningMember(Map<String, Object> map) {
        try {
            String userCode = String.valueOf(map.get("userCode"));
            String projectCode = String.valueOf(map.get("projectCode"));
            String tenantCode = String.valueOf(map.get("tenantCode"));
            String reportCode = String.valueOf(map.get("reportCode"));
            EstPublicPoolOp estPublicPoolOpManager = this.getEstPublicPoolOp(projectCode, userCode, tenantCode);
            if (estPublicPoolOpManager != null) {
                this.savePublicPoolRpt(reportCode, projectCode, estPublicPoolOpManager.getPublicPoolCode(), tenantCode);
            } else {
                Map<String, Object> teamMap = this.getTeamInfo(userCode, tenantCode);
                UserBean userBean = this.getUser(userCode, tenantCode);
                if (teamMap == null) {
                    if (userBean.getRoleCode().equals("0001008")) {
                        this.savePoster(reportCode, projectCode, tenantCode);
                    }
                    return;
                }
                String teamName = String.valueOf(teamMap.get("teamName"));
                this.saveRelationPublicPool(String.valueOf(teamName) + "-" + userBean.getUserRelname(), userCode, null, 0, 1, tenantCode);
                EstPublicPoolOp managerPublicPoolOp = this.getEstPublicPoolOp(projectCode, userCode, tenantCode);
                if (managerPublicPoolOp != null) {
                    this.savePublicPoolRpt(reportCode, projectCode, managerPublicPoolOp.getPublicPoolCode(), tenantCode);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("adminBetAssigningMember ex: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public void customerRecyclingMember(Map<String, Object> map) {
        try {
            String reportCode = String.valueOf(map.get("reportCode"));
            String userCode = String.valueOf(map.get("userCode"));
            String projectCode = String.valueOf(map.get("projectCode"));
            String tenantCode = String.valueOf(map.get("tenantCode"));
            UserBean userBean = this.getUser(userCode, tenantCode);
            if (userBean != null) {
                EstPublicPoolOp managerPublicPoolOp;
                Map<String, Object> teamMap = this.getTeamInfo(userCode, tenantCode);
                if (teamMap == null && (teamMap = this.getTeamInfo(userCode, tenantCode, true)) == null) {
                    return;
                }
                String teamCode = "";
                String managerCode = "";
                String teamName = "";
                teamCode = String.valueOf(teamMap.get("teamCode"));
                managerCode = String.valueOf(teamMap.get("userCode"));
                teamName = String.valueOf(teamMap.get("teamName"));
                EstPublicPoolOp estPublicPoolOp = this.getEstPublicPoolOp(projectCode, teamCode, tenantCode);
                if (estPublicPoolOp != null) {
                    this.savePublicPoolRpt(reportCode, projectCode, estPublicPoolOp.getPublicPoolCode(), tenantCode);
                    return;
                }
                int publicPoolType = 0;
                if (userBean != null) {
                    if (userBean.getRoleCode().equals("0001001")) {
                        publicPoolType = 1;
                    }
                    if (userBean.getRoleCode().equals("0001003")) {
                        publicPoolType = 2;
                    }
                }
                if ((managerPublicPoolOp = this.getEstPublicPoolOp(projectCode, managerCode, tenantCode)) != null) {
                    this.saveRelationPublicPool(teamName, teamCode, managerPublicPoolOp.getPublicPoolOpCode(), publicPoolType, 2, tenantCode);
                } else {
                    this.saveRelationPublicPool(String.valueOf(teamName) + "-" + teamMap.get("userName"), managerCode, null, 0, 1, tenantCode);
                    EstPublicPoolOp managerPublicPoolOpS = this.getEstPublicPoolOp(projectCode, managerCode, tenantCode);
                    if (managerPublicPoolOpS != null) {
                        this.saveRelationPublicPool(teamName, teamCode, managerPublicPoolOpS.getPublicPoolOpCode(), publicPoolType, 2, tenantCode);
                    }
                }
                EstPublicPoolOp estPublicPoolOpS = this.getEstPublicPoolOp(projectCode, teamCode, tenantCode);
                this.savePublicPoolRpt(reportCode, projectCode, estPublicPoolOpS.getPublicPoolCode(), tenantCode);
            } else {
                this.savePoster(reportCode, projectCode, tenantCode);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("customerRecyclingMember ex: " + ex.getMessage());
        }
    }

    @Override
    public void removedPublicPoolCustomer(Map<String, Object> map) {
        String reportCode = String.valueOf(map.get("reportCode"));
        String projectCode = String.valueOf(map.get("projectCode"));
        String tenantCode = String.valueOf(map.get("tenantCode"));
        if (StringUtils.isBlank((String)reportCode)) {
            return;
        }
        try {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("reportCode", reportCode);
            parmMap.put("projectCode", projectCode);
            parmMap.put("tenantCode", tenantCode);
            EstReport estReport = this.estReportMapper.getByCode(parmMap);
            UserBean userBean = this.getUser(estReport.getUserCode(), estReport.getTenantCode());
            if (userBean != null && userBean.getRoleCode().equals("0001001") || userBean.getRoleCode().equals("0001003")) {
                Map<String, Object> teamMap = this.getTeamInfo(userBean.getUserCode(), tenantCode);
                if (teamMap == null) {
                    return;
                }
                String teamCode = "";
                teamCode = String.valueOf(teamMap.get("teamCode"));
                EstPublicPoolOp estPublicPoolOp = this.getEstPublicPoolOp(projectCode, teamCode, tenantCode);
                if (estPublicPoolOp != null) {
                    this.estPublicPoolRptMapper.delByReportCode(parmMap);
                    return;
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("removedPublicPoolCustomer ex: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public void batchCheckPublicPoolCustomer(Map<String, Object> map) {
        try {
            String reportCode = String.valueOf(map.get("reportCode"));
            String userCode = String.valueOf(map.get("userCode"));
            String projectCode = String.valueOf(map.get("projectCode"));
            String tenantCode = String.valueOf(map.get("tenantCode"));
            UserBean userBean = this.getUser(userCode, tenantCode);
            if (userBean != null && StringUtils.isNotBlank((String)userBean.getRoleCode()) && (userBean.getRoleCode().equals("0001001") || userBean.getRoleCode().equals("0001003"))) {
                EstPublicPoolOp managerPublicPoolOp;
                Map<String, Object> teamMap = this.getTeamInfo(userCode, tenantCode);
                if (teamMap == null) {
                    return;
                }
                String teamCode = "";
                String managerCode = "";
                String teamName = "";
                teamCode = String.valueOf(teamMap.get("teamCode"));
                managerCode = String.valueOf(teamMap.get("userCode"));
                teamName = String.valueOf(teamMap.get("teamName"));
                EstPublicPoolOp estPublicPoolOp = this.getEstPublicPoolOp(projectCode, teamCode, tenantCode);
                if (estPublicPoolOp != null) {
                    this.savePublicPoolRpt(reportCode, projectCode, estPublicPoolOp.getPublicPoolCode(), tenantCode);
                    return;
                }
                int publicPoolType = 0;
                if (userBean != null) {
                    if (userBean.getRoleCode().equals("0001001")) {
                        publicPoolType = 1;
                    }
                    if (userBean.getRoleCode().equals("0001003")) {
                        publicPoolType = 2;
                    }
                }
                if ((managerPublicPoolOp = this.getEstPublicPoolOp(projectCode, managerCode, tenantCode)) != null) {
                    this.saveRelationPublicPool(teamName, teamCode, managerPublicPoolOp.getPublicPoolOpCode(), publicPoolType, 2, tenantCode);
                } else {
                    this.saveRelationPublicPool(String.valueOf(teamName) + "-" + teamMap.get("userName"), managerCode, null, 0, 1, tenantCode);
                    EstPublicPoolOp managerPublicPoolOpS = this.getEstPublicPoolOp(projectCode, managerCode, tenantCode);
                    if (managerPublicPoolOpS != null) {
                        this.saveRelationPublicPool(teamName, teamCode, managerPublicPoolOpS.getPublicPoolOpCode(), publicPoolType, 2, tenantCode);
                    }
                }
                EstPublicPoolOp estPublicPoolOpS = this.getEstPublicPoolOp(projectCode, teamCode, tenantCode);
                this.savePublicPoolRpt(reportCode, projectCode, estPublicPoolOpS.getPublicPoolCode(), tenantCode);
            } else {
                this.savePoster(reportCode, projectCode, tenantCode);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.logger.error("customerRecyclingMember ex: " + ex.getMessage());
        }
    }

    private void savePoster(String reportCode, String projectCode, String tenantCode) {
        boolean flag = this.savePosterRptInPublicPool(reportCode, projectCode, tenantCode);
        if (!flag) {
            EstPublicPoolReDomain newEstPublicPool = new EstPublicPoolReDomain();
            newEstPublicPool.setPublicPoolName("\u6d77\u62a5\u5ba2\u6237");
            newEstPublicPool.setPublicPoolType(3);
            newEstPublicPool.setTenantCode(tenantCode);
            newEstPublicPool.setMemo("poster");
            this.savePublicPool(newEstPublicPool);
            this.savePosterRptInPublicPool(reportCode, projectCode, tenantCode);
        }
    }

    private boolean savePosterRptInPublicPool(String reportCode, String projectCode, String tenantCode) {
        try {
            HashMap<String, Object> queryParm = new HashMap<String, Object>();
            queryParm.put("publicPoolType", 3);
            queryParm.put("memo", "poster");
            queryParm.put("tenantCode", tenantCode);
            List<EstPublicPool> estPublicPools = this.queryPublicPoolModelPage(queryParm);
            if (estPublicPools != null && estPublicPools.size() > 0) {
                this.savePublicPoolRpt(reportCode, projectCode, estPublicPools.get(0).getPublicPoolCode(), tenantCode);
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return true;
        }
    }

    void removeExcessPublicPoolRpt(List<EstPublicPoolRpt> estPublicPoolRptList, String reportCode) {
        if (estPublicPoolRptList != null && estPublicPoolRptList.size() > 0) {
            for (EstPublicPoolRpt estPublicPoolRpt : estPublicPoolRptList) {
                if (!estPublicPoolRpt.getReportCode().equals(reportCode)) continue;
                this.estPublicPoolRptService.deletePublicPoolRpt(estPublicPoolRpt.getPublicPoolRptId());
            }
        }
    }

    void removeExcessPublicPoolRpt(Map<String, Object> queryMap, String reportCode) {
        List<EstPublicPoolRpt> estPublicPoolRptList = this.estPublicPoolRptMapper.query(queryMap);
        if (estPublicPoolRptList != null && estPublicPoolRptList.size() > 0) {
            for (EstPublicPoolRpt estPublicPoolRpt : estPublicPoolRptList) {
                if (!estPublicPoolRpt.getReportCode().equals(reportCode)) continue;
                this.estPublicPoolRptService.deletePublicPoolRpt(estPublicPoolRpt.getPublicPoolRptId());
            }
        }
    }

    private void savePublicPoolRpt(String reportCode, String projectCode, String publicPoolCode, String tenantCode) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("reportCode", reportCode);
        queryMap.put("projectCode", projectCode);
        this.removeExcessPublicPoolRpt(queryMap, reportCode);
        List<EstPublicPoolRpt> estPublicPoolRptList = this.estPublicPoolRptMapper.query(queryMap);
        if (estPublicPoolRptList == null || estPublicPoolRptList.size() <= 0) {
            this.estPublicPoolRptService.savePublicPoolRpt(new EstPublicPoolRptDomain(publicPoolCode, reportCode, projectCode, tenantCode));
        }
    }

    private void setPublicPoolRptCount(QueryResult<EstPublicPool> queryResult, Map<String, Object> map) {
        if (queryResult != null && queryResult.getRows() != null && queryResult.getRows().size() > 0) {
            for (EstPublicPool estPublicPool : queryResult.getRows()) {
                map.put("publicPoolCode", estPublicPool.getPublicPoolCode());
                map.put("tenantCode", estPublicPool.getTenantCode());
                map.put("fuzzy", true);
                estPublicPool.setPublicPoolCount(Integer.valueOf(String.valueOf(this.countPublicCustomersModel(map))));
            }
        }
    }

    private long countPublicCustomersModel(final Map<String, Object> map) {
        try {
            long total = PageHelper.count((ISelect)new ISelect(){

                public void doSelect() {
                    EstPublicPoolServiceImpl.this.estReportMapper.publicCustomers(map);
                }
            });
            return total;
        }
        catch (Exception e) {
            this.logger.error("estate.EstPublicPoolServiceImpl.countPublicCustomersModel", (Throwable)e);
            return 0L;
        }
    }

    private Map<String, Object> getReportCodeByPublicPoolRpt(Map<String, Object> map) {
        if (map.containsKey("publicPoolCode") && StringUtils.isNotBlank((String)String.valueOf(map.get("publicPoolCode")))) {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("publicPoolCode", map.get("publicPoolCode"));
            parmMap.put("projectCode", map.get("projectCode"));
            List<EstPublicPoolRpt> estPublicPoolRptList = this.estPublicPoolRptMapper.query(parmMap);
            if (estPublicPoolRptList != null && estPublicPoolRptList.size() > 0) {
                ArrayList<String> reportCodes = new ArrayList<String>();
                for (EstPublicPoolRpt estPublicPoolRpt : estPublicPoolRptList) {
                    reportCodes.add(estPublicPoolRpt.getReportCode());
                }
                map.put("reportCodes", reportCodes);
                return map;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("###########");
            map.put("reportCodes", list);
        } else {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("opBillno", map.get("userCode"));
            parmMap.put("projectCode", map.get("projectCode"));
            List<EstPublicPoolRpt> estPublicPoolRptList = this.estPublicPoolRptMapper.queryPublicPoolRptByOpPage(parmMap);
            if (estPublicPoolRptList != null && estPublicPoolRptList.size() > 0) {
                ArrayList<String> reportCodes = new ArrayList<String>();
                for (EstPublicPoolRpt estPublicPoolRpt : estPublicPoolRptList) {
                    reportCodes.add(estPublicPoolRpt.getReportCode());
                }
                map.put("reportCodes", reportCodes);
                return map;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("###########");
            map.put("reportCodes", list);
        }
        return map;
    }

    @Override
    public EstPublicPool getPublicPoolByCode(Map<String, Object> map) {
        return this.getPublicPoolModelByCode(map);
    }

    @Override
    public void delPublicPoolByCode(Map<String, Object> map) throws ApiException {
        this.delPublicPoolModelByCode(map);
    }

    private Map<String, Object> getTeamInfo(String userCode, String tenantCode) {
        return this.getTeamInfo(userCode, tenantCode, false);
    }

    private Map<String, Object> getTeamInfo(String userCode, String tenantCode, Boolean flagDefault) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("userCode", userCode);
        paramMap.put("tenantCode", tenantCode);
        if (flagDefault.booleanValue()) {
            paramMap.put("defaultQuery", flagDefault);
        }
        HashMap<String, String> postParam = new HashMap<String, String>();
        postParam.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
        String resultJson = this.internalInvoke("um.user.getDirectManagerByCode", postParam);
        if (StringUtils.isNotBlank((String)resultJson)) {
            return (Map)JsonUtil.buildNonNullBinder().getJsonToMap(resultJson, String.class, Object.class);
        }
        return null;
    }

    private UserBean getUser(String userCode, String tenantCode) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("userCode", userCode);
        parmMap.put("tenantCode", tenantCode);
        String resultJson = this.internalInvoke("um.user.getUserByCode", parmMap);
        UserBean user = (UserBean)JsonUtil.buildNormalBinder().getJsonToObject(resultJson, UserBean.class);
        return user;
    }

    @Override
    public void automaticInitPublicPool(Map<String, Object> map) {
        try {
            String userCode = String.valueOf(map.get("userCode"));
            String projectCode = String.valueOf(map.get("projectCode"));
            String tenantCode = String.valueOf(map.get("tenantCode"));
            UserBean userBean = this.getUser(userCode, tenantCode);
            if (userBean == null || StringUtils.isBlank((String)userBean.getRoleCode())) {
                this.logger.error("EstPublicPoolServiceImpl.automaticInitPublicPool user is null");
                return;
            }
            String userRole = userBean.getRoleCode();
            if (userRole.equals("0001001") || userRole.equals("0001003")) {
                EstPublicPoolOp managerPublicPoolOp;
                Map<String, Object> teamMap = this.getTeamInfo(userCode, tenantCode);
                if (teamMap == null) {
                    return;
                }
                String teamCode = "";
                String managerCode = "";
                String teamName = "";
                teamCode = String.valueOf(teamMap.get("teamCode"));
                managerCode = String.valueOf(teamMap.get("userCode"));
                teamName = String.valueOf(teamMap.get("teamName"));
                EstPublicPoolOp estPublicPoolOp = this.getEstPublicPoolOp(projectCode, teamCode, tenantCode);
                EstPublicPoolOp estPublicPoolOpManager = this.getEstPublicPoolOp(null, managerCode, tenantCode);
                if (estPublicPoolOp != null) {
                    return;
                }
                int publicPoolType = 0;
                if (userBean.getRoleCode().equals("0001001")) {
                    publicPoolType = 1;
                }
                if (userBean.getRoleCode().equals("0001003")) {
                    publicPoolType = 2;
                }
                if (estPublicPoolOpManager == null) {
                    this.saveRelationPublicPool(String.valueOf(teamName) + "-" + teamMap.get("userName"), managerCode, null, 0, 1, tenantCode);
                }
                if ((managerPublicPoolOp = this.getEstPublicPoolOp(projectCode, managerCode, tenantCode)) != null) {
                    this.saveRelationPublicPool(teamName, teamCode, managerPublicPoolOp.getPublicPoolOpCode(), publicPoolType, 2, tenantCode);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error("EstPublicPoolServiceImpl.automaticInitPublicPool ex: " + ex);
        }
    }

    private EstPublicPoolOp getEstPublicPoolOp(String projectCode, String opBillno, String tenantCode) {
        HashMap<String, Object> querypOpMap = new HashMap<String, Object>();
        querypOpMap.put("opBillno", opBillno);
        querypOpMap.put("tenantCode", tenantCode);
        return this.estPublicPoolOpMapper.getByCode(querypOpMap);
    }

    private void saveRelationPublicPool(String publicPoolName, String userCode, String parentCode, int publicPoolType, int publicPoolOpType, String tenantCode) {
        EstPublicPool estPublicPool = new EstPublicPool(publicPoolName, publicPoolType, tenantCode);
        this.setPublicPoolDefault(estPublicPool);
        this.savePublicPoolModel(estPublicPool);
        this.estPublicPoolOpService.savePublicPoolOp(new EstPublicPoolOpDomain(estPublicPool.getPublicPoolCode(), userCode, parentCode, publicPoolOpType, tenantCode));
    }

    public void verifyIsExistPublicPool(Map<String, Object> map) {
    }

    public void initializationPublicPool(Map<String, Object> map) {
    }
}

