/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstReceivablesRecordMapper;
import com.yqbsoft.laser.service.estate.domain.EstReceivablesRecordDomain;
import com.yqbsoft.laser.service.estate.domain.EstReceivablesRecordReDomain;
import com.yqbsoft.laser.service.estate.model.EstReceivablesRecord;
import com.yqbsoft.laser.service.estate.service.EstReceivablesRecordService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstReceivablesRecordServiceImpl
extends BaseServiceImpl
implements EstReceivablesRecordService {
    public static final String SYS_CODE = "estate.EstReceivablesRecordServiceImpl";
    private EstReceivablesRecordMapper estReceivablesRecordMapper;

    public void setEstReceivablesRecordMapper(EstReceivablesRecordMapper estReceivablesRecordMapper) {
        this.estReceivablesRecordMapper = estReceivablesRecordMapper;
    }

    private Date getSysDate() {
        try {
            return this.estReceivablesRecordMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstReceivablesRecordServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkReceivablesRecord(EstReceivablesRecordDomain estReceivablesRecordDomain) {
        if (estReceivablesRecordDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setReceivablesRecordDefault(EstReceivablesRecord estReceivablesRecord) {
        if (estReceivablesRecord == null) {
            return;
        }
        if (estReceivablesRecord.getDataState() == null) {
            estReceivablesRecord.setDataState(0);
        }
        if (estReceivablesRecord.getGmtCreate() == null) {
            estReceivablesRecord.setGmtCreate(this.getSysDate());
        }
        estReceivablesRecord.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estReceivablesRecord.getReceivablesRecordCode())) {
            estReceivablesRecord.setReceivablesRecordCode(this.createUUIDString());
        }
    }

    private int getReceivablesRecordMaxCode() {
        int code = 0;
        try {
            return this.estReceivablesRecordMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstReceivablesRecordServiceImpl.getReceivablesRecordMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setReceivablesRecordUpdataDefault(EstReceivablesRecord estReceivablesRecord) {
        if (estReceivablesRecord == null) {
            return;
        }
        estReceivablesRecord.setGmtModified(this.getSysDate());
    }

    private void saveReceivablesRecordModel(EstReceivablesRecord estReceivablesRecord) throws ApiException {
        if (estReceivablesRecord == null) {
            return;
        }
        try {
            this.estReceivablesRecordMapper.insert(estReceivablesRecord);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.saveReceivablesRecordModel.ex", (Throwable)e);
        }
    }

    private EstReceivablesRecord getReceivablesRecordModelById(Integer receivablesRecordId) {
        if (receivablesRecordId == null) {
            return null;
        }
        try {
            return this.estReceivablesRecordMapper.selectByPrimaryKey(receivablesRecordId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReceivablesRecordServiceImpl.getReceivablesRecordModelById", (Throwable)e);
            return null;
        }
    }

    public EstReceivablesRecord getReceivablesRecordModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estReceivablesRecordMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReceivablesRecordServiceImpl.getReceivablesRecordModelByCode", (Throwable)e);
            return null;
        }
    }

    public int delReceivablesRecordModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return 0;
        }
        int i = 0;
        try {
            i = this.estReceivablesRecordMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.delReceivablesRecordModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.delReceivablesRecordModelByCode.num");
        }
        return i;
    }

    private void deleteReceivablesRecordModel(Integer receivablesRecordId) throws ApiException {
        if (receivablesRecordId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estReceivablesRecordMapper.deleteByPrimaryKey(receivablesRecordId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.deleteReceivablesRecordModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.deleteReceivablesRecordModel.num");
        }
    }

    private void updateReceivablesRecordModel(EstReceivablesRecord estReceivablesRecord) throws ApiException {
        if (estReceivablesRecord == null) {
            return;
        }
        try {
            this.estReceivablesRecordMapper.updateByPrimaryKeySelective(estReceivablesRecord);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.updateReceivablesRecordModel.ex", (Throwable)e);
        }
    }

    private void updateStateReceivablesRecordModel(Integer receivablesRecordId, Integer dataState, Integer oldDataState) throws ApiException {
        if (receivablesRecordId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("receivablesRecordId", receivablesRecordId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estReceivablesRecordMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.updateStateReceivablesRecordModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.updateStateReceivablesRecordModel.null");
        }
    }

    private EstReceivablesRecord makeReceivablesRecord(EstReceivablesRecordDomain estReceivablesRecordDomain, EstReceivablesRecord estReceivablesRecord) {
        if (estReceivablesRecordDomain == null) {
            return null;
        }
        if (estReceivablesRecord == null) {
            estReceivablesRecord = new EstReceivablesRecord();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estReceivablesRecord, (Object)estReceivablesRecordDomain);
            return estReceivablesRecord;
        }
        catch (Exception e) {
            this.logger.error("estate.EstReceivablesRecordServiceImpl.makeReceivablesRecord", (Throwable)e);
            return null;
        }
    }

    private List<EstReceivablesRecord> queryReceivablesRecordModelPage(Map<String, Object> parammap) {
        try {
            return this.estReceivablesRecordMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReceivablesRecordServiceImpl.queryReceivablesRecordModel", (Throwable)e);
            return null;
        }
    }

    private int countReceivablesRecord(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReceivablesRecordMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReceivablesRecordServiceImpl.countReceivablesRecord", (Throwable)e);
        }
        return i;
    }

    @Override
    public EstReceivablesRecord saveReceivablesRecord(EstReceivablesRecordDomain estReceivablesRecordDomain) throws ApiException {
        String msg = this.checkReceivablesRecord(estReceivablesRecordDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.saveReceivablesRecord.checkReceivablesRecord", msg);
        }
        EstReceivablesRecord estReceivablesRecord = this.makeReceivablesRecord(estReceivablesRecordDomain, null);
        this.saveReceivablesRecordWrraper(estReceivablesRecord);
        return estReceivablesRecord;
    }

    private void saveReceivablesRecordWrraper(EstReceivablesRecord estReceivablesRecord) {
        this.setReceivablesRecordDefault(estReceivablesRecord);
        this.saveReceivablesRecordModel(estReceivablesRecord);
    }

    @Override
    public void updateReceivablesRecordState(Integer receivablesRecordId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateReceivablesRecordModel(receivablesRecordId, dataState, oldDataState);
    }

    @Override
    public void updateReceivablesRecord(EstReceivablesRecordDomain estReceivablesRecordDomain) throws ApiException {
        String msg = this.checkReceivablesRecord(estReceivablesRecordDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.updateReceivablesRecord.checkReceivablesRecord", msg);
        }
        EstReceivablesRecord oldEstReceivablesRecord = this.getReceivablesRecordModelById(estReceivablesRecordDomain.getReceivablesRecordId());
        if (oldEstReceivablesRecord == null) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.updateReceivablesRecord.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstReceivablesRecord estReceivablesRecord = this.makeReceivablesRecord(estReceivablesRecordDomain, oldEstReceivablesRecord);
        this.setReceivablesRecordUpdataDefault(estReceivablesRecord);
        this.updateReceivablesRecordModel(estReceivablesRecord);
    }

    @Override
    public EstReceivablesRecord getReceivablesRecord(Integer receivablesRecordId) {
        return this.getReceivablesRecordModelById(receivablesRecordId);
    }

    @Override
    public void deleteReceivablesRecord(Integer receivablesRecordId) throws ApiException {
        this.deleteReceivablesRecordModel(receivablesRecordId);
    }

    @Override
    public QueryResult<EstReceivablesRecord> queryReceivablesRecordPage(Map<String, Object> map) {
        List<EstReceivablesRecord> estReceivablesRecordList = this.queryReceivablesRecordModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countReceivablesRecord(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReceivablesRecordList);
        return queryResult;
    }

    @Override
    public EstReceivablesRecord getReceivablesRecordByCode(Map<String, Object> map) {
        return this.getReceivablesRecordModelByCode(map);
    }

    @Override
    public Boolean delReceivablesRecordByCode(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return false;
        }
        int i = this.delReceivablesRecordModelByCode(map);
        if (i > 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean updateReceivablesRecordMap(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return false;
        }
        int i = this.updateReceivablesRecordMapModel(map);
        if (i > 0) {
            return true;
        }
        return false;
    }

    private int updateReceivablesRecordMapModel(Map<String, Object> map) {
        int i;
        try {
            i = this.estReceivablesRecordMapper.updateReceivablesRecordMap(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.updateReceivablesRecordMapModel.ex", (Throwable)e);
        }
        return i;
    }

    @Override
    public List<EstReceivablesRecord> queryReceivablesRecordList(Map<String, Object> map) {
        List<EstReceivablesRecord> estReceivablesRecordList = this.queryReceivablesRecordModelPage(map);
        return estReceivablesRecordList;
    }

    @Override
    public EstReceivablesRecord saveReceivablesRecordRe(EstReceivablesRecordReDomain estReceivablesRecordReDomain) throws ApiException {
        String msg = this.checkReceivablesRecord(estReceivablesRecordReDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstReceivablesRecordServiceImpl.saveReceivablesRecordRe.checkReceivablesRecord", msg);
        }
        EstReceivablesRecord estReceivablesRecord = this.makeReceivablesRecord(estReceivablesRecordReDomain, null);
        this.saveReceivablesRecordWrraper(estReceivablesRecord);
        return estReceivablesRecord;
    }

    @Override
    public Map<String, Integer> countWaitPaymentRecord(Map<String, Object> param) throws ApiException {
        String COUNTNUM_KEY = "countNum";
        String CUSTOMERCAPITALCODE_KEY = "customerCapitalCode";
        List<Map<String, Object>> waitMaps = this.countWaitPaymentRecordModel(param);
        if (ListUtil.isEmpty(waitMaps)) {
            return null;
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Map<String, Object> waitMap : waitMaps) {
            String code = "";
            Integer count = 0;
            for (Map.Entry<String, Object> wait : waitMap.entrySet()) {
                if (COUNTNUM_KEY.equals(wait.getKey())) {
                    count = Integer.valueOf(String.valueOf(wait.getValue()));
                    continue;
                }
                if (!CUSTOMERCAPITALCODE_KEY.equals(wait.getKey())) continue;
                code = String.valueOf(wait.getValue());
            }
            map.put(code, count);
        }
        return map;
    }

    private List<Map<String, Object>> countWaitPaymentRecordModel(Map<String, Object> map) {
        try {
            return this.estReceivablesRecordMapper.countWaitPaymentRecord(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReceivablesRecordServiceImpl.countReceivablesRecord", (Throwable)e);
            return null;
        }
    }
}

