/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.github.pagehelper.PageInfo;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.dd.DdEntity;
import com.yqbsoft.laser.service.esb.core.dd.DdTransUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstFollowMapper;
import com.yqbsoft.laser.service.estate.dao.EstPublicPoolRptMapper;
import com.yqbsoft.laser.service.estate.dao.EstReportMapper;
import com.yqbsoft.laser.service.estate.dao.EstStateMapper;
import com.yqbsoft.laser.service.estate.domain.EstReportDomain;
import com.yqbsoft.laser.service.estate.domain.EstReportReDomain;
import com.yqbsoft.laser.service.estate.domain.EstReserveUnitMemberDomain;
import com.yqbsoft.laser.service.estate.model.EstIntention;
import com.yqbsoft.laser.service.estate.model.EstPublicPool;
import com.yqbsoft.laser.service.estate.model.EstPublicPoolRpt;
import com.yqbsoft.laser.service.estate.model.EstReport;
import com.yqbsoft.laser.service.estate.model.EstReserveUnitMember;
import com.yqbsoft.laser.service.estate.model.UserBean;
import com.yqbsoft.laser.service.estate.service.EstIntentionService;
import com.yqbsoft.laser.service.estate.service.EstReportService;
import com.yqbsoft.laser.service.estate.service.EstReserveUnitMemberService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;

public class EstReportServiceImpl
extends BaseServiceImpl
implements EstReportService {
    public static final String SYS_CODE = "estate.EstReportServiceImpl";
    private EstReportMapper estReportMapper;
    @Autowired
    private EstReserveUnitMemberService estReserveUnitMemberService;
    @Autowired
    private EstPublicPoolRptMapper estPublicPoolRptMapper;
    @Autowired
    private EstFollowMapper estFollowMapper;
    @Autowired
    private EstStateMapper estStateMapper;
    @Autowired
    private EstIntentionService estIntentionService;

    public void setEstReportMapper(EstReportMapper estReportMapper) {
        this.estReportMapper = estReportMapper;
    }

    private Date getSysDate() {
        try {
            return this.estReportMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkReport(EstReportDomain estReportDomain) {
        if (estReportDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)estReportDomain.getMemberName())) {
            msg = String.valueOf(msg) + "MemberName\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setReportDefault(EstReport estReport) {
        if (estReport == null) {
            return;
        }
        if (estReport.getDataState() == null) {
            estReport.setDataState(1);
        }
        if (estReport.getGmtCreate() == null) {
            estReport.setGmtCreate(this.getSysDate());
        }
        estReport.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estReport.getReportCode())) {
            estReport.setReportCode(this.createUUIDString());
        }
    }

    private int getReportMaxCode() {
        int code = 0;
        try {
            return this.estReportMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.getReportMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setReportUpdataDefault(EstReport estReport) {
        if (estReport == null) {
            return;
        }
        estReport.setGmtModified(this.getSysDate());
    }

    private void saveReportModel(EstReport estReport) throws ApiException {
        if (estReport == null) {
            return;
        }
        try {
            this.estReportMapper.insert(estReport);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReportServiceImpl.saveReportModel.ex", (Throwable)e);
        }
    }

    private EstReport getReportModelById(Integer reportId) {
        if (reportId == null) {
            return null;
        }
        try {
            return this.estReportMapper.selectByPrimaryKey(reportId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.getReportModelById", (Throwable)e);
            return null;
        }
    }

    public EstReport getReportModelByCode(Map<String, Object> map) {
        block6: {
            String memberCode;
            String reportCode;
            block5: {
                if (map == null || map.isEmpty()) {
                    return null;
                }
                try {
                    reportCode = String.valueOf(map.get("reportCode"));
                    memberCode = String.valueOf(map.get("memberCode"));
                    if (map.containsKey("reportCode") || map.containsKey("memberCode")) break block5;
                    return null;
                }
                catch (Exception e) {
                    this.logger.error("estate.EstReportServiceImpl.getReportModelByCode", (Throwable)e);
                    return null;
                }
            }
            if (!StringUtils.isBlank((String)reportCode) && !"null".equals(reportCode) || !StringUtils.isBlank((String)memberCode) && !"null".equals(memberCode)) break block6;
            return null;
        }
        return this.estReportMapper.getByCode(map);
    }

    public void delReportModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estReportMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReportServiceImpl.delReportModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstReportServiceImpl.delReportModelByCode.num");
        }
    }

    private void deleteReportModel(Integer reportId) throws ApiException {
        if (reportId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estReportMapper.deleteByPrimaryKey(reportId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReportServiceImpl.deleteReportModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstReportServiceImpl.deleteReportModel.num");
        }
    }

    private void updateReportModel(EstReport estReport) throws ApiException {
        if (estReport == null) {
            return;
        }
        try {
            this.estReportMapper.updateByPrimaryKeySelective(estReport);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReportServiceImpl.updateReportModel.ex", (Throwable)e);
        }
    }

    private void updateStateReportModel(Integer reportId, Integer dataState, Integer oldDataState) throws ApiException {
        if (reportId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reportId", reportId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estReportMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReportServiceImpl.updateStateReportModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstReportServiceImpl.updateStateReportModel.null");
        }
    }

    private EstReport makeReport(EstReportDomain estReportDomain, EstReport estReport) {
        if (estReportDomain == null) {
            return null;
        }
        if (estReport == null) {
            estReport = new EstReport();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estReport, (Object)estReportDomain);
            return estReport;
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.makeReport", (Throwable)e);
            return null;
        }
    }

    private List<EstReport> queryReportModelPage(Map<String, Object> parammap) {
        try {
            return this.estReportMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.queryReportModel", (Throwable)e);
            return null;
        }
    }

    private int countReport(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReportMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.countReport", (Throwable)e);
        }
        return i;
    }

    public int getCountReportModel(Map<String, Object> map) {
        int i = 0;
        try {
            List userCodes;
            if (map.containsKey("userCodes") && ListUtil.isNotEmpty((Collection)(userCodes = (List)map.get("userCodes"))) && userCodes.size() > 50) {
                int length = userCodes.size();
                int k = 0;
                while (k * 50 < length) {
                    int num = (k + 1) * 50;
                    if (num > length) {
                        map.put("userCodes", userCodes.subList(k * 50, length));
                    } else {
                        map.put("userCodes", userCodes.subList(k * 50, num));
                    }
                    i += this.estReportMapper.getReportCount(map);
                    ++k;
                }
                return i;
            }
            i = this.estReportMapper.getReportCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.getCountReport", (Throwable)e);
        }
        return i;
    }

    @Override
    public int getCountReport(Map<String, Object> map) {
        int i = this.getCountReportModel(map);
        return i;
    }

    @Override
    public void saveReport(EstReportDomain estReportDomain) throws ApiException {
        String msg = this.checkReport(estReportDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstReportServiceImpl.saveReport.checkReport", msg);
        }
        EstReport estReport = this.makeReport(estReportDomain, null);
        this.setReportDefault(estReport);
        this.saveReportModel(estReport);
        if (estReportDomain.getReserveUnitMembers() != null && estReportDomain.getReserveUnitMembers().size() > 0) {
            for (EstReserveUnitMemberDomain reserveUnitMember : estReportDomain.getReserveUnitMembers()) {
                reserveUnitMember.setOpBillno(estReport.getMemberCode());
                reserveUnitMember.setMemberType(1);
                this.estReserveUnitMemberService.saveReserveUnitMember(reserveUnitMember);
            }
        }
    }

    @Override
    public void updateReportState(Integer reportId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateReportModel(reportId, dataState, oldDataState);
    }

    @Override
    public void updateReportStateByCode(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.estReportMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReportServiceImpl.updateStateReportModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstReportServiceImpl.updateStateReportModel.null");
        }
    }

    @Override
    public void updateReport(EstReportDomain estReportDomain) throws ApiException {
        String msg = this.checkReport(estReportDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstReportServiceImpl.updateReport.checkReport", msg);
        }
        EstReport oldEstReport = this.getReportModelById(estReportDomain.getReportId());
        if (oldEstReport == null) {
            throw new ApiException("estate.EstReportServiceImpl.updateReport.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstReport estReport = this.makeReport(estReportDomain, oldEstReport);
        this.setReportUpdataDefault(estReport);
        this.updateReportModel(estReport);
    }

    @Override
    public EstReport getReport(Integer reportId) {
        return this.getReportModelById(reportId);
    }

    @Override
    public void deleteReport(Integer reportId) throws ApiException {
        this.deleteReportModel(reportId);
    }

    @Override
    public QueryResult<EstReport> queryReportPage(Map<String, Object> map) {
        map = this.getMemberCodeByPhoneNumber(map);
        List<EstReport> estReportList = this.queryReportModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countReport(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReportList);
        return queryResult;
    }

    public int queryReportPageCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReportMapper.queryReportPageCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.countReport", (Throwable)e);
        }
        return i;
    }

    public int getScreeningQueryCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReportMapper.getScreeningQueryCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.countReport", (Throwable)e);
        }
        return i;
    }

    @Override
    public EstReport getReportByCode(Map<String, Object> map) {
        EstReport estReport = this.getReportModelByCode(map);
        if (estReport != null) {
            this.setReportInfo(estReport);
        }
        return estReport;
    }

    @Override
    public void delReportByCode(Map<String, Object> map) throws ApiException {
        this.delReportModelByCode(map);
    }

    @Override
    public void transfer(EstReportDomain estReportDomain) {
    }

    @Override
    public Integer getReportTotalByDate(Map<String, Object> map) {
        if (map.size() <= 0) {
            throw new ApiException("estate.EstReportServiceImpl.getOtherDayReportTotal.date", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (map.get("userCodes") == null) {
            throw new ApiException("estate.EstReportServiceImpl.getReportTotalByDate", "userCodes\u4e3a\u7a7a");
        }
        if (map.get("otherDay") == null && map.get("startDate") == null && map.get("endDate") == null) {
            throw new ApiException("estate.EstReportServiceImpl.getReportTotalByDate", "otherDay\u4e3a\u7a7a, startDate and endDate");
        }
        return this.estReportMapper.getReportTotalByDate(map);
    }

    @Override
    public Map<String, Object> getReportTotalByTask(Map<String, Object> map) {
        if (map.size() <= 0) {
            throw new ApiException("estate.EstReportServiceImpl.getReportTotalByTask", "map. \u53c2\u6570\u4e3a\u7a7a");
        }
        Map<String, Object> taskTotalList = this.estReportMapper.getReportTotalByTask(map);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String region = null;
        String vid = null;
        if (taskTotalList == null || taskTotalList.size() <= 0) {
            return resultMap;
        }
        for (Map.Entry<String, Object> entry : taskTotalList.entrySet()) {
            if ("TASK_CODE".equals(entry.getKey())) {
                region = (String)entry.getValue();
                continue;
            }
            if (!"total".equals(entry.getKey())) continue;
            vid = String.valueOf(entry.getValue());
        }
        resultMap.put(region, vid);
        return resultMap;
    }

    @Override
    public List<EstReport> queryReportListByLike(Map<String, Object> map) {
        if (map.size() <= 0) {
            throw new ApiException("estate.EstReportServiceImpl.queryReportListByLike", "map. \u53c2\u6570\u4e3a\u7a7a");
        }
        return this.estReportMapper.queryReportListByLike(map);
    }

    private PageInfo<EstReport> queryReportListByLikeModel(Map<String, Object> map) {
        try {
            this.startPage(map);
            List<EstReport> reportList = this.estReportMapper.queryReportListByLike(map);
            return this.getPageInfo(reportList);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.queryReportModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<EstReport> queryReportListByLikePage(Map<String, Object> map) {
        if (map.size() <= 0) {
            throw new ApiException("estate.EstReportServiceImpl.queryReportListByLikePage", "map. \u53c2\u6570\u4e3a\u7a7a");
        }
        PageInfo<EstReport> estReportList = this.queryReportListByLikeModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.valueOf(String.valueOf(estReportList.getTotal())).intValue());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReportList.getList());
        return queryResult;
    }

    @Override
    public List<EstReport> getReportList(Map<String, Object> map) {
        try {
            map = this.getMemberCodeByPhoneNumber(map);
            List<EstReport> reportList = this.estReportMapper.query(map);
            this.querySetAppertainByMyRpt(reportList);
            return reportList;
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.queryReportModel", (Throwable)e);
            return null;
        }
    }

    private PageInfo<EstReport> queryScreeningQueryListListModel(Map<String, Object> map) {
        try {
            this.logger.info("estate.EstReportServiceImpl.queryScreeningQueryListListModel map.toJson: ", map);
            this.startPage(map);
            List<EstReport> estReportList = this.estReportMapper.screeningQueryList(map);
            return this.getPageInfo(estReportList);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.getReportByCondForeachModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<EstReport> screeningQueryList(Map<String, Object> map) {
        map = this.getMemberCodeByPhoneNumber(map);
        PageInfo<EstReport> estReportPage = this.queryScreeningQueryListListModel(map);
        if (Boolean.parseBoolean(String.valueOf(map.get("opType")))) {
            this.setIntentionOpType(estReportPage);
            this.setVisitingCount(estReportPage);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.valueOf(String.valueOf(estReportPage.getTotal())).intValue());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReportPage.getList());
        return queryResult;
    }

    private void setVisitingCount(PageInfo<EstReport> reportPageInfo) {
        if (ListUtil.isEmpty((Collection)reportPageInfo.getList())) {
            return;
        }
        List estReportList = reportPageInfo.getList();
        for (EstReport estReport : estReportList) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("memberCode", estReport.getMemberCode());
            paramMap.put("opCode", estReport.getProjectCode());
            String visitingCount = this.internalInvoke("mm.merber.countVisiting", paramMap);
            if (!StringUtils.isNotBlank((String)visitingCount)) continue;
            estReport.setVisitingCount(Integer.valueOf(visitingCount));
        }
    }

    private void setIntentionOpType(PageInfo<EstReport> reportPageInfo) {
        if (ListUtil.isEmpty((Collection)reportPageInfo.getList())) {
            return;
        }
        List estReportList = reportPageInfo.getList();
        for (EstReport estReport : estReportList) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("memberCode", estReport.getMemberCode());
            paramMap.put("projectCode", estReport.getProjectCode());
            paramMap.put("tenantCode", estReport.getTenantCode());
            EstIntention estIntention = this.estIntentionService.getIntentionByCode(paramMap);
            if (estIntention == null) continue;
            estReport.setIntentionOpType(estIntention.getIntentionOpType());
        }
    }

    private PageInfo<EstReport> queryMyReportScreeningListModel(Map<String, Object> map) {
        try {
            this.logger.info("estate.EstReportServiceImpl.queryMyReportScreeningListModel map.toJson: ", map);
            this.startPage(map);
            List<EstReport> estReportList = this.estReportMapper.queryMyReportScreeningList(map);
            return this.getPageInfo(estReportList);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.getReportByCondForeachModel", (Throwable)e);
            return null;
        }
    }

    private PageInfo<EstReport> queryReportScreeningListModel(Map<String, Object> map) {
        try {
            this.logger.info("estate.EstReportServiceImpl.queryReportScreeningListModel map.toJson: ", map);
            this.startPage(map);
            List<EstReport> estReportList = this.estReportMapper.queryReportScreeningList(map);
            return this.getPageInfo(estReportList);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.queryReportScreeningListModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<EstReport> queryMyReportScreeningPage(Map<String, Object> map) {
        long currentTime = System.currentTimeMillis();
        map = this.getMemberCodeByPhoneNumber(map);
        PageInfo<EstReport> reportPageInfo = this.queryMyReportScreeningListModel(map);
        this.querySetAppertainByMyRpt(reportPageInfo);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.parseInt(String.valueOf(reportPageInfo.getTotal())));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(reportPageInfo.getList());
        return queryResult;
    }

    @Override
    public QueryResult<EstReport> queryReportListPageByCode(Map<String, Object> map) {
        map = this.getMemberCodeByPhoneNumber(map);
        List<EstReport> estReportList = this.queryReportModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countReport(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReportList);
        return queryResult;
    }

    @Override
    public QueryResult<EstReport> queryReportScreeningPage(Map<String, Object> map) {
        long currentTime = System.currentTimeMillis();
        map = this.getMemberCodeByPhoneNumber(map);
        PageInfo<EstReport> reportPageInfo = this.queryReportScreeningListModel(map);
        this.querySetAppertainByRpt(reportPageInfo);
        this.setIntentionTag(reportPageInfo);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.parseInt(String.valueOf(reportPageInfo.getTotal())));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(reportPageInfo.getList());
        return queryResult;
    }

    @Override
    public Integer checkReportState(Map<String, Object> map) {
        String tenantCode;
        String userCode;
        if (MapUtil.isEmpty(map)) {
            return -1;
        }
        String code = (String)map.get("code");
        if (StringUtils.isBlankLoop((String[])new String[]{code, userCode = (String)map.get("acceptCode"), tenantCode = (String)map.get("tenantCode")})) {
            return -1;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("reportCode", code);
        paramMap.put("userCode", userCode);
        paramMap.put("tenantCode", tenantCode);
        EstReport estReport = this.getReportByCode(paramMap);
        if (estReport == null || !estReport.getDataState().equals(1)) {
            return 0;
        }
        return 1;
    }

    private PageInfo<EstReport> queryReportByAssigningModel(Map<String, Object> map) {
        try {
            this.logger.info("estate.EstReportServiceImpl.queryReportByAssigningModel map.toJson: ", map);
            this.startPage(map);
            List<EstReport> estReportList = this.estReportMapper.queryReportAssigningList(map);
            return this.getPageInfo(estReportList);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.queryReportByAssigningModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<EstReport> queryReportListByAssigning(Map<String, Object> map) {
        PageInfo<EstReport> reportPageInfo = this.queryReportByAssigningModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.parseInt(String.valueOf(reportPageInfo.getTotal())));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(reportPageInfo.getList());
        return queryResult;
    }

    private Map<String, Object> getMemberInfo(String memberCode, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("merberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> paramPost = new HashMap<String, String>();
        paramPost.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String resultJson = this.internalInvoke("mm.merber.getMerberByCode", paramPost);
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
    }

    private void setIntentionTag(PageInfo<EstReport> reportPageInfo) {
        if (ListUtil.isEmpty((Collection)reportPageInfo.getList())) {
            return;
        }
        List estReportList = reportPageInfo.getList();
        List ddEntities = DdTransUtil.getDdList((String)"EstIntention-intentionContent");
        if (ddEntities == null) {
            return;
        }
        HashMap<String, String> ddICListMap = new HashMap<String, String>();
        for (DdEntity dd : ddEntities) {
            ddICListMap.put(dd.getDdCode(), dd.getDdValue());
        }
        for (EstReport report : estReportList) {
            if (report.getReportGrade() == null || !ddICListMap.containsKey(report.getIntentionContent())) continue;
            report.setIntentionTag((String)ddICListMap.get(report.getIntentionContent()));
        }
    }

    @Override
    public List<EstReport> publicCustomers(Map<String, Object> map) {
        if (map.size() <= 0 && map.get("projectCodes") == null) {
            throw new ApiException("estate.EstReportServiceImpl.publicCustomers", "map. \u53c2\u6570\u4e3a\u7a7a");
        }
        map = this.getMemberCodeByPhoneNumber(map);
        return this.estReportMapper.publicCustomers(map);
    }

    private PageInfo<EstReport> publicCustomersModel(Map<String, Object> map) {
        try {
            this.startPage(map);
            List<EstReport> list = this.estReportMapper.publicCustomers(map);
            return this.getPageInfo(list);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.publicCustomersModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<EstReport> publicCustomersPage(Map<String, Object> map) {
        map = this.getMemberCodeByPhoneNumber(map);
        PageInfo<EstReport> estReportList = this.publicCustomersModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.valueOf(String.valueOf(estReportList.getTotal())).intValue());
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReportList.getList());
        return queryResult;
    }

    private int getPublicCustomersCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReportMapper.getPublicCustomersCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.countReport", (Throwable)e);
        }
        return i;
    }

    private void setPublicPoolRptCount(QueryResult<EstPublicPool> queryResult, String projectCode) {
        if (queryResult != null && queryResult.getRows() != null && queryResult.getRows().size() > 0) {
            for (EstPublicPool estPublicPool : queryResult.getRows()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("publicPoolCode", estPublicPool.getPublicPoolCode());
                map.put("projectCode", projectCode);
                map.put("fuzzy", true);
                int publicPoolCount = this.estPublicPoolRptMapper.count(map);
                estPublicPool.setPublicPoolCount(publicPoolCount);
            }
        }
    }

    private Map<String, Object> getReportCodeByPublicPoolRpt(Map<String, Object> map) {
        if (map.containsKey("publicPoolCode") && StringUtils.isNotBlank((String)String.valueOf(map.get("publicPoolCode")))) {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("publicPoolCode", map.get("publicPoolCode"));
            parmMap.put("projectCode", map.get("projectCode"));
            List<EstPublicPoolRpt> estPublicPoolRptList = this.estPublicPoolRptMapper.query(parmMap);
            if (estPublicPoolRptList != null && estPublicPoolRptList.size() > 0) {
                ArrayList<String> reportCodes = new ArrayList<String>();
                for (EstPublicPoolRpt estPublicPoolRpt : estPublicPoolRptList) {
                    reportCodes.add(estPublicPoolRpt.getReportCode());
                }
                map.put("reportCodes", reportCodes);
                return map;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("###########");
            map.put("reportCodes", list);
        } else {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("opBillno", map.get("userCode"));
            parmMap.put("projectCode", map.get("projectCode"));
            List<EstPublicPoolRpt> estPublicPoolRptList = this.estPublicPoolRptMapper.queryPublicPoolRptByOpPage(parmMap);
            if (estPublicPoolRptList != null && estPublicPoolRptList.size() > 0) {
                ArrayList<String> reportCodes = new ArrayList<String>();
                for (EstPublicPoolRpt estPublicPoolRpt : estPublicPoolRptList) {
                    reportCodes.add(estPublicPoolRpt.getReportCode());
                }
                map.put("reportCodes", reportCodes);
                return map;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("###########");
            map.put("reportCodes", list);
        }
        return map;
    }

    @Override
    public QueryResult<EstReport> newlyAssignedList(Map<String, Object> map) {
        map = this.getMemberCodeByPhoneNumber(map);
        List<EstReport> estReportList = this.estReportMapper.newlyAssignedList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countReport(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReportList);
        return queryResult;
    }

    @Override
    public void saveReportReDomain(EstReportReDomain estReportReDomain) throws ApiException {
        String msg = this.checkReport(estReportReDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstReportServiceImpl.saveReportReDomain.checkReport", msg);
        }
        EstReport estReport = this.makeReport(estReportReDomain, null);
        this.setReportDefault(estReport);
        this.saveReportModel(estReport);
    }

    private List<EstReport> getReportByCondForeachModel(Map<String, Object> map) {
        try {
            return this.estReportMapper.getReportByCondForeach(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.getReportByCondForeachModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<EstReport> getReportByCondForeach(Map<String, Object> map) throws ApiException {
        return this.getReportByCondForeachModel(map);
    }

    @Override
    public List<Map<String, String>> saveReportBatchReDomain(List<EstReportReDomain> list) throws ApiException {
        if (list == null) {
            return null;
        }
        ArrayList<Map<String, String>> retVals = new ArrayList<Map<String, String>>();
        ArrayList<EstReport> estReports = new ArrayList<EstReport>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String memberCode = "memberCode";
        String tenantCode = "tenantCode";
        String projectCode = "projectCode";
        String roleCode = "roleCode";
        for (EstReportReDomain estReportReDomain : list) {
            if (estReportReDomain.getRoleCode() == null) {
                map.put(roleCode, "-");
            } else {
                map.put(roleCode, estReportReDomain.getRoleCode());
            }
            map.put(memberCode, estReportReDomain.getMemberCode());
            map.put(projectCode, estReportReDomain.getProjectCode());
            map.put(tenantCode, estReportReDomain.getTenantCode());
            EstReport hasEstReport = this.getReportByCode(map);
            map.clear();
            if (hasEstReport == null) {
                EstReport estReport = this.makeReport(estReportReDomain, null);
                this.setReportDefault(estReport);
                estReports.add(estReport);
                continue;
            }
            this.logger.error("estate.EstReportServiceImpl.\u5df2\u7ecf\u5b58\u5728\u7684\u62a5\u5907MemberCode" + hasEstReport.getMemberCode());
        }
        if (estReports.size() > 0) {
            this.insertBatchModel(estReports);
        }
        return retVals;
    }

    @Override
    public List<Map<String, String>> getReportTotalByCode(Map<String, Object> map) {
        List<Map<String, Object>> totalListMap = this.estReportMapper.getReportTotalByCode(map);
        ArrayList<Map<String, String>> resultArrayMap = new ArrayList<Map<String, String>>();
        if (totalListMap == null || totalListMap.size() <= 0) {
            return null;
        }
        Iterator<Map<String, Object>> iterator = totalListMap.iterator();
        while (iterator.hasNext()) {
            String region = null;
            String vid = null;
            Map<String, Object> entryMap = iterator.next();
            for (Map.Entry<String, Object> entry : entryMap.entrySet()) {
                if ("USER_CODE".equals(entry.getKey())) {
                    region = (String)entry.getValue();
                    continue;
                }
                if (!"total".equals(entry.getKey())) continue;
                vid = String.valueOf(entry.getValue());
            }
            if (!StringUtils.isNotBlank(region)) continue;
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put(region, vid);
            resultArrayMap.add(resultMap);
        }
        List userCodes = (List)map.get("userCodes");
        Iterator iter = resultArrayMap.iterator();
        HashMap<String, String> nextMapAdd = new HashMap<String, String>();
        while (iter.hasNext()) {
            Map nextMap = (Map)iter.next();
            for (String userCode : userCodes) {
                if (nextMap.containsKey(userCode)) continue;
                nextMapAdd.put(userCode, "0");
            }
        }
        resultArrayMap.add(nextMapAdd);
        return resultArrayMap;
    }

    @Override
    public void updateAssigningReport(Map<String, Object> map) {
        String reportJson = JsonUtil.buildNonEmptyBinder().toJson(map.get("estReport"));
        EstReport estReport = this.makeReport((EstReportDomain)JsonUtil.buildNonEmptyBinder().getJsonToObject(reportJson, EstReportDomain.class), null);
        String userCode = (String)map.get("userCode");
        List reUserCodes = (List)map.get("reUserCodes");
        if (estReport == null || StringUtils.isBlank((String)userCode)) {
            throw new ApiException("estate.EstReportServiceImpl.assigningReportAllByUser.ex", "estReport or userCode is null");
        }
        if (reUserCodes.size() <= 0) {
            throw new ApiException("estate.EstReportServiceImpl.updateAssigningReport error", "\u5206\u914d\u5bf9\u8c61\u5217\u8868\u7a7a");
        }
        HashMap<String, Object> parmMap2 = new HashMap<String, Object>();
        parmMap2.put("userCode", userCode);
        List<String> reportCodes = this.queryAssigningRptCodeListModel(parmMap2);
        Map<String, List<String>> calculateResultRptCodes = this.allotOfAverageByAssigningRpt(reUserCodes, reportCodes);
        Set<Map.Entry<String, List<String>>> entries = calculateResultRptCodes.entrySet();
        for (Map.Entry<String, List<String>> rptResultMap : entries) {
            if (StringUtils.isBlank((String)rptResultMap.getKey()) || ListUtil.isEmpty((Collection)rptResultMap.getValue())) {
                throw new ApiException("estate.EstReportServiceImpl.updateAssigningReport error", "\u5206\u914d\u5931\u8d25 \u6570\u636e\u4e3a\u7a7a");
            }
            System.out.println(String.valueOf(rptResultMap.getKey()) + ":" + rptResultMap.getValue());
            String reUCode = rptResultMap.getKey();
            UserBean userBean = this.getUser(reUCode, estReport.getTenantCode());
            if (userBean == null) {
                throw new ApiException("estate.EstReportServiceImpl.updateAssigningReport error", "\u5206\u914d\u5931\u8d25,\u6307\u5b9a\u4eba\u7528\u6237\u4e0d\u5b58\u5728");
            }
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("reUserCode", userBean.getUserCode());
            parmMap.put("userCode", userCode);
            parmMap.put("reportUname", userBean.getUserRelname());
            parmMap.put("reportUphone", userBean.getUserPhone());
            parmMap.put("roleCode", userBean.getRoleCode());
            if (entries.size() > 1) {
                parmMap.put("reportCodes", rptResultMap.getValue());
            } else {
                parmMap.put("reportCodes", null);
            }
            this.estReportMapper.updateAssigningReport(parmMap);
        }
    }

    private UserBean getUser(String userCode, String tenantCode) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("userCode", userCode);
        parmMap.put("tenantCode", tenantCode);
        String resultJson = this.internalInvoke("um.user.getUserByCode", parmMap);
        UserBean user = (UserBean)JsonUtil.buildNormalBinder().getJsonToObject(resultJson, UserBean.class);
        return user;
    }

    private List<String> queryAssigningRptCodeListModel(Map<String, Object> map) {
        try {
            List<String> reportCodes = this.estReportMapper.queryAssigningRptCodeList(map);
            return reportCodes;
        }
        catch (Exception ex) {
            throw new ApiException("estate.EstReportServiceImpl.queryAssigningRptCodeListModel error", "\u88ab\u5206\u914d\u7528\u6237\u7684\u6ca1\u6709\u5ba2\u6237");
        }
    }

    Map<String, Integer> calculateAssigningAlgorithm(String[] reUserCodes, Integer reportTotal) {
        return null;
    }

    public Map<String, List<String>> allotOfAverageByAssigningRpt(List<String> users, List<String> reportCodes) {
        ConcurrentHashMap<String, List<String>> allot = new ConcurrentHashMap<String, List<String>>();
        if (users != null && users.size() > 0 && reportCodes != null && reportCodes.size() > 0) {
            int i = 0;
            while (i < reportCodes.size()) {
                List<String> list;
                int j = i % users.size();
                if (allot.containsKey(users.get(j))) {
                    list = (List)allot.get(users.get(j));
                    list.add(reportCodes.get(i));
                    allot.put(users.get(j), list);
                } else {
                    list = new ArrayList<String>();
                    list.add(reportCodes.get(i));
                    allot.put(users.get(j), list);
                }
                ++i;
            }
        }
        return allot;
    }

    private void insertBatchModel(List<EstReport> estReports) throws ApiException {
        if (estReports == null) {
            return;
        }
        try {
            this.estReportMapper.insertBatch(estReports);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReportServiceImpl.saveBatchMerberModel.ex", (Throwable)e);
        }
    }

    private Map<String, Object> getMemberCodeByPhoneNumber(Map<String, Object> map) {
        String likeVal = null;
        String tenantCode = null;
        if (map != null && map.size() > 0) {
            likeVal = (String)map.get("phoneNo");
            tenantCode = (String)map.get("tenantCode");
        }
        if (StringUtils.isBlank(likeVal) || StringUtils.isBlank(tenantCode)) {
            try {
                map.remove("phoneNo");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return map;
        }
        likeVal.replaceAll("\\s*", "");
        likeVal.replaceAll("-", "");
        Integer likeValLength = likeVal.length();
        Integer regexLastLength = null;
        if (likeValLength.equals(4)) {
            regexLastLength = 4;
            ArrayList<String> memberCodes = new ArrayList<String>();
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("merberPhone", likeVal);
            param.put("regexLast", regexLastLength);
            param.put("tenantCode", tenantCode);
            HashMap<String, String> paramPost = new HashMap<String, String>();
            paramPost.put("map", JsonUtil.buildNormalBinder().toJson(param));
            String jsonObj = this.internalInvoke("mm.merber.queryMerberByAllPhoneByLike", paramPost);
            List memberMap = (List)JsonUtil.getAllJsonUtil().getJsonToList(jsonObj, Map.class);
            if (memberMap != null && memberMap.size() > 0) {
                for (Map member : memberMap) {
                    String memberCode = (String)member.get("merberCode");
                    if (!StringUtils.isNotBlank((String)memberCode)) continue;
                    memberCodes.add(memberCode);
                }
            } else {
                param = new HashMap();
                param.put("memberPhone", likeVal);
                param.put("memberType", 1);
                param.put("regexLast", regexLastLength);
                param.put("tenantCode", tenantCode);
                String memberCode = "";
                List<EstReserveUnitMember> estReserveUnitMemberList = this.estReserveUnitMemberService.queryReserveUnitMemberByPhoneLike(param);
                if (ListUtil.isNotEmpty(estReserveUnitMemberList)) {
                    for (EstReserveUnitMember reserveUnitMember : estReserveUnitMemberList) {
                        if (!StringUtils.isNotBlank((String)reserveUnitMember.getMemberPhone())) continue;
                        memberCodes.add(reserveUnitMember.getMemberPhone());
                    }
                }
            }
            if (memberCodes.size() <= 0) {
                memberCodes.add("###########");
            }
            map.put("memberCodes", memberCodes);
        }
        if ((regexLastLength == null || regexLastLength != 4) && this.getMemberCodeByFullMatchPhone(map, likeVal, tenantCode)) {
            return map;
        }
        return map;
    }

    private boolean getMemberCodeByFullMatchPhone(Map<String, Object> map, String likeVal, String tenantCode) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("merberPhone", likeVal);
        param.put("tenantCode", tenantCode);
        String jsonObj = this.internalInvoke("mm.merber.getMerberByAllPhone", param);
        JsonUtil.getAllJsonUtil();
        Map memberMap = JsonUtil.getJsonToMap((String)jsonObj);
        if (memberMap != null && memberMap.size() > 0) {
            String memberCode = (String)memberMap.get("merberCode");
            map.put("memberCode", memberCode);
            return true;
        }
        param = new HashMap();
        param.put("memberPhone", likeVal);
        param.put("memberType", 1);
        param.put("tenantCode", tenantCode);
        String memberCode = "";
        QueryResult<EstReserveUnitMember> estReserveUnitMemberQueryResult = this.estReserveUnitMemberService.queryReserveUnitMemberPage(param);
        if (estReserveUnitMemberQueryResult.getRows() != null && estReserveUnitMemberQueryResult.getRows().size() > 0) {
            memberCode = ((EstReserveUnitMember)estReserveUnitMemberQueryResult.getRows().get(0)).getOpBillno();
        }
        map.put("memberCode", memberCode);
        if (StringUtils.isBlank((String)memberCode)) {
            map.put("memberCode", "###########");
        }
        return false;
    }

    @Override
    public Integer updateReportUphone(Map<String, Object> map) {
        if (map == null) {
            return 0;
        }
        int index = this.updateReportUphoneModel(map);
        this.logger.info("\u5df2\u4fee\u6539\u62a5\u5907\u4eba\u624b\u673a\u53f7\u6570\u636e" + index + "\u884c\uff0c\u65e7\u624b\u673a\u53f7\u4e3a\uff1a" + map.get("oldUserPhone") + "\uff0c\u65b0\u624b\u673a\u53f7\u4e3a\uff1a" + map.get("newUserPhone"));
        return index;
    }

    private int updateReportUphoneModel(Map<String, Object> map) {
        try {
            return this.estReportMapper.updateReportUphone(map);
        }
        catch (Exception e) {
            if (this.updateUserPhone(map)) {
                this.logger.error("estate.EstReportServiceImpl.updateReportUphoneModel.ex", (Object)"\u62a5\u5907\u4eba\u624b\u673a\u53f7\u540c\u6b65\u5931\u8d25,\u7528\u6237\u8868\u56de\u6eda\u6210\u529f");
            } else {
                this.logger.error("estate.EstReportServiceImpl.updateReportUphoneModel.ex", (Object)"\u62a5\u5907\u4eba\u624b\u673a\u53f7\u540c\u6b65\u5931\u8d25,\u7528\u6237\u8868\u56de\u6eda\u5931\u8d25");
            }
            throw new ApiException("estate.EstReportServiceImpl.updateReportUphoneModel.ex", "\u62a5\u5907\u4eba\u624b\u673a\u53f7\u540c\u6b65\u5931\u8d25,\u8bf7\u91cd\u65b0\u64cd\u4f5c");
        }
    }

    private boolean updateUserPhone(Map<String, Object> map) {
        HashMap<String, Object> map2 = new HashMap<String, Object>();
        map2.put("oldUserPhone", map.get("newUserPhone"));
        map2.put("tenantCode", map.get("tenantCode"));
        map2.put("newUserPhone", map.get("oldUserPhone"));
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("map", JsonUtil.buildNormalBinder().toJson(map2));
        String jsonObj = this.internalInvoke("um.user.updateUserPhoneByUserPhone", param);
        Map resultMap = (Map)JsonUtil.buildNonNullBinder().getJsonToObject(jsonObj, Map.class);
        Boolean success = (Boolean)resultMap.get("successFlag");
        return success;
    }

    private int countFollow(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estFollowMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.countFollow", (Throwable)e);
        }
        return i;
    }

    private void querySetAppertainByMyRpt(PageInfo<EstReport> reportPageInfo) {
        if (reportPageInfo != null && ListUtil.isEmpty((Collection)reportPageInfo.getList())) {
            return;
        }
        this.querySetAppertainByMyRpt(reportPageInfo.getList());
    }

    private void querySetAppertainByMyRpt(List<EstReport> reportList) {
        try {
            if (ListUtil.isEmpty(reportList)) {
                return;
            }
            List<EstReport> estReportList = reportList;
            List ddIGList = DdTransUtil.getDdList((String)"EstIntention-intentionGrade");
            List ddCCList = DdTransUtil.getDdList((String)"EstReport-cognitiveChannel");
            HashMap<Integer, String> ddIGListMap = new HashMap<Integer, String>();
            HashMap<Integer, String> ddCCListMap = new HashMap<Integer, String>();
            for (DdEntity dd : ddIGList) {
                ddIGListMap.put(Integer.valueOf(dd.getDdCode()), dd.getDdValue());
            }
            for (DdEntity dd : ddCCList) {
                ddCCListMap.put(Integer.valueOf(dd.getDdCode()), dd.getDdValue());
            }
            for (EstReport estReport : estReportList) {
                if (MapUtil.isNotEmpty(ddIGListMap) && estReport.getReportGrade() != null && ddIGListMap.containsKey(estReport.getReportGrade())) {
                    estReport.setIntentionGradeTag((String)ddIGListMap.get(estReport.getReportGrade()));
                }
                if (!MapUtil.isNotEmpty(ddCCListMap) || estReport.getCognitiveChannel() == null || !ddCCListMap.containsKey(estReport.getCognitiveChannel())) continue;
                estReport.setCognitiveChannelTag((String)ddCCListMap.get(estReport.getCognitiveChannel()));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void querySetAppertainByRpt(PageInfo<EstReport> reportPageInfo) {
        long currentTime = System.currentTimeMillis();
        if (ListUtil.isEmpty((Collection)reportPageInfo.getList())) {
            return;
        }
        List estReportList = reportPageInfo.getList();
        for (EstReport estReport : estReportList) {
            this.setAppertainByRpt(estReport);
        }
    }

    private void setReportInfo(EstReport estReport) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("reportCode", estReport.getReportCode());
        paramMap.put("projectCode", estReport.getProjectCode());
        paramMap.put("tenantCode", estReport.getTenantCode());
        Map<String, Object> memberJson = this.getMemberInfo(estReport.getMemberCode(), estReport.getTenantCode());
        if (MapUtil.isNotEmpty(memberJson)) {
            estReport.setMemberPhone((String)memberJson.get("merberPhone"));
        }
    }

    private void setAppertainByRpt(EstReport estReport) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("reportCode", estReport.getReportCode());
        paramMap.put("projectCode", estReport.getProjectCode());
        paramMap.put("tenantCode", estReport.getTenantCode());
        long currentTime1 = System.currentTimeMillis();
        estReport.setFollowTotal(this.countFollow(paramMap));
        paramMap = new HashMap();
        paramMap.put("memberCode", estReport.getMemberCode());
        paramMap.put("projectCode", estReport.getProjectCode());
        long currentTime2 = System.currentTimeMillis();
        estReport.setStateTotal(this.getCountState(paramMap));
        long currentTime3 = System.currentTimeMillis();
        Map<String, Object> memberJson = this.getMemberInfo(estReport.getMemberCode(), estReport.getTenantCode());
        if (MapUtil.isNotEmpty(memberJson)) {
            estReport.setMemberPhone((String)memberJson.get("merberPhone"));
        }
    }

    public Long getCountState(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        Integer count = this.countState(map);
        return Long.parseLong(String.valueOf(count));
    }

    private int countState(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estStateMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReportServiceImpl.countState", (Throwable)e);
        }
        return i;
    }
}

