/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.github.pagehelper.PageInfo;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.EstateConstants;
import com.yqbsoft.laser.service.estate.dao.EstFlowLinkMapper;
import com.yqbsoft.laser.service.estate.dao.EstReserveUnitMapper;
import com.yqbsoft.laser.service.estate.domain.EstFlowLinkDomain;
import com.yqbsoft.laser.service.estate.domain.EstPaymentDetailsDomain;
import com.yqbsoft.laser.service.estate.domain.EstReserveUnitDomain;
import com.yqbsoft.laser.service.estate.domain.EstReserveUnitMemberDomain;
import com.yqbsoft.laser.service.estate.model.EstFlowLink;
import com.yqbsoft.laser.service.estate.model.EstPaymentDetails;
import com.yqbsoft.laser.service.estate.model.EstReport;
import com.yqbsoft.laser.service.estate.model.EstReserveUnit;
import com.yqbsoft.laser.service.estate.model.EstReserveUnitMember;
import com.yqbsoft.laser.service.estate.service.EstFlowLinkService;
import com.yqbsoft.laser.service.estate.service.EstPaymentDetailsService;
import com.yqbsoft.laser.service.estate.service.EstReportService;
import com.yqbsoft.laser.service.estate.service.EstReserveUnitMemberService;
import com.yqbsoft.laser.service.estate.service.EstReserveUnitService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class EstReserveUnitServiceImpl
extends BaseServiceImpl
implements EstReserveUnitService {
    public static final String SYS_CODE = "estate.EstReserveUnitServiceImpl";
    private EstReserveUnitMapper estReserveUnitMapper;
    @Autowired
    private EstReserveUnitMemberService estReserveUnitMemberService;
    @Autowired
    private EstFlowLinkService estFlowLinkService;
    @Autowired
    private EstPaymentDetailsService paymentDetailsService;
    @Autowired
    private EstFlowLinkMapper estFlowLinkMapper;
    @Autowired
    private EstReportService estReportService;

    public void setEstReserveUnitMapper(EstReserveUnitMapper estReserveUnitMapper) {
        this.estReserveUnitMapper = estReserveUnitMapper;
    }

    private Date getSysDate() {
        try {
            return this.estReserveUnitMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkReserveUnit(EstReserveUnitDomain estReserveUnitDomain) {
        Double valueOf;
        if (estReserveUnitDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        if (StringUtils.isNotBlank((String)estReserveUnitDomain.getPresalseArea())) {
            valueOf = Double.valueOf(estReserveUnitDomain.getPresalseArea());
            estReserveUnitDomain.setPresalseArea(String.format("%.4f", valueOf));
        }
        if (StringUtils.isNotBlank((String)estReserveUnitDomain.getContractArea())) {
            valueOf = Double.valueOf(estReserveUnitDomain.getContractArea());
            estReserveUnitDomain.setContractArea(String.format("%.4f", valueOf));
        }
        String msg = "";
        return msg;
    }

    private void setReserveUnitDefault(EstReserveUnit estReserveUnit) {
        if (estReserveUnit == null) {
            return;
        }
        if (estReserveUnit.getDataState() == null) {
            estReserveUnit.setDataState(1);
        }
        if (estReserveUnit.getGmtCreate() == null) {
            estReserveUnit.setGmtCreate(this.getSysDate());
        }
        estReserveUnit.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estReserveUnit.getReserveUnitCode())) {
            estReserveUnit.setReserveUnitCode(this.createUUIDString());
        }
    }

    private int getReserveUnitMaxCode() {
        int code = 0;
        try {
            return this.estReserveUnitMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.getReserveUnitMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setReserveUnitUpdataDefault(EstReserveUnit estReserveUnit) {
        if (estReserveUnit == null) {
            return;
        }
        estReserveUnit.setGmtModified(this.getSysDate());
    }

    private void saveReserveUnitModel(EstReserveUnit estReserveUnit) throws ApiException {
        if (estReserveUnit == null) {
            return;
        }
        try {
            estReserveUnit.setDataExamState(-1);
            this.estReserveUnitMapper.insert(estReserveUnit);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.saveReserveUnitModel.ex", (Throwable)e);
        }
    }

    private EstReserveUnit getReserveUnitModelById(Integer reserveUnitId) {
        if (reserveUnitId == null) {
            return null;
        }
        try {
            return this.estReserveUnitMapper.selectByPrimaryKey(reserveUnitId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.getReserveUnitModelById", (Throwable)e);
            return null;
        }
    }

    public EstReserveUnit getReserveUnitModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estReserveUnitMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.getReserveUnitModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delReserveUnitModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estReserveUnitMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.delReserveUnitModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.delReserveUnitModelByCode.num");
        }
    }

    private void deleteReserveUnitModel(Integer reserveUnitId) throws ApiException {
        if (reserveUnitId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estReserveUnitMapper.deleteByPrimaryKey(reserveUnitId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.deleteReserveUnitModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.deleteReserveUnitModel.num");
        }
    }

    private int updateReserveUnitModel(EstReserveUnit estReserveUnit) throws ApiException {
        if (estReserveUnit == null) {
            return 0;
        }
        try {
            return this.estReserveUnitMapper.updateByPrimaryKeySelective(estReserveUnit);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateReserveUnitModel.ex", (Throwable)e);
        }
    }

    private void updateStateReserveUnitModel(Integer reserveUnitId, Integer dataState, Integer oldDataState) throws ApiException {
        if (reserveUnitId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reserveUnitId", reserveUnitId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estReserveUnitMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateStateReserveUnitModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateStateReserveUnitModel.null");
        }
    }

    private EstReserveUnit makeReserveUnit(EstReserveUnitDomain estReserveUnitDomain, EstReserveUnit estReserveUnit) {
        if (estReserveUnitDomain == null) {
            return null;
        }
        if (estReserveUnit == null) {
            estReserveUnit = new EstReserveUnit();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estReserveUnit, (Object)estReserveUnitDomain);
            return estReserveUnit;
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.makeReserveUnit", (Throwable)e);
            return null;
        }
    }

    private List<EstReserveUnit> queryReserveUnitModelPage(Map<String, Object> parammap) {
        try {
            return this.estReserveUnitMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.queryReserveUnitModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public int countReserveUnit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReserveUnitMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.countReserveUnit", (Throwable)e);
        }
        return i;
    }

    private List<EstReserveUnit> queryAuditReserveUnitModelPage(Map<String, Object> parammap) {
        try {
            return this.estReserveUnitMapper.queryByFlowLinkAndRpt(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.queryReserveUnitModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<EstReserveUnit> queryAuditReserveUnitPage(Map<String, Object> map) {
        List<EstReserveUnit> estReserveUnitList = this.queryAuditReserveUnitModelPage(map);
        this.ssignmentaReserveUnitFlowLink(estReserveUnitList);
        this.ssignmentaReserveUnitMember(estReserveUnitList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.getQueryByFlowLinkAndRptCount(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReserveUnitList);
        return queryResult;
    }

    public int getQueryByFlowLinkCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReserveUnitMapper.getQueryByFlowLinkCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.countReserveUnit", (Throwable)e);
        }
        return i;
    }

    public int getQueryByFlowLinkAndRptCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReserveUnitMapper.getQueryByFlowLinkAndRptCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.countReserveUnit", (Throwable)e);
        }
        return i;
    }

    @Override
    public Map<String, Object> updateCopyReserveUnit(Map<String, Object> map) throws ApiException {
        List<EstFlowLink> flowLinkList;
        String reserveUnitCode = (String)map.get("reserveUnitCode");
        EstReserveUnitDomain estReserveUnitDomain = (EstReserveUnitDomain)JsonUtil.buildNonDefaultBinder().getJsonToObject((String)map.get("reserveUnitDomain"), EstReserveUnitDomain.class);
        String msg = this.checkReserveUnit(estReserveUnitDomain);
        if (StringUtils.isNotBlank((String)msg) || estReserveUnitDomain == null) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateCopyReserveUnit.checkReserveUnit", msg);
        }
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("reserveUnitCode", reserveUnitCode);
        parmMap.put("tenantCode", estReserveUnitDomain.getTenantCode());
        EstReserveUnit oldEstReserveUnit = this.getReserveUnitByCode(parmMap);
        if (oldEstReserveUnit == null) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateReserveUnit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstReserveUnit oldEstReserveUnitUpdate = new EstReserveUnit();
        EstReserveUnit estReserveUnit = new EstReserveUnit();
        try {
            BeanUtils.copyAllPropertysNotNull((Object)oldEstReserveUnitUpdate, (Object)oldEstReserveUnit);
            BeanUtils.copyAllPropertysNotNull((Object)oldEstReserveUnit, (Object)estReserveUnitDomain);
            BeanUtils.copyAllPropertysNotNull((Object)estReserveUnit, (Object)oldEstReserveUnit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        estReserveUnit.setReserveUnitId(null);
        estReserveUnit.setReserveUnitCode(null);
        estReserveUnit.setDataState(null);
        this.setReserveUnitDefault(estReserveUnit);
        this.saveReserveUnitModel(estReserveUnit);
        oldEstReserveUnitUpdate.setAfterUpdateCode(estReserveUnit.getReserveUnitCode());
        oldEstReserveUnitUpdate.setDataState(-1);
        this.updateReserveUnitModel(oldEstReserveUnitUpdate);
        if (estReserveUnitDomain.getReserveUnitMembers() != null && estReserveUnitDomain.getReserveUnitMembers().size() > 0) {
            for (EstReserveUnitMemberDomain reserveUnitMember : estReserveUnitDomain.getReserveUnitMembers()) {
                reserveUnitMember.setReserveUnitCode(estReserveUnit.getReserveUnitCode());
                this.estReserveUnitMemberService.saveReserveUnitMember(reserveUnitMember);
            }
        }
        if ((flowLinkList = this.queryFlowLinkList(oldEstReserveUnit.getReserveUnitCode(), oldEstReserveUnit.getTenantCode())) != null) {
            for (EstFlowLink estFlowLink : flowLinkList) {
                estFlowLink.setFlowLinkId(null);
                estFlowLink.setFlowLinkCode(this.createUUIDString());
                estFlowLink.setReserveUnitCode(estReserveUnit.getReserveUnitCode());
                estFlowLink.setDataState(2);
                try {
                    this.estFlowLinkMapper.insert(estFlowLink);
                }
                catch (Exception ex) {
                    this.logger.error("updateCopyReserveUnit.estFlowLinkMapper.insert", (Throwable)ex);
                }
            }
        }
        if (estReserveUnit.getReserveUnitType().equals(EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType())) {
            HashMap<String, String> mapPaymentDetails = new HashMap<String, String>();
            mapPaymentDetails.put("reserveUnitCode", reserveUnitCode);
            mapPaymentDetails.put("tenantCode", oldEstReserveUnit.getTenantCode());
            EstPaymentDetails paymentDetails = this.paymentDetailsService.getPaymentDetailsByCode(map);
            if (paymentDetails != null) {
                paymentDetails.setPaymentDetailsId(null);
                paymentDetails.setPaymentDetailsCode(null);
                paymentDetails.setReserveUnitCode(estReserveUnit.getReserveUnitCode());
                if (estReserveUnitDomain.getPaymentDetails() != null) {
                    EstPaymentDetailsDomain estPaymentDetailsDomain = estReserveUnitDomain.getPaymentDetails();
                    estPaymentDetailsDomain.setReserveUnitCode(estReserveUnit.getReserveUnitCode());
                    estPaymentDetailsDomain.setAcceptHandleState("1");
                    estPaymentDetailsDomain.setAcceptMaterialState("1");
                    estPaymentDetailsDomain.setTenantCode(estReserveUnit.getTenantCode());
                    this.paymentDetailsService.savePaymentDetails(estPaymentDetailsDomain);
                } else {
                    this.paymentDetailsService.savePaymentDetails(this.makePaymentDetails(paymentDetails, null));
                }
            }
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
        return resultMap;
    }

    private EstPaymentDetailsDomain makePaymentDetails(EstPaymentDetails estPaymentDetails, EstPaymentDetailsDomain estPaymentDetailsDomain) {
        if (estPaymentDetails == null) {
            return null;
        }
        if (estPaymentDetailsDomain == null) {
            estPaymentDetailsDomain = new EstPaymentDetailsDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estPaymentDetailsDomain, (Object)estPaymentDetails);
            return estPaymentDetailsDomain;
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.makePaymentDetails", (Throwable)e);
            return null;
        }
    }

    private EstFlowLinkDomain makeFlowLink(EstFlowLink estFlowLink, EstFlowLinkDomain estFlowLinkDomain) {
        if (estFlowLink == null) {
            return null;
        }
        if (estFlowLinkDomain == null) {
            estFlowLinkDomain = new EstFlowLinkDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estFlowLinkDomain, (Object)estFlowLink);
            return estFlowLinkDomain;
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.makeIntention", (Throwable)e);
            return null;
        }
    }

    private List<EstFlowLink> queryFlowLinkList(String reserveUnitCode, String tenantCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("reserveUnitCode", reserveUnitCode);
        parmMap.put("tenantCode", tenantCode);
        QueryResult<EstFlowLink> flowLinkQueryResult = this.estFlowLinkService.queryFlowLinkPage(parmMap);
        if (flowLinkQueryResult != null && flowLinkQueryResult.getRows() != null && flowLinkQueryResult.getRows().size() > 0) {
            return flowLinkQueryResult.getRows();
        }
        return null;
    }

    @Override
    public void saveReserveUnit(EstReserveUnitDomain estReserveUnitDomain) throws ApiException {
        String msg = this.checkReserveUnit(estReserveUnitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.saveReserveUnit.checkReserveUnit", msg);
        }
        EstReserveUnit estReserveUnit = this.makeReserveUnit(estReserveUnitDomain, null);
        this.setReserveUnitDefault(estReserveUnit);
        EstReport estReport = this.getEstReportByOpUser(estReserveUnit);
        if (estReport != null && ("0001001".equals(estReport.getRoleCode()) || "BK00001".equals(estReport.getRoleCode()))) {
            estReserveUnit.setOpBillcode(estReport.getUserCode());
        }
        this.saveReserveUnitModel(estReserveUnit);
        if (estReserveUnitDomain.getReserveUnitMembers() != null && estReserveUnitDomain.getReserveUnitMembers().size() > 0) {
            for (EstReserveUnitMemberDomain reserveUnitMember : estReserveUnitDomain.getReserveUnitMembers()) {
                reserveUnitMember.setReserveUnitCode(estReserveUnit.getReserveUnitCode());
                reserveUnitMember.setOpBillno(estReserveUnit.getMemberCode());
                this.estReserveUnitMemberService.saveReserveUnitMember(reserveUnitMember);
            }
        }
        if (estReserveUnitDomain.getReserveUnitType().equals(EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType()) && estReserveUnitDomain.getPaymentDetails() != null) {
            estReserveUnitDomain.getPaymentDetails().setReserveUnitCode(estReserveUnit.getReserveUnitCode());
            estReserveUnitDomain.getPaymentDetails().setTenantCode(estReserveUnit.getTenantCode());
            estReserveUnitDomain.getPaymentDetails().setAcceptHandleState("1");
            estReserveUnitDomain.getPaymentDetails().setAcceptMaterialState("1");
            this.paymentDetailsService.savePaymentDetails(estReserveUnitDomain.getPaymentDetails());
        }
    }

    private EstReport getEstReportByOpUser(EstReserveUnit estReserveUnit) {
        HashMap<String, Object> paramRptMap = new HashMap<String, Object>();
        paramRptMap.put("memberCode", estReserveUnit.getMemberCode());
        paramRptMap.put("roleCode", "0001001");
        paramRptMap.put("dataState", 1);
        paramRptMap.put("projectCode", estReserveUnit.getProjectCode());
        paramRptMap.put("tenantCode", estReserveUnit.getTenantCode());
        EstReport estReport = this.estReportService.getReportByCode(paramRptMap);
        if (estReport == null) {
            paramRptMap.put("roleCode", "BK00001");
            EstReport report = this.estReportService.getReportByCode(paramRptMap);
            return report;
        }
        return estReport;
    }

    private EstReserveUnitMember getEstReserveUnitMember(String memberCode, int memberType, String memberPhone) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberCode", memberCode);
        map.put("memberType", memberType);
        map.put("memberPhone", memberPhone);
        QueryResult<EstReserveUnitMember> reserveUnitMemberQueryResult = this.estReserveUnitMemberService.queryReserveUnitMemberPage(map);
        if (reserveUnitMemberQueryResult != null && reserveUnitMemberQueryResult.getRows() != null && reserveUnitMemberQueryResult.getRows().size() > 0) {
            return (EstReserveUnitMember)reserveUnitMemberQueryResult.getRows().get(0);
        }
        return null;
    }

    private EstFlowLinkDomain encapsulationFlowLink(EstReserveUnit estReserveUnit, int flowLinkType) {
        EstFlowLinkDomain estFlowLinkDomain = new EstFlowLinkDomain();
        estFlowLinkDomain.setTenantCode(estReserveUnit.getTenantCode());
        estFlowLinkDomain.setProjectCode(estReserveUnit.getProjectCode());
        estFlowLinkDomain.setReserveUnitCode(estReserveUnit.getReserveUnitCode());
        estFlowLinkDomain.setApprovalStatus(0);
        estFlowLinkDomain.setFlowLinkType(flowLinkType);
        return estFlowLinkDomain;
    }

    @Override
    public void updateReserveUnitState(Integer reserveUnitId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateReserveUnitModel(reserveUnitId, dataState, oldDataState);
    }

    @Override
    public void updateReserveUnit(EstReserveUnitDomain estReserveUnitDomain) throws ApiException {
        String msg = this.checkReserveUnit(estReserveUnitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateReserveUnit.checkReserveUnit", msg);
        }
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("reserveUnitCode", estReserveUnitDomain.getReserveUnitCode());
        parmMap.put("tenantCode", estReserveUnitDomain.getTenantCode());
        EstReserveUnit oldEstReserveUnit = this.getReserveUnitByCode(parmMap);
        if (oldEstReserveUnit == null) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateReserveUnit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        estReserveUnitDomain.setReserveUnitId(oldEstReserveUnit.getReserveUnitId());
        EstReserveUnit estReserveUnit = this.makeReserveUnit(estReserveUnitDomain, oldEstReserveUnit);
        this.setReserveUnitUpdataDefault(estReserveUnit);
        this.updateReserveUnitModel(estReserveUnit);
        if (estReserveUnitDomain.getReserveUnitMembers() != null && estReserveUnitDomain.getReserveUnitMembers().size() > 0) {
            HashMap<String, Object> delMemberMap = new HashMap<String, Object>();
            delMemberMap.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
            delMemberMap.put("tenantCode", estReserveUnitDomain.getTenantCode());
            this.estReserveUnitMemberService.delReserveUnitMemberByCode(delMemberMap);
            for (EstReserveUnitMemberDomain reserveUnitMember : estReserveUnitDomain.getReserveUnitMembers()) {
                reserveUnitMember.setReserveUnitCode(estReserveUnit.getReserveUnitCode());
                this.estReserveUnitMemberService.saveReserveUnitMember(reserveUnitMember);
            }
        }
        if (estReserveUnit.getReserveUnitType().equals(EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType()) && estReserveUnitDomain.getPaymentDetails() != null) {
            try {
                HashMap<String, Object> mapPaymentDetails = new HashMap<String, Object>();
                mapPaymentDetails.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
                mapPaymentDetails.put("tenantCode", oldEstReserveUnit.getTenantCode());
                EstPaymentDetails paymentDetails = this.paymentDetailsService.getPaymentDetailsByCode(mapPaymentDetails);
                if (paymentDetails != null) {
                    EstPaymentDetailsDomain estPaymentDetailsDomain = estReserveUnitDomain.getPaymentDetails();
                    estPaymentDetailsDomain.setPaymentDetailsId(paymentDetails.getPaymentDetailsId());
                    estPaymentDetailsDomain.setPaymentDetailsCode(paymentDetails.getPaymentDetailsCode());
                    estPaymentDetailsDomain.setReserveUnitCode(paymentDetails.getReserveUnitCode());
                    estPaymentDetailsDomain.setTenantCode(paymentDetails.getTenantCode());
                    this.paymentDetailsService.updatePaymentDetails(estPaymentDetailsDomain);
                } else {
                    estReserveUnitDomain.getPaymentDetails().setReserveUnitCode(estReserveUnit.getReserveUnitCode());
                    estReserveUnitDomain.getPaymentDetails().setTenantCode(estReserveUnit.getTenantCode());
                    this.paymentDetailsService.savePaymentDetails(estReserveUnitDomain.getPaymentDetails());
                }
            }
            catch (Exception ex) {
                this.logger.error("updateReserveUnit.savePaymentDetails ex", (Throwable)ex);
            }
        }
    }

    @Override
    public EstReserveUnit getReserveUnit(Integer reserveUnitId) {
        return this.getReserveUnitModelById(reserveUnitId);
    }

    @Override
    public void deleteReserveUnit(Integer reserveUnitId) throws ApiException {
        this.deleteReserveUnitModel(reserveUnitId);
    }

    @Override
    public QueryResult<EstReserveUnit> queryReserveUnitPage(Map<String, Object> map) {
        this.queryCodeByLikeVal(map);
        List<EstReserveUnit> estReserveUnitList = this.queryReserveUnitModelPage(map);
        this.ssignmentaReserveUnitFlowLink(estReserveUnitList);
        this.ssignmentaReserveUnitMember(estReserveUnitList);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countReserveUnit(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReserveUnitList);
        return queryResult;
    }

    private void queryCodeByLikeVal(Map<String, Object> mapRe) {
        String likeVal = (String)mapRe.get("likeVal");
        if (likeVal == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberType", "2");
        map.put("memberPhone", likeVal);
        QueryResult<EstReserveUnitMember> reserveUnitMemberPage = this.estReserveUnitMemberService.queryReserveUnitMemberPage(map);
        if (reserveUnitMemberPage != null && reserveUnitMemberPage.getRows() != null) {
            ArrayList<String> reserveUnitCodes = new ArrayList<String>();
            if (ListUtil.isNotEmpty((Collection)reserveUnitMemberPage.getList())) {
                for (EstReserveUnitMember reserveUnitMember : reserveUnitMemberPage.getList()) {
                    reserveUnitCodes.add(reserveUnitMember.getReserveUnitCode());
                }
                mapRe.put("reserveUnitCodes", reserveUnitCodes);
            } else {
                reserveUnitCodes.add("###########");
                mapRe.put("reserveUnitCodes", reserveUnitCodes);
            }
        }
    }

    private void ssignmentaReserveUnitMember(List<EstReserveUnit> estReserveUnits) {
        if (estReserveUnits == null) {
            return;
        }
        for (EstReserveUnit estReserveUnit : estReserveUnits) {
            this.getEstReserveUnitMember(estReserveUnit);
        }
    }

    private void ssignmentaPaymentDetails(List<EstReserveUnit> estReserveUnits) {
        if (estReserveUnits == null) {
            return;
        }
        for (EstReserveUnit estReserveUnit : estReserveUnits) {
            this.getEstPaymentDetails(estReserveUnit);
        }
    }

    private void getEstPaymentDetails(EstReserveUnit estReserveUnit) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
        map.put("tenantCode", estReserveUnit.getTenantCode());
        EstPaymentDetails estPaymentDetails = this.paymentDetailsService.getPaymentDetailsByCode(map);
        if (estPaymentDetails != null) {
            estReserveUnit.setEstPaymentDetails(estPaymentDetails);
        }
    }

    private void getEstReserveUnitMember(EstReserveUnit estReserveUnit) {
        EstReserveUnitMember estReserveUnitMember;
        if (estReserveUnit == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberType", "2");
        map.put("membership", 0);
        map.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
        QueryResult<EstReserveUnitMember> flowLinkQueryResult = this.estReserveUnitMemberService.queryReserveUnitMemberPage(map);
        if (flowLinkQueryResult != null && flowLinkQueryResult.getRows() != null && flowLinkQueryResult.getRows().size() == 1 && (estReserveUnitMember = (EstReserveUnitMember)flowLinkQueryResult.getRows().get(0)) != null) {
            estReserveUnit.setEstReserveUnitMember(estReserveUnitMember);
        }
    }

    private void ssignmentaReserveUnitFlowLink(List<EstReserveUnit> estReserveUnits) {
        if (estReserveUnits == null) {
            return;
        }
        for (EstReserveUnit estReserveUnit : estReserveUnits) {
            this.getEstFlowLink(estReserveUnit);
            this.getEstFlowLinkLast(estReserveUnit);
        }
    }

    private void getEstFlowLink(EstReserveUnit estReserveUnit) {
        if (estReserveUnit == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
        map.put("flowLinkType", estReserveUnit.getReserveUnitType());
        QueryResult<EstFlowLink> flowLinkQueryResult = this.estFlowLinkService.queryFlowLinkPage(map);
        if (flowLinkQueryResult != null && flowLinkQueryResult.getRows() != null) {
            EstFlowLink estFlowLink;
            if (flowLinkQueryResult.getRows().size() > 0 && (estFlowLink = (EstFlowLink)flowLinkQueryResult.getRows().get(0)) != null) {
                estReserveUnit.setEstFlowLink(estFlowLink);
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
            estReserveUnit.setFlowLinkTotal(Long.valueOf(String.valueOf(this.countFlowLink(param))));
        }
    }

    private int countFlowLink(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estFlowLinkMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.countFlowLink", (Throwable)e);
        }
        return i;
    }

    private void getEstFlowLinkLast(EstReserveUnit estReserveUnit) {
        EstFlowLink estFlowLink;
        if (estReserveUnit == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("reserveUnitCode", estReserveUnit.getReserveUnitCode());
        map.put("order", true);
        QueryResult<EstFlowLink> flowLinkQueryResult = this.estFlowLinkService.queryFlowLinkPage(map);
        if (flowLinkQueryResult != null && flowLinkQueryResult.getRows() != null && flowLinkQueryResult.getRows().size() > 0 && (estFlowLink = (EstFlowLink)flowLinkQueryResult.getRows().get(0)) != null) {
            estReserveUnit.setEstFlowLinkLast(estFlowLink);
        }
    }

    @Override
    public EstReserveUnit getReserveUnitByCode(Map<String, Object> map) {
        EstReserveUnit estReserveUnit = this.getReserveUnitModelByCode(map);
        if (estReserveUnit != null && estReserveUnit.getReserveUnitType().equals(EstateConstants.FlowLinkTypeEnum.DEAL.getFlowLinkType())) {
            this.getEstPaymentDetails(estReserveUnit);
        }
        return estReserveUnit;
    }

    @Override
    public void delReserveUnitByCode(Map<String, Object> map) throws ApiException {
        this.delReserveUnitModelByCode(map);
    }

    @Override
    public Boolean updateReserveUnitNew(EstReserveUnitDomain estReserveUnitDomain) throws ApiException {
        String msg = this.checkReserveUnit(estReserveUnitDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateReserveUnitContractNo.checkReserveUnit", msg);
        }
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("reserveUnitCode", estReserveUnitDomain.getReserveUnitCode());
        parmMap.put("tenantCode", estReserveUnitDomain.getTenantCode());
        EstReserveUnit oldEstReserveUnit = this.getReserveUnitByCode(parmMap);
        if (oldEstReserveUnit == null) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateReserveUnit.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        estReserveUnitDomain.setReserveUnitId(oldEstReserveUnit.getReserveUnitId());
        try {
            BeanUtils.copyAllPropertysNotNull((Object)oldEstReserveUnit, (Object)estReserveUnitDomain);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setReserveUnitUpdataDefault(oldEstReserveUnit);
        int index = this.updateReserveUnitModel(oldEstReserveUnit);
        if (index < 1) {
            return false;
        }
        return true;
    }

    @Override
    public List<Map<String, Object>> queryStatisticalSellTrans(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        return this.statisticalSellTransModel(map);
    }

    @Override
    public List<Map<String, Object>> queryStatisticalSellPayment(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        return this.statisticalSellPaymentModel(map);
    }

    private Integer getFlowLinkAndRptCountModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReserveUnitMapper.getQueryByFlowLinkAndRptCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.getFlowLinkAndRptCountModel", (Throwable)e);
        }
        return i;
    }

    @Override
    public Integer getFlowLinkAndRptCount(Map<String, Object> map) {
        return this.getFlowLinkAndRptCountModel(map);
    }

    PageInfo<EstReserveUnit> queryOverdueNotSignedByAuditModel(Map<String, Object> parammap) {
        try {
            this.startPage(parammap);
            List<EstReserveUnit> estReserveUnitList = this.estReserveUnitMapper.queryOverdueNotSignedByAudit(parammap);
            return this.getPageInfo(estReserveUnitList);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.queryOverdueNotSignedByAuditModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<EstReserveUnit> queryOverdueNotSignedPage(Map<String, Object> map) {
        PageInfo<EstReserveUnit> estReserveUnitPageInfo = this.queryOverdueNotSignedByAuditModel(map);
        this.ssignmentaReserveUnitFlowLink(estReserveUnitPageInfo.getList());
        this.ssignmentaReserveUnitMember(estReserveUnitPageInfo.getList());
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(Integer.parseInt(String.valueOf(estReserveUnitPageInfo.getTotal())));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estReserveUnitPageInfo.getList());
        return queryResult;
    }

    private int getQueryOverdueNotSignedCount(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReserveUnitMapper.getQueryOverdueNotSignedCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.getQueryOverdueNotSignedCount", (Throwable)e);
        }
        return i;
    }

    private List<Map<String, Object>> statisticalSellTransModel(Map<String, Object> map) throws ApiException {
        try {
            return this.estReserveUnitMapper.statisticalSellTrans(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.statisticalSellTransModel", (Throwable)e);
            return null;
        }
    }

    private List<Map<String, Object>> statisticalSellPaymentModel(Map<String, Object> map) throws ApiException {
        try {
            return this.estReserveUnitMapper.statisticalSellPayment(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.statisticalSellPaymentModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<Map<String, Object>> querySelledDetails(Map<String, Object> map) throws ApiException {
        List reserveUnitCodes;
        if (map == null) {
            return null;
        }
        QueryResult<String> supResult = this.estFlowLinkService.queryNotBackHouseUnitCode(map);
        if (supResult != null && ListUtil.isNotEmpty((Collection)(reserveUnitCodes = supResult.getList()))) {
            int countSelledDetails = this.countSelledDetailsModel(map);
            List<Map<String, Object>> estFlowLinkList = this.querySelledDetailsModel(map);
            QueryResult queryResult = new QueryResult();
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(countSelledDetails);
            queryResult.setPageTools((SupPageTools)pageTools);
            queryResult.setList(estFlowLinkList);
            return queryResult;
        }
        return null;
    }

    private List<Map<String, Object>> querySelledDetailsModel(Map<String, Object> map) throws ApiException {
        try {
            return this.estReserveUnitMapper.querySelledDetails(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.querySelledDetailsModel", (Throwable)e);
            return null;
        }
    }

    private int countSelledDetailsModel(Map<String, Object> map) throws ApiException {
        try {
            return this.estReserveUnitMapper.countSelledDetails(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.countSelledDetailsModel", (Throwable)e);
            return 0;
        }
    }

    private void updateReserveUnitByReportModel(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.estReserveUnitMapper.updateByReport(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateReserveUnitByReportModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstReserveUnitServiceImpl.updateReserveUnitByReportModel.null");
        }
    }

    @Override
    public void updateReserveUnitByReport(Map<String, Object> map) {
        String reportCode = (String)map.get("reportCode");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("page", 1);
        param.put("size", 10);
        param.put("reportCode", reportCode);
        List<EstReserveUnit> reserveUnitList = this.queryReserveUnitModelPage(param);
        if (reserveUnitList != null && reserveUnitList.size() > 0) {
            this.updateReserveUnitByReportModel(map);
        }
    }

    private List<EstReserveUnit> queryByFlowLinkModel(Map<String, Object> map) throws ApiException {
        try {
            return this.estReserveUnitMapper.queryByFlowLink(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.queryByFlowLinkModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<EstReserveUnit> queryByFlowLink(Map<String, Object> map) {
        return this.queryByFlowLinkModel(map);
    }

    @Override
    public Integer getCustomerByoundDate(Map<String, Object> map) throws ApiException {
        EstPaymentDetails paymentDetails;
        Integer beyond;
        EstReserveUnit reserveUnit;
        Integer result = -1;
        if (MapUtil.isEmpty(map)) {
            return result;
        }
        String code = (String)map.get("code");
        String userCode = (String)map.get("acceptCode");
        String tenantCode = (String)map.get("tenantCode");
        String reserveUnitCode = (String)map.get("reserveUnitCode");
        String overdueType = (String)map.get("overdueType");
        if (StringUtils.isBlankLoop((String[])new String[]{code, userCode, tenantCode, overdueType})) {
            return result;
        }
        map.clear();
        map.put("tenantCode", tenantCode);
        map.put("reserveUnitCode", reserveUnitCode);
        if ("1".equals(overdueType) ? (reserveUnit = this.getReserveUnitByCode(map)) != null && reserveUnit.getSigningDate() != null : ("2".equals(overdueType) ? (beyond = this.queryByReserveUnitCodeModel(map)) == null || beyond == 0 : "3".equals(overdueType) && (paymentDetails = this.paymentDetailsService.getPaymentDetailsByReserveUnitCode(map)) != null && paymentDetails.getAcceptHandleState() != null && !"10".equals(paymentDetails.getAcceptHandleState()))) {
            return 0;
        }
        return 1;
    }

    private Integer queryByReserveUnitCodeModel(Map<String, Object> map) {
        try {
            return this.estReserveUnitMapper.queryByReserveUnitCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.queryByReserveUnitCodeModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> queryFstatisticalAll(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<Map<String, Object>> fstatisticalAll = this.queryFstatisticalAllModel(map);
        return fstatisticalAll;
    }

    private List<Map<String, Object>> queryFstatisticalAllModel(Map<String, Object> map) throws ApiException {
        try {
            return this.estReserveUnitMapper.queryFstatisticalAll(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.queryFstatisticalAllModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> queryTotalLoanAmount(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<Map<String, Object>> totalLoanAmount = this.queryTotalLoanAmountModel(map);
        return totalLoanAmount;
    }

    @Override
    public int getCountReserveUnit(Map<String, Object> map) {
        return this.countReserveUnit(map);
    }

    private List<Map<String, Object>> queryTotalLoanAmountModel(Map<String, Object> map) throws ApiException {
        try {
            return this.estReserveUnitMapper.queryTotalLoanAmount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.queryTotalLoanAmountModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<EstReserveUnit> queryOrderByHouseCode(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<EstReserveUnit> orderList = this.queryOrderByHouseCodeModel(map);
        this.ssignmentaReserveUnitFlowLink(orderList);
        this.ssignmentaReserveUnitMember(orderList);
        return orderList;
    }

    public List<EstReserveUnit> queryOrderByHouseCodeModel(Map<String, Object> map) throws ApiException {
        try {
            return this.estReserveUnitMapper.queryOrderByHouseCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstReserveUnitServiceImpl.queryOrderByHouseCodeModel", (Throwable)e);
            return null;
        }
    }
}

