/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstRuleQueueMapper;
import com.yqbsoft.laser.service.estate.domain.EstRuleQueueDomain;
import com.yqbsoft.laser.service.estate.model.EstRuleQueue;
import com.yqbsoft.laser.service.estate.service.EstRuleQueueService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EstRuleQueueServiceImpl
extends BaseServiceImpl
implements EstRuleQueueService {
    private static final String SYS_CODE = "estate.EstRuleQueueServiceImpl";
    private EstRuleQueueMapper estRuleQueueMapper;

    public void setEstRuleQueueMapper(EstRuleQueueMapper estRuleQueueMapper) {
        this.estRuleQueueMapper = estRuleQueueMapper;
    }

    private Date getSysDate() {
        try {
            return this.estRuleQueueMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleQueueServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRuleQueue(EstRuleQueueDomain estRuleQueueDomain) {
        if (estRuleQueueDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setRuleQueueDefault(EstRuleQueue estRuleQueue) {
        if (estRuleQueue == null) {
            return;
        }
        if (estRuleQueue.getDataState() == null) {
            estRuleQueue.setDataState(0);
        }
        if (estRuleQueue.getGmtCreate() == null) {
            estRuleQueue.setGmtCreate(this.getSysDate());
        }
        estRuleQueue.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estRuleQueue.getRuleQueueCode())) {
            estRuleQueue.setRuleQueueCode(this.createUUIDString());
        }
    }

    private int getRuleQueueMaxCode() {
        int code = 0;
        try {
            return this.estRuleQueueMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleQueueServiceImpl.getRuleQueueMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRuleQueueUpdataDefault(EstRuleQueue estRuleQueue) {
        if (estRuleQueue == null) {
            return;
        }
        estRuleQueue.setGmtModified(this.getSysDate());
    }

    private void saveRuleQueueModel(EstRuleQueue estRuleQueue) throws ApiException {
        if (estRuleQueue == null) {
            return;
        }
        try {
            this.estRuleQueueMapper.insert(estRuleQueue);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.saveRuleQueueModel.ex", (Throwable)e);
        }
    }

    private EstRuleQueue getRuleQueueModelById(Integer ruleQueueId) {
        if (ruleQueueId == null) {
            return null;
        }
        try {
            return this.estRuleQueueMapper.selectByPrimaryKey(ruleQueueId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleQueueServiceImpl.getRuleQueueModelById", (Throwable)e);
            return null;
        }
    }

    public EstRuleQueue getRuleQueueModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estRuleQueueMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleQueueServiceImpl.getRuleQueueModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRuleQueueModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estRuleQueueMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.delRuleQueueModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.delRuleQueueModelByCode.num");
        }
    }

    private void deleteRuleQueueModel(Integer ruleQueueId) throws ApiException {
        if (ruleQueueId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estRuleQueueMapper.deleteByPrimaryKey(ruleQueueId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.deleteRuleQueueModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.deleteRuleQueueModel.num");
        }
    }

    private void updateRuleQueueModel(EstRuleQueue estRuleQueue) throws ApiException {
        if (estRuleQueue == null) {
            return;
        }
        try {
            this.estRuleQueueMapper.updateByPrimaryKeySelective(estRuleQueue);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.updateRuleQueueModel.ex", (Throwable)e);
        }
    }

    private void updateStateRuleQueueModel(Integer ruleQueueId, Integer dataState, Integer oldDataState) throws ApiException {
        if (ruleQueueId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleQueueId", ruleQueueId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estRuleQueueMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.updateStateRuleQueueModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.updateStateRuleQueueModel.null");
        }
    }

    private EstRuleQueue makeRuleQueue(EstRuleQueueDomain estRuleQueueDomain, EstRuleQueue estRuleQueue) {
        if (estRuleQueueDomain == null) {
            return null;
        }
        if (estRuleQueue == null) {
            estRuleQueue = new EstRuleQueue();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estRuleQueue, (Object)estRuleQueueDomain);
            return estRuleQueue;
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleQueueServiceImpl.makeRuleQueue", (Throwable)e);
            return null;
        }
    }

    private List<EstRuleQueue> queryRuleQueueModelPage(Map<String, Object> parammap) {
        try {
            return this.estRuleQueueMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleQueueServiceImpl.queryRuleQueueModel", (Throwable)e);
            return null;
        }
    }

    private int countRuleQueue(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estRuleQueueMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleQueueServiceImpl.countRuleQueue", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveRuleQueue(EstRuleQueueDomain estRuleQueueDomain) throws ApiException {
        String msg = this.checkRuleQueue(estRuleQueueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.saveRuleQueue.checkRuleQueue", msg);
        }
        EstRuleQueue estRuleQueue = this.makeRuleQueue(estRuleQueueDomain, null);
        this.setRuleQueueDefault(estRuleQueue);
        this.saveRuleQueueModel(estRuleQueue);
        return estRuleQueue.getRuleQueueCode();
    }

    @Override
    public void updateRuleQueueState(Integer ruleQueueId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRuleQueueModel(ruleQueueId, dataState, oldDataState);
    }

    @Override
    public void updateRuleQueue(EstRuleQueueDomain estRuleQueueDomain) throws ApiException {
        String msg = this.checkRuleQueue(estRuleQueueDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.updateRuleQueue.checkRuleQueue", msg);
        }
        EstRuleQueue oldEstRuleQueue = this.getRuleQueueModelById(estRuleQueueDomain.getRuleQueueId());
        if (oldEstRuleQueue == null) {
            throw new ApiException("estate.EstRuleQueueServiceImpl.updateRuleQueue.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstRuleQueue estRuleQueue = this.makeRuleQueue(estRuleQueueDomain, oldEstRuleQueue);
        this.setRuleQueueUpdataDefault(estRuleQueue);
        this.updateRuleQueueModel(estRuleQueue);
    }

    @Override
    public EstRuleQueue getRuleQueue(Integer ruleQueueId) {
        return this.getRuleQueueModelById(ruleQueueId);
    }

    @Override
    public void deleteRuleQueue(Integer ruleQueueId) throws ApiException {
        this.deleteRuleQueueModel(ruleQueueId);
    }

    @Override
    public QueryResult<EstRuleQueue> queryRuleQueuePage(Map<String, Object> map) {
        List<EstRuleQueue> estRuleQueueList = this.queryRuleQueueModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRuleQueue(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estRuleQueueList);
        return queryResult;
    }

    @Override
    public EstRuleQueue getRuleQueueByCode(Map<String, Object> map) {
        return this.getRuleQueueModelByCode(map);
    }

    @Override
    public void delRuleQueueByCode(Map<String, Object> map) throws ApiException {
        this.delRuleQueueModelByCode(map);
    }
}

