/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.dd.DdEntity;
import com.yqbsoft.laser.service.esb.core.dd.DdTransUtil;
import com.yqbsoft.laser.service.esb.core.flow.SoaUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstRuleMapper;
import com.yqbsoft.laser.service.estate.domain.EstIntentionDomain;
import com.yqbsoft.laser.service.estate.domain.EstReportDomain;
import com.yqbsoft.laser.service.estate.domain.EstRuleDomain;
import com.yqbsoft.laser.service.estate.domain.EstRuleQueueDomain;
import com.yqbsoft.laser.service.estate.domain.EstStateDomain;
import com.yqbsoft.laser.service.estate.model.EstIntention;
import com.yqbsoft.laser.service.estate.model.EstReport;
import com.yqbsoft.laser.service.estate.model.EstRule;
import com.yqbsoft.laser.service.estate.model.EstRuleQueue;
import com.yqbsoft.laser.service.estate.service.EstIntentionService;
import com.yqbsoft.laser.service.estate.service.EstReportService;
import com.yqbsoft.laser.service.estate.service.EstRuleQueueService;
import com.yqbsoft.laser.service.estate.service.EstRuleService;
import com.yqbsoft.laser.service.estate.service.EstStateService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class EstRuleServiceImpl
extends BaseServiceImpl
implements EstRuleService {
    private static final String SYS_CODE = "estate.EstRuleServiceImpl";
    private EstRuleMapper estRuleMapper;
    private EstReportService estReportService;
    private EstRuleQueueService estRuleQueueService;
    private EstStateService estStateService;
    private EstIntentionService estIntentionService;

    public void setEstRuleQueueService(EstRuleQueueService estRuleQueueService) {
        this.estRuleQueueService = estRuleQueueService;
    }

    public void setEstReportService(EstReportService estReportService) {
        this.estReportService = estReportService;
    }

    public void setEstRuleMapper(EstRuleMapper estRuleMapper) {
        this.estRuleMapper = estRuleMapper;
    }

    public void setEstStateService(EstStateService estStateService) {
        this.estStateService = estStateService;
    }

    public void setEstIntentionService(EstIntentionService estIntentionService) {
        this.estIntentionService = estIntentionService;
    }

    private Date getSysDate() {
        try {
            return this.estRuleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRule(EstRuleDomain estRuleDomain) {
        if (estRuleDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setRuleDefault(EstRule estRule) {
        if (estRule == null) {
            return;
        }
        if (estRule.getDataState() == null) {
            estRule.setDataState(0);
        }
        if (estRule.getGmtCreate() == null) {
            estRule.setGmtCreate(this.getSysDate());
        }
        estRule.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estRule.getRuleCode())) {
            estRule.setRuleCode(this.createUUIDString());
        }
    }

    private int getRuleMaxCode() {
        int code = 0;
        try {
            return this.estRuleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.getRuleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRuleUpdataDefault(EstRule estRule) {
        if (estRule == null) {
            return;
        }
        estRule.setGmtModified(this.getSysDate());
    }

    private void saveRuleModel(EstRule estRule) throws ApiException {
        if (estRule == null) {
            return;
        }
        try {
            this.estRuleMapper.insert(estRule);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleServiceImpl.saveRuleModel.ex", (Throwable)e);
        }
    }

    private EstRule getRuleModelById(Integer ruleId) {
        if (ruleId == null) {
            return null;
        }
        try {
            return this.estRuleMapper.selectByPrimaryKey(ruleId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.getRuleModelById", (Throwable)e);
            return null;
        }
    }

    public EstRule getRuleModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estRuleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.getRuleModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRuleModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estRuleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleServiceImpl.delRuleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstRuleServiceImpl.delRuleModelByCode.num");
        }
    }

    private void deleteRuleModel(Integer ruleId) throws ApiException {
        if (ruleId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estRuleMapper.deleteByPrimaryKey(ruleId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleServiceImpl.deleteRuleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstRuleServiceImpl.deleteRuleModel.num");
        }
    }

    private void updateRuleModel(EstRule estRule) throws ApiException {
        if (estRule == null) {
            return;
        }
        try {
            this.estRuleMapper.updateByPrimaryKeySelective(estRule);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleServiceImpl.updateRuleModel.ex", (Throwable)e);
        }
    }

    private void updateStateRuleModel(Integer ruleId, Integer dataState, Integer oldDataState) throws ApiException {
        if (ruleId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleId", ruleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estRuleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstRuleServiceImpl.updateStateRuleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstRuleServiceImpl.updateStateRuleModel.null");
        }
    }

    private EstRule makeRule(EstRuleDomain estRuleDomain, EstRule estRule) {
        if (estRuleDomain == null) {
            return null;
        }
        if (estRule == null) {
            estRule = new EstRule();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estRule, (Object)estRuleDomain);
            return estRule;
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.makeRule", (Throwable)e);
            return null;
        }
    }

    private List<EstRule> queryRuleModelPage(Map<String, Object> parammap) {
        try {
            return this.estRuleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.queryRuleModel", (Throwable)e);
            return null;
        }
    }

    private int countRule(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estRuleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.countRule", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveRule(EstRuleDomain estRuleDomain) throws ApiException {
        String msg = this.checkRule(estRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstRuleServiceImpl.saveRule.checkRule", msg);
        }
        EstRule estRule = this.makeRule(estRuleDomain, null);
        this.setRuleDefault(estRule);
        this.saveRuleModel(estRule);
        return estRule.getRuleCode();
    }

    @Override
    public void updateRuleState(Integer ruleId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRuleModel(ruleId, dataState, oldDataState);
    }

    @Override
    public void updateRule(EstRuleDomain estRuleDomain) throws ApiException {
        String msg = this.checkRule(estRuleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstRuleServiceImpl.updateRule.checkRule", msg);
        }
        EstRule oldEstRule = this.getRuleModelById(estRuleDomain.getRuleId());
        if (oldEstRule == null) {
            throw new ApiException("estate.EstRuleServiceImpl.updateRule.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstRule estRule = this.makeRule(estRuleDomain, oldEstRule);
        this.setRuleUpdataDefault(estRule);
        this.updateRuleModel(estRule);
    }

    @Override
    public EstRule getRule(Integer ruleId) {
        return this.getRuleModelById(ruleId);
    }

    @Override
    public void deleteRule(Integer ruleId) throws ApiException {
        this.deleteRuleModel(ruleId);
    }

    @Override
    public QueryResult<EstRule> queryRulePage(Map<String, Object> map) {
        List<EstRule> estRuleList = this.queryRuleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRule(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estRuleList);
        return queryResult;
    }

    @Override
    public EstRule getRuleByCode(Map<String, Object> map) {
        return this.getRuleModelByCode(map);
    }

    @Override
    public void delRuleByCode(Map<String, Object> map) throws ApiException {
        this.delRuleModelByCode(map);
    }

    @Override
    public void autoReportByRule() {
        List<EstRule> estRuleList = this.queryRuleModelPage(this.getQueryParamMap("dataState", new Object[]{1}));
        if (ListUtil.isEmpty(estRuleList)) {
            return;
        }
        for (EstRule estRule : estRuleList) {
            if (!this.filterDate(estRule)) continue;
            String ruleQueueDate = DateUtil.getDateString((Date)this.getSysDate(), (String)"yyyyMMdd");
            QueryResult<EstRuleQueue> qresult = this.estRuleQueueService.queryRuleQueuePage(this.getQueryParamMap("tenantCode,ruleCode,ruleQueueDate", new Object[]{estRule.getTenantCode(), estRule.getRuleCode(), ruleQueueDate}));
            EstRuleQueue ruleQueue = this.makeRuleQueue(qresult, estRule, ruleQueueDate);
            if (ruleQueue == null) {
                this.logger.error("estate.EstRuleServiceImpl.autoReportByRule.ruleQueue.null", (Object)"\u89c4\u5219\u961f\u5217\u4e3a\u7a7a");
                continue;
            }
            List reportUserList = (List)JsonUtil.buildNormalBinder().getJsonToList(ruleQueue.getRuleQueueOcontent(), HashMap.class);
            if (ListUtil.isEmpty((Collection)reportUserList)) continue;
            LinkedBlockingQueue<Map<String, Object>> reportUserQueue = new LinkedBlockingQueue<Map<String, Object>>();
            for (Map map : reportUserList) {
                reportUserQueue.add(map);
            }
            QueryResult<EstReport> reportResult = this.estReportService.queryReportListByAssigning(this.getQueryParamMap("roleCode,reRoleCode,projectCode,tenantCode,gmtCreate", new Object[]{estRule.getReportTypeQuery(), estRule.getReportType(), estRule.getProjectCode(), estRule.getTenantCode(), DateUtil.getDateString((Date)this.getSysDate(), (String)"yyyy-MM-dd")}));
            if (!ListUtil.isNotEmpty((Collection)qresult.getList()) || !ListUtil.isNotEmpty((Collection)reportResult.getList())) continue;
            for (EstReport estReport : reportResult.getList()) {
                Map user = (Map)reportUserQueue.poll();
                if (this.checkReportState(estReport, estRule)) continue;
                this.setReportInfo(estReport, user, estRule);
                this.saveReportCustomers(estReport);
                reportUserQueue.add(user);
            }
            this.updateRuleQueue(ruleQueue, reportUserQueue);
        }
    }

    private void setReportInfo(EstReport estReport, Map<String, Object> user, EstRule estRule) {
        estReport.setReportId(null);
        estReport.setReportCode(null);
        estReport.setUserCode(String.valueOf(user.get("userCode")));
        estReport.setRoleCode(estRule.getReportType());
        estReport.setReportUname(String.valueOf(user.get("userRelname")));
        estReport.setReportUphone(String.valueOf(user.get("userPhone")));
        estReport.setReportDate(new Date());
        this.setReportEdate(estReport);
    }

    @Override
    public void saveReportCustomers(EstReport estReport) {
        if (estReport == null) {
            return;
        }
        try {
            EstReportDomain estReportDomain = new EstReportDomain();
            BeanUtils.copyAllPropertys((Object)estReportDomain, (Object)estReport);
            this.estReportService.saveReport(estReportDomain);
            this.updateIntention(estReport.getMemberCode(), estReport.getProjectCode(), "2", estReport.getTenantCode());
            this.saveState(estReport.getMemberCode(), estReport.getProjectCode(), "\u5206\u914d\u5ba2\u6237", estReport.getUserCode(), "\u7cfb\u7edf", 2, estReport.getTenantCode());
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.makeReport", (Throwable)e);
        }
    }

    private void setReportEdate(EstReport estReport) {
        estReport.setReportEdate(new Date());
        List ddEntities = DdTransUtil.getDdList((String)"EstReport-roleCode");
        if (ddEntities == null) {
            return;
        }
        HashMap<String, String> ddICListMap = new HashMap<String, String>();
        for (DdEntity dd : ddEntities) {
            ddICListMap.put(dd.getDdCode(), dd.getDdValue());
        }
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(estReport.getReportEdate());
        rightNow.add(5, Integer.parseInt((String)ddICListMap.get(estReport.getRoleCode())));
        estReport.setReportEdate(rightNow.getTime());
    }

    void saveState(String memberCode, String projectCode, String content, String userCode, String userName, Integer stateType, String tenantCode) {
        try {
            EstStateDomain estStateDomain = new EstStateDomain();
            estStateDomain.setProjectCode(projectCode);
            estStateDomain.setMemberCode(memberCode);
            estStateDomain.setStateContent(content);
            estStateDomain.setUserCode(userCode);
            estStateDomain.setUserName(userName);
            if (estStateDomain == null) {
                estStateDomain.setStateType(1);
            } else {
                estStateDomain.setStateType(stateType);
            }
            estStateDomain.setTenantCode(tenantCode);
            this.estStateService.saveState(estStateDomain);
        }
        catch (Exception ex) {
            this.logger.error(SYS_CODE, (Object)"method sysSaveState.", (Throwable)ex);
        }
    }

    public void updateIntention(String memberCode, String projectCode, String state, String tenantCode) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("memberCode", memberCode);
            map.put("projectCode", projectCode);
            map.put("tenantCode", tenantCode);
            EstIntention estIntention = this.estIntentionService.getIntentionByCode(map);
            if (estIntention == null) {
                return;
            }
            estIntention.setIntentionContent(state);
            this.estIntentionService.updateIntention(this.makeIntention(null, estIntention));
        }
        catch (Exception ex) {
            this.logger.error(SYS_CODE, (Object)"method updateIntention.", (Throwable)ex);
        }
    }

    private EstIntentionDomain makeIntention(EstIntentionDomain estIntentionDomain, EstIntention estIntention) {
        if (estIntention == null) {
            return null;
        }
        if (estIntentionDomain == null) {
            estIntentionDomain = new EstIntentionDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estIntentionDomain, (Object)estIntention);
            return estIntentionDomain;
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.makeIntention", (Throwable)e);
            return null;
        }
    }

    private void updateRuleQueue(EstRuleQueue ruleQueue, Queue<Map<String, Object>> reportUserQueue) {
        if (reportUserQueue == null) {
            return;
        }
        EstRuleQueueDomain estRuleQueueDomain = new EstRuleQueueDomain();
        LinkedList<Map> reportUserList = new LinkedList<Map>();
        Iterator iterator = reportUserQueue.iterator();
        while (iterator.hasNext()) {
            reportUserList.add((Map)iterator.next());
        }
        try {
            BeanUtils.copyAllPropertys((Object)estRuleQueueDomain, (Object)ruleQueue);
            estRuleQueueDomain.setRuleQueueOcontent(JsonUtil.buildNormalBinder().toJson(reportUserList));
            this.estRuleQueueService.updateRuleQueue(estRuleQueueDomain);
        }
        catch (Exception e) {
            this.logger.error("estate.EstRuleServiceImpl.updateRuleQueue.ex", (Object)estRuleQueueDomain.getRuleQueueOcontent());
        }
    }

    private boolean checkReportState(EstReport estReport, EstRule estRule) {
        boolean flag = false;
        if (!estReport.getDataState().equals(1)) {
            flag = true;
        }
        return flag;
    }

    private EstRuleQueue makeRuleQueue(QueryResult<EstRuleQueue> qresult, EstRule estRule, String ruleQueueDate) {
        EstRuleQueue ruleQueue = null;
        HashMap<String, EstRule> makeMap = new HashMap<String, EstRule>();
        makeMap.put(EstRule.class.getSimpleName(), estRule);
        if (qresult == null || ListUtil.isEmpty((Collection)qresult.getList())) {
            try {
                String jsonStr;
                String jsonParam = SoaUtil.makeParam((String)estRule.getDataCallparam(), (String)estRule.getDataCom(), makeMap);
                Map paramMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(jsonParam, String.class, Object.class);
                SoaUtil.transferParam((Map)paramMap);
                String onJsonStr = jsonStr = this.internalInvoke(estRule.getDataCallurl(), paramMap);
                EstRuleQueueDomain estRuleQueueDomain = new EstRuleQueueDomain();
                estRuleQueueDomain.setTenantCode(estRule.getTenantCode());
                estRuleQueueDomain.setRuleCode(estRule.getRuleCode());
                estRuleQueueDomain.setRuleQueueDate(ruleQueueDate);
                Calendar date = Calendar.getInstance();
                date.setTime(this.getSysDate());
                date.set(5, date.get(5) - 1);
                String lastQueueDate = DateUtil.getDateString((Date)date.getTime(), (String)"yyyyMMdd");
                QueryResult<EstRuleQueue> lastQresult = this.estRuleQueueService.queryRuleQueuePage(this.getQueryParamMap("tenantCode,ruleCode,ruleQueueDate", new Object[]{estRule.getTenantCode(), estRule.getRuleCode(), lastQueueDate}));
                LinkedBlockingQueue<Map> reportUserQueue = new LinkedBlockingQueue<Map>();
                if (lastQresult != null && ListUtil.isNotEmpty((Collection)lastQresult.getList())) {
                    EstRuleQueue lastRuleQueue = (EstRuleQueue)lastQresult.getList().get(0);
                    List lastReportUserList = (List)JsonUtil.buildNormalBinder().getJsonToList(lastRuleQueue.getRuleQueueOcontent(), HashMap.class);
                    List reportUserList = (List)JsonUtil.buildNormalBinder().getJsonToList(jsonStr, HashMap.class);
                    for (Map map : reportUserList) {
                        reportUserQueue.add(map);
                    }
                    Map objMap = null;
                    if (ListUtil.isNotEmpty((Collection)lastReportUserList)) {
                        objMap = (Map)lastReportUserList.get(0);
                    }
                    if (MapUtil.isNotEmpty(objMap)) {
                        for (Map userQueue : reportUserList) {
                            Map user = (Map)reportUserQueue.peek();
                            if (user == null || userQueue.get("userId").equals(objMap.get("userId"))) break;
                            reportUserQueue.remove();
                            reportUserQueue.add(user);
                        }
                    }
                    if (ListUtil.isNotEmpty(reportUserQueue)) {
                        onJsonStr = JsonUtil.buildNormalBinder().toJson(reportUserQueue);
                    }
                }
                estRuleQueueDomain.setRuleQueueContent(jsonStr);
                estRuleQueueDomain.setRuleQueueOcontent(onJsonStr);
                String ruleQueueCode = this.estRuleQueueService.saveRuleQueue(estRuleQueueDomain);
                ruleQueue = this.estRuleQueueService.getRuleQueueByCode(this.getQueryParamMap("tenantCode,ruleQueueCode", new Object[]{estRule.getTenantCode(), ruleQueueCode}));
                ArrayList<EstRuleQueue> queueList = new ArrayList<EstRuleQueue>();
                queueList.add(ruleQueue);
                qresult.setList(queueList);
            }
            catch (Exception e) {
                this.logger.error("estate.EstRuleServiceImpl.makeRuleQueue.ex", (Object)e.getMessage());
                return null;
            }
        } else {
            ruleQueue = (EstRuleQueue)qresult.getList().get(0);
        }
        return ruleQueue;
    }

    private boolean filterDate(EstRule estRule) {
        String sdate = estRule.getRuleSdate();
        String edate = estRule.getRuleEdate();
        if (StringUtils.isBlank((String)sdate) || StringUtils.isBlank((String)edate)) {
            return false;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.getSysDate());
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            int shour = Integer.valueOf(sdate.substring(0, 2));
            int sminute = Integer.valueOf(sdate.substring(2, 4));
            int ssecond = Integer.valueOf(sdate.substring(4));
            int ehour = Integer.valueOf(edate.substring(0, 2));
            int eminute = Integer.valueOf(edate.substring(2, 4));
            int esecond = Integer.valueOf(edate.substring(4));
            if (shour >= hour && sminute >= minute && ssecond >= second && ehour < hour && eminute < minute && ssecond < esecond) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

