/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.dao.EstReportMapper;
import com.yqbsoft.laser.service.estate.dao.EstStateMapper;
import com.yqbsoft.laser.service.estate.domain.EstStateDomain;
import com.yqbsoft.laser.service.estate.model.EstReport;
import com.yqbsoft.laser.service.estate.model.EstState;
import com.yqbsoft.laser.service.estate.model.UserBean;
import com.yqbsoft.laser.service.estate.service.EstFollowService;
import com.yqbsoft.laser.service.estate.service.EstStateService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class EstStateServiceImpl
extends BaseServiceImpl
implements EstStateService {
    public static final String SYS_CODE = "estate.EstStateServiceImpl";
    private EstStateMapper estStateMapper;
    @Autowired
    private EstFollowService estFollowService;
    @Autowired
    private EstReportMapper estReportMapper;

    public void setEstStateMapper(EstStateMapper estStateMapper) {
        this.estStateMapper = estStateMapper;
    }

    private Date getSysDate() {
        try {
            return this.estStateMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstStateServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkState(EstStateDomain estStateDomain) {
        if (estStateDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)estStateDomain.getMemberCode())) {
            msg = String.valueOf(msg) + "memberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)estStateDomain.getProjectCode())) {
            msg = String.valueOf(msg) + "projectCode\u4e3a\u7a7a;";
        }
        if (estStateDomain.getStateType() <= 0) {
            msg = String.valueOf(msg) + "stateType\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setStateDefault(EstState estState) {
        if (estState == null) {
            return;
        }
        if (estState.getDataState() == null) {
            estState.setDataState(0);
        }
        if (estState.getGmtCreate() == null) {
            estState.setGmtCreate(this.getSysDate());
        }
        estState.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estState.getStateCode())) {
            estState.setStateCode(this.createUUIDString());
        }
    }

    private int getStateMaxCode() {
        int code = 0;
        try {
            return this.estStateMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstStateServiceImpl.getStateMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStateUpdataDefault(EstState estState) {
        if (estState == null) {
            return;
        }
        estState.setGmtModified(this.getSysDate());
    }

    private void saveStateModel(EstState estState) throws ApiException {
        if (estState == null) {
            return;
        }
        try {
            this.estStateMapper.insert(estState);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStateServiceImpl.saveStateModel.ex", (Throwable)e);
        }
    }

    private EstState getStateModelById(Integer stateId) {
        if (stateId == null) {
            return null;
        }
        try {
            return this.estStateMapper.selectByPrimaryKey(stateId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStateServiceImpl.getStateModelById", (Throwable)e);
            return null;
        }
    }

    public EstState getStateModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estStateMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStateServiceImpl.getStateModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStateModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estStateMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStateServiceImpl.delStateModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstStateServiceImpl.delStateModelByCode.num");
        }
    }

    private void deleteStateModel(Integer stateId) throws ApiException {
        if (stateId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estStateMapper.deleteByPrimaryKey(stateId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStateServiceImpl.deleteStateModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstStateServiceImpl.deleteStateModel.num");
        }
    }

    private void updateStateModel(EstState estState) throws ApiException {
        if (estState == null) {
            return;
        }
        try {
            this.estStateMapper.updateByPrimaryKeySelective(estState);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStateServiceImpl.updateStateModel.ex", (Throwable)e);
        }
    }

    private void updateStateStateModel(Integer stateId, Integer dataState, Integer oldDataState) throws ApiException {
        if (stateId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stateId", stateId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estStateMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStateServiceImpl.updateStateStateModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstStateServiceImpl.updateStateStateModel.null");
        }
    }

    private EstState makeState(EstStateDomain estStateDomain, EstState estState) {
        if (estStateDomain == null) {
            return null;
        }
        if (estState == null) {
            estState = new EstState();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estState, (Object)estStateDomain);
            return estState;
        }
        catch (Exception e) {
            this.logger.error("estate.EstStateServiceImpl.makeState", (Throwable)e);
            return null;
        }
    }

    private List<EstState> queryStateModelPage(Map<String, Object> parammap) {
        try {
            return this.estStateMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStateServiceImpl.queryStateModel", (Throwable)e);
            return null;
        }
    }

    private int countState(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estStateMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStateServiceImpl.countState", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveState(EstStateDomain estStateDomain) throws ApiException {
        String msg = this.checkState(estStateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstStateServiceImpl.saveState.checkState", msg);
        }
        EstState estState = this.makeState(estStateDomain, null);
        this.setStateDefault(estState);
        this.saveStateModel(estState);
    }

    @Override
    public void updateStateState(Integer stateId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStateModel(stateId, dataState, oldDataState);
    }

    @Override
    public void updateState(EstStateDomain estStateDomain) throws ApiException {
        String msg = this.checkState(estStateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstStateServiceImpl.updateState.checkState", msg);
        }
        EstState oldEstState = this.getStateModelById(estStateDomain.getStateId());
        if (oldEstState == null) {
            throw new ApiException("estate.EstStateServiceImpl.updateState.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstState estState = this.makeState(estStateDomain, oldEstState);
        this.setStateUpdataDefault(estState);
        this.updateStateModel(estState);
    }

    @Override
    public EstState getState(Integer stateId) {
        return this.getStateModelById(stateId);
    }

    @Override
    public void deleteState(Integer stateId) throws ApiException {
        this.deleteStateModel(stateId);
    }

    @Override
    public QueryResult<EstState> queryStatePage(Map<String, Object> map) {
        List<EstState> estStateList = this.queryStateModelPage(map);
        Boolean appertainBool = MapUtil.getBoolean(map, (Object)"appertainBool");
        if (appertainBool != null && appertainBool.booleanValue()) {
            this.querySetAppertainByRpt(estStateList);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countState(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estStateList);
        return queryResult;
    }

    private void querySetAppertainByRpt(List<EstState> estStates) {
        if (ListUtil.isEmpty(estStates)) {
            return;
        }
        for (EstState estState : estStates) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("memberCode", estState.getMemberCode());
            paramMap.put("projectCode", estState.getProjectCode());
            paramMap.put("tenantCode", estState.getTenantCode());
            List<EstReport> estReports = this.getReportList(paramMap);
            if (!ListUtil.isNotEmpty(estReports)) continue;
            estState.setMemberName(estReports.get(0).getMemberName());
            Map<String, Object> memberJson = this.getMemberInfo(estState.getMemberCode(), estState.getTenantCode());
            if (memberJson == null) continue;
            estState.setMemberPhone((String)memberJson.get("merberPhone"));
        }
    }

    private UserBean getUser(String userCode, String tenantCode) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("userCode", userCode);
        parmMap.put("tenantCode", tenantCode);
        String resultJson = this.internalInvoke("um.user.getUserByCode", parmMap);
        UserBean user = (UserBean)JsonUtil.buildNormalBinder().getJsonToObject(resultJson, UserBean.class);
        return user;
    }

    public List<EstReport> getReportList(Map<String, Object> map) {
        try {
            List<EstReport> reportList = this.estReportMapper.query(map);
            return reportList;
        }
        catch (Exception e) {
            this.logger.error("estate.EstStateServiceImpl.queryReportModel", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> getMemberInfo(String memberCode, String tenantCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("merberCode", memberCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> paramPost = new HashMap<String, String>();
        paramPost.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String resultJson = this.internalInvoke("mm.merber.getMerberByCode", paramPost);
        return (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
    }

    @Override
    public EstState getStateByCode(Map<String, Object> map) {
        return this.getStateModelByCode(map);
    }

    @Override
    public void delStateByCode(Map<String, Object> map) throws ApiException {
        this.delStateModelByCode(map);
    }

    @Override
    public void updateProjectState(EstStateDomain estStateDomain) {
        String msg = this.checkState(estStateDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstStateServiceImpl.updateProjectState.checkState", msg);
        }
    }

    @Override
    public Map<String, Object> getCountStateList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            paramMap.put("memberCode", entry.getKey());
            paramMap.put("userCode", entry.getValue());
            Integer count = this.countState(paramMap);
            resultMap.put(entry.getKey(), Long.parseLong(String.valueOf(count)));
        }
        if (resultMap.size() <= 0) {
            return null;
        }
        return resultMap;
    }

    @Override
    public Long getCountState(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        Integer count = this.countState(map);
        return Long.parseLong(String.valueOf(count));
    }
}

