/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.github.pagehelper.PageInfo;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.estate.EstateConstants;
import com.yqbsoft.laser.service.estate.dao.EstFlowLinkMapper;
import com.yqbsoft.laser.service.estate.dao.EstReserveUnitMapper;
import com.yqbsoft.laser.service.estate.dao.EstStatisticsMapper;
import com.yqbsoft.laser.service.estate.domain.EstStatisticsDomain;
import com.yqbsoft.laser.service.estate.model.EstReserveUnit;
import com.yqbsoft.laser.service.estate.model.EstStatistics;
import com.yqbsoft.laser.service.estate.model.UserBean;
import com.yqbsoft.laser.service.estate.service.EstFollowService;
import com.yqbsoft.laser.service.estate.service.EstReportService;
import com.yqbsoft.laser.service.estate.service.EstStatisticsService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class EstStatisticsServiceImpl
extends BaseServiceImpl
implements EstStatisticsService {
    public static final String SYS_CODE = "estate.EstStatisticsServiceImpl";
    private EstStatisticsMapper estStatisticsMapper;
    @Autowired
    private EstReserveUnitMapper estReserveUnitMapper;
    @Autowired
    private EstReportService estReportService;
    @Autowired
    private EstFollowService estFollowService;
    @Autowired
    private EstFlowLinkMapper estFlowLinkMapper;

    public void setEstStatisticsMapper(EstStatisticsMapper estStatisticsMapper) {
        this.estStatisticsMapper = estStatisticsMapper;
    }

    private Date getSysDate() {
        try {
            return this.estStatisticsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStatistics(EstStatisticsDomain estStatisticsDomain) {
        if (estStatisticsDomain == null) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStatisticsDefault(EstStatistics estStatistics) {
        if (estStatistics == null) {
            return;
        }
        if (estStatistics.getDataState() == null) {
            estStatistics.setDataState(0);
        }
        if (estStatistics.getGmtCreate() == null) {
            estStatistics.setGmtCreate(this.getSysDate());
        }
        estStatistics.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)estStatistics.getStatisticsCode())) {
            estStatistics.setStatisticsCode(this.createUUIDString());
        }
    }

    private int getStatisticsMaxCode() {
        int code = 0;
        try {
            return this.estStatisticsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.getStatisticsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStatisticsUpdataDefault(EstStatistics estStatistics) {
        if (estStatistics == null) {
            return;
        }
        estStatistics.setGmtModified(this.getSysDate());
    }

    private void saveStatisticsModel(EstStatistics estStatistics) throws ApiException {
        if (estStatistics == null) {
            return;
        }
        try {
            this.estStatisticsMapper.insert(estStatistics);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStatisticsServiceImpl.saveStatisticsModel.ex", (Throwable)e);
        }
    }

    private EstStatistics getStatisticsModelById(Integer statisticsId) {
        if (statisticsId == null) {
            return null;
        }
        try {
            return this.estStatisticsMapper.selectByPrimaryKey(statisticsId);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.getStatisticsModelById", (Throwable)e);
            return null;
        }
    }

    public EstStatistics getStatisticsModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        try {
            return this.estStatisticsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.getStatisticsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delStatisticsModelByCode(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.estStatisticsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStatisticsServiceImpl.delStatisticsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstStatisticsServiceImpl.delStatisticsModelByCode.num");
        }
    }

    private void deleteStatisticsModel(Integer statisticsId) throws ApiException {
        if (statisticsId == null) {
            return;
        }
        int i = 0;
        try {
            i = this.estStatisticsMapper.deleteByPrimaryKey(statisticsId);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStatisticsServiceImpl.deleteStatisticsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("estate.EstStatisticsServiceImpl.deleteStatisticsModel.num");
        }
    }

    private void updateStatisticsModel(EstStatistics estStatistics) throws ApiException {
        if (estStatistics == null) {
            return;
        }
        try {
            this.estStatisticsMapper.updateByPrimaryKeySelective(estStatistics);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStatisticsServiceImpl.updateStatisticsModel.ex", (Throwable)e);
        }
    }

    private void updateStateStatisticsModel(Integer statisticsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (statisticsId == null || dataState == null) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statisticsId", statisticsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.estStatisticsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStatisticsServiceImpl.updateStateStatisticsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("estate.EstStatisticsServiceImpl.updateStateStatisticsModel.null");
        }
    }

    private EstStatistics makeStatistics(EstStatisticsDomain estStatisticsDomain, EstStatistics estStatistics) {
        if (estStatisticsDomain == null) {
            return null;
        }
        if (estStatistics == null) {
            estStatistics = new EstStatistics();
        }
        try {
            BeanUtils.copyAllPropertys((Object)estStatistics, (Object)estStatisticsDomain);
            return estStatistics;
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.makeStatistics", (Throwable)e);
            return null;
        }
    }

    private List<EstStatistics> queryStatisticsModelPage(Map<String, Object> parammap) {
        try {
            return this.estStatisticsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.queryStatisticsModel", (Throwable)e);
            return null;
        }
    }

    private int countStatistics(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estStatisticsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.countStatistics", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveStatistics(EstStatisticsDomain estStatisticsDomain) throws ApiException {
        String msg = this.checkStatistics(estStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstStatisticsServiceImpl.saveStatistics.checkStatistics", msg);
        }
        EstStatistics estStatistics = this.makeStatistics(estStatisticsDomain, null);
        this.setStatisticsDefault(estStatistics);
        this.saveStatisticsModel(estStatistics);
    }

    @Override
    public void updateStatisticsState(Integer statisticsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStatisticsModel(statisticsId, dataState, oldDataState);
    }

    @Override
    public void updateStatistics(EstStatisticsDomain estStatisticsDomain) throws ApiException {
        String msg = this.checkStatistics(estStatisticsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("estate.EstStatisticsServiceImpl.updateStatistics.checkStatistics", msg);
        }
        EstStatistics oldEstStatistics = this.getStatisticsModelById(estStatisticsDomain.getStatisticsId());
        if (oldEstStatistics == null) {
            throw new ApiException("estate.EstStatisticsServiceImpl.updateStatistics.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EstStatistics estStatistics = this.makeStatistics(estStatisticsDomain, oldEstStatistics);
        this.setStatisticsUpdataDefault(estStatistics);
        this.updateStatisticsModel(estStatistics);
    }

    @Override
    public EstStatistics getStatistics(Integer statisticsId) {
        return this.getStatisticsModelById(statisticsId);
    }

    @Override
    public void deleteStatistics(Integer statisticsId) throws ApiException {
        this.deleteStatisticsModel(statisticsId);
    }

    @Override
    public QueryResult<EstStatistics> queryStatisticsPage(Map<String, Object> map) {
        List<EstStatistics> estStatisticsList = this.queryStatisticsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStatistics(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(estStatisticsList);
        return queryResult;
    }

    @Override
    public EstStatistics getStatisticsByCode(Map<String, Object> map) {
        return this.getStatisticsModelByCode(map);
    }

    @Override
    public void delStatisticsByCode(Map<String, Object> map) throws ApiException {
        this.delStatisticsModelByCode(map);
    }

    private PageInfo<Map<String, Object>> membersSalesStatisticsModel(Map<String, Object> map) {
        try {
            this.startPage(map);
            List<Map<String, Object>> list = this.estStatisticsMapper.membersSalesStatistics(map);
            return this.getPageInfo(list);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public QueryResult<Map<String, Object>> membersSalesStatistics(Map<String, Object> map) {
        try {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.putAll(map);
            Integer countTotal = this.estStatisticsMapper.salesStatisticsCount(parmMap);
            map.put("countTotal", countTotal);
            PageInfo<Map<String, Object>> pageInfo = this.membersSalesStatisticsModel(map);
            QueryResult queryResult = new QueryResult();
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(Integer.valueOf(String.valueOf(pageInfo.getTotal())).intValue());
            queryResult.setPageTools((SupPageTools)pageTools);
            queryResult.setList(pageInfo.getList());
            return queryResult;
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStatisticsServiceImpl.membersSalesStatistics.null", "\u6570\u636e\u4e3a\u7a7a");
        }
    }

    int membersSalesStatisticsCountModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estStatisticsMapper.membersSalesStatisticsCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.countStatistics", (Throwable)e);
        }
        return i;
    }

    private Map<String, Integer> queryStatisticsSumModel(Map<String, Object> map) {
        try {
            Map<String, Integer> resultMap = this.estStatisticsMapper.queryStatisticsSum(map);
            return resultMap;
        }
        catch (Exception ex) {
            throw new ApiException("estate.EstStatisticsServiceImpl.queryStatisticsSumModel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
    }

    private PageInfo<Map<String, Object>> queryStatisticsSumPageModel(Map<String, Object> map) {
        try {
            this.startPage(map);
            List<Map<String, Object>> resultListMap = this.estStatisticsMapper.queryStatisticsListSum(map);
            return this.getPageInfo(resultListMap);
        }
        catch (Exception ex) {
            throw new ApiException("estate.EstStatisticsServiceImpl.queryStatisticsSumModel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
    }

    @Override
    public Map<String, Object> getStatisticsByCycle(Map<String, Object> map) {
        String tcType = (String)map.get("tcType");
        String cycleType = (String)map.get("cycleType");
        if (cycleType == null) {
            throw new ApiException("estate.EstStatisticsServiceImpl.getStatisticsByCycle parm cycleType null", "\u8c03\u7528\u5468\u671f\u4e3a\u7a7a");
        }
        HashMap<String, Object> resultObj = new HashMap<String, Object>();
        Calendar curr = Calendar.getInstance();
        curr.set(5, curr.get(5) - 7);
        curr.add(5, 1);
        String startDateByWeek = DateUtils.parseDate((Date)curr.getTime());
        curr = Calendar.getInstance();
        curr.set(2, curr.get(2) - 1);
        curr.add(5, 1);
        String startDateByMonth = DateUtils.parseDate((Date)curr.getTime());
        curr = Calendar.getInstance();
        if (cycleType.equals("today")) {
            map.put("startDate", DateUtils.parseDate((Date)curr.getTime()));
        }
        if (cycleType.equals("week")) {
            map.put("startDate", startDateByWeek);
        }
        if (cycleType.equals("month")) {
            map.put("startDate", startDateByMonth);
        }
        map.put("endDate", DateUtils.parseDate((Date)curr.getTime()));
        Map<String, Integer> statisticsSumMap = this.queryStatisticsSumModel(map);
        if (statisticsSumMap == null) {
            statisticsSumMap = new HashMap<String, Integer>();
            if (tcType.equals("toker")) {
                statisticsSumMap.put("reportNum", 0);
                statisticsSumMap.put("visitNum", 0);
                statisticsSumMap.put("followNum", 0);
            } else if (tcType.equals("deal")) {
                statisticsSumMap.put("fromNum", 0);
                statisticsSumMap.put("sbuyNum", 0);
                statisticsSumMap.put("tradeNum", 0);
                statisticsSumMap.put("salesAmount", 0);
            } else if (tcType.equals("tdeal")) {
                statisticsSumMap.put("tfromNum", 0);
                statisticsSumMap.put("tsbuyNum", 0);
                statisticsSumMap.put("ttradeNum", 0);
                statisticsSumMap.put("tsalesAmount", 0);
            }
        }
        resultObj.putAll(statisticsSumMap);
        HashMap<String, Map<String, Map<String, Object>>> trendChartMap = new HashMap<String, Map<String, Map<String, Object>>>();
        if (StringUtils.isNotBlank((String)tcType)) {
            if (tcType.equals("toker")) {
                map.put("tcType", "report");
                trendChartMap.put("report", this.queryTrendChartByDayx(map));
                map.put("tcType", "follow");
                trendChartMap.put("follow", this.queryTrendChartByDayx(map));
                map.put("tcType", "visit");
                trendChartMap.put("visit", this.queryTrendChartByDayx(map));
            } else if (tcType.equals("deal")) {
                map.put("tcType", "from");
                trendChartMap.put("from", this.queryTrendChartByDayx(map));
                map.put("tcType", "sbuy");
                trendChartMap.put("sbuy", this.queryTrendChartByDayx(map));
                map.put("tcType", "trade");
                trendChartMap.put("trade", this.queryTrendChartByDayx(map));
            } else if (tcType.equals("tdeal")) {
                map.put("tcType", "tfrom");
                trendChartMap.put("tfrom", this.queryTrendChartByDayx(map));
                map.put("tcType", "tsbuy");
                trendChartMap.put("tsbuy", this.queryTrendChartByDayx(map));
                map.put("tcType", "ttrade");
                trendChartMap.put("ttrade", this.queryTrendChartByDayx(map));
            }
            resultObj.put("trendCharts", trendChartMap);
        }
        return resultObj;
    }

    @Override
    public QueryResult<Map<String, Object>> performanceRankingByTeam(Map<String, Object> map) {
        try {
            String tenantCode = (String)map.get("tenantCode");
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.putAll(map);
            Integer countTotal = this.estStatisticsMapper.salesStatisticsCount(parmMap);
            map.put("countTotal", countTotal);
            List<EstStatistics> estStatisticsList = this.queryStatisticsModelPage(map);
            ArrayList<Map> teamPRMap = new ArrayList<Map>();
            if (ListUtil.isNotEmpty(estStatisticsList)) {
                HashMap teamMapArray = new HashMap();
                for (EstStatistics estStatistics : estStatisticsList) {
                    Map<String, Object> getTeamMap;
                    HashMap<String, Object> teamMap = new HashMap<String, Object>();
                    String userCode = estStatistics.getUserCode();
                    if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode) || (getTeamMap = this.getTeamInfo(userCode, tenantCode, false)) == null) continue;
                    String teamCode = String.valueOf(getTeamMap.get("teamCode"));
                    teamMap.put("teamName", String.valueOf(getTeamMap.get("teamName")));
                    teamMap.put("teamCode", teamCode);
                    BigDecimal salesAmount = estStatistics.getSalesAmount();
                    if (salesAmount == null) continue;
                    teamMap.put("salesAmount", salesAmount);
                    if (teamMapArray.containsKey(teamCode)) {
                        Map teamCoverMap = (Map)teamMapArray.get(teamCode);
                        teamPRMap.remove(teamCoverMap);
                        teamCoverMap.put("salesAmount", salesAmount.add((BigDecimal)teamCoverMap.get("salesAmount")));
                        teamPRMap.add(teamCoverMap);
                        continue;
                    }
                    teamPRMap.add(teamMap);
                    teamMapArray.put(teamCode, teamMap);
                }
            }
            Collections.sort(teamPRMap, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    return ((BigDecimal)o2.get("salesAmount")).compareTo((BigDecimal)o1.get("salesAmount"));
                }
            });
            QueryResult queryResult = new QueryResult();
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(this.membersSalesStatisticsCountModel(map));
            queryResult.setPageTools((SupPageTools)pageTools);
            queryResult.setList(teamPRMap);
            return queryResult;
        }
        catch (Exception e) {
            throw new ApiException("estate.EstStatisticsServiceImpl.membersSalesStatistics.null", "\u6570\u636e\u4e3a\u7a7a");
        }
    }

    private Map<String, String> queryProjectCodes() {
        HashMap<String, Integer> parmMap = new HashMap<String, Integer>();
        parmMap.put("dataState", 0);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("pt.project.queryProjectPage", postParm);
        Map projectMaps = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
        if (projectMaps == null) {
            return null;
        }
        HashMap<String, String> projectCodeMaps = new HashMap<String, String>();
        for (Map projectMap : (List)projectMaps.get("rows")) {
            projectCodeMaps.put((String)projectMap.get("projectCode"), (String)projectMap.get("tenantCode"));
        }
        return projectCodeMaps;
    }

    private List<String> queryTeamCodesByProject(String projectCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("projectCode", projectCode);
        parmMap.put("dataState", 0);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("pt.project.queryProjectTmPage", postParm);
        Map teamInfoMaps = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
        if (teamInfoMaps == null) {
            return null;
        }
        ArrayList<String> teamCodes = new ArrayList<String>();
        for (Map teamMap : (List)teamInfoMaps.get("rows")) {
            teamCodes.add((String)teamMap.get("teamCode"));
        }
        return teamCodes;
    }

    private List<Map<String, String>> queryUserCodesByTeam(String teamCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("relationBillno", teamCode);
        parmMap.put("dataState", 0);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("um.user.queryRelationPage", postParm);
        Map relationMaps = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
        if (relationMaps == null) {
            return null;
        }
        ArrayList<Map<String, String>> userCodeListMap = new ArrayList<Map<String, String>>();
        for (Map relationMap : (List)relationMaps.get("rows")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userCode", (String)relationMap.get("userCode"));
            map.put("groupCode", (String)relationMap.get("relationBillno2"));
            userCodeListMap.add(map);
        }
        return userCodeListMap;
    }

    Map<String, List<String>> getUserGroups(List<Map<String, String>> userCodeListMap) {
        if (userCodeListMap != null && userCodeListMap.size() > 0) {
            HashMap<String, List<String>> userGroupMap = new HashMap<String, List<String>>();
            for (Map<String, String> map : userCodeListMap) {
                String groupCode = map.get("groupCode");
                ArrayList<String> userCodes = (ArrayList<String>)userGroupMap.get(groupCode);
                if (userCodes == null) {
                    userCodes = new ArrayList<String>();
                }
                userCodes.add(map.get("userCode"));
                userGroupMap.put(groupCode, userCodes);
            }
            return userGroupMap;
        }
        return null;
    }

    @Override
    public void batchStatisticsJobByCycle() {
        Map<String, String> projectCodeMaps = this.queryProjectCodes();
        if (projectCodeMaps == null || projectCodeMaps.size() <= 0) {
            return;
        }
        Calendar curr = Calendar.getInstance();
        curr.set(5, curr.get(5) - 1);
        Date startDate = curr.getTime();
        for (Map.Entry<String, String> entry : projectCodeMaps.entrySet()) {
            List<String> teamCodes = this.queryTeamCodesByProject(entry.getKey());
            if (teamCodes == null || teamCodes.size() <= 0) continue;
            for (String teamCode : teamCodes) {
                List<Map<String, String>> userCodeListMap;
                if (StringUtils.isBlank((String)teamCode) || (userCodeListMap = this.queryUserCodesByTeam(teamCode)) == null || userCodeListMap.size() <= 0) continue;
                for (Map<String, String> map : userCodeListMap) {
                    UserBean user = this.getUser(map.get("userCode"), entry.getValue());
                    if (user == null || StringUtils.isBlank((String)user.getRoleCode()) || !user.getRoleCode().equals("0001001") && !user.getRoleCode().equals("0001003")) continue;
                    this.saveStatistics(startDate, entry.getKey(), teamCode, map.get("groupCode"), user);
                }
            }
        }
    }

    @Override
    public QueryResult<Map<String, Object>> performanceRankingByGroup(Map<String, Object> map) {
        PageInfo<Map<String, Object>> statisticsListSum = this.queryStatisticsSumPageModel(map);
        return null;
    }

    @Override
    public Map<String, Map<String, Long>> queryTeamRanking(Map<String, Object> map) {
        block6: {
            if (!MapUtil.isEmpty(map)) break block6;
            return null;
        }
        try {
            this.getCycleDate(map);
            HashMap<String, Map<String, Long>> resultMap = new HashMap<String, Map<String, Long>>();
            Map teamCodes = (Map)map.get("teamCodes");
            for (Map.Entry entry : teamCodes.entrySet()) {
                String pCode = (String)entry.getKey();
                List teamCodeList = (List)entry.getValue();
                HashMap<String, Long> tmTotalMap = new HashMap<String, Long>();
                if (StringUtils.isBlank((String)pCode) || ListUtil.isEmpty((Collection)teamCodeList)) continue;
                for (String teamCode : teamCodeList) {
                    if (StringUtils.isBlank((String)teamCode)) break;
                    map.put("relevantCode", teamCode);
                    Map<String, Integer> totalMap = this.queryStatisticsSumModel(map);
                    if (MapUtil.isEmpty(totalMap)) {
                        tmTotalMap.put(teamCode, Long.valueOf("0"));
                        continue;
                    }
                    tmTotalMap.put(teamCode, Long.valueOf(String.valueOf(totalMap.get(map.get("typeName")))));
                }
                resultMap.put(pCode, tmTotalMap);
            }
            return resultMap;
        }
        catch (Exception ex) {
            this.logger.error("estate.EstStatisticsServiceImpl.queryTeamRanking", (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Map<String, Object>> queryGroupRanking(Map<String, Object> map) {
        HashMap<String, String> groupInfoListMap;
        ArrayList<Map<String, Object>> resultListMap;
        PageInfo<Map<String, Object>> statisticsListSum;
        block11: {
            List<Map<String, String>> groupInfoList;
            block10: {
                String teamCode;
                block9: {
                    map.put("gbGroupCode", true);
                    teamCode = (String)map.get("relevantCode");
                    if (!StringUtils.isBlank((String)teamCode)) break block9;
                    return null;
                }
                this.getCycleDate(map);
                statisticsListSum = this.queryStatisticsSumPageModel(map);
                groupInfoList = this.queryGroupByCode(teamCode);
                if (!ListUtil.isEmpty(groupInfoList)) break block10;
                return null;
            }
            resultListMap = new ArrayList<Map<String, Object>>();
            if (ListUtil.isEmpty((Collection)statisticsListSum.getList()) && ListUtil.isEmpty((Collection)statisticsListSum.getList())) {
                for (Map<String, String> mapGroup : groupInfoList) {
                    HashMap<String, Object> remap = new HashMap<String, Object>();
                    remap.put("groupName", mapGroup.get("groupName"));
                    remap.put("groupCode", mapGroup.get("groupCode"));
                    remap.put("tenantCode", mapGroup.get("tenantCode"));
                    remap.put("total", 0);
                    resultListMap.add(remap);
                }
                return resultListMap;
            }
            groupInfoListMap = new HashMap<String, String>();
            for (Map<String, String> groupMap : groupInfoList) {
                groupInfoListMap.put(groupMap.get("groupCode"), groupMap.get("groupName"));
            }
            if (!MapUtil.isEmpty(groupInfoListMap)) break block11;
            return null;
        }
        try {
            for (Map<String, String> mapR : statisticsListSum.getList()) {
                String groupCode = mapR.get("relevantCode2");
                String tenantCode = mapR.get("tenantCode");
                if (!groupInfoListMap.containsKey(groupCode)) continue;
                HashMap remap = new HashMap();
                remap.put("groupName", groupInfoListMap.get(groupCode));
                remap.put("groupCode", groupCode);
                remap.put("tenantCode", tenantCode);
                remap.put("total", mapR.get(map.get("typeName")));
                resultListMap.add(remap);
            }
            Collections.sort(resultListMap, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    return Long.valueOf(String.valueOf(o2.get("total"))).compareTo(Long.valueOf(String.valueOf(o1.get("total"))));
                }
            });
            return resultListMap;
        }
        catch (Exception ex) {
            this.logger.error("estate.EstStatisticsServiceImpl.queryGroupRanking", (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
    }

    private List<Map<String, String>> queryGroupByCode(String teamCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("teamCode", teamCode);
        parmMap.put("dataState", 0);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("um.user.queryGroupPage", postParm);
        Map relationMaps = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resultJson, String.class, Object.class);
        if (relationMaps == null) {
            return null;
        }
        ArrayList<Map<String, String>> groupListMap = new ArrayList<Map<String, String>>();
        for (Map relationMap : (List)relationMaps.get("rows")) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("groupName", (String)relationMap.get("groupName"));
            map.put("groupCode", (String)relationMap.get("groupCode"));
            groupListMap.add(map);
        }
        return groupListMap;
    }

    @Override
    public QueryResult<Map<String, Object>> queryMemberRankingPage(Map<String, Object> map) {
        PageInfo<Map<String, Object>> statisticsListSum;
        QueryResult queryResult;
        block5: {
            queryResult = new QueryResult();
            map.put("gbUserCode", true);
            this.getCycleDate(map);
            statisticsListSum = this.queryStatisticsSumPageModel(map);
            if (!ListUtil.isEmpty((Collection)statisticsListSum.getList())) break block5;
            return null;
        }
        try {
            ArrayList resultListMap = new ArrayList();
            for (Map mapR : statisticsListSum.getList()) {
                String tenantCode;
                HashMap<String, String> remap = new HashMap<String, String>();
                String userCode = (String)mapR.get("userCode");
                UserBean userBean = this.getUser(userCode, tenantCode = (String)mapR.get("tenantCode"));
                if (userBean != null) {
                    remap.put("userName", userBean.getUserRelname());
                }
                remap.put("userCode", userCode);
                remap.put("tenantCode", tenantCode);
                remap.put("total", (String)mapR.get(map.get("typeName")));
                resultListMap.add(remap);
            }
            Collections.sort(resultListMap, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    return Long.valueOf(String.valueOf(o2.get("total"))).compareTo(Long.valueOf(String.valueOf(o1.get("total"))));
                }
            });
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(Integer.parseInt(String.valueOf(statisticsListSum.getTotal())));
            queryResult.setPageTools((SupPageTools)pageTools);
            queryResult.setList(resultListMap);
            return queryResult;
        }
        catch (Exception ex) {
            this.logger.error("estate.EstStatisticsServiceImpl.queryMemberRankingPage", (Throwable)ex);
            ex.printStackTrace();
            return null;
        }
    }

    private Map<String, Object> getCycleDate(Map<String, Object> map) {
        String cycleType = (String)map.get("cycleType");
        Calendar curr = Calendar.getInstance();
        curr.set(5, curr.get(5) - 7);
        String startDateByWeek = DateUtils.parseDate((Date)curr.getTime());
        curr = Calendar.getInstance();
        curr.set(2, curr.get(2) - 1);
        String startDateByMonth = DateUtils.parseDate((Date)curr.getTime());
        curr = Calendar.getInstance();
        if (StringUtils.isBlank((String)cycleType)) {
            Date date = new Date();
            map.put("startDate", DateUtils.parseDate((Date)curr.getTime()));
            map.put("endDate", DateUtils.parseDate((Date)curr.getTime()));
            return map;
        }
        if (cycleType.equals("today")) {
            map.put("startDate", DateUtils.parseDate((Date)curr.getTime()));
        }
        if (cycleType.equals("week")) {
            map.put("startDate", startDateByWeek);
        }
        if (cycleType.equals("month")) {
            map.put("startDate", startDateByMonth);
        }
        map.put("endDate", DateUtils.parseDate((Date)curr.getTime()));
        return map;
    }

    private void saveStatistics(Date startDate, String projectCode, String teamCode, String groupCode, UserBean user) {
        try {
            EstStatisticsDomain estStatisticsDomain = new EstStatisticsDomain();
            int reportTotal = this.getReportCountByUser(user.getUserCode(), projectCode, user.getTenantCode(), startDate);
            estStatisticsDomain.setReportNum(reportTotal);
            int followTotal = this.followCountByUser(user.getUserCode(), projectCode, user.getTenantCode(), startDate);
            estStatisticsDomain.setFollowNum(followTotal);
            int countVisitReport = this.visitCountByUser(user.getUserCode(), user.getRoleCode(), projectCode, user.getTenantCode(), startDate);
            estStatisticsDomain.setVisitNum(countVisitReport);
            estStatisticsDomain.setUserCode(user.getUserCode());
            estStatisticsDomain.setRelevantCode(teamCode);
            estStatisticsDomain.setRelevantCode2(groupCode);
            estStatisticsDomain.setTenantCode(user.getTenantCode());
            Map<String, Object> resultMap = this.tradeOrderCount(user.getUserCode(), user.getRoleCode(), projectCode, user.getTenantCode());
            if (resultMap != null) {
                estStatisticsDomain.setTradeNum((Integer)resultMap.get("dealCount"));
                estStatisticsDomain.setFromNum((Integer)resultMap.get("registrationCount"));
                estStatisticsDomain.setSbuyNum((Integer)resultMap.get("subscriptionCount"));
                estStatisticsDomain.setTtradeNum((Integer)resultMap.get("tdealCount"));
                estStatisticsDomain.setTfromNum((Integer)resultMap.get("tregistrationCount"));
                estStatisticsDomain.setTsbuyNum((Integer)resultMap.get("tsubscriptionCount"));
                estStatisticsDomain.setSalesAmount((BigDecimal)resultMap.get("salesAmount"));
                estStatisticsDomain.setTsalesAmount((BigDecimal)resultMap.get("tsalesAmount"));
            }
            estStatisticsDomain.setProjectCode(projectCode);
            this.saveStatistics(estStatisticsDomain);
        }
        catch (Exception ex) {
            this.logger.error("estate.EstStatisticsServiceImpl.saveStatistics", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private Integer getReportCountByUser(String userCode, String projectCode, String tenantCode, Date date) {
        try {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("userCode", userCode);
            parmMap.put("reportDate", DateUtils.parseDate((Date)date));
            parmMap.put("tenantCode", tenantCode);
            parmMap.put("projectCode", projectCode);
            parmMap.put("groupBy", true);
            int countReport = this.estReportService.getCountReport(parmMap);
            if (countReport > 0) {
                return countReport;
            }
        }
        catch (Exception ex) {
            this.logger.error("estate.EstStatisticsServiceImpl.getReportCountByUser", (Throwable)ex);
        }
        return 0;
    }

    private Integer followCountByUser(String userCode, String projectCode, String tenantCode, Date date) {
        try {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("userCode", userCode);
            parmMap.put("startDate", DateUtils.parseDate((Date)date));
            parmMap.put("endDate", DateUtils.parseDate((Date)date));
            parmMap.put("projectCode", projectCode);
            parmMap.put("tenantCode", tenantCode);
            int countReport = this.estFollowService.getCountFollow(parmMap);
            if (countReport > 0) {
                return countReport;
            }
        }
        catch (Exception ex) {
            this.logger.error("estate.EstStatisticsServiceImpl.followCountByUser", (Throwable)ex);
        }
        return 0;
    }

    private Integer visitCountByUser(String userCode, String roleCode, String projectCode, String tenantCode, Date date) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            if ("0001001".equals(roleCode)) {
                paramMap.put("opRelative", userCode);
            } else {
                paramMap.put("opBillno", userCode);
            }
            paramMap.put("gmtCreate", DateUtils.parseDate((Date)date));
            paramMap.put("opCode", projectCode);
            paramMap.put("tenantCode", tenantCode);
            HashMap<String, String> postParam = new HashMap<String, String>();
            postParam.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
            int countVisitReport = Integer.parseInt(this.internalInvoke("mm.merber.countVisiting", postParam));
            if (countVisitReport > 0) {
                return countVisitReport;
            }
        }
        catch (Exception ex) {
            this.logger.error("estate.EstStatisticsServiceImpl.visitCountByUser", (Throwable)ex);
        }
        return 0;
    }

    private Integer visitCountByUsers(String userCodes, String roleCode, String tenantCode) {
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            if ("0001001".equals(roleCode)) {
                paramMap.put("opRelatives", userCodes);
            } else {
                paramMap.put("userCodes", userCodes);
            }
            paramMap.put("gmtCreate", DateUtils.parseDate((Date)new Date()));
            paramMap.put("tenantCode", tenantCode);
            HashMap<String, String> postParam = new HashMap<String, String>();
            postParam.put("map", JsonUtil.buildNonNullBinder().toJson(paramMap));
            int countVisitReport = Integer.parseInt(this.internalInvoke("mm.merber.countVisiting", postParam));
            if (countVisitReport > 0) {
                return countVisitReport;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private Map<String, Object> tradeOrderCount(String userCode, String roleCode, String projectCode, String tenantCode) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            HashMap<String, Object> parmMap = new HashMap<String, Object>();
            parmMap.put("userCode", userCode);
            parmMap.put("projectCode", projectCode);
            parmMap.put("gmtCreate", DateUtils.parseDate((Date)new Date()));
            parmMap.put("tenantCode", tenantCode);
            Map<String, Object> countResultMap = this.countAuditReserveUnit(parmMap);
            int registrationCount = Integer.valueOf(countResultMap.get("from_count").toString());
            resultMap.put("registrationCount", registrationCount);
            int tregistrationCount = Integer.valueOf(countResultMap.get("tfrom_count").toString());
            resultMap.put("tregistrationCount", tregistrationCount);
            int subscriptionCount = Integer.valueOf(countResultMap.get("sbuy_count").toString());
            resultMap.put("subscriptionCount", subscriptionCount);
            int tsubscriptionCount = Integer.valueOf(countResultMap.get("tsbuy_count").toString());
            resultMap.put("tsubscriptionCount", tsubscriptionCount);
            int dealCount = Integer.valueOf(countResultMap.get("deal_count").toString());
            resultMap.put("dealCount", dealCount);
            int tdealCount = Integer.valueOf(countResultMap.get("tdeal_count").toString());
            resultMap.put("tdealCount", tdealCount);
            parmMap.put("approvalStatus", EstateConstants.FlowLinkApprovalStatusEnum.APPROVAL_THROUGH.getApprovalStatus());
            if ("0001001".equals(roleCode)) {
                parmMap.remove("userCode");
                parmMap.put("opBillcode", userCode);
            }
            List<EstReserveUnit> estReserveUnitList = this.queryAuditReserveUnitModelPage(parmMap);
            BigDecimal salesAmount = new BigDecimal(BigInteger.ZERO);
            BigDecimal tsalesAmount = new BigDecimal(BigInteger.ZERO);
            if (estReserveUnitList != null && ListUtil.isNotEmpty(estReserveUnitList)) {
                for (EstReserveUnit estReserveUnit : estReserveUnitList) {
                    if (StringUtils.isNotBlank((String)estReserveUnit.getOpBillcode()) || estReserveUnit.getTotalTransactionPrice() == null) continue;
                    salesAmount = salesAmount.add(estReserveUnit.getTotalTransactionPrice());
                }
            }
            ArrayList<EstReserveUnit> retreatReserveUnitList = new ArrayList<EstReserveUnit>();
            parmMap.put("dataState", 0);
            ArrayList<Integer> flowLinkTypes = new ArrayList<Integer>();
            flowLinkTypes.add(EstateConstants.FlowLinkTypeEnum.RETREAT_REGISTRATION.getFlowLinkType());
            flowLinkTypes.add(EstateConstants.FlowLinkTypeEnum.RETREAT_SUBSCRIPTION.getFlowLinkType());
            flowLinkTypes.add(EstateConstants.FlowLinkTypeEnum.RETREAT_DEAL.getFlowLinkType());
            parmMap.put("flowLinkTypes", flowLinkTypes);
            retreatReserveUnitList.addAll(this.queryAuditReserveUnitModelPage(parmMap));
            if (retreatReserveUnitList != null && ListUtil.isNotEmpty(retreatReserveUnitList)) {
                for (EstReserveUnit estReserveUnit : retreatReserveUnitList) {
                    if (StringUtils.isNotBlank((String)estReserveUnit.getOpBillcode()) || estReserveUnit.getTotalTransactionPrice() == null) continue;
                    tsalesAmount = tsalesAmount.add(estReserveUnit.getTotalTransactionPrice());
                }
            }
            resultMap.put("salesAmount", salesAmount);
            resultMap.put("tsalesAmount", tsalesAmount);
        }
        catch (Exception ex) {
            this.logger.error("estate.EstStatisticsServiceImpl.tradeOrderCount", (Throwable)ex);
            ex.printStackTrace();
        }
        return resultMap;
    }

    Map<String, Object> countAuditReserveUnit(Map<String, Object> param) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.putAll(param);
        Map<String, Object> countResultMap = this.estFlowLinkMapper.getCountAuditReserveUnit(paramMap);
        if (countResultMap != null && countResultMap.size() > 0) {
            if (countResultMap.get("from_count") == null) {
                countResultMap.put("from_count", 0);
            }
            if (countResultMap.get("tfrom_count") == null) {
                countResultMap.put("tfrom_count", 0);
            }
            if (countResultMap.get("sbuy_count") == null) {
                countResultMap.put("sbuy_count", 0);
            }
            if (countResultMap.get("tsbuy_count") == null) {
                countResultMap.put("tsbuy_count", 0);
            }
            if (countResultMap.get("deal_count") == null) {
                countResultMap.put("deal_count", 0);
            }
            if (countResultMap.get("tdeal_count") == null) {
                countResultMap.put("tdeal_count", 0);
            }
        } else {
            countResultMap = new HashMap<String, Object>();
            countResultMap.put("from_count", 0);
            countResultMap.put("tfrom_count", 0);
            countResultMap.put("sbuy_count", 0);
            countResultMap.put("tsbuy_count", 0);
            countResultMap.put("deal_count", 0);
            countResultMap.put("tdeal_count", 0);
        }
        return countResultMap;
    }

    private List<EstReserveUnit> queryAuditReserveUnitModelPage(Map<String, Object> parammap) {
        try {
            return this.estReserveUnitMapper.queryByFlowLinkAndRpt(parammap);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.queryReserveUnitModel", (Throwable)e);
            return null;
        }
    }

    public int countReserveUnit(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReserveUnitMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.countReserveUnit", (Throwable)e);
        }
        return i;
    }

    private UserBean getUser(String userCode, String tenantCode) {
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("userCode", userCode);
        parmMap.put("tenantCode", tenantCode);
        String resultJson = this.internalInvoke("um.user.getUserByCode", parmMap);
        UserBean user = (UserBean)JsonUtil.buildNormalBinder().getJsonToObject(resultJson, UserBean.class);
        return user;
    }

    private List<UserBean> getUserListByRole(String roleCode, String tenantCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("roleCode", roleCode);
        parmMap.put("tenantCode", tenantCode);
        parmMap.put("dataState", 0);
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("um.user.queryUserList", postParm);
        List userList = (List)JsonUtil.buildNormalBinder().getJsonToList(resultJson, UserBean.class);
        if (userList == null || userList.size() <= 0) {
            return null;
        }
        return userList;
    }

    private Map<String, Object> getTeamInfo(String userCode, String tenantCode, Boolean flagDefault) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        parmMap.put("userCode", userCode);
        parmMap.put("tenantCode", tenantCode);
        if (flagDefault.booleanValue()) {
            parmMap.put("defaultQuery", flagDefault);
        }
        HashMap<String, String> postParm = new HashMap<String, String>();
        postParm.put("map", JsonUtil.buildNonNullBinder().toJson(parmMap));
        String resultJson = this.internalInvoke("um.user.getDirectManagerByCode", postParm);
        if (StringUtils.isNotBlank((String)resultJson)) {
            return (Map)JsonUtil.buildNonNullBinder().getJsonToMap(resultJson, String.class, Object.class);
        }
        return null;
    }

    @Override
    public Map<String, Map<String, Object>> queryTrendChartByDayx(Map<String, Object> map) {
        try {
            String tcType = (String)map.get("tcType");
            if (StringUtils.isBlank((String)tcType)) {
                throw new ApiException("estate.EstStatisticsServiceImpl.queryTrendChartByDayx.null", "\u89c6\u56fe\u7c7b\u578b\u4e3a\u7a7a");
            }
            return this.queryTrendChartByDayxModel(map, tcType);
        }
        catch (Exception ex) {
            throw new ApiException("estate.EstStatisticsServiceImpl.queryTrendChartByDayx.null", "\u6570\u636e\u4e3a\u7a7a");
        }
    }

    private Map<String, Map<String, Object>> queryTrendChartByDayxModel(Map<String, Object> map, String type) {
        Map<String, Object> mapRe;
        HashMap<String, Object> dayPointArray;
        HashMap<String, Map<String, Object>> trendChartMap = new HashMap<String, Map<String, Object>>();
        Calendar curr = Calendar.getInstance();
        curr.set(5, curr.get(5) - 7);
        curr.add(5, 1);
        String startDateByWeek = DateUtils.parseDate((Date)curr.getTime());
        curr = Calendar.getInstance();
        curr.set(2, curr.get(2) - 1);
        curr.add(5, 1);
        String startDateByMonth = DateUtils.parseDate((Date)curr.getTime());
        map.put("startDate", startDateByWeek);
        curr = Calendar.getInstance();
        map.put("endDate", DateUtils.parseDate((Date)curr.getTime()));
        List<EstStatistics> estStatisticsList = this.queryStatisticsModelPage(map);
        if (ListUtil.isNotEmpty(estStatisticsList)) {
            dayPointArray = new HashMap<String, Object>();
            for (EstStatistics estStatistics : estStatisticsList) {
                mapRe = this.getTrendChartMapReSwitch(type, estStatistics);
                if (mapRe == null) continue;
                for (String key : mapRe.keySet()) {
                    if (dayPointArray.containsKey(key)) {
                        dayPointArray.put(key, Integer.parseInt(String.valueOf(mapRe.get(key))) + Integer.parseInt(String.valueOf(dayPointArray.get(key))));
                        continue;
                    }
                    dayPointArray.put(key, mapRe.get(key));
                }
            }
            this.setNotDateDataInDefault(startDateByWeek, dayPointArray);
            trendChartMap.put("week", this.sortMapKey(dayPointArray));
        } else {
            dayPointArray = new HashMap();
            this.setNotDateDataInDefault(startDateByWeek, dayPointArray);
            trendChartMap.put("week", this.sortMapKey(dayPointArray));
        }
        map.put("startDate", startDateByMonth);
        estStatisticsList = this.queryStatisticsModelPage(map);
        if (ListUtil.isNotEmpty(estStatisticsList)) {
            dayPointArray = new HashMap();
            for (EstStatistics estStatistics : estStatisticsList) {
                mapRe = this.getTrendChartMapReSwitch(type, estStatistics);
                if (mapRe == null) continue;
                for (String key : mapRe.keySet()) {
                    if (dayPointArray.containsKey(key)) {
                        dayPointArray.put(key, Integer.parseInt(String.valueOf(mapRe.get(key))) + Integer.parseInt(String.valueOf(dayPointArray.get(key))));
                        continue;
                    }
                    dayPointArray.put(key, mapRe.get(key));
                }
            }
            this.setNotDateDataInDefault(startDateByMonth, dayPointArray);
            trendChartMap.put("month", this.sortMapKey(dayPointArray));
        } else {
            dayPointArray = new HashMap();
            this.setNotDateDataInDefault(startDateByMonth, dayPointArray);
            trendChartMap.put("month", this.sortMapKey(dayPointArray));
        }
        return trendChartMap;
    }

    private Map<String, Object> sortMapKey(Map<String, Object> map) {
        Object[] key = map.keySet().toArray();
        Arrays.sort(key);
        LinkedHashMap<String, Object> sortMap = new LinkedHashMap<String, Object>();
        Object[] objectArray = key;
        int n = key.length;
        int n2 = 0;
        while (n2 < n) {
            Object keyStr = objectArray[n2];
            sortMap.put((String)keyStr, map.get(keyStr));
            ++n2;
        }
        return sortMap;
    }

    private Map<String, Object> getTrendChartMapReSwitch(String type, EstStatistics estStatistics) {
        HashMap<String, Object> mapRe = new HashMap<String, Object>();
        Calendar curr = Calendar.getInstance();
        curr.setTime(estStatistics.getGmtCreate());
        curr.add(5, -1);
        String date = DateUtils.parseDate((Date)curr.getTime());
        String subsDate = date.substring(date.indexOf("-") + 1, date.length());
        switch (type) {
            case "follow": {
                int followNum = estStatistics.getFollowNum() != null ? estStatistics.getFollowNum() : 0;
                mapRe.put(subsDate, followNum);
                break;
            }
            case "from": {
                int fromNum = estStatistics.getFromNum() != null ? estStatistics.getFromNum() : 0;
                mapRe.put(subsDate, fromNum);
                break;
            }
            case "tfrom": {
                int tfromNum = estStatistics.getTfromNum() != null ? estStatistics.getTfromNum() : 0;
                mapRe.put(subsDate, tfromNum);
                break;
            }
            case "visit": {
                int visitNum = estStatistics.getVisitNum() != null ? estStatistics.getVisitNum() : 0;
                mapRe.put(subsDate, visitNum);
                break;
            }
            case "trade": {
                int tradeNum = estStatistics.getTradeNum() != null ? estStatistics.getTradeNum() : 0;
                mapRe.put(subsDate, tradeNum);
                break;
            }
            case "ttrade": {
                int ttradeNum = estStatistics.getTtradeNum() != null ? estStatistics.getTtradeNum() : 0;
                mapRe.put(subsDate, ttradeNum);
                break;
            }
            case "sbuy": {
                int sbuyNum = estStatistics.getSbuyNum() != null ? estStatistics.getSbuyNum() : 0;
                mapRe.put(subsDate, sbuyNum);
                break;
            }
            case "tsbuy": {
                int tsbuyNum = estStatistics.getTsbuyNum() != null ? estStatistics.getTsbuyNum() : 0;
                mapRe.put(subsDate, tsbuyNum);
                break;
            }
            case "report": {
                int reportNum = estStatistics.getReportNum() != null ? estStatistics.getReportNum() : 0;
                mapRe.put(subsDate, reportNum);
            }
        }
        return mapRe;
    }

    void setNotDateDataInDefault(String startDateStr, Map<String, Object> map) {
        try {
            Date startDate = DateUtils.parseDate((String)startDateStr, (String)"yyyy-MM-dd");
            Calendar curr = DateUtils.getCalendar((Date)startDate);
            Calendar todayCurr = Calendar.getInstance();
            curr.add(5, -1);
            long forDay = DateUtils.getBetweenDays((Date)curr.getTime(), (Date)todayCurr.getTime());
            int i = 0;
            while ((long)i < forDay) {
                String keyDateStr;
                String subsKeyDateStr;
                if (i > 0) {
                    curr.set(5, curr.get(5) + 1);
                }
                if (!map.containsKey(subsKeyDateStr = (keyDateStr = DateUtils.parseDate((Date)curr.getTime())).substring(keyDateStr.indexOf("-") + 1, keyDateStr.length()))) {
                    map.put(subsKeyDateStr, 0);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public EstStatistics getTodaySalesStatistics(Map<String, Object> map) {
        String projectCode = String.valueOf(map.get("projectCode"));
        String userCode = String.valueOf(map.get("userCode"));
        List userCodes = (List)map.get("userCodes");
        String tenantCode = String.valueOf(map.get("tenantCode"));
        EstStatistics estStatistics = new EstStatistics();
        int registrationCount = this.getAuditReserveUnitCount(1, userCode, userCodes, projectCode, tenantCode);
        int subscriptionCount = this.getAuditReserveUnitCount(2, userCode, userCodes, projectCode, tenantCode);
        int dealCount = this.getAuditReserveUnitCount(3, userCode, userCodes, projectCode, tenantCode);
        estStatistics.setProjectCode(projectCode);
        estStatistics.setFromNum(registrationCount);
        estStatistics.setSbuyNum(subscriptionCount);
        estStatistics.setTradeNum(dealCount);
        HashMap<String, Object> queryReportCount = new HashMap<String, Object>();
        queryReportCount.put("groupBy", true);
        if (StringUtils.isNotBlank((String)userCode) && !"null".equals(userCode)) {
            queryReportCount.put("userCode", userCode);
        }
        queryReportCount.put("projectCode", projectCode);
        queryReportCount.put("tenantCode", tenantCode);
        if (ListUtil.isNotEmpty((Collection)userCodes)) {
            queryReportCount.put("userCodes", userCodes);
        }
        estStatistics.setVisitNum(this.estReportService.getCountReport(queryReportCount));
        return estStatistics;
    }

    private int getAuditReserveUnitCount(int reserveUnitType, String userCode, List<String> rptUserCodes, String projectCode, String tenantCode) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)userCode) && !"null".equals(userCode)) {
            parmMap.put("rptUserCode", userCode);
        }
        if (ListUtil.isNotEmpty(rptUserCodes)) {
            parmMap.put("rptUserCodes", rptUserCodes);
        }
        parmMap.put("flowLinkType", reserveUnitType);
        parmMap.put("approvalStatus", 2);
        parmMap.put("projectCode", projectCode);
        parmMap.put("dataState", 1);
        parmMap.put("rptDataState", 1);
        parmMap.put("tenantCode", tenantCode);
        parmMap.put("greaterThan1", true);
        Integer count = this.getFlowLinkAndRptCountModel(parmMap);
        if (count != null) {
            return count;
        }
        return 0;
    }

    private Integer getFlowLinkAndRptCountModel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.estReserveUnitMapper.getQueryByFlowLinkAndRptCount(map);
        }
        catch (Exception e) {
            this.logger.error("estate.EstStatisticsServiceImpl.getFlowLinkAndRptCountModel", (Throwable)e);
        }
        return i;
    }
}

