/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.evaluate.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.evaluate.dao.ResScoreDetailMapper;
import com.yqbsoft.laser.service.evaluate.dao.ResScoreMapper;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateGoodsReDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateScopeDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateScopeReDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResEvaluateShopReDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResScoreDetailDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResScoreDetailReDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResScoreDomain;
import com.yqbsoft.laser.service.evaluate.domain.ResScoreReDomain;
import com.yqbsoft.laser.service.evaluate.enums.ResConfigKey;
import com.yqbsoft.laser.service.evaluate.model.ResScore;
import com.yqbsoft.laser.service.evaluate.model.ResScoreDetail;
import com.yqbsoft.laser.service.evaluate.service.ResConfigService;
import com.yqbsoft.laser.service.evaluate.service.ResEvaluateService;
import com.yqbsoft.laser.service.evaluate.service.ResScoreService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DoubleUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResScoreServiceImpl
extends BaseServiceImpl
implements ResScoreService {
    private static final String SYS_CODE = "res.ResScoreServiceImpl";
    private ResScoreMapper resScoreMapper;
    private ResScoreDetailMapper resScoreDetailMapper;
    private ResConfigService resConfigService;
    private ResEvaluateService resEvaluateService;

    public void setResScoreMapper(ResScoreMapper resScoreMapper) {
        this.resScoreMapper = resScoreMapper;
    }

    public void setResScoreDetailMapper(ResScoreDetailMapper resScoreDetailMapper) {
        this.resScoreDetailMapper = resScoreDetailMapper;
    }

    public void setResConfigService(ResConfigService resConfigService) {
        this.resConfigService = resConfigService;
    }

    public void setResEvaluateService(ResEvaluateService resEvaluateService) {
        this.resEvaluateService = resEvaluateService;
    }

    private Date getSysDate() {
        try {
            return this.resScoreMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkScore(ResScoreDomain resScoreDomain) {
        if (null == resScoreDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)resScoreDomain.getScoreType())) {
            msg = msg + "ScoreType\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resScoreDomain.getMemberBgCode())) {
            msg = msg + "MemberBgCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resScoreDomain.getMemberBgName())) {
            msg = msg + "MemberBgName\u4e3a\u7a7a;";
        }
        if (resScoreDomain.getScoreValue() == null) {
            msg = msg + "ScoreValue\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resScoreDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setScoreDefault(ResScore resScore) {
        if (null == resScore) {
            return;
        }
        if (null == resScore.getDataState()) {
            resScore.setDataState(0);
        }
        if (null == resScore.getGmtCreate()) {
            resScore.setGmtCreate(this.getSysDate());
        }
        resScore.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)resScore.getScoreCode())) {
            resScore.setScoreCode(this.createUUIDString());
        }
    }

    private int getScoreMaxCode() {
        int code = 0;
        try {
            return this.resScoreMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.getScoreMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setScoreUpdataDefault(ResScore resScore) {
        if (null == resScore) {
            return;
        }
        resScore.setGmtModified(this.getSysDate());
    }

    private void saveScoreModel(ResScore resScore) throws ApiException {
        if (null == resScore) {
            return;
        }
        int i = 0;
        try {
            i = this.resScoreMapper.insert(resScore);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.saveScoreModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResScoreServiceImpl.saveScoreModel.num");
        }
    }

    private ResScore getScoreModelById(Integer scoreId) {
        if (null == scoreId) {
            return null;
        }
        try {
            return this.resScoreMapper.selectByPrimaryKey(scoreId);
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.getScoreModelById", (Throwable)e);
            return null;
        }
    }

    private ResScore getScoreModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.resScoreMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.getScoreModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delScoreModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.resScoreMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.delScoreModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResScoreServiceImpl.delScoreModelByCode.num");
        }
    }

    private void deleteScoreModel(Integer scoreId) throws ApiException {
        if (null == scoreId) {
            return;
        }
        int i = 0;
        try {
            i = this.resScoreMapper.deleteByPrimaryKey(scoreId);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.deleteScoreModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResScoreServiceImpl.deleteScoreModel.num");
        }
    }

    private void updateScoreModel(ResScore resScore) throws ApiException {
        if (null == resScore) {
            return;
        }
        int i = 0;
        try {
            i = this.resScoreMapper.updateByPrimaryKeySelective(resScore);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.updateScoreModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResScoreServiceImpl.updateScoreModel.num");
        }
    }

    private void updateStateScoreModel(Integer scoreId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == scoreId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scoreId", scoreId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.resScoreMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.updateStateScoreModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResScoreServiceImpl.updateStateScoreModel.null");
        }
    }

    private ResScore makeScore(ResScoreDomain resScoreDomain, ResScore resScore) {
        if (null == resScoreDomain) {
            return null;
        }
        if (null == resScore) {
            resScore = new ResScore();
        }
        try {
            BeanUtils.copyAllPropertys((Object)resScore, (Object)resScoreDomain);
            return resScore;
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.makeScore", (Throwable)e);
            return null;
        }
    }

    private List<ResScore> queryScoreModelPage(Map<String, Object> parammap) {
        try {
            return this.resScoreMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.queryScoreModel", (Throwable)e);
            return null;
        }
    }

    private int countScore(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.resScoreMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.countScore", (Throwable)e);
        }
        return i;
    }

    private String checkScopeDetail(ResScoreDetailDomain resScoreDetailDomain) {
        if (null == resScoreDetailDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)resScoreDetailDomain.getScoreDetailObject())) {
            msg = msg + "ScoreDetailObject\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resScoreDetailDomain.getScoreCode())) {
            msg = msg + "ScoreCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resScoreDetailDomain.getTemplateCode())) {
            msg = msg + "TemplateCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resScoreDetailDomain.getTemplateTitle())) {
            msg = msg + "TemplateTitle\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((Integer)resScoreDetailDomain.getScoreDetailEnum())) {
            msg = msg + "ScoreDetailEnum\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((Integer)resScoreDetailDomain.getScoreDetailEnum())) {
            msg = msg + "ScoreDetailScore\u4e3a\u7a7a;";
        }
        if (resScoreDetailDomain.getScoreDetailEnum() == null) {
            msg = msg + "ScoreDetailEnable\u4e3a\u7a7a;";
        }
        if (resScoreDetailDomain.getScoreDetailTotal() == null) {
            msg = msg + "ScoreDetailTotal\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)resScoreDetailDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setScopeDetailDefault(ResScoreDetail resScoreDetail) {
        if (null == resScoreDetail) {
            return;
        }
        if (null == resScoreDetail.getDataState()) {
            resScoreDetail.setDataState(0);
        }
        if (null == resScoreDetail.getGmtCreate()) {
            resScoreDetail.setGmtCreate(this.getSysDate());
        }
        resScoreDetail.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)resScoreDetail.getScoreDetailCode())) {
            resScoreDetail.setScoreDetailCode(this.createUUIDString());
        }
    }

    private int getScopeDetailMaxCode() {
        int code = 0;
        try {
            return this.resScoreDetailMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.getScopeDetailMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setScopeDetailUpdataDefault(ResScoreDetail resScoreDetail) {
        if (null == resScoreDetail) {
            return;
        }
        resScoreDetail.setGmtModified(this.getSysDate());
    }

    private void saveScopeDetailModel(ResScoreDetail resScoreDetail) throws ApiException {
        if (null == resScoreDetail) {
            return;
        }
        try {
            this.resScoreDetailMapper.insert(resScoreDetail);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.saveScopeDetailModel.ex", (Throwable)e);
        }
    }

    private ResScoreDetail getScopeDetailModelById(Integer scoreDetailId) {
        if (null == scoreDetailId) {
            return null;
        }
        try {
            return this.resScoreDetailMapper.selectByPrimaryKey(scoreDetailId);
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.getScopeDetailModelById", (Throwable)e);
            return null;
        }
    }

    private ResScoreDetail getScopeDetailModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.resScoreDetailMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.getScopeDetailModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delScopeDetailModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.resScoreDetailMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.delScopeDetailModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResScoreServiceImpl.delScopeDetailModelByCode.num");
        }
    }

    private void deleteScopeDetailModel(Integer scoreDetailId) throws ApiException {
        if (null == scoreDetailId) {
            return;
        }
        int i = 0;
        try {
            i = this.resScoreDetailMapper.deleteByPrimaryKey(scoreDetailId);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.deleteScopeDetailModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResScoreServiceImpl.deleteScopeDetailModel.num");
        }
    }

    private void updateScopeDetailModel(ResScoreDetail resScoreDetail) throws ApiException {
        if (null == resScoreDetail) {
            return;
        }
        int i = 0;
        try {
            i = this.resScoreDetailMapper.updateByPrimaryKeySelective(resScoreDetail);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.updateScopeDetailModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("res.ResScoreServiceImpl.updateScopeDetailModel.num");
        }
    }

    private void updateStateScopeDetailModel(Integer scoreDetailId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == scoreDetailId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scoreDetailId", scoreDetailId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.resScoreDetailMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.updateStateScopeDetailModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("res.ResScoreServiceImpl.updateStateScopeDetailModel.null");
        }
    }

    private ResScoreDetail makeScopeDetail(ResScoreDetailDomain resScoreDetailDomain, ResScoreDetail resScoreDetail) {
        if (null == resScoreDetailDomain) {
            return null;
        }
        if (null == resScoreDetail) {
            resScoreDetail = new ResScoreDetail();
        }
        try {
            BeanUtils.copyAllPropertys((Object)resScoreDetail, (Object)resScoreDetailDomain);
            return resScoreDetail;
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.makeScopeDetail", (Throwable)e);
            return null;
        }
    }

    private List<ResScoreDetail> queryScopeDetailModelPage(Map<String, Object> parammap) {
        try {
            return this.resScoreDetailMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.queryScopeDetailModel", (Throwable)e);
            return null;
        }
    }

    private int countScopeDetail(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.resScoreDetailMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.countScopeDetail", (Throwable)e);
        }
        return i;
    }

    private ResScoreReDomain makeScoreReDomain(ResScore resScore) {
        if (resScore == null) {
            return null;
        }
        try {
            ResScoreReDomain scoreRed = new ResScoreReDomain();
            BeanUtils.copyAllPropertys((Object)scoreRed, (Object)resScore);
            return scoreRed;
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.makeScoreReDomain.ex", (Throwable)e);
            return null;
        }
    }

    private List<ResScoreDetailReDomain> makeScoreDetailReDomainList(List<ResScoreDetail> scoreDetailList) {
        if (ListUtil.isEmpty(scoreDetailList)) {
            return null;
        }
        try {
            ArrayList<ResScoreDetailReDomain> reDomainList = new ArrayList<ResScoreDetailReDomain>();
            for (ResScoreDetail resScoreDetail : scoreDetailList) {
                ResScoreDetailReDomain reDomain = new ResScoreDetailReDomain();
                BeanUtils.copyAllPropertys((Object)reDomain, (Object)resScoreDetail);
                reDomainList.add(reDomain);
            }
            return reDomainList;
        }
        catch (Exception e) {
            this.logger.error("res.ResScoreServiceImpl.makeScoreDetailReDomainList.ex", (Throwable)e);
            return null;
        }
    }

    private ResScoreReDomain getByBGCode(String type, String bgCode, String tenantCode) {
        try {
            HashMap<String, Object> scoreMap = new HashMap<String, Object>();
            scoreMap.put("scoreType", type);
            scoreMap.put("memberBgCode", bgCode);
            scoreMap.put("tenantCode", tenantCode);
            ResScoreReDomain scoreRedoamin = this.makeScoreReDomain(this.resScoreMapper.getByBGCode(scoreMap));
            if (scoreRedoamin == null) {
                return null;
            }
            HashMap<String, Object> detailParMap = new HashMap<String, Object>();
            detailParMap.put("scoreDetailObject", type);
            detailParMap.put("scoreCode", scoreRedoamin.getScoreCode());
            detailParMap.put("tenantCode", tenantCode);
            scoreRedoamin.setScoreDetailReDomainList(this.makeScoreDetailReDomainList(this.resScoreDetailMapper.query(detailParMap)));
            return scoreRedoamin;
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.getByBGCode.ex", (Throwable)e);
        }
    }

    private Map<String, Double> evaluateScoreConfig(String type, String tenantCode) {
        String evaluateValuesConfig;
        HashMap<String, Double> evbMap = new HashMap<String, Double>();
        if ("shop".equals(type)) {
            evaluateValuesConfig = this.resConfigService.saveGetConfigByKey(ResConfigKey.EVALUATE_VALUES_BUSINESS, tenantCode);
        } else if ("goods".equals(type)) {
            evaluateValuesConfig = this.resConfigService.saveGetConfigByKey(ResConfigKey.EVALUATE_VALUES_GOODS, tenantCode);
        } else {
            throw new ApiException("res.ResScoreServiceImpl.evaluateScoreConfig.type", "\u7c7b\u578b\u6709\u8bef");
        }
        if (StringUtils.isBlank((String)evaluateValuesConfig)) {
            return evbMap;
        }
        try {
            String[] evbStrs;
            for (String v : evbStrs = evaluateValuesConfig.split(";")) {
                String[] kv = v.split("=");
                evbMap.put(kv[0], Double.valueOf(kv[1]));
            }
            return evbMap;
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.evaluateValuesShop.ex", (Throwable)e);
        }
    }

    private ResScoreReDomain makeScoreDomainForGoods(ResEvaluateGoodsReDomain evaluateGoods) {
        ResScoreReDomain scoreDomain = new ResScoreReDomain();
        scoreDomain.setAppmanageIcode(evaluateGoods.getAppmanageIcode());
        scoreDomain.setTenantCode(evaluateGoods.getTenantCode());
        scoreDomain.setScoreType("goods");
        scoreDomain.setMemberBgCode(evaluateGoods.getGoodsCode());
        scoreDomain.setMemberBgName(evaluateGoods.getGoodsName());
        scoreDomain.setScoreValue(0.0);
        return scoreDomain;
    }

    private ResScoreReDomain makeScoreDomainForShop(ResEvaluateShopReDomain evaluateShop) {
        ResScoreReDomain scoreDomain = new ResScoreReDomain();
        scoreDomain.setAppmanageIcode(evaluateShop.getAppmanageIcode());
        scoreDomain.setTenantCode(evaluateShop.getTenantCode());
        scoreDomain.setScoreType("shop");
        scoreDomain.setMemberBgCode(evaluateShop.getMemberCode());
        scoreDomain.setMemberBgName(evaluateShop.getMemberName());
        scoreDomain.setScoreValue(0.0);
        return scoreDomain;
    }

    private ResScoreDetailDomain makeScoreDetailDomain(ResScoreDomain score, ResEvaluateScopeReDomain escope, Double bsvalueD, Double currentScore) {
        ResScoreDetailDomain detailDomain = new ResScoreDetailDomain();
        detailDomain.setAppmanageIcode(score.getAppmanageIcode());
        detailDomain.setTenantCode(score.getTenantCode());
        detailDomain.setScoreCode(score.getScoreCode());
        detailDomain.setScoreDetailObject(score.getScoreType());
        detailDomain.setTemplateCode(escope.getTemplateCode());
        detailDomain.setTemplateTitle(escope.getTemplateTitle());
        detailDomain.setScoreDetailEnum(1);
        detailDomain.setScoreDetailScore(bsvalueD);
        detailDomain.setScoreDetailEnable(true);
        detailDomain.setScoreDetailTotal(currentScore);
        return detailDomain;
    }

    private Double updateBatchScoreDetail(ResScoreReDomain score, List<ResEvaluateScopeReDomain> evaBusiScopeList, List<ResEvaluateScopeReDomain> evaGoodsList, String tenantCode, String scoreDetailObject) throws ApiException {
        Map<String, Double> evbConfigMap = this.evaluateScoreConfig(scoreDetailObject, tenantCode);
        if (evbConfigMap.isEmpty()) {
            throw new ApiException("res.ResScoreServiceImpl.updateBatchScoreDetail.evbConfigMap.empty", "\u5173\u8054\u8bc4\u8bba\u6a21\u677f\u672a\u914d\u7f6e");
        }
        double finalScore = 0.0;
        try {
            ArrayList<ResEvaluateScopeReDomain> evaluateScopeList = new ArrayList<ResEvaluateScopeReDomain>();
            if (ListUtil.isNotEmpty(evaBusiScopeList)) {
                evaluateScopeList.addAll(evaBusiScopeList);
            }
            if (ListUtil.isNotEmpty(evaGoodsList)) {
                evaluateScopeList.addAll(evaGoodsList);
            }
            for (Map.Entry<String, Double> config : evbConfigMap.entrySet()) {
                ResEvaluateScopeDomain escope = null;
                if (escope == null && evaluateScopeList != null && !evaluateScopeList.isEmpty()) {
                    for (ResEvaluateScopeReDomain scope : evaluateScopeList) {
                        if (!config.getKey().equals(scope.getTemplateCode()) || !"option".equals(scope.getTemplateContentType())) continue;
                        escope = scope;
                        break;
                    }
                }
                if (escope == null) continue;
                ResScoreDetailReDomain detail = null;
                if (ListUtil.isNotEmpty(score.getScoreDetailReDomainList())) {
                    for (ResScoreDetailReDomain sd : score.getScoreDetailReDomainList()) {
                        if (!sd.getTemplateCode().equals(config.getKey())) continue;
                        detail = sd;
                        break;
                    }
                }
                Integer bsvalue = Integer.parseInt(escope.getEvaluateScopeValue());
                double bsvalueD = Double.parseDouble(escope.getEvaluateScopeValue());
                double currentScore = DoubleUtil.preciseMul((Double)bsvalueD, (Double)config.getValue());
                finalScore = DoubleUtil.preciseAdd((Double)finalScore, (Double)currentScore);
                if (detail == null) {
                    ResScoreDetailDomain detailDomain = this.makeScoreDetailDomain(score, (ResEvaluateScopeReDomain)escope, bsvalueD, currentScore);
                    this.saveScopeDetail(detailDomain);
                    continue;
                }
                detail.setScoreDetailTotal(detail.getScoreDetailTotal() + (double)bsvalue.intValue());
                detail.setScoreDetailEnum(detail.getScoreDetailEnum() + 1);
                detail.setScoreDetailScore(DoubleUtil.preciseAdd((Double)detail.getScoreDetailScore(), (Double)currentScore));
                this.updateScopeDetail(detail);
            }
            return finalScore;
        }
        catch (Exception e) {
            throw new ApiException("res.ResScoreServiceImpl.updateBatchScoreDetail.ex", (Throwable)e);
        }
    }

    @Override
    public String saveScore(ResScoreDomain resScoreDomain) throws ApiException {
        String msg = this.checkScore(resScoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResScoreServiceImpl.saveScore.checkScore", msg);
        }
        ResScore resScore = this.makeScore(resScoreDomain, null);
        this.setScoreDefault(resScore);
        this.saveScoreModel(resScore);
        return resScore.getScoreCode();
    }

    @Override
    public void updateScoreState(Integer scoreId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateScoreModel(scoreId, dataState, oldDataState);
    }

    @Override
    public void updateScore(ResScoreDomain resScoreDomain) throws ApiException {
        String msg = this.checkScore(resScoreDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResScoreServiceImpl.updateScore.checkScore", msg);
        }
        ResScore oldResScore = this.getScoreModelById(resScoreDomain.getScoreId());
        if (null == oldResScore) {
            throw new ApiException("res.ResScoreServiceImpl.updateScore.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ResScore resScore = this.makeScore(resScoreDomain, oldResScore);
        this.setScoreUpdataDefault(resScore);
        this.updateScoreModel(resScore);
    }

    @Override
    public ResScore getScore(Integer scoreId) {
        return this.getScoreModelById(scoreId);
    }

    @Override
    public void deleteScore(Integer scoreId) throws ApiException {
        this.deleteScoreModel(scoreId);
    }

    @Override
    public QueryResult<ResScore> queryScorePage(Map<String, Object> map) {
        List<ResScore> resScoreList = this.queryScoreModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countScore(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(resScoreList);
        return queryResult;
    }

    @Override
    public ResScore getScoreByCode(Map<String, Object> map) {
        return this.getScoreModelByCode(map);
    }

    @Override
    public void deleteScoreByCode(Map<String, Object> map) throws ApiException {
        this.delScoreModelByCode(map);
    }

    @Override
    public void updateScoresShop(ResEvaluateShopReDomain resEvaluateShopReDomain) {
        if (resEvaluateShopReDomain == null) {
            this.logger.error("res.ResScoreServiceImpl.updateScoresShop.params", (Object)"resEvaluateShopReDomain is null");
        }
        String tenantCode = resEvaluateShopReDomain.getTenantCode();
        ResScoreReDomain shopScore = this.getByBGCode("shop", resEvaluateShopReDomain.getMemberCode(), tenantCode);
        if (shopScore == null) {
            shopScore = this.makeScoreDomainForShop(resEvaluateShopReDomain);
            String code = this.saveScore(shopScore);
            if ((shopScore = this.makeScoreReDomain(this.getScoreModelByCode(this.getQueryMapParam("scoreCode,tenantCode", new Object[]{code, shopScore.getTenantCode()})))) == null) {
                throw new ApiException("res.ResScoreServiceImpl.updateScoresShop.secondSave.null", "\u4fdd\u5b58\u5931\u8d25");
            }
        }
        double totalScoreShop = this.updateBatchScoreDetail(shopScore, resEvaluateShopReDomain.getEvaluateScopeReList(), null, tenantCode, "shop");
        boolean totalScoreOn = Boolean.valueOf(this.resConfigService.saveGetConfigByKey(ResConfigKey.TOTAL_SCORE, tenantCode));
        if (totalScoreOn) {
            BigDecimal avgScoreShop = new BigDecimal((shopScore.getScoreValue() + totalScoreShop) / 2.0).setScale(2, RoundingMode.HALF_UP);
            shopScore.setScoreValue(avgScoreShop.doubleValue());
            this.updateScore(shopScore);
        }
        this.resEvaluateService.updateEvaluateShopState(resEvaluateShopReDomain.getEvaluateShopId(), 1, 0);
    }

    @Override
    public void updateScoresGoods(ResEvaluateGoodsReDomain resEvaluateGoodsReDomain) {
        double totalScoreGoods;
        if (resEvaluateGoodsReDomain == null) {
            this.logger.error("res.ResScoreServiceImpl.updateScoresGoods.params", (Object)"resEvaluateGoodsReDomain is null");
        }
        String tenantCode = resEvaluateGoodsReDomain.getTenantCode();
        ResScoreReDomain goodsScore = this.getByBGCode("goods", resEvaluateGoodsReDomain.getContractBillcode(), tenantCode);
        if (goodsScore == null) {
            goodsScore = this.makeScoreDomainForGoods(resEvaluateGoodsReDomain);
            String code = this.saveScore(goodsScore);
            if ((goodsScore = this.makeScoreReDomain(this.getScoreModelByCode(this.getQueryMapParam("scoreCode,tenantCode", new Object[]{code, goodsScore.getTenantCode()})))) == null) {
                throw new ApiException("res.ResScoreServiceImpl.updateScoresShop.secondSave.null", "\u4fdd\u5b58\u5931\u8d25");
            }
        }
        if ((totalScoreGoods = this.updateBatchScoreDetail(goodsScore, null, resEvaluateGoodsReDomain.getEvaluateScopeReList(), tenantCode, "goods").doubleValue()) < 0.0) {
            return;
        }
        boolean totalScoreOn = Boolean.valueOf(this.resConfigService.saveGetConfigByKey(ResConfigKey.TOTAL_SCORE, tenantCode));
        if (totalScoreOn) {
            BigDecimal avgScoreGoods = new BigDecimal((goodsScore.getScoreValue() + totalScoreGoods) / 2.0).setScale(2, RoundingMode.HALF_UP);
            goodsScore.setScoreValue(avgScoreGoods.doubleValue());
            this.updateScore(goodsScore);
        }
        this.resEvaluateService.updateEvaluateShopState(resEvaluateGoodsReDomain.getEvaluateGoodsId(), 1, 0);
    }

    @Override
    public String saveScopeDetail(ResScoreDetailDomain resScoreDetailDomain) throws ApiException {
        String msg = this.checkScopeDetail(resScoreDetailDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResScoreServiceImpl.saveScopeDetail.checkScopeDetail", msg);
        }
        ResScoreDetail resScoreDetail = this.makeScopeDetail(resScoreDetailDomain, null);
        this.setScopeDetailDefault(resScoreDetail);
        this.saveScopeDetailModel(resScoreDetail);
        return resScoreDetail.getScoreDetailCode();
    }

    @Override
    public void updateScopeDetailState(Integer scoreDetailId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateScopeDetailModel(scoreDetailId, dataState, oldDataState);
    }

    @Override
    public void updateScopeDetail(ResScoreDetailDomain resScoreDetailDomain) throws ApiException {
        String msg = this.checkScopeDetail(resScoreDetailDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("res.ResScoreServiceImpl.updateScopeDetail.checkScopeDetail", msg);
        }
        ResScoreDetail oldResScoreDetail = this.getScopeDetailModelById(resScoreDetailDomain.getScoreDetailId());
        if (null == oldResScoreDetail) {
            throw new ApiException("res.ResScoreServiceImpl.updateScopeDetail.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        ResScoreDetail resScoreDetail = this.makeScopeDetail(resScoreDetailDomain, oldResScoreDetail);
        this.setScopeDetailUpdataDefault(resScoreDetail);
        this.updateScopeDetailModel(resScoreDetail);
    }

    @Override
    public ResScoreDetail getScopeDetail(Integer scoreDetailId) {
        return this.getScopeDetailModelById(scoreDetailId);
    }

    @Override
    public void deleteScopeDetail(Integer scoreDetailId) throws ApiException {
        this.deleteScopeDetailModel(scoreDetailId);
    }

    @Override
    public QueryResult<ResScoreDetail> queryScopeDetailPage(Map<String, Object> map) {
        List<ResScoreDetail> resScoreDetailList = this.queryScopeDetailModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countScopeDetail(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(resScoreDetailList);
        return queryResult;
    }

    @Override
    public ResScoreDetail getScopeDetailByCode(Map<String, Object> map) {
        return this.getScopeDetailModelByCode(map);
    }

    @Override
    public void deleteScopeDetailByCode(Map<String, Object> map) throws ApiException {
        this.delScopeDetailModelByCode(map);
    }
}

