/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.exception.handler.service;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.router.ApiExceptionParam;
import com.yqbsoft.laser.service.esb.core.router.ErrorApiException;
import com.yqbsoft.laser.service.esb.core.router.ExceptionHandler;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.exception.handler.util.ExceptionHandleContext;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.core.ProxyMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExceptionHandlerImpl
extends BaseServiceImpl
implements ExceptionHandler {
    private static final String SYS_CODE = "ExceptionHandlerImpl";
    public static final Integer EXCEPTION_MSG_TYPE = 0;
    public static final Integer PARAM_RETYPE_DEF = 1;
    public static final Integer PARAM_RETYPE_IN = 0;

    public void handle(ProxyMessage inMessage, OutMessage outMessage) {
        if ("OK".equals(outMessage.getOpErrorType())) {
            return;
        }
        String appapiCode = inMessage.getParam("method");
        String errorCode = outMessage.getOpErrorCode();
        ExceptionHandleContext exceptionHandleContext = new ExceptionHandleContext(this.makeApiException(this.getApiException(appapiCode), errorCode), this.getApiExceptionParamList(appapiCode));
        String reBody = this.executeReBody(exceptionHandleContext, inMessage, outMessage);
        if (StringUtils.isNotBlank((String)reBody)) {
            outMessage.setReObj((Object)reBody);
        }
    }

    private List<ErrorApiException> getApiException(String appapiCode) {
        Map apiExceptionMap = LocalCache.getApiExceptionMap();
        List apiExceptionList = null;
        if (MapUtil.isNotEmpty((Map)apiExceptionMap)) {
            apiExceptionList = (List)apiExceptionMap.get(appapiCode);
        }
        return apiExceptionList;
    }

    private ErrorApiException makeApiException(List<ErrorApiException> apiExceptionList, String errorCode) {
        if (ListUtil.isEmpty(apiExceptionList) || StringUtils.isBlank((String)errorCode)) {
            return null;
        }
        for (ErrorApiException apiException : apiExceptionList) {
            if (!errorCode.equals(apiException.getExceptionErrorCode())) continue;
            return apiException;
        }
        return null;
    }

    private List<ApiExceptionParam> getApiExceptionParamList(String appapiCode) {
        Map apiExceptionParamMap = LocalCache.getApiExceptionParamMap();
        List apiExceptionParamList = null;
        if (MapUtil.isNotEmpty((Map)apiExceptionParamMap)) {
            apiExceptionParamList = (List)apiExceptionParamMap.get(appapiCode);
        }
        return apiExceptionParamList;
    }

    private String executeReBody(ExceptionHandleContext exceptionHandleContext, ProxyMessage inMessage, OutMessage outMessage) {
        boolean saveFlag;
        ErrorApiException apiException = exceptionHandleContext.getApiException();
        if (apiException == null) {
            return null;
        }
        String reBody = null;
        if (ExceptionHandler.EXCEPTION_MSG_SAVE.equals(apiException.getExceptionSave()) && !(saveFlag = this.saveExceptionMsg(inMessage, outMessage, exceptionHandleContext.getApiException()))) {
            return null;
        }
        if (StringUtils.isNotBlank((String)apiException.getExceptionSucRevalue())) {
            reBody = apiException.getExceptionSucRevalue();
        } else {
            List<ApiExceptionParam> apiExceptionParamList = exceptionHandleContext.getApiExceptionParamList();
            if (apiExceptionParamList == null) {
                return null;
            }
            HashMap<String, Object> reMap = new HashMap<String, Object>();
            for (ApiExceptionParam apiExceptionParam : apiExceptionParamList) {
                String objcet = null;
                String paramName = apiExceptionParam.getParamName();
                if (PARAM_RETYPE_IN.equals(apiExceptionParam.getParamRetype())) {
                    objcet = inMessage.getParam(paramName);
                    if (objcet == null) {
                        this.logger.error(SYS_CODE, (Object)"exception param value not found in inMessage");
                        throw new ApiException("ExceptionHandlerImpl.paramValueNotFound", "exception param value not found in inMessage");
                    }
                } else {
                    objcet = apiExceptionParam.getParamDvalue();
                }
                Object putObj = this.convertObj(objcet, apiExceptionParam);
                reMap.put(paramName, putObj);
            }
            if (MapUtil.isNotEmpty(reMap)) {
                reBody = JsonUtil.buildNormalBinder().toJson(reMap);
            }
        }
        return reBody;
    }

    private boolean saveExceptionMsg(ProxyMessage inMessage, OutMessage outMessage, ErrorApiException apiException) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String body = JsonUtil.buildNormalBinder().toJson((Object)inMessage.getAllParamMap());
        HashMap<String, Object> emhExceptionMsgDomain = new HashMap<String, Object>();
        emhExceptionMsgDomain.put("exceptionCode", apiException.getExceptionCode());
        emhExceptionMsgDomain.put("appapiCode", apiException.getAppapiCode());
        emhExceptionMsgDomain.put("exceptionMsgType", EXCEPTION_MSG_TYPE);
        emhExceptionMsgDomain.put("exceptionMsgBody", body);
        paramMap.put("emhExceptionMsgDomain", JsonUtil.buildNormalBinder().toJson(emhExceptionMsgDomain));
        OutMessage reOutMessage = this.getInternalRouter().inInvokeOutMessage("emh.exception.saveExceptionMsg", "1.0", "0", paramMap);
        return "OK".equals(reOutMessage.getOpErrorType());
    }

    private Object convertObj(Object objcet, ApiExceptionParam apiExceptionParam) {
        if (objcet == null) {
            return null;
        }
        Object reObject = null;
        String typeClass = apiExceptionParam.getParamType();
        reObject = "Long".equals(typeClass) || "long".equals(typeClass) ? Long.valueOf(objcet.toString()) : ("Integer".equals(typeClass) || "int".equals(typeClass) ? Integer.valueOf(objcet.toString()) : ("Boolean".equals(typeClass) || "boolean".equals(typeClass) ? Boolean.valueOf(objcet.toString()) : ("Double".equals(typeClass) || "double".equals(typeClass) ? Double.valueOf(objcet.toString()) : objcet.toString())));
        return reObject;
    }
}

