/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.facerecognizer;

import com.yqbsoft.laser.service.tool.util.FileUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_highgui;
import org.bytedeco.javacpp.opencv_imgproc;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class FaceRecognizerUtil {
    public static opencv_core.IplImage convertImageToGreyScale(opencv_core.IplImage imageSrc) {
        opencv_core.IplImage imageGrey;
        if (imageSrc.nChannels() == 3) {
            imageGrey = opencv_core.cvCreateImage((opencv_core.CvSize)opencv_core.cvGetSize((opencv_core.CvArr)imageSrc), (int)8, (int)1);
            opencv_imgproc.cvCvtColor((opencv_core.CvArr)imageSrc, (opencv_core.CvArr)imageGrey, (int)6);
        } else {
            imageGrey = opencv_core.cvCloneImage((opencv_core.IplImage)imageSrc);
        }
        return imageGrey;
    }

    public static opencv_core.IplImage copyImage(opencv_core.IplImage img) {
        if (img.depth() != 8) {
            System.out.println("cropImage error : depth :" + img.depth());
        }
        opencv_core.IplImage imageTmp = opencv_core.cvCreateImage((opencv_core.CvSize)opencv_core.cvGetSize((opencv_core.CvArr)img), (int)8, (int)img.nChannels());
        opencv_core.cvCopy((opencv_core.CvArr)img, (opencv_core.CvArr)imageTmp);
        return imageTmp;
    }

    public static opencv_core.IplImage cropImage(opencv_core.IplImage img, opencv_core.CvRect region) {
        opencv_core.IplImage imageTmp = FaceRecognizerUtil.copyImage(img);
        opencv_core.cvSetImageROI((opencv_core.IplImage)imageTmp, (opencv_core.CvRect)region);
        opencv_core.IplImage imageRGB = opencv_core.cvCreateImage((opencv_core.CvSize)opencv_core.cvSize((int)region.width(), (int)region.height()), (int)8, (int)img.nChannels());
        opencv_core.cvCopy((opencv_core.CvArr)imageTmp, (opencv_core.CvArr)imageRGB);
        opencv_core.cvReleaseImage((opencv_core.IplImage)imageTmp);
        return imageRGB;
    }

    public static opencv_core.IplImage resizeImage(opencv_core.IplImage origImg, int newWidth, int newHeight) {
        opencv_core.IplImage outImg = null;
        int origWidth = 0;
        int origHeight = 0;
        if (origImg != null) {
            origWidth = origImg.width();
            origHeight = origImg.height();
        }
        if (newWidth <= 0 || newHeight <= 0 || origImg == null || origWidth <= 0 || origHeight <= 0) {
            System.exit(1);
        }
        outImg = opencv_core.cvCreateImage((opencv_core.CvSize)opencv_core.cvSize((int)newWidth, (int)newHeight), (int)origImg.depth(), (int)origImg.nChannels());
        if (newWidth > origImg.width() && newHeight > origImg.height()) {
            opencv_core.cvResetImageROI((opencv_core.IplImage)origImg);
            opencv_imgproc.cvResize((opencv_core.CvArr)origImg, (opencv_core.CvArr)outImg, (int)1);
        } else {
            opencv_core.cvResetImageROI((opencv_core.IplImage)origImg);
            opencv_imgproc.cvResize((opencv_core.CvArr)origImg, (opencv_core.CvArr)outImg, (int)3);
        }
        return outImg;
    }

    public static String writeToFile(String content, String filePath, String fileName) {
        File file;
        if (StringUtils.isBlank((String)fileName)) {
            System.out.println("fileName is null");
            return null;
        }
        if (StringUtils.isBlank((String)filePath)) {
            System.out.println("filePath is null");
            return null;
        }
        String path = filePath.substring(1);
        System.out.println(path);
        File dir = new File(path);
        if (!dir.exists()) {
            FileUtil.makeDir((File)dir);
        }
        if (!(file = new File(path, fileName)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (file.isFile()) {
            try {
                FileUtil.writeFile((File)file, (String)FaceRecognizerUtil.formatXML(content), (String)"UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return path + "/" + fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXML(String inputXML) throws Exception {
        if (StringUtils.isBlank((String)inputXML)) {
            return "";
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(inputXML));
        String requestXML = null;
        XMLWriter writer = null;
        if (document != null) {
            try {
                StringWriter stringWriter = new StringWriter();
                OutputFormat format = new OutputFormat(" ", true);
                writer = new XMLWriter((Writer)stringWriter, format);
                writer.write(document);
                writer.flush();
                requestXML = stringWriter.getBuffer().toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return requestXML;
    }

    public static String writeImageToFile(opencv_core.IplImage image, String filePath, String fileName) {
        File file;
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(filePath, fileName)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (file.isFile()) {
            try {
                opencv_highgui.cvSaveImage((String)file.getPath(), (opencv_core.CvArr)image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return filePath;
    }

    public static String getStrFromFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        String fileContent = FileUtil.readFile((File)file, (String)"UTF-8");
        return fileContent;
    }

    public static opencv_core.IplImage getGreyIplImageByPath(String path) {
        opencv_core.IplImage src = opencv_highgui.cvLoadImage((String)path);
        opencv_core.IplImage greyImg = FaceRecognizerUtil.convertImageToGreyScale(src);
        return greyImg;
    }

    public static opencv_core.IplImage cutHalfImage(opencv_core.IplImage image) {
        opencv_core.CvRect r = new opencv_core.CvRect();
        r.x(image.width() / 2);
        r.y(0);
        r.width(image.width() / 2);
        r.height(image.height());
        opencv_core.IplImage re = FaceRecognizerUtil.cropImage(image, r);
        return re;
    }

    public static String readFile(String filePath, String fileName) {
        File file;
        if (StringUtils.isBlank((String)fileName)) {
            System.out.println("fileName is null");
            return null;
        }
        if (StringUtils.isBlank((String)filePath)) {
            System.out.println("filePath is null");
            return null;
        }
        String path = filePath.substring(1);
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(path, fileName)).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (file.isFile()) {
            try {
                String content = FileUtil.readFile((File)file, (String)"UTF-8");
                return content;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String path = "g:/yqId.jpg";
        path = "data.xml";
        String content = FaceRecognizerUtil.readFile("f", path);
        try {
            System.out.println(FaceRecognizerUtil.formatXML(content));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static opencv_core.IplImage prepareImageByType(opencv_core.IplImage greyImage, String type) {
        opencv_core.IplImage copyImage = FaceRecognizerUtil.copyImage(greyImage);
        if (!"FACE".equals(type)) {
            if ("EYE".equals(type)) {
                copyImage = FaceRecognizerUtil.getImageEye(copyImage);
            } else if ("MOUSE".equals(type)) {
                copyImage = FaceRecognizerUtil.copyImage(copyImage);
            } else if (!"NOISE".equals(type) && "BLOW".equals(type)) {
                copyImage = FaceRecognizerUtil.getImageBlow(copyImage);
            }
        }
        return copyImage;
    }

    private static opencv_core.IplImage getImageBlow(opencv_core.IplImage image) {
        opencv_core.CvRect r = new opencv_core.CvRect();
        r.x(0);
        r.y(0);
        r.width(image.width());
        r.height(image.height() / 2);
        opencv_core.IplImage re = FaceRecognizerUtil.cropImage(image, r);
        return re;
    }

    private static opencv_core.IplImage getImageNOISE(opencv_core.IplImage image) {
        opencv_core.CvRect r = new opencv_core.CvRect();
        r.x(0);
        r.y(image.height() / 4);
        r.width(image.width());
        r.height(image.height() / 2);
        opencv_core.IplImage re = FaceRecognizerUtil.cropImage(image, r);
        return re;
    }

    private static opencv_core.IplImage getImageMOUSE(opencv_core.IplImage image) {
        opencv_core.CvRect r = new opencv_core.CvRect();
        r.x(0);
        r.y(image.height() / 2);
        r.width(image.width());
        r.height(image.height() / 2);
        opencv_core.IplImage re = FaceRecognizerUtil.cropImage(image, r);
        return re;
    }

    public static opencv_core.IplImage getImageEye(opencv_core.IplImage image) {
        opencv_core.CvRect r = new opencv_core.CvRect();
        r.x(0);
        r.y(0);
        r.width(image.width());
        r.height(image.height() / 2);
        opencv_core.IplImage re = FaceRecognizerUtil.cropImage(image, r);
        return re;
    }
}

