/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.facerecognizer.process;

import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.facerecognizer.FaceRecognizerUtil;
import com.yqbsoft.laser.service.facerecognizer.domain.RmrFaceDataDomainBean;
import com.yqbsoft.laser.service.facerecognizer.model.RmrFaceData;
import com.yqbsoft.laser.service.facerecognizer.service.RmrFaceDataService;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.bytedeco.javacpp.FloatPointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_highgui;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacpp.opencv_legacy;

public class FaceTrainProcess {
    public final String SYS_CODE = "RMR.FaceRecognizer.FaceTrainProcess";
    RmrFaceDataService rmrFaceDataService = (RmrFaceDataService)SpringApplicationContextUtil.getBean((String)"rmrFaceDataService");
    public int nPersons = 0;
    public int nEigens = 0;
    public opencv_core.CvMat personNumTruthMat;
    public opencv_core.CvMat eigenValMat;
    public opencv_core.CvMat projectedTrainFaceMat;
    public opencv_core.CvMat trainPersonNumMat;
    String filePath;
    String fileName;
    opencv_core.IplImage[] eigenVectArr;
    opencv_core.IplImage[] trainingFaceImgArr;
    opencv_core.IplImage[] testFaceImgArr;
    opencv_core.IplImage pAvgTrainImg;
    public String personName;
    public double g_confidence = 0.0;
    RmrFaceData rmrFaceData;

    public RmrFaceDataService getRmrFaceDataService() {
        return this.rmrFaceDataService;
    }

    public void setRmrFaceDataService(RmrFaceDataService rmrFaceDataService) {
        this.rmrFaceDataService = rmrFaceDataService;
    }

    public FaceTrainProcess(String rmrUserCode, String type) throws IOException {
        this.rmrFaceData = this.rmrFaceDataService.getFaceDataByType(rmrUserCode, type);
        this.filePath = this.getClass().getResource("/").getPath() + "data/" + rmrUserCode + "/" + type;
        this.fileName = "data.xml";
        this.trainPersonNumMat = this.loadTrainingData(rmrUserCode, type);
    }

    public void learn(List<opencv_core.IplImage> list, String rmrUserCode, String type) {
        System.out.println("\u5f00\u59cb\u8bad\u7ec3\u4efb\u52a1\uff0c\u7528\u6237\u7f16\u7801\uff1a " + rmrUserCode);
        this.trainingFaceImgArr = this.loadFaceImgArray(list);
        System.out.println("Got " + this.trainingFaceImgArr.length + " training images");
        if (this.trainingFaceImgArr.length < 2) {
            System.out.println("\u81f3\u5c11\u9700\u8981\u4e00\u5f20\u8bad\u7ec3\u56fe\u7247\n\u8f93\u5165\u6837\u672c\u7a7a\u95f4\u4e2d\u53ea\u6709" + this.trainingFaceImgArr.length + "\u5f20\u56fe\u7247");
            return;
        }
        this.doPCA();
        System.out.println("projecting the training images onto the PCA subspace");
        this.projectedTrainFaceMat = opencv_core.cvCreateMat((int)this.trainingFaceImgArr.length, (int)this.nEigens, (int)opencv_core.CV_32FC1);
        for (int a = 0; a < this.trainingFaceImgArr.length; ++a) {
            for (int j = 0; j < this.nEigens; ++j) {
                this.projectedTrainFaceMat.put(a, j, 0.0);
            }
        }
        System.out.println("\u521b\u5efa\u8bad\u7ec3\u9762\u77e9\u9635 " + this.trainingFaceImgArr.length + " (nTrainFaces) rows and " + this.nEigens + " (nEigens) columns");
        if (this.trainingFaceImgArr.length < 2) {
            System.out.println("projectedTrainFaceMat contents:\n" + this.oneChannelCvMatToString(this.projectedTrainFaceMat));
        }
        FloatPointer floatPointer = new FloatPointer(this.nEigens);
        for (int i = 0; i < this.trainingFaceImgArr.length; ++i) {
            opencv_legacy.cvEigenDecomposite((opencv_core.IplImage)this.trainingFaceImgArr[i], (int)this.nEigens, (opencv_core.IplImage[])this.eigenVectArr, (int)0, null, (opencv_core.IplImage)this.pAvgTrainImg, (FloatPointer)floatPointer);
            if (this.trainingFaceImgArr.length < 2) {
                System.out.println("floatPointer: " + this.floatPointerToString(floatPointer));
            }
            for (int j1 = 0; j1 < this.nEigens; ++j1) {
                this.projectedTrainFaceMat.put(i, j1, (double)floatPointer.get(j1));
            }
        }
        if (this.trainingFaceImgArr.length < 2) {
            System.out.println("projectedTrainFaceMat after cvEigenDecomposite:\n" + this.projectedTrainFaceMat);
        }
        System.out.println("\u4fdd\u5b58\u8bad\u7ec3\u7ed3\u679c:" + this.filePath + "/" + this.fileName);
        this.storeTrainingData(rmrUserCode, type, this.trainingFaceImgArr.length);
        this.storeEigenfaceImages();
    }

    public opencv_core.IplImage[] loadFaceImgArray(List<opencv_core.IplImage> list) {
        if (list == null) {
            return null;
        }
        opencv_core.IplImage[] faceImgArr = new opencv_core.IplImage[list.size()];
        int nFaces = 0;
        Iterator<opencv_core.IplImage> i$ = list.iterator();
        while (i$.hasNext()) {
            opencv_core.IplImage iplImage;
            faceImgArr[nFaces] = iplImage = i$.next();
            ++nFaces;
        }
        this.personNumTruthMat = opencv_core.cvCreateMat((int)1, (int)nFaces, (int)opencv_core.CV_32SC1);
        for (int i = 0; i < nFaces; ++i) {
            this.personNumTruthMat.put(0, i, 0.0);
        }
        for (int iFace = 0; iFace < nFaces; ++iFace) {
            this.personNumTruthMat.put(0, iFace, 1.0);
        }
        return faceImgArr;
    }

    public void doPCA() {
        opencv_core.CvSize faceImgSize = new opencv_core.CvSize();
        this.nEigens = this.trainingFaceImgArr.length - 1;
        System.out.println("\u5f00\u59cb\u8fdb\u884cPCA\u5206\u6790\uff1a" + this.nEigens + (this.nEigens == 1 ? " eigenvalue" : " eigenvalues"));
        faceImgSize.width(this.trainingFaceImgArr[0].width());
        faceImgSize.height(this.trainingFaceImgArr[0].height());
        this.eigenVectArr = new opencv_core.IplImage[this.nEigens];
        for (int i = 0; i < this.nEigens; ++i) {
            this.eigenVectArr[i] = opencv_core.cvCreateImage((opencv_core.CvSize)faceImgSize, (int)32, (int)1);
        }
        this.eigenValMat = opencv_core.cvCreateMat((int)1, (int)this.nEigens, (int)opencv_core.CV_32FC1);
        this.pAvgTrainImg = opencv_core.cvCreateImage((opencv_core.CvSize)faceImgSize, (int)32, (int)1);
        opencv_core.CvTermCriteria calcLimit = opencv_core.cvTermCriteria((int)1, (int)this.nEigens, (double)1.0);
        System.out.println("\u8ba1\u7b97\u5e73\u5747\u56fe");
        opencv_legacy.cvCalcEigenObjects((int)this.trainingFaceImgArr.length, (opencv_core.IplImage[])this.trainingFaceImgArr, (opencv_core.IplImage[])this.eigenVectArr, (int)0, (int)0, null, (opencv_core.CvTermCriteria)calcLimit, (opencv_core.IplImage)this.pAvgTrainImg, (FloatPointer)this.eigenValMat.data_fl());
        opencv_core.cvNormalize((opencv_core.CvArr)this.eigenValMat, (opencv_core.CvArr)this.eigenValMat, (double)1.0, (double)0.0, (int)2, null);
        System.out.println("PCA\u5206\u6790\u5b8c\u6bd5");
    }

    public void storeTrainingData(String rmrUserCode, String type, int nTrainFaces) {
        System.out.println("RMR.FaceRecognizer.FaceTrainProcess.save data/facedata.xml");
        String path = (this.filePath + "/" + this.fileName).substring(1);
        FaceRecognizerUtil.writeToFile("", this.filePath, this.fileName);
        opencv_core.CvFileStorage fileStorage = opencv_core.cvOpenFileStorage((String)path, null, (int)1, null);
        opencv_core.cvWriteInt((opencv_core.CvFileStorage)fileStorage, (String)"nPersons", (int)1);
        opencv_core.cvWriteInt((opencv_core.CvFileStorage)fileStorage, (String)"nEigens", (int)this.nEigens);
        opencv_core.cvWriteInt((opencv_core.CvFileStorage)fileStorage, (String)"nTrainFaces", (int)nTrainFaces);
        opencv_core.cvWrite((opencv_core.CvFileStorage)fileStorage, (String)"trainPersonNumMat", (Pointer)this.personNumTruthMat);
        opencv_core.cvWrite((opencv_core.CvFileStorage)fileStorage, (String)"eigenValMat", (Pointer)this.eigenValMat);
        opencv_core.cvWrite((opencv_core.CvFileStorage)fileStorage, (String)"projectedTrainFaceMat", (Pointer)this.projectedTrainFaceMat);
        opencv_core.cvWrite((opencv_core.CvFileStorage)fileStorage, (String)"avgTrainImg", (Pointer)this.pAvgTrainImg);
        for (int i = 0; i < this.nEigens; ++i) {
            String varname = "eigenVect_" + i;
            opencv_core.cvWrite((opencv_core.CvFileStorage)fileStorage, (String)varname, (Pointer)this.eigenVectArr[i]);
        }
        this.rmrFaceDataService.deleteAllByUserCode(rmrUserCode, type);
        opencv_core.cvReleaseFileStorage((opencv_core.CvFileStorage)fileStorage);
        System.out.println(path);
        String content = FaceRecognizerUtil.getStrFromFile(path);
        RmrFaceDataDomainBean rmrFaceDataDomainBean = new RmrFaceDataDomainBean();
        rmrFaceDataDomainBean.setRmrFacedataValue(content);
        rmrFaceDataDomainBean.setRmrUserCode(rmrUserCode);
        rmrFaceDataDomainBean.setRmrFacedataType(type);
        this.rmrFaceDataService.saveFaceData(rmrFaceDataDomainBean);
    }

    public opencv_core.CvMat loadTrainingData(String rmrUserCode, String type) throws IOException {
        System.out.println("RMR.FaceRecognizer.FaceTrainProcess.loading training data");
        if (this.rmrFaceData == null) {
            return null;
        }
        String content = this.rmrFaceData.getRmrFacedataValue();
        System.out.println("RMR.FaceRecognizer.FaceTrainProcess.save data/facedata.xml");
        String path = (this.filePath + "/" + this.fileName).substring(1);
        System.out.println(path);
        String xml = null;
        try {
            xml = FaceRecognizerUtil.formatXML(content);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FaceRecognizerUtil.writeToFile(xml, this.filePath, this.fileName);
        opencv_core.CvMat pTrainPersonNumMat = null;
        opencv_core.CvFileStorage fileStorage = opencv_core.cvOpenFileStorage((String)path, null, (int)0, null);
        if (fileStorage == null) {
            System.out.println("Can't open training database file ");
            return null;
        }
        this.nPersons = opencv_core.cvReadIntByName((opencv_core.CvFileStorage)fileStorage, null, (String)"nPersons", (int)0);
        if (this.nPersons == 0) {
            System.out.println("loadTrainingData No people found in the training database 'data/facedata.xml'.");
            return null;
        }
        System.out.println(this.nPersons + " persons loadTrainingData read from the training database");
        this.nEigens = opencv_core.cvReadIntByName((opencv_core.CvFileStorage)fileStorage, null, (String)"nEigens", (int)0);
        Pointer pointer = opencv_core.cvReadByName((opencv_core.CvFileStorage)fileStorage, null, (String)"trainPersonNumMat");
        pTrainPersonNumMat = new opencv_core.CvMat(pointer);
        pointer = opencv_core.cvReadByName((opencv_core.CvFileStorage)fileStorage, null, (String)"eigenValMat");
        this.eigenValMat = new opencv_core.CvMat(pointer);
        pointer = opencv_core.cvReadByName((opencv_core.CvFileStorage)fileStorage, null, (String)"projectedTrainFaceMat");
        this.projectedTrainFaceMat = new opencv_core.CvMat(pointer);
        pointer = opencv_core.cvReadByName((opencv_core.CvFileStorage)fileStorage, null, (String)"avgTrainImg");
        this.pAvgTrainImg = new opencv_core.IplImage(pointer);
        this.eigenVectArr = new opencv_core.IplImage[this.nEigens];
        for (int i = 0; i < this.nEigens; ++i) {
            String varname = "eigenVect_" + i;
            pointer = opencv_core.cvReadByName((opencv_core.CvFileStorage)fileStorage, null, (String)varname);
            this.eigenVectArr[i] = new opencv_core.IplImage(pointer);
        }
        opencv_core.cvReleaseFileStorage((opencv_core.CvFileStorage)fileStorage);
        return pTrainPersonNumMat;
    }

    public void storeEigenfaceImages() {
        System.out.println("Saving the image of the average face as 'data/out_averageImage.bmp'");
        String path1 = (this.filePath + "/out_averageImage.jpg").substring(1);
        String path2 = (this.filePath + "/out_eigenfaces.jpg").substring(1);
        opencv_highgui.cvSaveImage((String)path1, (opencv_core.CvArr)this.pAvgTrainImg);
        System.out.println("Saving the " + this.nEigens + " eigenvector images as 'data/out_eigenfaces.bmp'");
        if (this.nEigens > 0) {
            int COLUMNS = 8;
            int nCols = Math.min(this.nEigens, COLUMNS);
            int nRows = 1 + this.nEigens / COLUMNS;
            int w = this.eigenVectArr[0].width();
            int h = this.eigenVectArr[0].height();
            opencv_core.CvSize size = opencv_core.cvSize((int)(nCols * w), (int)(nRows * h));
            opencv_core.IplImage bigImg = opencv_core.cvCreateImage((opencv_core.CvSize)size, (int)8, (int)1);
            for (int i = 0; i < this.nEigens; ++i) {
                opencv_core.IplImage byteImg = this.convertFloatImageToUcharImage(this.eigenVectArr[i]);
                int x = w * (i % COLUMNS);
                int y = h * (i / COLUMNS);
                opencv_core.CvRect ROI = opencv_core.cvRect((int)x, (int)y, (int)w, (int)h);
                opencv_core.cvSetImageROI((opencv_core.IplImage)bigImg, (opencv_core.CvRect)ROI);
                opencv_core.cvCopy((opencv_core.CvArr)byteImg, (opencv_core.CvArr)bigImg, null);
                opencv_core.cvResetImageROI((opencv_core.IplImage)bigImg);
                opencv_core.cvReleaseImage((opencv_core.IplImage)byteImg);
            }
            opencv_highgui.cvSaveImage((String)path2, (opencv_core.CvArr)bigImg);
            opencv_core.cvReleaseImage((opencv_core.IplImage)bigImg);
        }
    }

    public opencv_core.IplImage convertFloatImageToUcharImage(opencv_core.IplImage srcImg) {
        if (srcImg != null && srcImg.width() > 0 && srcImg.height() > 0) {
            double[] minVal = new double[1];
            double[] maxVal = new double[1];
            if (minVal[0] < -1.0E30) {
                minVal[0] = -1.0E30;
            }
            if (maxVal[0] > 1.0E30) {
                maxVal[0] = 1.0E30;
            }
            if (maxVal[0] - minVal[0] == 0.0) {
                maxVal[0] = minVal[0] + 0.001;
            }
            opencv_core.IplImage dstImg = opencv_core.cvCreateImage((opencv_core.CvSize)opencv_core.cvSize((int)srcImg.width(), (int)srcImg.height()), (int)8, (int)1);
            opencv_core.cvConvertScale((opencv_core.CvArr)srcImg, (opencv_core.CvArr)dstImg, (double)(255.0 / (maxVal[0] - minVal[0])), (double)(-minVal[0] * 255.0 / (maxVal[0] - minVal[0])));
            return dstImg;
        }
        return null;
    }

    public String floatPointerToString(FloatPointer floatPointer) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean isFirst = true;
        stringBuilder.append('[');
        for (int i = 0; i < floatPointer.capacity(); ++i) {
            if (isFirst) {
                isFirst = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(floatPointer.get(i));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String oneChannelCvMatToString(opencv_core.CvMat cvMat) {
        if (cvMat.channels() != 1) {
            throw new RuntimeException("illegal argument - CvMat must have one channel");
        }
        int type = cvMat.type();
        StringBuilder s = new StringBuilder("[ ");
        for (int i = 0; i < cvMat.rows(); ++i) {
            for (int j = 0; j < cvMat.cols(); ++j) {
                if (type != opencv_core.CV_32FC1 && type != opencv_core.CV_32SC1) {
                    throw new RuntimeException("illegal argument - CvMat must have one channel and type of float or signed integer");
                }
                s.append(cvMat.get(i, j));
                if (j >= cvMat.cols() - 1) continue;
                s.append(", ");
            }
            if (i >= cvMat.rows() - 1) continue;
            s.append("\n  ");
        }
        s.append(" ]");
        return s.toString();
    }

    public double detectAndCropFromImg(opencv_core.IplImage src, String type) {
        opencv_core.IplImage sizedImg = null;
        opencv_core.IplImage equalizedImg = null;
        opencv_core.CvFont font = new opencv_core.CvFont();
        opencv_core.cvInitFont((opencv_core.CvFont)font, (int)5, (double)1.0, (double)0.8, (double)1.0, (int)1, (int)16);
        sizedImg = FaceRecognizerUtil.resizeImage(src, 50, 50);
        equalizedImg = opencv_core.cvCreateImage((opencv_core.CvSize)opencv_core.cvGetSize((opencv_core.CvArr)sizedImg), (int)8, (int)1);
        opencv_imgproc.cvEqualizeHist((opencv_core.CvArr)sizedImg, (opencv_core.CvArr)equalizedImg);
        this.eigenDecomImg(equalizedImg);
        System.out.println("g_confidence:" + this.g_confidence);
        return this.g_confidence;
    }

    public void eigenDecomImg(opencv_core.IplImage src) {
        float confidence = 0.0f;
        int nearest = 0;
        int iNearest = 0;
        float[] projectedTestFace = new float[this.nEigens];
        opencv_legacy.cvEigenDecomposite((opencv_core.IplImage)src, (int)this.nEigens, (opencv_core.IplImage[])this.eigenVectArr, (int)0, null, (opencv_core.IplImage)this.pAvgTrainImg, (float[])projectedTestFace);
        FloatPointer pConfidence = new FloatPointer(new float[]{confidence});
        System.out.println("projectedTestFace:" + projectedTestFace);
        iNearest = this.findNearestNeighbor(projectedTestFace, new FloatPointer((Pointer)pConfidence));
        confidence = pConfidence.get();
        nearest = this.trainPersonNumMat.data_i().get(iNearest);
        this.personName = "";
        System.out.println("nearest:" + nearest);
        this.g_confidence = confidence;
    }

    private int findNearestNeighbor(float[] projectedTestFace, FloatPointer pConfidencePointer) {
        double leastDistSq = Double.MAX_VALUE;
        int i = 0;
        int iTrain = 0;
        int iNearest = 0;
        System.out.println(".......findNearestNeighbor.........");
        for (iTrain = 0; iTrain < projectedTestFace.length; ++iTrain) {
            double distSq = 0.0;
            for (i = 0; i < this.nEigens; ++i) {
                float projectedTrainFaceDistance = (float)this.projectedTrainFaceMat.get(iTrain, i);
                System.out.println("projectedTrainFaceDistance:" + projectedTrainFaceDistance);
                float d_i = projectedTestFace[i] - projectedTrainFaceDistance;
                distSq += (double)(d_i * d_i);
            }
            if (!(distSq < leastDistSq)) continue;
            leastDistSq = distSq;
            iNearest = iTrain;
            System.out.println("  training face " + (iTrain + 1) + " is the new best match, least squared distance: " + leastDistSq);
        }
        float pConfidence = (float)(1.0 - Math.sqrt(leastDistSq / (double)((projectedTestFace.length + 1) * this.nEigens)) / 255.0);
        pConfidencePointer.put(pConfidence);
        System.out.println("training face " + (iNearest + 1) + " is the final best match, confidence " + pConfidence);
        return iNearest;
    }

    public static void main(String[] args) throws IOException {
    }
}

