/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.facerecognizer.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.facerecognizer.dao.RmrFaceDataMapper;
import com.yqbsoft.laser.service.facerecognizer.domain.RmrFaceDataDomainBean;
import com.yqbsoft.laser.service.facerecognizer.model.RmrFaceData;
import com.yqbsoft.laser.service.facerecognizer.service.RmrFaceDataService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RmrFaceDataServiceImpl
extends BaseServiceImpl
implements RmrFaceDataService {
    public static final String SYS_CODE = "RMR.FaceRecognizer.RmrFaceDataServiceImpl";
    private RmrFaceDataMapper rmrFaceDataMapper;

    public void setRmrFaceDataMapper(RmrFaceDataMapper rmrFaceDataMapper) {
        this.rmrFaceDataMapper = rmrFaceDataMapper;
    }

    private Date getSysDate() {
        try {
            return this.rmrFaceDataMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceDataServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFaceData(RmrFaceDataDomainBean rmrFaceDataDomainBean) {
        if (null == rmrFaceDataDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFaceDataDefault(RmrFaceData rmrFaceData) {
        if (null == rmrFaceData) {
            return;
        }
        if (null == rmrFaceData.getDataState()) {
            rmrFaceData.setDataState(0);
        }
        if (null == rmrFaceData.getGmtCreate()) {
            rmrFaceData.setGmtCreate(this.getSysDate());
        }
        rmrFaceData.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.rmrFaceDataMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceDataServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFaceDataUpdataDefault(RmrFaceData rmrFaceData) {
        if (null == rmrFaceData) {
            return;
        }
        rmrFaceData.setGmtModified(this.getSysDate());
    }

    private void saveFaceDataModel(RmrFaceData rmrFaceData) throws ApiException {
        if (null == rmrFaceData) {
            return;
        }
        try {
            this.rmrFaceDataMapper.insert(rmrFaceData);
        }
        catch (Exception e) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceDataServiceImpl.saveFaceDataModel.ex", (Throwable)e);
        }
    }

    private RmrFaceData getFaceDataModelById(Integer rmrFacedataId) {
        if (null == rmrFacedataId) {
            return null;
        }
        try {
            return this.rmrFaceDataMapper.selectByPrimaryKey(rmrFacedataId);
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceDataServiceImpl.getFaceDataModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteFaceDataModel(Integer rmrFacedataId) throws ApiException {
        if (null == rmrFacedataId) {
            return;
        }
        int i = 0;
        try {
            i = this.rmrFaceDataMapper.deleteByPrimaryKey(rmrFacedataId);
        }
        catch (Exception e) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceDataServiceImpl.deleteFaceDataModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceDataServiceImpl.deleteFaceDataModel.num");
        }
    }

    private void updateFaceDataModel(RmrFaceData rmrFaceData) throws ApiException {
        if (null == rmrFaceData) {
            return;
        }
        try {
            this.rmrFaceDataMapper.updateByPrimaryKeySelective(rmrFaceData);
        }
        catch (Exception e) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceDataServiceImpl.updateFaceDataModel.ex", (Throwable)e);
        }
    }

    private void updateStateFaceDataModel(Integer rmrFacedataId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == rmrFacedataId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rmrFacedataId", rmrFacedataId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rmrFaceDataMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceDataServiceImpl.updateStateFaceDataModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceDataServiceImpl.updateStateFaceDataModel.null");
        }
    }

    private RmrFaceData makeFaceData(RmrFaceDataDomainBean rmrFaceDataDomainBean, RmrFaceData rmrFaceData) {
        if (null == rmrFaceDataDomainBean) {
            return null;
        }
        if (null == rmrFaceData) {
            rmrFaceData = new RmrFaceData();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rmrFaceData, (Object)rmrFaceDataDomainBean);
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceDataServiceImpl.makeFaceData", (Throwable)e);
        }
        return rmrFaceData;
    }

    private List<RmrFaceData> queryFaceDataModelPage(Map<String, Object> parammap) {
        try {
            return this.rmrFaceDataMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceDataServiceImpl.queryFaceDataModel", (Throwable)e);
            return null;
        }
    }

    private int countFaceData(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rmrFaceDataMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceDataServiceImpl.countFaceData", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveFaceData(RmrFaceDataDomainBean rmrFaceDataDomainBean) throws ApiException {
        String msg = this.checkFaceData(rmrFaceDataDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceDataServiceImpl.saveFaceData.checkFaceData", msg);
        }
        RmrFaceData rmrFaceData = this.makeFaceData(rmrFaceDataDomainBean, null);
        this.setFaceDataDefault(rmrFaceData);
        this.saveFaceDataModel(rmrFaceData);
    }

    @Override
    public void updateFaceDataState(Integer rmrFacedataId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaceDataModel(rmrFacedataId, dataState, oldDataState);
    }

    @Override
    public void updateFaceData(RmrFaceDataDomainBean rmrFaceDataDomainBean) throws ApiException {
        String msg = this.checkFaceData(rmrFaceDataDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceDataServiceImpl.updateFaceData.checkFaceData", msg);
        }
        RmrFaceData oldRmrFaceData = this.getFaceDataModelById(rmrFaceDataDomainBean.getRmrFacedataId());
        if (null == oldRmrFaceData) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceDataServiceImpl.updateFaceData.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RmrFaceData rmrFaceData = this.makeFaceData(rmrFaceDataDomainBean, oldRmrFaceData);
        this.setFaceDataUpdataDefault(rmrFaceData);
        this.updateFaceDataModel(rmrFaceData);
    }

    @Override
    public RmrFaceData getFaceData(Integer rmrFacedataId) {
        return this.getFaceDataModelById(rmrFacedataId);
    }

    @Override
    public void deleteFaceData(Integer rmrFacedataId) throws ApiException {
        this.deleteFaceDataModel(rmrFacedataId);
    }

    @Override
    public QueryResult<RmrFaceData> queryFaceDataPage(Map<String, Object> map) {
        List<RmrFaceData> rmrFaceDataList = this.queryFaceDataModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaceData(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rmrFaceDataList);
        return queryResult;
    }

    @Override
    public RmrFaceData getFaceDataByType(String rmrUserCode, String type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("rmrUserCode", rmrUserCode);
        paramMap.put("rmrFacedataType", type);
        List<RmrFaceData> list = this.queryFaceDataModelPage(paramMap);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public void deleteAllByUserCode(String rmrUserCode, String type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("rmrUserCode", rmrUserCode);
        paramMap.put("rmrFacedataType", type);
        List<RmrFaceData> list = this.queryFaceDataModelPage(paramMap);
        if (list != null && list.size() > 0) {
            for (RmrFaceData rmrFaceData : list) {
                this.deleteFaceData(rmrFaceData.getRmrFacedataId());
            }
        }
    }
}

