/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.facerecognizer.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.facerecognizer.FaceRecognizerConstants;
import com.yqbsoft.laser.service.facerecognizer.FaceRecognizerUtil;
import com.yqbsoft.laser.service.facerecognizer.model.RmrFaceDetect;
import com.yqbsoft.laser.service.facerecognizer.model.RmrFaceTrain;
import com.yqbsoft.laser.service.facerecognizer.model.RmrUserID;
import com.yqbsoft.laser.service.facerecognizer.process.FaceTrainProcess;
import com.yqbsoft.laser.service.facerecognizer.service.RmrFaceDataService;
import com.yqbsoft.laser.service.facerecognizer.service.RmrFaceDetectService;
import com.yqbsoft.laser.service.facerecognizer.service.RmrFaceRecognizerService;
import com.yqbsoft.laser.service.facerecognizer.service.RmrFaceTrainService;
import com.yqbsoft.laser.service.facerecognizer.service.RmrUserIDService;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.helper.opencv_core;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacpp.opencv_highgui;
import org.bytedeco.javacpp.opencv_imgproc;
import org.bytedeco.javacpp.opencv_objdetect;

public class RmrFaceRecognizerServiceImpl
extends BaseServiceImpl
implements RmrFaceRecognizerService {
    public static final String SYS_CODE = "RMR.FaceRecognizer.RmrFaceRecognizerServiceImpl";
    RmrFaceDataService rmrFaceDataService;
    RmrFaceDetectService rmrFaceDetectService;
    RmrFaceTrainService rmrFaceTrainService;
    RmrUserIDService rmrUserIDService;

    public RmrFaceDataService getRmrFaceDataService() {
        return this.rmrFaceDataService;
    }

    public void setRmrFaceDataService(RmrFaceDataService rmrFaceDataService) {
        this.rmrFaceDataService = rmrFaceDataService;
    }

    public RmrFaceDetectService getRmrFaceDetectService() {
        return this.rmrFaceDetectService;
    }

    public void setRmrFaceDetectService(RmrFaceDetectService rmrFaceDetectService) {
        this.rmrFaceDetectService = rmrFaceDetectService;
    }

    public RmrFaceTrainService getRmrFaceTrainService() {
        return this.rmrFaceTrainService;
    }

    public void setRmrFaceTrainService(RmrFaceTrainService rmrFaceTrainService) {
        this.rmrFaceTrainService = rmrFaceTrainService;
    }

    public RmrUserIDService getRmrUserIDService() {
        return this.rmrUserIDService;
    }

    public void setRmrUserIDService(RmrUserIDService rmrUserIDService) {
        this.rmrUserIDService = rmrUserIDService;
    }

    @Override
    public List<opencv_core.IplImage> imageDirFilter(String imageDirPath, String rmrUserCode) throws ApiException {
        ArrayList<String> fileList_filtered = new ArrayList<String>();
        ArrayList<opencv_core.IplImage> images = new ArrayList<opencv_core.IplImage>();
        this.imageDirFilterRe(imageDirPath, rmrUserCode, fileList_filtered, images);
        return images;
    }

    @Override
    public opencv_core.IplImage imageFilter(String imagePath, String rmrUserCode) throws ApiException {
        HashMap<String, List<opencv_core.IplImage>> result = new HashMap<String, List<opencv_core.IplImage>>();
        System.out.println("image path :" + imagePath + "\u5f00\u59cb\u9a8c\u8bc1");
        opencv_core.IplImage greyImg = null;
        for (String type : FaceRecognizerConstants.DetectionArray) {
            opencv_core.IplImage src = opencv_highgui.cvLoadImage((String)imagePath);
            greyImg = FaceRecognizerUtil.convertImageToGreyScale(src);
            if (this.detectiveAndCutByType(rmrUserCode, type, greyImg, result, false, true)) continue;
            System.out.println("image path :" + imagePath + "**********************\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
            return null;
        }
        System.out.println("image path :" + imagePath + "**********************\u9a8c\u8bc1\u901a\u8fc7");
        return greyImg;
    }

    @Override
    public String formatCutImage(String rmrUserCode) {
        return null;
    }

    @Override
    public String train(String rmrUserCode) {
        return null;
    }

    @Override
    public String compare(String rmrUserCode) {
        return null;
    }

    @Override
    public String recognizeProcess(String rmrUserCode) {
        long begin = new Date().getTime();
        System.out.println("begin--------------------------" + begin);
        HashMap<String, List<opencv_core.IplImage>> re_yb = new HashMap<String, List<opencv_core.IplImage>>();
        ArrayList<opencv_core.IplImage> yb = new ArrayList<opencv_core.IplImage>();
        List<RmrFaceTrain> prototypeList = this.rmrFaceTrainService.queryFaceTrainList(rmrUserCode);
        if (prototypeList == null) {
            this.logger.info("RMR.FaceRecognizer.RmrFaceRecognizerServiceImpl.formatCutImage.prototypeList.null");
            return null;
        }
        for (RmrFaceTrain rmrFaceTrain : prototypeList) {
            String filePath = rmrFaceTrain.getRmrFacetrainPath();
            if (StringUtils.isBlank((String)filePath)) {
                this.logger.info("RMR.FaceRecognizer.RmrFaceRecognizerServiceImpl.formatCutImage.iterator.rmrFaceTrain.filePath.null");
                continue;
            }
            opencv_core.IplImage greyImg = this.imageFilter(filePath, rmrUserCode);
            if (greyImg == null) continue;
            yb.add(greyImg);
        }
        System.out.println("\u6837\u672c\u9a8c\u8bc1\u5b8c\u6210\uff0c\u5df2\u8fc7\u6ee4\u4e0d\u5408\u89c4\u8303\u7684\u56fe\u7247\uff08\u7279\u5f81\u7ec4\u4ef6\u4e2a\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff09\uff0c\u5f85\u526a\u5207\u7684\u56fe\u7247\u4e00\u5171\u6709\uff1a" + yb.size());
        for (opencv_core.IplImage greyImg : yb) {
            for (String type : FaceRecognizerConstants.DetectionArray) {
                this.detectiveAndCutByType(rmrUserCode, type, greyImg, re_yb, true, true);
            }
        }
        long end1 = new Date().getTime();
        System.out.println("\u6837\u672c\u88c1\u526a\u5b8c\u6bd5 \uff0c\u8017\u65f6:" + (end1 - begin) / 1000L + "s");
        System.out.println("\u7ec4\u4ef6\u4e2a\u6570\u5927\u5c0f(\u6b63\u5e38\u5e94\u8be5\u662f5\u4e2a):" + re_yb.size());
        for (String key : re_yb.keySet()) {
            String type = key.substring(8);
            List resource = (List)re_yb.get(key);
            System.out.println("\u7ec4\u4ef6\uff1a" + type + ",\u6837\u672c\u7a7a\u95f4\u5927\u5c0f\uff1a" + resource.size());
            try {
                FaceTrainProcess faceTrainProcess = new FaceTrainProcess(rmrUserCode, type);
                faceTrainProcess.learn(resource, rmrUserCode, type);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long end2 = new Date().getTime();
        System.out.println("\u8bad\u7ec3\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a" + (end2 - end1) / 1000L + "s");
        opencv_core.IplImage ID_image = this.getIdImageByUserCode(rmrUserCode);
        opencv_core.IplImage ID_half = FaceRecognizerUtil.cutHalfImage(ID_image);
        HashMap<String, List<opencv_core.IplImage>> result_first = new HashMap<String, List<opencv_core.IplImage>>();
        for (String type : FaceRecognizerConstants.DetectionArray) {
            boolean isCut = true;
            boolean isFormat = false;
            if (this.detectiveAndCutByType(rmrUserCode, type, ID_half, result_first, isCut, isFormat)) continue;
            System.out.println("ID\u9a8c\u8bc1\u4e0d\u901a\u8fc7");
            return null;
        }
        System.out.println("ID\u9a8c\u8bc1\u901a\u8fc7");
        long end3 = new Date().getTime();
        System.out.println("\u8eab\u4efd\u8bc1\u683c\u5f0f\u5316\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end3 - end2) / 1000L + "s");
        HashMap<String, Double> map = new HashMap<String, Double>();
        System.out.println(result_first.size());
        for (String key : result_first.keySet()) {
            List l = (List)result_first.get(key);
            System.out.println(l.size());
            opencv_core.IplImage i = (opencv_core.IplImage)l.get(0);
            opencv_highgui.cvSaveImage((String)("d:/test_head" + key + ".jpg"), (opencv_core.CvArr)i);
            String type = key.substring(8);
            try {
                FaceTrainProcess faceTrainProcess = new FaceTrainProcess(rmrUserCode, type);
                System.out.println(faceTrainProcess.detectAndCropFromImg(i, type));
                System.out.println(type + ":" + faceTrainProcess.g_confidence);
                map.put(type, faceTrainProcess.g_confidence);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        double sum = 0.0;
        for (String key : map.keySet()) {
            double v = (Double)map.get(key);
            sum += v;
        }
        double avg = sum / 5.0;
        System.out.println("\u7ed3\u8bba\uff1a\u76f8\u4f3c\u5ea6\uff1a" + avg);
        long end4 = new Date().getTime();
        System.out.println("\u5bf9\u6bd4\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end4 - end3) / 1000L + "s");
        return null;
    }

    private opencv_core.IplImage getIdImageByUserCode(String rmrUserCode) {
        RmrUserID rmrUserID = this.rmrUserIDService.getUserIdByCode(rmrUserCode);
        if (rmrUserID == null) {
            return null;
        }
        if (StringUtils.isBlank((String)rmrUserID.getRmrUseridPath())) {
            return null;
        }
        opencv_core.IplImage greyImage = FaceRecognizerUtil.getGreyIplImageByPath(rmrUserID.getRmrUseridPath());
        return greyImage;
    }

    private boolean imageDirFilterRe(String imageDirPath, String rmrUserCode, List<String> list, List<opencv_core.IplImage> images) {
        ArrayList<String> fileList = new ArrayList<String>();
        this.getFiles(imageDirPath, fileList);
        int num = 0;
        for (String filePath : fileList) {
            opencv_core.IplImage image = this.imageFilter(rmrUserCode, filePath);
            if (image != null) {
                ++num;
                list.add(filePath);
                images.add(image);
            }
            if (num < 100) continue;
            this.rmrFaceTrainService.insertBatch(list, rmrUserCode, "FACE");
            return true;
        }
        return false;
    }

    private void getFiles(String dirPath, List<String> fileList) {
        File[] files;
        File root = new File(dirPath);
        for (File file : files = root.listFiles()) {
            if (file.isDirectory()) {
                this.getFiles(file.getAbsolutePath(), fileList);
                fileList.add(file.getAbsolutePath());
                continue;
            }
            fileList.add(file.getAbsolutePath().toString());
        }
    }

    private boolean detectiveAndCutByType(String rmrUserCode, String type, opencv_core.IplImage image, Map<String, List<opencv_core.IplImage>> result, boolean needCut, boolean needFormat) {
        opencv_objdetect.CvHaarClassifierCascade cascade = this.getCascadeByType(rmrUserCode, type);
        opencv_core.CvMemStorage storage = opencv_core.CvMemStorage.create();
        int flag = 9;
        opencv_core.CvSeq sign = opencv_objdetect.cvHaarDetectObjects((opencv_core.CvArr)image, (opencv_objdetect.CvHaarClassifierCascade)cascade, (opencv_core.CvMemStorage)storage, (double)1.1, (int)3, (int)flag);
        opencv_core.cvClearMemStorage((opencv_core.CvMemStorage)storage);
        if (sign.isNull() || StringUtils.isBlank((String)type)) {
            return false;
        }
        System.out.println(type + "\u7ec4\u4ef6\u68c0\u6d4b\u5230\uff1a" + sign.total() + "\u4e2a\uff0c\u662f\u5426\u9700\u8981\u8fdb\u884c\u526a\u5207\u64cd\u4f5c\uff1a" + needCut);
        for (int i = 0; i < FaceRecognizerConstants.DetectionNumArray.length; ++i) {
            int detectionNum = FaceRecognizerConstants.DetectionNumArray[i];
            String detectionType = FaceRecognizerConstants.DetectionArray[i];
            if ((!detectionType.equals(type) || detectionNum != sign.total()) && (!type.equals("EYE") || 3 != sign.total())) continue;
            if (needCut) {
                this.cutImage(image, rmrUserCode, type, sign, result, needFormat);
            }
            return true;
        }
        return false;
    }

    private void cutImage(opencv_core.IplImage greyImage, String rmrUserCode, String type, opencv_core.CvSeq sign, Map<String, List<opencv_core.IplImage>> result, boolean needFormat) {
        if (result == null) {
            this.logger.info("RMR.FaceRecognizer.RmrFaceRecognizerServiceImpl.cutImage.result.null");
            result = new HashMap<String, List<opencv_core.IplImage>>();
        }
        opencv_core.IplImage copyImage = FaceRecognizerUtil.prepareImageByType(greyImage, type);
        for (int i = 0; i < sign.total(); ++i) {
            opencv_core.CvRect r = new opencv_core.CvRect((Pointer)opencv_core.cvGetSeqElem((opencv_core.CvSeq)sign, (int)i));
            String fp = "f:/" + rmrUserCode + "/" + type;
            String fn = "src" + copyImage.address() + ".jpg";
            FaceRecognizerUtil.writeImageToFile(copyImage, fp, fn);
            opencv_core.cvSetImageROI((opencv_core.IplImage)copyImage, (opencv_core.CvRect)r);
            opencv_core.IplImage pDstImage = null;
            if (needFormat) {
                pDstImage = opencv_core.cvCreateImage((opencv_core.CvSize)opencv_core.cvSize((int)50, (int)50), (int)greyImage.depth(), (int)copyImage.nChannels());
                opencv_imgproc.cvResize((opencv_core.CvArr)copyImage, (opencv_core.CvArr)pDstImage, (int)3);
            } else {
                pDstImage = copyImage;
            }
            String fn2 = "src_cutted" + copyImage.address() + ".jpg";
            FaceRecognizerUtil.writeImageToFile(copyImage, fp, fn2);
            List<opencv_core.IplImage> list = result.get(rmrUserCode + type);
            if (list == null) {
                list = new ArrayList<opencv_core.IplImage>();
            }
            list.add(pDstImage);
            result.put(rmrUserCode + type, list);
        }
    }

    private opencv_objdetect.CvHaarClassifierCascade getCascadeByType(String rmrUserCode, String type) {
        opencv_objdetect.CvHaarClassifierCascade cascade = null;
        RmrFaceDetect rmrFaceDetect = this.rmrFaceDetectService.getFaceDetectByType(type);
        String filePath = this.getClass().getResource("/").getPath() + "data/" + rmrUserCode + "/" + type;
        String fileName = rmrFaceDetect.getRmrFacedetectName();
        FaceRecognizerUtil.writeToFile(rmrFaceDetect.getRmrFacedetectFile(), filePath, fileName);
        String path = filePath.substring(1) + "/" + fileName;
        cascade = new opencv_objdetect.CvHaarClassifierCascade(opencv_core.cvLoad((String)path));
        return cascade;
    }
}

