/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.facerecognizer.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.facerecognizer.dao.RmrFaceTrainMapper;
import com.yqbsoft.laser.service.facerecognizer.domain.RmrFaceTrainDomainBean;
import com.yqbsoft.laser.service.facerecognizer.model.RmrFaceTrain;
import com.yqbsoft.laser.service.facerecognizer.service.RmrFaceTrainService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RmrFaceTrainServiceImpl
extends BaseServiceImpl
implements RmrFaceTrainService {
    public static final String SYS_CODE = "RMR.FaceRecognizer.RmrFaceTrainServiceImpl";
    private RmrFaceTrainMapper rmrFaceTrainMapper;

    public void setrmrFaceTrainMapper(RmrFaceTrainMapper rmrFaceTrainMapper) {
        this.rmrFaceTrainMapper = rmrFaceTrainMapper;
    }

    private Date getSysDate() {
        try {
            return this.rmrFaceTrainMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFaceTrain(RmrFaceTrainDomainBean rmrFaceTrainDomainBean) {
        if (null == rmrFaceTrainDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFaceTrainDefault(RmrFaceTrain rmrFaceTrain) {
        if (null == rmrFaceTrain) {
            return;
        }
        if (null == rmrFaceTrain.getDataState()) {
            rmrFaceTrain.setDataState(0);
        }
        if (null == rmrFaceTrain.getGmtCreate()) {
            rmrFaceTrain.setGmtCreate(this.getSysDate());
        }
        rmrFaceTrain.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.rmrFaceTrainMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFaceTrainUpdataDefault(RmrFaceTrain rmrFaceTrain) {
        if (null == rmrFaceTrain) {
            return;
        }
        rmrFaceTrain.setGmtModified(this.getSysDate());
    }

    private void saveFaceTrainModel(RmrFaceTrain rmrFaceTrain) throws ApiException {
        if (null == rmrFaceTrain) {
            return;
        }
        try {
            this.rmrFaceTrainMapper.insert(rmrFaceTrain);
        }
        catch (Exception e) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.saveFaceTrainModel.ex", (Throwable)e);
        }
    }

    private RmrFaceTrain getFaceTrainModelById(Integer rmrFacetrainId) {
        if (null == rmrFacetrainId) {
            return null;
        }
        try {
            return this.rmrFaceTrainMapper.selectByPrimaryKey(rmrFacetrainId);
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.getFaceTrainModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteFaceTrainModel(Integer rmrFacetrainId) throws ApiException {
        if (null == rmrFacetrainId) {
            return;
        }
        int i = 0;
        try {
            i = this.rmrFaceTrainMapper.deleteByPrimaryKey(rmrFacetrainId);
        }
        catch (Exception e) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.deleteFaceTrainModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.deleteFaceTrainModel.num");
        }
    }

    private void updateFaceTrainModel(RmrFaceTrain rmrFaceTrain) throws ApiException {
        if (null == rmrFaceTrain) {
            return;
        }
        try {
            this.rmrFaceTrainMapper.updateByPrimaryKeySelective(rmrFaceTrain);
        }
        catch (Exception e) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.updateFaceTrainModel.ex", (Throwable)e);
        }
    }

    private void updateStateFaceTrainModel(Integer rmrFacetrainId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == rmrFacetrainId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rmrFacetrainId", rmrFacetrainId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.rmrFaceTrainMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.updateStateFaceTrainModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.updateStateFaceTrainModel.null");
        }
    }

    private RmrFaceTrain makeFaceTrain(RmrFaceTrainDomainBean rmrFaceTrainDomainBean, RmrFaceTrain rmrFaceTrain) {
        if (null == rmrFaceTrainDomainBean) {
            return null;
        }
        if (null == rmrFaceTrain) {
            rmrFaceTrain = new RmrFaceTrain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)rmrFaceTrain, (Object)rmrFaceTrainDomainBean);
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.makeFaceTrain", (Throwable)e);
        }
        return rmrFaceTrain;
    }

    private List<RmrFaceTrain> queryFaceTrainModelPage(Map<String, Object> parammap) {
        try {
            return this.rmrFaceTrainMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.queryFaceTrainModel", (Throwable)e);
            return null;
        }
    }

    private int countFaceTrain(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.rmrFaceTrainMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.countFaceTrain", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveFaceTrain(RmrFaceTrainDomainBean rmrFaceTrainDomainBean) throws ApiException {
        String msg = this.checkFaceTrain(rmrFaceTrainDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.saveFaceTrain.checkFaceTrain", msg);
        }
        RmrFaceTrain rmrFaceTrain = this.makeFaceTrain(rmrFaceTrainDomainBean, null);
        this.setFaceTrainDefault(rmrFaceTrain);
        this.saveFaceTrainModel(rmrFaceTrain);
    }

    @Override
    public void updateFaceTrainState(Integer rmrFacetrainId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaceTrainModel(rmrFacetrainId, dataState, oldDataState);
    }

    @Override
    public void updateFaceTrain(RmrFaceTrainDomainBean rmrFaceTrainDomainBean) throws ApiException {
        String msg = this.checkFaceTrain(rmrFaceTrainDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.updateFaceTrain.checkFaceTrain", msg);
        }
        RmrFaceTrain oldRmrFaceTrain = this.getFaceTrainModelById(rmrFaceTrainDomainBean.getRmrFacetrainId());
        if (null == oldRmrFaceTrain) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.updateFaceTrain.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        RmrFaceTrain rmrFaceTrain = this.makeFaceTrain(rmrFaceTrainDomainBean, oldRmrFaceTrain);
        this.setFaceTrainUpdataDefault(rmrFaceTrain);
        this.updateFaceTrainModel(rmrFaceTrain);
    }

    @Override
    public RmrFaceTrain getFaceTrain(Integer rmrFacetrainId) {
        return this.getFaceTrainModelById(rmrFacetrainId);
    }

    @Override
    public void deleteFaceTrain(Integer rmrFacetrainId) throws ApiException {
        this.deleteFaceTrainModel(rmrFacetrainId);
    }

    @Override
    public QueryResult<RmrFaceTrain> queryFaceTrainPage(Map<String, Object> map) {
        List<RmrFaceTrain> rmrFaceTrainList = this.queryFaceTrainModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaceTrain(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(rmrFaceTrainList);
        return queryResult;
    }

    @Override
    public void insertBatch(List<String> fileList_filtered, String rmrUserCode, String fileName) {
        this.deleteByRmrUserCode(rmrUserCode);
        if (fileList_filtered != null && !fileList_filtered.isEmpty()) {
            for (String filePath : fileList_filtered) {
                RmrFaceTrainDomainBean rmrFaceTrainDomainBean = new RmrFaceTrainDomainBean();
                rmrFaceTrainDomainBean.setRmrUserCode(rmrUserCode);
                rmrFaceTrainDomainBean.setRmrFacetrainPath(filePath);
                rmrFaceTrainDomainBean.setRmrFacetrainFilename(fileName);
                this.saveFaceTrain(rmrFaceTrainDomainBean);
            }
        }
    }

    private void deleteByRmrUserCode(String rmrUserCode) {
        if (StringUtils.isBlank((String)rmrUserCode)) {
            return;
        }
        try {
            this.rmrFaceTrainMapper.deleteByCode(rmrUserCode);
        }
        catch (Exception e) {
            throw new ApiException("RMR.FaceRecognizer.RmrFaceTrainServiceImpl.deleteByRmrUserCode.ex", (Throwable)e);
        }
    }

    @Override
    public List<RmrFaceTrain> queryFaceTrainList(String rmrUserCode) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("rmrUserCode", rmrUserCode);
        List<RmrFaceTrain> list = this.queryFaceTrainModelPage(paramsMap);
        return list;
    }
}

