/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.financetitile.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.financetitile.constants.FtFinanceTitileLevelEnum;
import com.yqbsoft.laser.service.financetitile.constants.FtFinanceTitileRangeEnum;
import com.yqbsoft.laser.service.financetitile.model.FtFinanceTitileDaily;
import com.yqbsoft.laser.service.financetitile.model.FtFinanceTitileTrial;
import com.yqbsoft.laser.service.financetitile.service.BaseFtFinanceTitileService;
import com.yqbsoft.laser.service.financetitile.service.FtFinanceTitileTrialService;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class FtFinanceTitileTrialServiceImpl
extends BaseFtFinanceTitileService
implements FtFinanceTitileTrialService {
    @Override
    public List<FtFinanceTitileTrial> getTrialRecords(String startDate, String endDate, String tenantCode) {
        if (StringUtils.hasBlank((String[])new String[]{startDate, endDate, tenantCode})) {
            throw new ApiException("ILLEGAL.PARAMS", "date,tenantCode can`t be blank");
        }
        List<FtFinanceTitileTrial> trialList = this.ftFinanceTitileDailyMapper.getTrialRecords(this.getQueryParamMap("startDate,endDate,financeTitileLevel,tenantCode", new Object[]{startDate.substring(0, 10), endDate.substring(0, 10), FtFinanceTitileLevelEnum.LEVEL_3.getCode(), tenantCode}));
        if (CollectionUtils.isEmpty(trialList)) {
            this.logger.info("RECORDS.NULL", (Object)"\u79d1\u76ee\u4f59\u989d\u8bd5\u7b97\u7ed3\u679c\u4e3a\u7a7a");
            return null;
        }
        this.setFaccountBalance(trialList, startDate, endDate);
        return trialList;
    }

    private void setFaccountBalance(List<FtFinanceTitileTrial> titileTrialList, String startDate, String endDate) {
        List<FtFinanceTitileTrial> titileTrials = this.getInnerTitileTrialRecords(titileTrialList);
        if (CollectionUtils.isEmpty(titileTrials)) {
            return;
        }
        Iterator<FtFinanceTitileTrial> iterator = titileTrialList.iterator();
        while (iterator.hasNext()) {
            FtFinanceTitileTrial trial = iterator.next();
            this.setFaccountBalanceWithNextToStartDate(trial, startDate);
            if (this.gtZero(trial.getFaccountCramount()) || this.gtZero(trial.getFaccountDeamount())) {
                this.setFaccountBalanceWithNextToEndDate(trial, endDate);
                continue;
            }
            if (this.gtZero(trial.getBeginingCrBalance()) || this.gtZero(trial.getBeginingDeBalance())) {
                trial.setFaccountCrabalance(trial.getBeginingCrBalance());
                trial.setFaccountDeabalance(trial.getBeginingDeBalance());
                continue;
            }
            iterator.remove();
        }
    }

    private List<FtFinanceTitileTrial> getInnerTitileTrialRecords(List<FtFinanceTitileTrial> titileTrialList) {
        if (CollectionUtils.isEmpty(titileTrialList)) {
            return null;
        }
        ArrayList<FtFinanceTitileTrial> results = new ArrayList<FtFinanceTitileTrial>();
        for (FtFinanceTitileTrial trial : titileTrialList) {
            if (!FtFinanceTitileRangeEnum.RANGE_INNER.getCode().equals(trial.getFaccountTitileRange())) continue;
            results.add(trial);
        }
        return results;
    }

    private void setFaccountBalanceWithNextToStartDate(FtFinanceTitileTrial trial, String startDate) {
        String pastStartDateOneDay = DateUtils.changeDateStrformat((String)startDate, (String)"yyyy-MM-dd", (String[])new String[]{"yyyy-MM-dd HH:mm:ss"});
        FtFinanceTitileDaily nearStartDateDaily = this.getFtFinanceTitileDailyNearDate(pastStartDateOneDay, trial.getFinanceTitileCode(), trial.getTenantCode());
        if (nearStartDateDaily == null) {
            return;
        }
        trial.setBeginingCrBalance(nearStartDateDaily.getFaccountCrabalance());
        trial.setBeginingDeBalance(nearStartDateDaily.getFaccountDeabalance());
    }

    private void setFaccountBalanceWithNextToEndDate(FtFinanceTitileTrial trial, String endDate) {
        String AfterEndDateOneDay = DateUtils.getAfterDate((String)endDate, (int)1, (String)"yyyy-MM-dd");
        FtFinanceTitileDaily nearEndDateDaily = this.getFtFinanceTitileDailyNearDate(AfterEndDateOneDay, trial.getFinanceTitileCode(), trial.getTenantCode());
        if (nearEndDateDaily == null) {
            return;
        }
        trial.setFaccountDeabalance(nearEndDateDaily.getFaccountDeabalance());
        trial.setFaccountCrabalance(nearEndDateDaily.getFaccountCrabalance());
    }
}

