/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.finterface.client.system.b2b;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.finterface.client.system.b2b.bean.DownloadFileDomainBean;
import com.yqbsoft.laser.service.finterface.client.system.b2b.bean.FileDomain;
import com.yqbsoft.laser.service.finterface.client.system.b2b.iface.SystemInterfaceServiceImpl;
import com.yqbsoft.laser.service.finterface.iface.b2b.bean.B2bSpuBean;
import com.yqbsoft.laser.service.finterface.iface.b2b.bean.ImageBean;
import com.yqbsoft.laser.service.finterface.iface.b2b.bean.ListingTypeEnum;
import com.yqbsoft.laser.service.finterface.iface.b2b.bean.PropsBean;
import com.yqbsoft.laser.service.finterface.iface.b2b.domain.B2bGoodsRequest;
import com.yqbsoft.laser.service.finterface.iface.b2b.v1.B2bGoodsService;
import com.yqbsoft.laser.service.finterface.iface.base.InterfaceRequest;
import com.yqbsoft.laser.service.suppercore.core.JsonReBean;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class SystemB2bGoodsServiceImpl
extends SystemInterfaceServiceImpl
implements B2bGoodsService {
    private static final String FILE_SORT_ATTACHMENT = "file_03";
    private static final String SAVE_RESOURCE_GOODS = "rs.resourceGoods.saveResourceGoods";
    private static final String UPDATE_RESOURCE_GOODS = "rs.resourceGoods.updateResourceGoods";
    private static final String DOWNLOAD_FILE = "fm.file.getDownloadFile";
    private static final String SAVE_FILE = "fm.file.saveFile";
    private static final String DELETE_FILE_BY_CODE = "fm.file.deleteFileByCode";
    private static final String SAVE_SKU = "rs.sku.saveSku";
    private static final String UPDATE_SKU = "rs.sku.updateSku";
    private static final String DEL_SKU_BY_CODE = "rs.sku.delSkuByCode";
    private static final String UPDATE_CANNEL_RESOURCE = "rs.resourceGoods.updateCannelResource";
    private static final String UPDATE_AH_RESOURCE = "rs.resourceGoods.updateAhResourceList";
    private static final String GET_SPU_BY_CODE = "rs.spu.getSpuByCode";
    private static final String GET_RESOURCE_BY_CODE = "rs.resourceGoods.getResourceGoodsByCode";

    public Object storeGoods(B2bGoodsRequest request) {
        assert (request != null);
        if (StringUtils.isBlank((String)request.getPntreeCode())) {
            throw new ApiException("PNTREE.MAPPING.MISSING", "\u5546\u54c1\u7c7b\u578b\u672a\u6dfb\u52a0\u6620\u5c04");
        }
        this.loadConfig((InterfaceRequest)request);
        String goodsCode = this.internalInvoke(SAVE_RESOURCE_GOODS, this.getQueryMapParam("rsResourceGoodsDomain", new Object[]{request}));
        return new JsonReBean((Object)goodsCode);
    }

    public Object updateGoods(B2bGoodsRequest request) {
        assert (request != null);
        if (StringUtils.hasBlank((String[])new String[]{request.getGoodsCode(), request.getPntreeCode()})) {
            throw new ApiException("PARAMS.MAPPING.MISSING", "\u5546\u54c1\u6216\u8005\u5546\u54c1\u7c7b\u578b\u672a\u6dfb\u52a0\u6620\u5c04");
        }
        this.loadConfig((InterfaceRequest)request);
        this.internalInvoke(UPDATE_RESOURCE_GOODS, this.getQueryMapParam("rsResourceGoodsDomain", new Object[]{request}));
        return new JsonReBean();
    }

    public Object storeGoodsImg(B2bGoodsRequest request) {
        String name;
        String fileType;
        assert (request != null);
        ImageBean goodsImage = request.getGoodsImage();
        assert (goodsImage != null && goodsImage.getImageCode() != null);
        if (StringUtils.hasBlank((String[])new String[]{request.getGoodsCode()})) {
            throw new ApiException("GOODS.MAPPING.MISSING", "\u5546\u54c1\u672a\u6dfb\u52a0");
        }
        this.loadConfig((InterfaceRequest)request);
        ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
        DownloadFileDomainBean imgFile = (DownloadFileDomainBean)this.getForObject(DOWNLOAD_FILE, DownloadFileDomainBean.class, this.getQueryMapParam("fileCode", new Object[]{goodsImage.getImageCode()}));
        if (imgFile == null || imgFile.getFilecontent() == null) {
            throw new ApiException("IMAGE.NOT.EXISTED", "\u56fe\u7247\u4e0d\u5b58\u5728");
        }
        String filename = goodsImage.getImageName();
        if (filename != null && filename.contains(".")) {
            fileType = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
            name = filename.substring(0, filename.lastIndexOf("."));
        } else {
            fileType = imgFile.getFileCtype();
            name = imgFile.getFileName();
        }
        FileDomain fileDomainBean = new FileDomain();
        fileDomainBean.setFileName(name);
        fileDomainBean.setFileType("1");
        fileDomainBean.setFileCtype(fileType);
        fileDomainBean.setFileSort(FILE_SORT_ATTACHMENT);
        fileDomainBean.setTenantCode(request.getTenantCode());
        fileDomainBean.setFlag(true);
        fileDomainBean.setRootPath(request.getTenantCode() + "/");
        fileDomainBean.setRelationCode(request.getGoodsCode());
        fileDomainBean.setFileSize(imgFile.getFilecontent().length);
        FileBean fileBean = new FileBean();
        fileBean.setBytes(imgFile.getFilecontent());
        fileBean.setFileType(fileType);
        fileBean.setOriginalFilename(name);
        fileBean.setBytes(fileBean.getBytes());
        fileBean.setSize(Long.valueOf(fileBean.getBytes().length));
        fileBeanList.add(fileBean);
        FileDomain result = (FileDomain)this.getForObject(SAVE_FILE, FileDomain.class, this.getQueryMapParam("fmFileDomainBean,fileBeanList", new Object[]{fileDomainBean, fileBeanList}));
        if (result == null) {
            throw new ApiException("Fail", "\u65b0\u589e\u5546\u54c1\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002");
        }
        return new JsonReBean((Object)result.getFileCode());
    }

    public Object deleteGoodsImg(B2bGoodsRequest request) {
        this.loadConfig((InterfaceRequest)request);
        ImageBean imageBean = request.getGoodsImage();
        assert (imageBean != null);
        if (StringUtils.hasBlank((String[])new String[]{request.getGoodsCode(), imageBean.getImageCode()})) {
            throw new ApiException("PARAMS.MAPPING.MISSING", "\u5546\u54c1\u672a\u6dfb\u52a0\u6216\u56fe\u7247\u672a\u6dfb\u52a0");
        }
        this.internalInvoke(DELETE_FILE_BY_CODE, this.getQueryMapParam("fileCode,tenantCode", new Object[]{imageBean.getImageCode(), request.getTenantCode()}));
        return new JsonReBean();
    }

    public Object storeSku(B2bGoodsRequest request) {
        B2bSpuBean b2bSpuBean;
        this.loadConfig((InterfaceRequest)request);
        if (StringUtils.isBlank((String)request.getGoodsCode())) {
            throw new ApiException("ILLEAGL.OPERATION", "\u5546\u54c1\u4fe1\u606f\u672a\u6dfb\u52a0");
        }
        if (StringUtils.isBlank((String)request.getBrandCode())) {
            throw new ApiException("BRAND.MAPPING.MISSING", "\u54c1\u724c\u672a\u6dfb\u52a0\u6620\u5c04");
        }
        if (StringUtils.isBlank((String)request.getPntreeCode())) {
            throw new ApiException("PNTREE.MAPPING.MISSING", "\u5546\u54c1\u7c7b\u578b\u672a\u6dfb\u52a0\u6620\u5c04");
        }
        if (ListUtil.isNotEmpty((Collection)request.getPropertiesList())) {
            for (PropsBean bean : request.getPropertiesList()) {
                if (StringUtils.isBlank((String)bean.getPropertiesCode())) {
                    throw new ApiException("SKU.MAPPING.MISSING", "\u5c5e\u6027\u672a\u6dfb\u52a0\u6620\u5c04");
                }
                bean.setTenantCode(request.getTenantCode());
            }
        }
        if (null == (b2bSpuBean = this.getSpuByCode(request.getTenantCode(), request.getBrandCode(), request.getPntreeCode()))) {
            throw new ApiException("SPU.MAPPING.MISSING", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684spu\u4fe1\u606f(spu\u4fe1\u606f\u672a\u7ef4\u62a4)");
        }
        request.setSpuCode(b2bSpuBean.getSpuCode());
        String skuCode = this.internalInvoke(SAVE_SKU, this.getQueryMapParam("rsSkuDomain", new Object[]{request}));
        return new JsonReBean((Object)skuCode);
    }

    public Object updateSku(B2bGoodsRequest request) {
        this.loadConfig((InterfaceRequest)request);
        if (StringUtils.hasBlank((String[])new String[]{request.getGoodsCode(), request.getSkuCode()})) {
            throw new ApiException("ILLEAGL.OPERATION", "\u5546\u54c1\u6216\u8005SKU\u4fe1\u606f\u672a\u6dfb\u52a0");
        }
        if (StringUtils.isBlank((String)request.getPntreeCode())) {
            throw new ApiException("PNTREE.MAPPING.MISSING", "\u5546\u54c1\u7c7b\u578b\u672a\u6dfb\u52a0\u6620\u5c04");
        }
        for (PropsBean bean : request.getPropertiesList()) {
            if (StringUtils.isBlankLoop((String[])new String[]{bean.getPropertiesCode(), bean.getPropertiesValueValue()})) {
                throw new ApiException("PARAMS.MAPPING.MISSING", "\u5c5e\u6027\u6620\u5c04\u672a\u6dfb\u52a0");
            }
            bean.setTenantCode(request.getTenantCode());
        }
        this.internalInvoke(UPDATE_SKU, this.getQueryMapParam("rsSkuDomain", new Object[]{request}));
        return new JsonReBean();
    }

    public Object deleteSku(B2bGoodsRequest request) {
        this.loadConfig((InterfaceRequest)request);
        if (StringUtils.isBlankLoop((String[])new String[]{request.getSkuCode(), request.getGoodsCode()})) {
            throw new ApiException("ILLEAGL.OPERATION", "\u5546\u54c1\u6216\u8005SKU\u4fe1\u606f\u672a\u6dfb\u52a0");
        }
        this.internalInvoke(DEL_SKU_BY_CODE, this.getQueryMapParam("map:skuCode,tenantCode", new Object[]{request.getSkuCode(), request.getTenantCode()}));
        return new JsonReBean();
    }

    public Object listingGoods(B2bGoodsRequest request) {
        this.loadConfig((InterfaceRequest)request);
        if (StringUtils.isBlank((String)request.getGoodsCode())) {
            throw new ApiException("ILLEAGL.OPERATION", "\u5546\u54c1\u672a\u6dfb\u52a0");
        }
        if (ListingTypeEnum.LISTING.getType().equals(request.getLisingType())) {
            this.updateAhResource(request);
        } else if (ListingTypeEnum.DELISTING.getType().equals(request.getLisingType())) {
            this.internalInvoke(UPDATE_CANNEL_RESOURCE, this.getQueryMapParam("rsResourceGoodsDomain", new Object[]{request}));
        } else {
            this.logger.error("SystemB2bGoodsServiceImpl.listingGoods", (Object)"lisingtype is unknown");
            throw new ApiException("UNSUPPORTED.OPERATION", "\u672a\u77e5\u7684\u64cd\u4f5c");
        }
        return new JsonReBean();
    }

    private B2bSpuBean getSpuByCode(String tenantCode, String brandCode, String pntreeCode) {
        assert (!StringUtils.hasBlank((String[])new String[]{tenantCode, brandCode, pntreeCode}));
        return (B2bSpuBean)this.getForObject(GET_SPU_BY_CODE, B2bSpuBean.class, this.getQueryMapParam("map:brandCode,pntreeCode,tenantCode", new Object[]{brandCode, pntreeCode, tenantCode}));
    }

    private void updateAhResource(B2bGoodsRequest goodsRequest) {
        List<B2bGoodsRequest> goodsRequests = Collections.singletonList(goodsRequest);
        HashMap<String, String> composeParams = new HashMap<String, String>();
        composeParams.put("goodsList", JsonUtil.buildNormalBinder().toJson(goodsRequests));
        composeParams.put("nodeCode", "00000022");
        composeParams.put("nodeName", "\u65e0\u9700\u5ba1\u6838");
        composeParams.put("userCode", goodsRequest.getOperatorBean().getUserCode());
        composeParams.put("userName", goodsRequest.getOperatorBean().getUserName());
        composeParams.put("tenantCode", goodsRequest.getOperatorBean().getTenantCode());
        B2bGoodsRequest bGoodsRequest = this.getRsGoods(goodsRequest.getTenantCode(), goodsRequest.getGoodsCode());
        HashMap<String, String> callMap = new HashMap<String, String>();
        callMap.put("goodsIds", "[" + bGoodsRequest.getGoodsId() + "]");
        composeParams.put("dataParam", JsonUtil.buildNormalBinder().toJson(callMap).replace("\"", "#26#"));
        this.internalInvoke(UPDATE_AH_RESOURCE, composeParams);
    }

    private B2bGoodsRequest getRsGoods(String tenantCode, String goodsCode) {
        return (B2bGoodsRequest)this.getForObject(GET_RESOURCE_BY_CODE, B2bGoodsRequest.class, this.getQueryMapParam("map:tenantCode,goodsCode", new Object[]{tenantCode, goodsCode}));
    }
}

