/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftUserlistMapper;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserBean;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserlistDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserlistReDomain;
import com.yqbsoft.laser.service.gt.domain.OcReorderDomain;
import com.yqbsoft.laser.service.gt.domain.OrgCompany;
import com.yqbsoft.laser.service.gt.domain.UmUserinfo;
import com.yqbsoft.laser.service.gt.model.GtGift;
import com.yqbsoft.laser.service.gt.model.GtGiftUserlist;
import com.yqbsoft.laser.service.gt.service.GtGiftService;
import com.yqbsoft.laser.service.gt.service.GtGiftUserService;
import com.yqbsoft.laser.service.gt.service.GtGiftUserlistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GtGiftUserlistServiceImpl
extends BaseServiceImpl
implements GtGiftUserlistService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftUserlistServiceImpl";
    private GtGiftService gtGiftService;
    private GtGiftUserService gtGiftUserService;
    private GtGiftUserlistMapper gtGiftUserlistMapper;
    private String api_userinfo = "um.user.getUserinfoByUserCode";

    public void setGtGiftUserService(GtGiftUserService gtGiftUserService) {
        this.gtGiftUserService = gtGiftUserService;
    }

    public void setGtGiftService(GtGiftService gtGiftService) {
        this.gtGiftService = gtGiftService;
    }

    public void setGtGiftUserlistMapper(GtGiftUserlistMapper gtGiftUserlistMapper) {
        this.gtGiftUserlistMapper = gtGiftUserlistMapper;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftUserlistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftUserlist(GtGiftUserlistDomain gtGiftUserlistDomain) {
        if (null == gtGiftUserlistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftUserlistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftUserlistDefault(GtGiftUserlist gtGiftUserlist) {
        if (null == gtGiftUserlist) {
            return;
        }
        if (null == gtGiftUserlist.getDataState()) {
            gtGiftUserlist.setDataState(0);
        }
        if (null == gtGiftUserlist.getGmtCreate()) {
            gtGiftUserlist.setGmtCreate(this.getSysDate());
        }
        gtGiftUserlist.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftUserlist.getGiftUserlistCode())) {
            gtGiftUserlist.setGiftUserlistCode(this.createUUIDString());
        }
    }

    private int getGiftUserlistMaxCode() {
        int code = 0;
        try {
            return this.gtGiftUserlistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.getGiftUserlistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftUserlistUpdataDefault(GtGiftUserlist gtGiftUserlist) {
        if (null == gtGiftUserlist) {
            return;
        }
        gtGiftUserlist.setGmtModified(this.getSysDate());
    }

    private void saveGiftUserlistModel(GtGiftUserlist gtGiftUserlist) throws ApiException {
        if (null == gtGiftUserlist) {
            return;
        }
        try {
            this.gtGiftUserlistMapper.insert(gtGiftUserlist);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.saveGiftUserlistModel.ex", (Throwable)e);
        }
    }

    private void saveGiftUserlistBatchModel(List<GtGiftUserlist> gtGiftUserlistList) throws ApiException {
        if (null == gtGiftUserlistList || gtGiftUserlistList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftUserlistMapper.insertBatch(gtGiftUserlistList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.saveGiftUserlistBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftUserlist getGiftUserlistModelById(Integer giftUserlistId) {
        if (null == giftUserlistId) {
            return null;
        }
        try {
            return this.gtGiftUserlistMapper.selectByPrimaryKey(giftUserlistId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.getGiftUserlistModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftUserlist getGiftUserlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftUserlistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.getGiftUserlistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftUserlistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserlistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.delGiftUserlistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.delGiftUserlistModelByCode.num");
        }
    }

    private void deleteGiftUserlistModel(Integer giftUserlistId) throws ApiException {
        if (null == giftUserlistId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserlistMapper.deleteByPrimaryKey(giftUserlistId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.deleteGiftUserlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.deleteGiftUserlistModel.num");
        }
    }

    private void updateGiftUserlistModel(GtGiftUserlist gtGiftUserlist) throws ApiException {
        if (null == gtGiftUserlist) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserlistMapper.updateByPrimaryKeySelective(gtGiftUserlist);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.updateGiftUserlistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.updateGiftUserlistModel.num");
        }
    }

    private void updateStateGiftUserlistModel(Integer giftUserlistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftUserlistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftUserlistId", giftUserlistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftUserlistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.updateStateGiftUserlistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.updateStateGiftUserlistModel.null");
        }
    }

    private void updateStateGiftUserlistModelByCode(String tenantCode, String giftUserlistCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftUserlistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserlistCode", giftUserlistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftUserlistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.updateStateGiftUserlistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.updateStateGiftUserlistModelByCode.null");
        }
    }

    private GtGiftUserlist makeGiftUserlist(GtGiftUserlistDomain gtGiftUserlistDomain, GtGiftUserlist gtGiftUserlist) {
        if (null == gtGiftUserlistDomain) {
            return null;
        }
        if (null == gtGiftUserlist) {
            gtGiftUserlist = new GtGiftUserlist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUserlist, (Object)gtGiftUserlistDomain);
            return gtGiftUserlist;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.makeGiftUserlist", (Throwable)e);
            return null;
        }
    }

    private GtGiftUserlistReDomain makeGtGiftUserlistReDomain(GtGiftUserlist gtGiftUserlist) {
        if (null == gtGiftUserlist) {
            return null;
        }
        GtGiftUserlistReDomain gtGiftUserlistReDomain = new GtGiftUserlistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUserlistReDomain, (Object)gtGiftUserlist);
            return gtGiftUserlistReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.makeGtGiftUserlistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftUserlist> queryGiftUserlistModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftUserlistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.queryGiftUserlistModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftUserlist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftUserlistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.countGiftUserlist", (Throwable)e);
        }
        return i;
    }

    private GtGiftUserlist createGtGiftUserlist(GtGiftUserlistDomain gtGiftUserlistDomain) {
        String msg = this.checkGiftUserlist(gtGiftUserlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.saveGiftUserlist.checkGiftUserlist", msg);
        }
        GtGiftUserlist gtGiftUserlist = this.makeGiftUserlist(gtGiftUserlistDomain, null);
        this.setGiftUserlistDefault(gtGiftUserlist);
        return gtGiftUserlist;
    }

    @Override
    public String saveGiftUserlist(GtGiftUserlistDomain gtGiftUserlistDomain) throws ApiException {
        GtGiftUserlist gtGiftUserlist = this.createGtGiftUserlist(gtGiftUserlistDomain);
        this.saveGiftUserlistModel(gtGiftUserlist);
        return gtGiftUserlist.getGiftUserlistCode();
    }

    @Override
    public String saveGiftUserlistBatch(List<GtGiftUserlistDomain> gtGiftUserlistDomainList) throws ApiException {
        if (null == gtGiftUserlistDomainList || gtGiftUserlistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftUserlist> gtGiftUserlistList = new ArrayList<GtGiftUserlist>();
        String code = "";
        for (GtGiftUserlistDomain gtGiftUserlistDomain : gtGiftUserlistDomainList) {
            GtGiftUserlist gtGiftUserlist = this.createGtGiftUserlist(gtGiftUserlistDomain);
            code = gtGiftUserlist.getGiftUserlistCode();
            gtGiftUserlistList.add(gtGiftUserlist);
        }
        this.saveGiftUserlistBatchModel(gtGiftUserlistList);
        return code;
    }

    @Override
    public void updateGiftUserlistState(Integer giftUserlistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftUserlistModel(giftUserlistId, dataState, oldDataState);
    }

    @Override
    public void updateGiftUserlistStateByCode(String tenantCode, String giftUserlistCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftUserlistModelByCode(tenantCode, giftUserlistCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftUserlist(GtGiftUserlistDomain gtGiftUserlistDomain) throws ApiException {
        String msg = this.checkGiftUserlist(gtGiftUserlistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.updateGiftUserlist.checkGiftUserlist", msg);
        }
        GtGiftUserlist oldGtGiftUserlist = this.getGiftUserlistModelById(gtGiftUserlistDomain.getGiftUserlistId());
        if (null == oldGtGiftUserlist) {
            throw new ApiException("gt.GIFT.GtGiftUserlistServiceImpl.updateGiftUserlist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGiftUserlist gtGiftUserlist = this.makeGiftUserlist(gtGiftUserlistDomain, oldGtGiftUserlist);
        this.setGiftUserlistUpdataDefault(gtGiftUserlist);
        this.updateGiftUserlistModel(gtGiftUserlist);
    }

    @Override
    public GtGiftUserlist getGiftUserlist(Integer giftUserlistId) {
        return this.getGiftUserlistModelById(giftUserlistId);
    }

    @Override
    public void deleteGiftUserlist(Integer giftUserlistId) throws ApiException {
        this.deleteGiftUserlistModel(giftUserlistId);
    }

    @Override
    public QueryResult<GtGiftUserlist> queryGiftUserlistPage(Map<String, Object> map) {
        List<GtGiftUserlist> gtGiftUserlistList = this.queryGiftUserlistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftUserlist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftUserlistList);
        return queryResult;
    }

    @Override
    public GtGiftUserlist getGiftUserlistByCode(String tenantCode, String giftUserlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserlistCode", giftUserlistCode);
        return this.getGiftUserlistModelByCode(map);
    }

    @Override
    public void deleteGiftUserlistByCode(String tenantCode, String giftUserlistCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserlistCode", giftUserlistCode);
        this.delGiftUserlistModelByCode(map);
    }

    @Override
    public OcReorderDomain saveGiftUserAndList(List<GtGiftUserBean> gtGiftUserBeanList) throws ApiException {
        this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.saveGiftUserAndList.e", (Object)"-----------------111111");
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        ocReorderDomain.setOrderState("3");
        if (ListUtil.isEmpty(gtGiftUserBeanList)) {
            return ocReorderDomain;
        }
        ArrayList<GtGiftUserlistDomain> gtGiftUserlistDomainList = new ArrayList<GtGiftUserlistDomain>();
        ArrayList<GtGiftUserDomain> gtGiftUserDomainList = new ArrayList<GtGiftUserDomain>();
        for (GtGiftUserBean gtGiftUserBean : gtGiftUserBeanList) {
            this.makeGtGiftUserDomain(gtGiftUserBean, gtGiftUserDomainList, gtGiftUserlistDomainList);
        }
        String code = this.gtGiftUserService.saveGiftUserBatch(gtGiftUserDomainList);
        this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.saveGiftUserAndList.e", (Object)("-----------------222====" + code));
        if (StringUtils.isBlank((String)code)) {
            ocReorderDomain.setOrderState("3");
            return ocReorderDomain;
        }
        ocReorderDomain.setOrderState("2");
        code = this.saveGiftUserlistBatch(gtGiftUserlistDomainList);
        if (StringUtils.isBlank((String)code)) {
            ocReorderDomain.setOrderState("3");
        } else {
            ocReorderDomain.setOrderState("2");
        }
        this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.saveGiftUserAndList.e", (Object)"-----------------end");
        return ocReorderDomain;
    }

    private boolean makeGtGiftUserDomain(GtGiftUserBean gtGiftUserBean, List<GtGiftUserDomain> gtGiftUserDomainList, List<GtGiftUserlistDomain> gtGiftUserlistDomainList) {
        if (null == gtGiftUserBean || ListUtil.isEmpty(gtGiftUserDomainList) || ListUtil.isEmpty(gtGiftUserlistDomainList)) {
            return false;
        }
        GtGiftUserDomain gtGiftUserDomain = new GtGiftUserDomain();
        GtGiftUserlistDomain gtGiftUserlistDomain = new GtGiftUserlistDomain();
        gtGiftUserlistDomainList.add(gtGiftUserlistDomain);
        gtGiftUserDomainList.add(gtGiftUserDomain);
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUserDomain, (Object)gtGiftUserBean);
            BeanUtils.copyAllPropertys((Object)gtGiftUserlistDomain, (Object)gtGiftUserBean);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.makeGtGiftUserDomain.e", (Throwable)e);
            return false;
        }
        GtGift gtGift = this.gtGiftService.getGiftByCode(gtGiftUserBean.getTenantCode(), gtGiftUserBean.getGiftCode());
        if (null == gtGift) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.makeGtGiftUserDomain.gtGift");
            return false;
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUserDomain, (Object)gtGift);
            BeanUtils.copyAllPropertys((Object)gtGiftUserlistDomain, (Object)gtGift);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserlistServiceImpl.makeGtGiftUserDomain.e", (Throwable)e);
            return false;
        }
        gtGiftUserDomain.setGiftUserEnd(gtGift.getGiftEnd());
        gtGiftUserDomain.setGiftUserStart(gtGift.getGiftStart());
        gtGiftUserlistDomain.setGiftUserEnd(gtGift.getGiftEnd());
        gtGiftUserlistDomain.setGiftUserStart(gtGift.getGiftStart());
        if (StringUtils.isBlank((String)gtGiftUserDomain.getGiftUserType())) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("userinfoCode", gtGiftUserDomain.getMemberBcode());
            paramMap.put("tenantCode", gtGiftUserDomain.getTenantCode());
            String userinfoStr = this.internalInvoke(this.api_userinfo, paramMap);
            if (StringUtils.isBlank((String)userinfoStr)) {
                return false;
            }
            UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfo.class);
            if (null == umUserinfo) {
                return false;
            }
            gtGiftUserDomain.setGiftUserType(String.valueOf(umUserinfo.getUserinfoType()));
            gtGiftUserlistDomain.setGiftUserlistType(String.valueOf(umUserinfo.getUserinfoType()));
        }
        if (StringUtils.isBlank((String)gtGiftUserDomain.getCompanyCode())) {
            String json = DisUtil.getMap((String)"OrgCompany-all", (String)(gtGiftUserDomain.getMemberBcode() + "-" + gtGiftUserDomain.getTenantCode()));
            if (StringUtils.isBlank((String)json)) {
                return true;
            }
            OrgCompany orgCompany = (OrgCompany)JsonUtil.buildNormalBinder().getJsonToObject(json, OrgCompany.class);
            if (null == orgCompany) {
                return true;
            }
            gtGiftUserDomain.setCompanyCode(orgCompany.getCompanyCode());
            gtGiftUserDomain.setCompanyShortname(orgCompany.getCompanyShortname());
            gtGiftUserlistDomain.setCompanyCode(orgCompany.getCompanyCode());
            gtGiftUserlistDomain.setCompanyShortname(orgCompany.getCompanyShortname());
        }
        return true;
    }
}

