/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftFileMapper;
import com.yqbsoft.laser.service.gt.dao.GtGiftMapper;
import com.yqbsoft.laser.service.gt.dao.GtGiftRelMapper;
import com.yqbsoft.laser.service.gt.domain.GtGiftDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftFileDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftReDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftRelDomain;
import com.yqbsoft.laser.service.gt.model.GtGift;
import com.yqbsoft.laser.service.gt.service.GtGiftFileService;
import com.yqbsoft.laser.service.gt.service.GtGiftRelService;
import com.yqbsoft.laser.service.gt.service.GtGiftService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GtGiftServiceImpl
extends BaseServiceImpl
implements GtGiftService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftServiceImpl";
    private GtGiftMapper gtGiftMapper;
    private GtGiftFileService gtGiftFileService;
    private GtGiftRelService gtGiftRelService;
    private GtGiftFileMapper gtGiftFileMapper;
    private GtGiftRelMapper gtGiftRelMapper;

    public void setGtGiftMapper(GtGiftMapper gtGiftMapper) {
        this.gtGiftMapper = gtGiftMapper;
    }

    public void setGtGiftRelMapper(GtGiftRelMapper gtGiftRelMapper) {
        this.gtGiftRelMapper = gtGiftRelMapper;
    }

    public void setGtGiftFileMapper(GtGiftFileMapper gtGiftFileMapper) {
        this.gtGiftFileMapper = gtGiftFileMapper;
    }

    public void setGtGiftRelService(GtGiftRelService gtGiftRelService) {
        this.gtGiftRelService = gtGiftRelService;
    }

    public void setGtGiftFileService(GtGiftFileService gtGiftFileService) {
        this.gtGiftFileService = gtGiftFileService;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGift(GtGiftDomain gtGiftDomain) {
        if (null == gtGiftDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftDefault(GtGift gtGift) {
        if (null == gtGift) {
            return;
        }
        if (null == gtGift.getDataState()) {
            gtGift.setDataState(0);
        }
        if (null == gtGift.getGmtCreate()) {
            gtGift.setGmtCreate(this.getSysDate());
        }
        gtGift.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGift.getGiftCode())) {
            gtGift.setGiftCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)gtGift.getGiftNo())) {
            gtGift.setGiftNo(this.getNo("0", "GtGift", "giftNo", gtGift.getTenantCode()));
        }
    }

    private int getGiftMaxCode() {
        int code = 0;
        try {
            return this.gtGiftMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftServiceImpl.getGiftMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftUpdataDefault(GtGift gtGift) {
        if (null == gtGift) {
            return;
        }
        gtGift.setGmtModified(this.getSysDate());
    }

    private void saveGiftModel(GtGift gtGift) throws ApiException {
        if (null == gtGift) {
            return;
        }
        try {
            this.gtGiftMapper.insert(gtGift);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.saveGiftModel.ex", (Throwable)e);
        }
    }

    private void saveGiftBatchModel(List<GtGift> gtGiftList) throws ApiException {
        if (null == gtGiftList || gtGiftList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftMapper.insertBatch(gtGiftList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.saveGiftBatchModel.ex", (Throwable)e);
        }
    }

    private GtGift getGiftModelById(Integer giftId) {
        if (null == giftId) {
            return null;
        }
        try {
            return this.gtGiftMapper.selectByPrimaryKey(giftId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftServiceImpl.getGiftModelById", (Throwable)e);
            return null;
        }
    }

    private GtGift getGiftModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftServiceImpl.getGiftModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.delGiftModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.delGiftModelByCode.num");
        }
    }

    private void deleteGiftModel(Integer giftId) throws ApiException {
        if (null == giftId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftMapper.deleteByPrimaryKey(giftId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.deleteGiftModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.deleteGiftModel.num");
        }
    }

    private void updateGiftModel(GtGift gtGift) throws ApiException {
        if (null == gtGift) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftMapper.updateByPrimaryKeySelective(gtGift);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.updateGiftModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.updateGiftModel.num");
        }
    }

    private void updateStateGiftModel(Integer giftId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftId", giftId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.updateStateGiftModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.updateStateGiftModel.null");
        }
    }

    private void updateStateGiftModelByCode(String tenantCode, String giftCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftCode", giftCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.updateStateGiftModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.updateStateGiftModelByCode.null");
        }
    }

    private GtGift makeGift(GtGiftDomain gtGiftDomain, GtGift gtGift) {
        if (null == gtGiftDomain) {
            return null;
        }
        if (null == gtGift) {
            gtGift = new GtGift();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGift, (Object)gtGiftDomain);
            return gtGift;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftServiceImpl.makeGift", (Throwable)e);
            return null;
        }
    }

    private GtGiftReDomain makeGtGiftReDomain(GtGift gtGift) {
        if (null == gtGift) {
            return null;
        }
        GtGiftReDomain gtGiftReDomain = new GtGiftReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftReDomain, (Object)gtGift);
            return gtGiftReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftServiceImpl.makeGtGiftReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGift> queryGiftModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftServiceImpl.queryGiftModel", (Throwable)e);
            return null;
        }
    }

    private int countGift(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftServiceImpl.countGift", (Throwable)e);
        }
        return i;
    }

    private GtGift createGtGift(GtGiftDomain gtGiftDomain) {
        String msg = this.checkGift(gtGiftDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.saveGift.checkGift", msg);
        }
        GtGift gtGift = this.makeGift(gtGiftDomain, null);
        this.setGiftDefault(gtGift);
        return gtGift;
    }

    @Override
    public String saveGift(GtGiftDomain gtGiftDomain) throws ApiException {
        List<GtGiftRelDomain> gtGiftRelDomainList;
        GtGift gtGift = this.createGtGift(gtGiftDomain);
        this.saveGiftModel(gtGift);
        String giftCode = gtGift.getGiftCode();
        List<GtGiftFileDomain> gtGiftFileDomainList = gtGiftDomain.getGtGiftFileDomainList();
        if (null != gtGiftFileDomainList && gtGiftFileDomainList.size() > 0) {
            for (GtGiftFileDomain gtGiftFileDomain : gtGiftFileDomainList) {
                gtGiftFileDomain.setGiftCode(giftCode);
                gtGiftFileDomain.setTenantCode(gtGift.getTenantCode());
                gtGiftFileDomain.setAppmanageIcode(gtGift.getAppmanageIcode());
            }
            this.gtGiftFileService.saveGiftFileBatch(gtGiftFileDomainList);
        }
        if (null != (gtGiftRelDomainList = gtGiftDomain.getGtGiftRelDomainList()) && gtGiftRelDomainList.size() > 0) {
            for (GtGiftRelDomain giftRelDomain : gtGiftRelDomainList) {
                giftRelDomain.setGiftCode(giftCode);
                giftRelDomain.setTenantCode(gtGift.getTenantCode());
                giftRelDomain.setAppmanageIcode(gtGift.getAppmanageIcode());
            }
            this.gtGiftRelService.saveGiftRelBatch(gtGiftRelDomainList);
        }
        return giftCode;
    }

    @Override
    public String saveGiftBatch(List<GtGiftDomain> gtGiftDomainList) throws ApiException {
        if (null == gtGiftDomainList || gtGiftDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGift> gtGiftList = new ArrayList<GtGift>();
        String code = "";
        for (GtGiftDomain gtGiftDomain : gtGiftDomainList) {
            GtGift gtGift = this.createGtGift(gtGiftDomain);
            code = gtGift.getGiftCode();
            gtGiftList.add(gtGift);
        }
        this.saveGiftBatchModel(gtGiftList);
        return code;
    }

    @Override
    public void updateGiftState(Integer giftId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftModel(giftId, dataState, oldDataState);
    }

    @Override
    public void updateGiftStateByCode(String tenantCode, String giftCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftModelByCode(tenantCode, giftCode, dataState, oldDataState);
    }

    @Override
    public void updateGift(GtGiftDomain gtGiftDomain) throws ApiException {
        List<GtGiftRelDomain> gtGiftRelDomainList;
        String msg = this.checkGift(gtGiftDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.updateGift.checkGift", msg);
        }
        GtGift oldGtGift = this.getGiftModelById(gtGiftDomain.getGiftId());
        if (null == oldGtGift) {
            throw new ApiException("gt.GIFT.GtGiftServiceImpl.updateGift.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGift gtGift = this.makeGift(gtGiftDomain, oldGtGift);
        this.setGiftUpdataDefault(gtGift);
        this.updateGiftModel(gtGift);
        String giftCode = gtGift.getGiftCode();
        Map giftMap = this.getQueryParamMap("giftCode,tenantCode", new Object[]{giftCode, gtGift.getTenantCode()});
        this.gtGiftFileMapper.delByGiftCode(giftMap);
        this.gtGiftRelMapper.delByGiftCode(giftMap);
        List<GtGiftFileDomain> gtGiftFileDomainList = gtGiftDomain.getGtGiftFileDomainList();
        if (null != gtGiftFileDomainList && gtGiftFileDomainList.size() > 0) {
            for (GtGiftFileDomain gtGiftFileDomain : gtGiftFileDomainList) {
                gtGiftFileDomain.setGiftCode(giftCode);
                gtGiftFileDomain.setTenantCode(gtGift.getTenantCode());
                gtGiftFileDomain.setAppmanageIcode(gtGift.getAppmanageIcode());
            }
            this.gtGiftFileService.saveGiftFileBatch(gtGiftFileDomainList);
        }
        if (null != (gtGiftRelDomainList = gtGiftDomain.getGtGiftRelDomainList()) && gtGiftRelDomainList.size() > 0) {
            for (GtGiftRelDomain giftRelDomain : gtGiftRelDomainList) {
                giftRelDomain.setGiftCode(giftCode);
                giftRelDomain.setTenantCode(gtGift.getTenantCode());
                giftRelDomain.setAppmanageIcode(gtGift.getAppmanageIcode());
            }
            this.gtGiftRelService.saveGiftRelBatch(gtGiftRelDomainList);
        }
    }

    @Override
    public GtGift getGift(Integer giftId) {
        return this.getGiftModelById(giftId);
    }

    @Override
    public void deleteGift(Integer giftId) throws ApiException {
        GtGift gtGift = this.getGift(giftId);
        String giftCode = gtGift.getGiftCode();
        Map giftMap = this.getQueryParamMap("giftCode,tenantCode", new Object[]{giftCode, gtGift.getTenantCode()});
        this.gtGiftFileMapper.delByGiftCode(giftMap);
        this.gtGiftRelMapper.delByGiftCode(giftMap);
        this.deleteGiftModel(giftId);
    }

    @Override
    public QueryResult<GtGift> queryGiftPage(Map<String, Object> map) {
        List<GtGift> gtGiftList = this.queryGiftModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGift(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftList);
        return queryResult;
    }

    @Override
    public GtGift getGiftByCode(String tenantCode, String giftCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftCode", giftCode);
        return this.getGiftModelByCode(map);
    }

    @Override
    public void deleteGiftByCode(String tenantCode, String giftCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftCode", giftCode);
        this.delGiftModelByCode(map);
    }
}

