/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftUserMapper;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserReDomain;
import com.yqbsoft.laser.service.gt.model.GtGiftUser;
import com.yqbsoft.laser.service.gt.service.GtGiftUserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GtGiftUserServiceImpl
extends BaseServiceImpl
implements GtGiftUserService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftUserServiceImpl";
    private GtGiftUserMapper gtGiftUserMapper;

    public void setGtGiftUserMapper(GtGiftUserMapper gtGiftUserMapper) {
        this.gtGiftUserMapper = gtGiftUserMapper;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftUser(GtGiftUserDomain gtGiftUserDomain) {
        if (null == gtGiftUserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftUserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftUserDefault(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return;
        }
        if (null == gtGiftUser.getDataState()) {
            gtGiftUser.setDataState(0);
        }
        if (null == gtGiftUser.getGmtCreate()) {
            gtGiftUser.setGmtCreate(this.getSysDate());
        }
        gtGiftUser.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftUser.getGiftUserCode())) {
            gtGiftUser.setGiftUserCode(this.createUUIDString());
        }
    }

    private int getGiftUserMaxCode() {
        int code = 0;
        try {
            return this.gtGiftUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getGiftUserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftUserUpdataDefault(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return;
        }
        gtGiftUser.setGmtModified(this.getSysDate());
    }

    private void saveGiftUserModel(GtGiftUser gtGiftUser) throws ApiException {
        if (null == gtGiftUser) {
            return;
        }
        try {
            this.gtGiftUserMapper.insert(gtGiftUser);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.saveGiftUserModel.ex", (Throwable)e);
        }
    }

    private void saveGiftUserBatchModel(List<GtGiftUser> gtGiftUserList) throws ApiException {
        if (null == gtGiftUserList || gtGiftUserList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftUserMapper.insertBatch(gtGiftUserList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.saveGiftUserBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftUser getGiftUserModelById(Integer giftUserId) {
        if (null == giftUserId) {
            return null;
        }
        try {
            return this.gtGiftUserMapper.selectByPrimaryKey(giftUserId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getGiftUserModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftUser getGiftUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getGiftUserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.delGiftUserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.delGiftUserModelByCode.num");
        }
    }

    private void deleteGiftUserModel(Integer giftUserId) throws ApiException {
        if (null == giftUserId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.deleteByPrimaryKey(giftUserId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.deleteGiftUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.deleteGiftUserModel.num");
        }
    }

    private void updateGiftUserModel(GtGiftUser gtGiftUser) throws ApiException {
        if (null == gtGiftUser) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateByPrimaryKeySelective(gtGiftUser);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserModel.num");
        }
    }

    private void updateStateGiftUserModel(Integer giftUserId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftUserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftUserId", giftUserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModel.null");
        }
    }

    private void updateStateGiftUserModelByCode(String tenantCode, String giftUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftUserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserCode", giftUserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModelByCode.null");
        }
    }

    private GtGiftUser makeGiftUser(GtGiftUserDomain gtGiftUserDomain, GtGiftUser gtGiftUser) {
        if (null == gtGiftUserDomain) {
            return null;
        }
        if (null == gtGiftUser) {
            gtGiftUser = new GtGiftUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUser, (Object)gtGiftUserDomain);
            return gtGiftUser;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.makeGiftUser", (Throwable)e);
            return null;
        }
    }

    private GtGiftUserReDomain makeGtGiftUserReDomain(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return null;
        }
        GtGiftUserReDomain gtGiftUserReDomain = new GtGiftUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUserReDomain, (Object)gtGiftUser);
            return gtGiftUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.makeGtGiftUserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftUser> queryGiftUserModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.queryGiftUserModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.countGiftUser", (Throwable)e);
        }
        return i;
    }

    private GtGiftUser createGtGiftUser(GtGiftUserDomain gtGiftUserDomain) {
        String msg = this.checkGiftUser(gtGiftUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.saveGiftUser.checkGiftUser", msg);
        }
        GtGiftUser gtGiftUser = this.makeGiftUser(gtGiftUserDomain, null);
        this.setGiftUserDefault(gtGiftUser);
        return gtGiftUser;
    }

    @Override
    public String saveGiftUser(GtGiftUserDomain gtGiftUserDomain) throws ApiException {
        GtGiftUser gtGiftUser = this.createGtGiftUser(gtGiftUserDomain);
        this.saveGiftUserModel(gtGiftUser);
        return gtGiftUser.getGiftUserCode();
    }

    @Override
    public String saveGiftUserBatch(List<GtGiftUserDomain> gtGiftUserDomainList) throws ApiException {
        if (null == gtGiftUserDomainList || gtGiftUserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftUser> gtGiftUserList = new ArrayList<GtGiftUser>();
        String code = "";
        for (GtGiftUserDomain gtGiftUserDomain : gtGiftUserDomainList) {
            GtGiftUser gtGiftUser = this.createGtGiftUser(gtGiftUserDomain);
            code = gtGiftUser.getGiftUserCode();
            gtGiftUserList.add(gtGiftUser);
        }
        this.saveGiftUserBatchModel(gtGiftUserList);
        return code;
    }

    @Override
    public void updateGiftUserState(Integer giftUserId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftUserModel(giftUserId, dataState, oldDataState);
    }

    @Override
    public void updateGiftUserStateByCode(String tenantCode, String giftUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftUserModelByCode(tenantCode, giftUserCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftUser(GtGiftUserDomain gtGiftUserDomain) throws ApiException {
        String msg = this.checkGiftUser(gtGiftUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.checkGiftUser", msg);
        }
        GtGiftUser oldGtGiftUser = this.getGiftUserModelById(gtGiftUserDomain.getGiftUserId());
        if (null == oldGtGiftUser) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGiftUser gtGiftUser = this.makeGiftUser(gtGiftUserDomain, oldGtGiftUser);
        this.setGiftUserUpdataDefault(gtGiftUser);
        this.updateGiftUserModel(gtGiftUser);
    }

    @Override
    public GtGiftUser getGiftUser(Integer giftUserId) {
        return this.getGiftUserModelById(giftUserId);
    }

    @Override
    public void deleteGiftUser(Integer giftUserId) throws ApiException {
        this.deleteGiftUserModel(giftUserId);
    }

    @Override
    public QueryResult<GtGiftUser> queryGiftUserPage(Map<String, Object> map) {
        List<GtGiftUser> gtGiftUserList = this.queryGiftUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftUserList);
        return queryResult;
    }

    @Override
    public GtGiftUser getGiftUserByCode(String tenantCode, String giftUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserCode", giftUserCode);
        return this.getGiftUserModelByCode(map);
    }

    @Override
    public void deleteGiftUserByCode(String tenantCode, String giftUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserCode", giftUserCode);
        this.delGiftUserModelByCode(map);
    }
}

