/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftUserMapper;
import com.yqbsoft.laser.service.gt.domain.BuyGiftBean;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserBean;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserReDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftUserrelDomain;
import com.yqbsoft.laser.service.gt.domain.ReceiveGiftUserDomain;
import com.yqbsoft.laser.service.gt.domain.TaTransferaDomain;
import com.yqbsoft.laser.service.gt.domain.TaTransferaListDomain;
import com.yqbsoft.laser.service.gt.domain.UmUserinfo;
import com.yqbsoft.laser.service.gt.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.gt.model.GtGift;
import com.yqbsoft.laser.service.gt.model.GtGiftUser;
import com.yqbsoft.laser.service.gt.model.GtGiftUserrel;
import com.yqbsoft.laser.service.gt.service.GtGiftService;
import com.yqbsoft.laser.service.gt.service.GtGiftUserService;
import com.yqbsoft.laser.service.gt.service.GtGiftUserrelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GtGiftUserServiceImpl
extends BaseServiceImpl
implements GtGiftUserService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftUserServiceImpl";
    private GtGiftUserMapper gtGiftUserMapper;
    private GtGiftService gtGiftService;
    private GtGiftUserrelService gtGiftUserrelService;
    private String api_userinfo = "um.user.getUserinfoByUserCode";

    public void setGtGiftUserrelService(GtGiftUserrelService gtGiftUserrelService) {
        this.gtGiftUserrelService = gtGiftUserrelService;
    }

    public void setGtGiftService(GtGiftService gtGiftService) {
        this.gtGiftService = gtGiftService;
    }

    public void setGtGiftUserMapper(GtGiftUserMapper gtGiftUserMapper) {
        this.gtGiftUserMapper = gtGiftUserMapper;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftUser(GtGiftUserDomain gtGiftUserDomain) {
        if (null == gtGiftUserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftUserDomain.getMemberBcode())) {
            msg = msg + "MemberBcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)gtGiftUserDomain.getMemberBname())) {
            msg = msg + "MemberBname\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)gtGiftUserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftUserDefault(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return;
        }
        if (null == gtGiftUser.getDataState()) {
            gtGiftUser.setDataState(0);
        }
        if (null == gtGiftUser.getGmtCreate()) {
            gtGiftUser.setGmtCreate(this.getSysDate());
        }
        gtGiftUser.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftUser.getGiftUserCode())) {
            gtGiftUser.setGiftUserCode(this.createUUIDString());
        }
    }

    private int getGiftUserMaxCode() {
        int code = 0;
        try {
            return this.gtGiftUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getGiftUserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftUserUpdataDefault(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return;
        }
        gtGiftUser.setGmtModified(this.getSysDate());
    }

    private void saveGiftUserModel(GtGiftUser gtGiftUser) throws ApiException {
        if (null == gtGiftUser) {
            return;
        }
        try {
            this.gtGiftUserMapper.insert(gtGiftUser);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.saveGiftUserModel.ex", (Throwable)e);
        }
    }

    private void saveGiftUserBatchModel(List<GtGiftUser> gtGiftUserList) throws ApiException {
        if (null == gtGiftUserList || gtGiftUserList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftUserMapper.insertBatch(gtGiftUserList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.saveGiftUserBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftUser getGiftUserModelById(Integer giftUserId) {
        if (null == giftUserId) {
            return null;
        }
        try {
            return this.gtGiftUserMapper.selectByPrimaryKey(giftUserId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getGiftUserModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftUser getGiftUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.getGiftUserModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.delGiftUserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.delGiftUserModelByCode.num");
        }
    }

    private void deleteGiftUserModel(Integer giftUserId) throws ApiException {
        if (null == giftUserId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.deleteByPrimaryKey(giftUserId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.deleteGiftUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.deleteGiftUserModel.num");
        }
    }

    private void updateGiftUserModel(GtGiftUser gtGiftUser) throws ApiException {
        if (null == gtGiftUser) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateByPrimaryKeySelective(gtGiftUser);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserModel.num");
        }
    }

    private void updateStateGiftUserModel(Integer giftUserId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftUserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftUserId", giftUserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModel.null");
        }
    }

    private void updateStateGiftUserModelByCode(String tenantCode, String giftUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftUserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserCode", giftUserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftUserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateStateGiftUserModelByCode.null");
        }
    }

    private GtGiftUser makeGiftUser(GtGiftUserDomain gtGiftUserDomain, GtGiftUser gtGiftUser) {
        if (null == gtGiftUserDomain) {
            return null;
        }
        if (null == gtGiftUser) {
            gtGiftUser = new GtGiftUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUser, (Object)gtGiftUserDomain);
            return gtGiftUser;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.makeGiftUser", (Throwable)e);
            return null;
        }
    }

    private GtGiftUserReDomain makeGtGiftUserReDomain(GtGiftUser gtGiftUser) {
        if (null == gtGiftUser) {
            return null;
        }
        GtGiftUserReDomain gtGiftUserReDomain = new GtGiftUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftUserReDomain, (Object)gtGiftUser);
            return gtGiftUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.makeGtGiftUserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftUser> queryGiftUserModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.queryGiftUserModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.countGiftUser", (Throwable)e);
        }
        return i;
    }

    private GtGiftUser createGtGiftUser(GtGiftUserDomain gtGiftUserDomain) {
        String msg = this.checkGiftUser(gtGiftUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.saveGiftUser.checkGiftUser", msg);
        }
        GtGiftUser gtGiftUser = this.makeGiftUser(gtGiftUserDomain, null);
        this.setGiftUserDefault(gtGiftUser);
        return gtGiftUser;
    }

    @Override
    public String saveGiftUser(GtGiftUserDomain gtGiftUserDomain) throws ApiException {
        GtGiftUser gtGiftUser = this.createGtGiftUser(gtGiftUserDomain);
        this.saveGiftUserModel(gtGiftUser);
        return gtGiftUser.getGiftUserCode();
    }

    @Override
    public String saveGiftUserBatch(List<GtGiftUserDomain> gtGiftUserDomainList) throws ApiException {
        if (null == gtGiftUserDomainList || gtGiftUserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftUser> gtGiftUserList = new ArrayList<GtGiftUser>();
        String code = "";
        for (GtGiftUserDomain gtGiftUserDomain : gtGiftUserDomainList) {
            GtGiftUser gtGiftUser = this.createGtGiftUser(gtGiftUserDomain);
            code = gtGiftUser.getGiftUserCode();
            gtGiftUserList.add(gtGiftUser);
        }
        this.saveGiftUserBatchModel(gtGiftUserList);
        return code;
    }

    @Override
    public void updateGiftUserState(Integer giftUserId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftUserModel(giftUserId, dataState, oldDataState);
    }

    @Override
    public void updateGiftUserStateByCode(String tenantCode, String giftUserCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftUserModelByCode(tenantCode, giftUserCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftUser(GtGiftUserDomain gtGiftUserDomain) throws ApiException {
        String msg = this.checkGiftUser(gtGiftUserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.checkGiftUser", msg);
        }
        GtGiftUser oldGtGiftUser = this.getGiftUserModelById(gtGiftUserDomain.getGiftUserId());
        if (null == oldGtGiftUser) {
            throw new ApiException("gt.GIFT.GtGiftUserServiceImpl.updateGiftUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGiftUser gtGiftUser = this.makeGiftUser(gtGiftUserDomain, oldGtGiftUser);
        this.setGiftUserUpdataDefault(gtGiftUser);
        this.updateGiftUserModel(gtGiftUser);
    }

    @Override
    public GtGiftUser getGiftUser(Integer giftUserId) {
        return this.getGiftUserModelById(giftUserId);
    }

    @Override
    public void deleteGiftUser(Integer giftUserId) throws ApiException {
        this.deleteGiftUserModel(giftUserId);
    }

    @Override
    public QueryResult<GtGiftUser> queryGiftUserPage(Map<String, Object> map) {
        List<GtGiftUser> gtGiftUserList = this.queryGiftUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftUserList);
        return queryResult;
    }

    @Override
    public GtGiftUser getGiftUserByCode(String tenantCode, String giftUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserCode", giftUserCode);
        return this.getGiftUserModelByCode(map);
    }

    @Override
    public void deleteGiftUserByCode(String tenantCode, String giftUserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftUserCode", giftUserCode);
        this.delGiftUserModelByCode(map);
    }

    private void updateGiftUserValid(Map<String, Object> map) {
        try {
            this.gtGiftUserMapper.updateGiftUserValidState(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserValid", (Throwable)e);
        }
    }

    private List<GtGiftUser> queryVaildGiftUser() {
        try {
            return this.gtGiftUserMapper.queryVaildGiftUser();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftUserServiceImpl.queryVaildGiftUser", (Throwable)e);
            return null;
        }
    }

    @Override
    public String saveGiftUserByBuyGift(List<BuyGiftBean> buyGiftBeanList) throws ApiException {
        if (null == buyGiftBeanList || buyGiftBeanList.size() == 0) {
            return "false";
        }
        for (BuyGiftBean buyGiftBean : buyGiftBeanList) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("userinfoCode", buyGiftBean.getUserinfoCode());
            paramMap.put("tenantCode", buyGiftBean.getTenantCode());
            String userinfoStr = this.internalInvoke(this.api_userinfo, paramMap);
            if (StringUtils.isBlank((String)userinfoStr)) {
                return "false";
            }
            UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(userinfoStr, UmUserinfo.class);
            GtGift gtGift = this.gtGiftService.getGiftByCode(buyGiftBean.getTenantCode(), buyGiftBean.getGiftCode());
            if (null == gtGift) {
                return "false";
            }
            ArrayList<GtGiftUserBean> gtGiftUserBeanList = new ArrayList<GtGiftUserBean>();
            GtGiftUserBean gtGiftUserBean = new GtGiftUserBean();
            gtGiftUserBean.setGiftCode(buyGiftBean.getGiftCode());
            gtGiftUserBean.setGiftUserType(umUserinfo.getUserinfoType() + "");
            gtGiftUserBean.setGiftUserNum(buyGiftBean.getBuyAmount());
            gtGiftUserBean.setMemberBcode(buyGiftBean.getUserinfoCode());
            gtGiftUserBean.setMemberBname(umUserinfo.getUserinfoCompname());
            gtGiftUserBean.setTenantCode(buyGiftBean.getTenantCode());
            gtGiftUserBean.setGiftStart(gtGift.getGiftStart());
            gtGiftUserBean.setGiftEnd(gtGift.getGiftEnd());
            gtGiftUserBean.setDataState(0);
            gtGiftUserBean.setGiftUserPhone(umUserinfo.getUserinfoPhone());
            gtGiftUserBeanList.add(gtGiftUserBean);
            HashMap<String, String> paramMap1 = new HashMap<String, String>();
            paramMap1.put("gtGiftUserBeanList", JsonUtil.buildNormalBinder().toJson(gtGiftUserBeanList));
            this.internalInvoke("gt.gtgiftuserlist.saveGiftUserAndList", paramMap1);
        }
        return "success";
    }

    @Override
    public void updateGiftUserDataState() throws ApiException {
        String saveTransfera = "ta.taTransfera.saveTransfera";
        String queryOuterFaccount = "vd.faccount.queryOuterFaccount";
        List<GtGiftUser> gtGiftUserList = this.queryVaildGiftUser();
        if (null != gtGiftUserList && gtGiftUserList.size() > 0) {
            for (GtGiftUser gtGiftUser : gtGiftUserList) {
                List vdFaccountInfoList;
                List vdFaccountInfoList2;
                this.updateGiftUserValid(this.getQueryParamMap("giftUserCode,tenantCode", new Object[]{gtGiftUser.getGiftUserCode(), gtGiftUser.getTenantCode()}));
                String giftCode = gtGiftUser.getGiftCode();
                String tenantCode = gtGiftUser.getTenantCode();
                GtGift gtGift = this.gtGiftService.getGiftByCode(tenantCode, giftCode);
                if (null != gtGift && !"1".equals(gtGift.getGiftOver())) continue;
                TaTransferaDomain taTransferaDomain = new TaTransferaDomain();
                ArrayList<TaTransferaListDomain> taTransferaListDomainList = new ArrayList<TaTransferaListDomain>();
                TaTransferaListDomain taTransferaListDomain = new TaTransferaListDomain();
                String type = gtGiftUser.getMemberCode().substring(0, 1);
                String faccountType = "101";
                if ("2".equals(type)) {
                    faccountType = "201";
                }
                HashMap<String, String> paramMap1 = new HashMap<String, String>();
                paramMap1.put("merchantCode", gtGiftUser.getMemberCode());
                paramMap1.put("faccountType", faccountType);
                paramMap1.put("tenantCode", gtGiftUser.getTenantCode());
                String result = this.internalInvoke(queryOuterFaccount, paramMap1);
                String outerNo = "";
                if (!StringUtils.isBlank((String)result) && null != (vdFaccountInfoList2 = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(result, VdFaccountInfo.class)) && vdFaccountInfoList2.size() > 0) {
                    outerNo = ((VdFaccountInfo)vdFaccountInfoList2.get(0)).getFaccountOuterNo();
                    taTransferaDomain.setTransferaCategory(gtGiftUser.getMemberCode().substring(0, 1));
                    taTransferaDomain.setTenantCode(gtGiftUser.getTenantCode());
                    taTransferaDomain.setTransferaOpcode(giftCode);
                    taTransferaDomain.setTransferaType("07");
                    taTransferaDomain.setTransferaMode("1");
                    taTransferaDomain.setFaccountId(outerNo);
                    taTransferaDomain.setTransferaMoney(gtGift.getGiftOnum());
                    taTransferaDomain.setUserinfoCode(gtGiftUser.getMemberCode());
                    taTransferaDomain.setUserinfoName(gtGiftUser.getMemberName());
                    taTransferaDomain.setFchannelPmodeCode("web");
                    taTransferaDomain.setFundType("01");
                }
                type = gtGiftUser.getMemberBcode().substring(0, 1);
                faccountType = "101";
                if ("2".equals(type)) {
                    faccountType = "201";
                }
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("merchantCode", gtGiftUser.getMemberBcode());
                paramMap.put("faccountType", faccountType);
                paramMap.put("tenantCode", gtGiftUser.getTenantCode());
                result = this.internalInvoke(queryOuterFaccount, paramMap);
                outerNo = "";
                if (StringUtils.isBlank((String)result) || null == (vdFaccountInfoList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(result, VdFaccountInfo.class)) || vdFaccountInfoList.size() <= 0) continue;
                outerNo = ((VdFaccountInfo)vdFaccountInfoList.get(0)).getFaccountOuterNo();
                taTransferaListDomain.setUserinfoCode(gtGiftUser.getMemberCode());
                taTransferaListDomain.setTransferaListCategory(type);
                taTransferaListDomain.setUserinfoName(gtGiftUser.getMemberName());
                taTransferaListDomain.setTransferaListUcode(gtGiftUser.getMemberBcode());
                taTransferaListDomain.setTransferaListUname(gtGiftUser.getMemberBname());
                taTransferaListDomain.setTransferaListUno(outerNo);
                taTransferaListDomain.setTransferaListFtype("01");
                taTransferaListDomain.setTransferaListMoney(gtGift.getGiftOnum());
                taTransferaListDomainList.add(taTransferaListDomain);
                taTransferaDomain.setTaTransferaListDomainList(taTransferaListDomainList);
                HashMap<String, String> paramMap2 = new HashMap<String, String>();
                paramMap2.put("taTransferaDomain", JsonUtil.buildNormalBinder().toJson((Object)taTransferaDomain));
                this.internalInvoke(saveTransfera, paramMap2);
            }
        }
    }

    @Override
    public String updateGiftUserCallBack(List<ReceiveGiftUserDomain> receiveGiftUserDomainList) throws ApiException {
        if (null == receiveGiftUserDomainList || receiveGiftUserDomainList.size() == 0) {
            return "false";
        }
        BigDecimal cnum = BigDecimal.ZERO;
        BigDecimal camt = BigDecimal.ZERO;
        for (ReceiveGiftUserDomain receiveGiftUserDomain : receiveGiftUserDomainList) {
            String giftUserCode = receiveGiftUserDomain.getGiftUserCode();
            String tenantCode = receiveGiftUserDomain.getTenantCode();
            GtGiftUser gtGiftUser = this.getGiftUserByCode(tenantCode, giftUserCode);
            if (null == gtGiftUser) continue;
            cnum = cnum.add(receiveGiftUserDomain.getGiftUserCnum());
            camt = camt.add(receiveGiftUserDomain.getGiftUserCamt());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("skuCode", receiveGiftUserDomain.getSkuCode());
            map.put("tenantCode", tenantCode);
            map.put("giftUserrelCode", receiveGiftUserDomain.getGiftUserCode());
            map.put("memberBcode", receiveGiftUserDomain.getMemeberBcode());
            QueryResult<GtGiftUserrel> gtGiftUserrelQueryResult = this.gtGiftUserrelService.queryGiftUserrelPage(map);
            List gtGiftUserrelList = gtGiftUserrelQueryResult.getList();
            if (null != gtGiftUserrelList && gtGiftUserrelList.size() > 0) {
                GtGiftUserrel gtGiftUserrel = (GtGiftUserrel)gtGiftUserrelList.get(0);
                GtGiftUserrelDomain gtGiftUserrelDomain = new GtGiftUserrelDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)gtGiftUserrelDomain, (Object)gtGiftUserrel);
                }
                catch (Exception e) {
                    this.logger.error("gt.GIFT.GtGiftUserServiceImpl.updateGiftUserCallBack.e", (Throwable)e);
                }
                if (null == gtGiftUserrelDomain.getGiftUserrelNum()) {
                    gtGiftUserrelDomain.setGiftUserrelNum(BigDecimal.ZERO);
                }
                if (null == gtGiftUserrelDomain.getGiftUserrelAmt()) {
                    gtGiftUserrelDomain.setGiftUserrelAmt(BigDecimal.ZERO);
                }
                gtGiftUserrelDomain.setGiftUserrelNum(gtGiftUserrelDomain.getGiftUserrelNum().add(receiveGiftUserDomain.getGiftUserCnum()));
                gtGiftUserrelDomain.setGiftUserrelAmt(gtGiftUserrelDomain.getGiftUserrelAmt().add(receiveGiftUserDomain.getGiftUserCamt()));
                this.gtGiftUserrelService.updateGiftUserrel(gtGiftUserrelDomain);
            }
            gtGiftUser.setGiftUserCnum(cnum);
            gtGiftUser.setGiftUserCamt(camt);
            if ("1".equals(gtGiftUser.getGiftCtype())) {
                BigDecimal userrelNum = gtGiftUser.getGiftUserNum();
                BigDecimal giftCnum = gtGiftUser.getGiftCnum();
                BigDecimal allNum = giftCnum.multiply(userrelNum);
                if (cnum.compareTo(allNum) == 0) {
                    gtGiftUser.setDataState(1);
                } else {
                    gtGiftUser.setDataState(2);
                }
            } else {
                gtGiftUser.setDataState(1);
            }
            this.gtGiftUserMapper.updateByPrimaryKey(gtGiftUser);
        }
        return "success";
    }
}

