/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.gt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.gt.dao.GtGiftRelMapper;
import com.yqbsoft.laser.service.gt.domain.GtGiftRelDomain;
import com.yqbsoft.laser.service.gt.domain.GtGiftRelReDomain;
import com.yqbsoft.laser.service.gt.model.GtGiftRel;
import com.yqbsoft.laser.service.gt.service.GtGiftRelService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GtGiftRelServiceImpl
extends BaseServiceImpl
implements GtGiftRelService {
    private static final String SYS_CODE = "gt.GIFT.GtGiftRelServiceImpl";
    private GtGiftRelMapper gtGiftRelMapper;

    public void setGtGiftRelMapper(GtGiftRelMapper gtGiftRelMapper) {
        this.gtGiftRelMapper = gtGiftRelMapper;
    }

    private Date getSysDate() {
        try {
            return this.gtGiftRelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftRelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGiftRel(GtGiftRelDomain gtGiftRelDomain) {
        if (null == gtGiftRelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)gtGiftRelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGiftRelDefault(GtGiftRel gtGiftRel) {
        if (null == gtGiftRel) {
            return;
        }
        if (null == gtGiftRel.getDataState()) {
            gtGiftRel.setDataState(0);
        }
        if (null == gtGiftRel.getGmtCreate()) {
            gtGiftRel.setGmtCreate(this.getSysDate());
        }
        gtGiftRel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)gtGiftRel.getGiftRelCode())) {
            gtGiftRel.setGiftRelCode(this.createUUIDString());
        }
    }

    private int getGiftRelMaxCode() {
        int code = 0;
        try {
            return this.gtGiftRelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftRelServiceImpl.getGiftRelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGiftRelUpdataDefault(GtGiftRel gtGiftRel) {
        if (null == gtGiftRel) {
            return;
        }
        gtGiftRel.setGmtModified(this.getSysDate());
    }

    private void saveGiftRelModel(GtGiftRel gtGiftRel) throws ApiException {
        if (null == gtGiftRel) {
            return;
        }
        try {
            this.gtGiftRelMapper.insert(gtGiftRel);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.saveGiftRelModel.ex", (Throwable)e);
        }
    }

    private void saveGiftRelBatchModel(List<GtGiftRel> gtGiftRelList) throws ApiException {
        if (null == gtGiftRelList || gtGiftRelList.isEmpty()) {
            return;
        }
        try {
            this.gtGiftRelMapper.insertBatch(gtGiftRelList);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.saveGiftRelBatchModel.ex", (Throwable)e);
        }
    }

    private GtGiftRel getGiftRelModelById(Integer giftRelId) {
        if (null == giftRelId) {
            return null;
        }
        try {
            return this.gtGiftRelMapper.selectByPrimaryKey(giftRelId);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftRelServiceImpl.getGiftRelModelById", (Throwable)e);
            return null;
        }
    }

    private GtGiftRel getGiftRelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.gtGiftRelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftRelServiceImpl.getGiftRelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGiftRelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftRelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.delGiftRelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.delGiftRelModelByCode.num");
        }
    }

    private void delGiftRelModelByGiftCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.gtGiftRelMapper.delByGiftCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.delGiftRelModelByGiftCode.ex", (Throwable)e);
        }
    }

    private void deleteGiftRelModel(Integer giftRelId) throws ApiException {
        if (null == giftRelId) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftRelMapper.deleteByPrimaryKey(giftRelId);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.deleteGiftRelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.deleteGiftRelModel.num");
        }
    }

    private void updateGiftRelModel(GtGiftRel gtGiftRel) throws ApiException {
        if (null == gtGiftRel) {
            return;
        }
        int i = 0;
        try {
            i = this.gtGiftRelMapper.updateByPrimaryKeySelective(gtGiftRel);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.updateGiftRelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.updateGiftRelModel.num");
        }
    }

    private void updateStateGiftRelModel(Integer giftRelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == giftRelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("giftRelId", giftRelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftRelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.updateStateGiftRelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.updateStateGiftRelModel.null");
        }
    }

    private void updateStateGiftRelModelByCode(String tenantCode, String giftRelCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)giftRelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftRelCode", giftRelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.gtGiftRelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.updateStateGiftRelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.updateStateGiftRelModelByCode.null");
        }
    }

    private GtGiftRel makeGiftRel(GtGiftRelDomain gtGiftRelDomain, GtGiftRel gtGiftRel) {
        if (null == gtGiftRelDomain) {
            return null;
        }
        if (null == gtGiftRel) {
            gtGiftRel = new GtGiftRel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftRel, (Object)gtGiftRelDomain);
            return gtGiftRel;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftRelServiceImpl.makeGiftRel", (Throwable)e);
            return null;
        }
    }

    private GtGiftRelReDomain makeGtGiftRelReDomain(GtGiftRel gtGiftRel) {
        if (null == gtGiftRel) {
            return null;
        }
        GtGiftRelReDomain gtGiftRelReDomain = new GtGiftRelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)gtGiftRelReDomain, (Object)gtGiftRel);
            return gtGiftRelReDomain;
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftRelServiceImpl.makeGtGiftRelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<GtGiftRel> queryGiftRelModelPage(Map<String, Object> parammap) {
        try {
            return this.gtGiftRelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftRelServiceImpl.queryGiftRelModel", (Throwable)e);
            return null;
        }
    }

    private int countGiftRel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.gtGiftRelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("gt.GIFT.GtGiftRelServiceImpl.countGiftRel", (Throwable)e);
        }
        return i;
    }

    private GtGiftRel createGtGiftRel(GtGiftRelDomain gtGiftRelDomain) {
        String msg = this.checkGiftRel(gtGiftRelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.saveGiftRel.checkGiftRel", msg);
        }
        GtGiftRel gtGiftRel = this.makeGiftRel(gtGiftRelDomain, null);
        this.setGiftRelDefault(gtGiftRel);
        return gtGiftRel;
    }

    @Override
    public String saveGiftRel(GtGiftRelDomain gtGiftRelDomain) throws ApiException {
        GtGiftRel gtGiftRel = this.createGtGiftRel(gtGiftRelDomain);
        this.saveGiftRelModel(gtGiftRel);
        return gtGiftRel.getGiftRelCode();
    }

    @Override
    public String saveGiftRelBatch(List<GtGiftRelDomain> gtGiftRelDomainList) throws ApiException {
        if (null == gtGiftRelDomainList || gtGiftRelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<GtGiftRel> gtGiftRelList = new ArrayList<GtGiftRel>();
        String code = "";
        for (GtGiftRelDomain gtGiftRelDomain : gtGiftRelDomainList) {
            GtGiftRel gtGiftRel = this.createGtGiftRel(gtGiftRelDomain);
            code = gtGiftRel.getGiftRelCode();
            gtGiftRelList.add(gtGiftRel);
        }
        this.saveGiftRelBatchModel(gtGiftRelList);
        return code;
    }

    @Override
    public void updateGiftRelState(Integer giftRelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftRelModel(giftRelId, dataState, oldDataState);
    }

    @Override
    public void updateGiftRelStateByCode(String tenantCode, String giftRelCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGiftRelModelByCode(tenantCode, giftRelCode, dataState, oldDataState);
    }

    @Override
    public void updateGiftRel(GtGiftRelDomain gtGiftRelDomain) throws ApiException {
        String msg = this.checkGiftRel(gtGiftRelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.updateGiftRel.checkGiftRel", msg);
        }
        GtGiftRel oldGtGiftRel = this.getGiftRelModelById(gtGiftRelDomain.getGiftRelId());
        if (null == oldGtGiftRel) {
            throw new ApiException("gt.GIFT.GtGiftRelServiceImpl.updateGiftRel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        GtGiftRel gtGiftRel = this.makeGiftRel(gtGiftRelDomain, oldGtGiftRel);
        this.setGiftRelUpdataDefault(gtGiftRel);
        this.updateGiftRelModel(gtGiftRel);
    }

    @Override
    public GtGiftRel getGiftRel(Integer giftRelId) {
        return this.getGiftRelModelById(giftRelId);
    }

    @Override
    public void deleteGiftRel(Integer giftRelId) throws ApiException {
        this.deleteGiftRelModel(giftRelId);
    }

    @Override
    public QueryResult<GtGiftRel> queryGiftRelPage(Map<String, Object> map) {
        List<GtGiftRel> gtGiftRelList = this.queryGiftRelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGiftRel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(gtGiftRelList);
        return queryResult;
    }

    @Override
    public GtGiftRel getGiftRelByCode(String tenantCode, String giftRelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftRelCode", giftRelCode);
        return this.getGiftRelModelByCode(map);
    }

    @Override
    public void deleteGiftRelByCode(String tenantCode, String giftRelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("giftRelCode", giftRelCode);
        this.delGiftRelModelByCode(map);
    }

    @Override
    public void deleteGiftRelByGiftCode(String tenantCode, String giftCode) throws ApiException {
        Map giftMap = this.getQueryParamMap("giftCode,tenantCode", new Object[]{giftCode, tenantCode});
        this.delGiftRelModelByGiftCode(giftMap);
    }
}

