/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ia.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.ia.dao.IaInsurancelistMapper;
import com.yqbsoft.laser.service.ia.domain.IaInsurancelistDomain;
import com.yqbsoft.laser.service.ia.domain.IaInsurancelistReDomain;
import com.yqbsoft.laser.service.ia.model.IaInsurancelist;
import com.yqbsoft.laser.service.ia.service.IaInsurancelistService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IaInsurancelistServiceImpl
extends BaseServiceImpl
implements IaInsurancelistService {
    private static final String SYS_CODE = "ia.GIFT.IaInsurancelistServiceImpl";
    private IaInsurancelistMapper iaInsurancelistMapper;

    public void setIaInsurancelistMapper(IaInsurancelistMapper iaInsurancelistMapper) {
        this.iaInsurancelistMapper = iaInsurancelistMapper;
    }

    private Date getSysDate() {
        try {
            return this.iaInsurancelistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ia.GIFT.IaInsurancelistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkInsurancelist(IaInsurancelistDomain iaInsurancelistDomain) {
        if (null == iaInsurancelistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)iaInsurancelistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInsurancelistDefault(IaInsurancelist iaInsurancelist) {
        if (null == iaInsurancelist) {
            return;
        }
        if (null == iaInsurancelist.getDataState()) {
            iaInsurancelist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == iaInsurancelist.getGmtCreate()) {
            iaInsurancelist.setGmtCreate(date);
        }
        iaInsurancelist.setGmtModified(date);
        if (StringUtils.isBlank((String)iaInsurancelist.getInsurancelistCode())) {
            iaInsurancelist.setInsurancelistCode(this.getNo(null, "IaInsurancelist", "iaInsurancelist", iaInsurancelist.getTenantCode()));
        }
    }

    private int getInsurancelistMaxCode() {
        int code = 0;
        try {
            return this.iaInsurancelistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ia.GIFT.IaInsurancelistServiceImpl.getInsurancelistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setInsurancelistUpdataDefault(IaInsurancelist iaInsurancelist) {
        if (null == iaInsurancelist) {
            return;
        }
        iaInsurancelist.setGmtModified(this.getSysDate());
    }

    private void saveInsurancelistModel(IaInsurancelist iaInsurancelist) throws ApiException {
        if (null == iaInsurancelist) {
            return;
        }
        try {
            this.iaInsurancelistMapper.insert(iaInsurancelist);
        }
        catch (Exception e) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.saveInsurancelistModel.ex", (Throwable)e);
        }
    }

    private void saveInsurancelistBatchModel(List<IaInsurancelist> iaInsurancelistList) throws ApiException {
        if (null == iaInsurancelistList || iaInsurancelistList.isEmpty()) {
            return;
        }
        try {
            this.iaInsurancelistMapper.insertBatch(iaInsurancelistList);
        }
        catch (Exception e) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.saveInsurancelistBatchModel.ex", (Throwable)e);
        }
    }

    private IaInsurancelist getInsurancelistModelById(Integer insurancelistId) {
        if (null == insurancelistId) {
            return null;
        }
        try {
            return this.iaInsurancelistMapper.selectByPrimaryKey(insurancelistId);
        }
        catch (Exception e) {
            this.logger.error("ia.GIFT.IaInsurancelistServiceImpl.getInsurancelistModelById", (Throwable)e);
            return null;
        }
    }

    private IaInsurancelist getInsurancelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.iaInsurancelistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ia.GIFT.IaInsurancelistServiceImpl.getInsurancelistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delInsurancelistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.iaInsurancelistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.delInsurancelistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.delInsurancelistModelByCode.num");
        }
    }

    private void deleteInsurancelistModel(Integer insurancelistId) throws ApiException {
        if (null == insurancelistId) {
            return;
        }
        int i = 0;
        try {
            i = this.iaInsurancelistMapper.deleteByPrimaryKey(insurancelistId);
        }
        catch (Exception e) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.deleteInsurancelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.deleteInsurancelistModel.num");
        }
    }

    private void updateInsurancelistModel(IaInsurancelist iaInsurancelist) throws ApiException {
        if (null == iaInsurancelist) {
            return;
        }
        int i = 0;
        try {
            i = this.iaInsurancelistMapper.updateByPrimaryKey(iaInsurancelist);
        }
        catch (Exception e) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.updateInsurancelistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.updateInsurancelistModel.num");
        }
    }

    private void updateStateInsurancelistModel(Integer insurancelistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == insurancelistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("insurancelistId", insurancelistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.iaInsurancelistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.updateStateInsurancelistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.updateStateInsurancelistModel.null");
        }
    }

    private void updateStateInsurancelistModelByCode(String tenantCode, String insurancelistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)insurancelistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("insurancelistCode", insurancelistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.iaInsurancelistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.updateStateInsurancelistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.updateStateInsurancelistModelByCode.null");
        }
    }

    private IaInsurancelist makeInsurancelist(IaInsurancelistDomain iaInsurancelistDomain, IaInsurancelist iaInsurancelist) {
        if (null == iaInsurancelistDomain) {
            return null;
        }
        if (null == iaInsurancelist) {
            iaInsurancelist = new IaInsurancelist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)iaInsurancelist, (Object)iaInsurancelistDomain);
            return iaInsurancelist;
        }
        catch (Exception e) {
            this.logger.error("ia.GIFT.IaInsurancelistServiceImpl.makeInsurancelist", (Throwable)e);
            return null;
        }
    }

    private IaInsurancelistReDomain makeIaInsurancelistReDomain(IaInsurancelist iaInsurancelist) {
        if (null == iaInsurancelist) {
            return null;
        }
        IaInsurancelistReDomain iaInsurancelistReDomain = new IaInsurancelistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)iaInsurancelistReDomain, (Object)iaInsurancelist);
            return iaInsurancelistReDomain;
        }
        catch (Exception e) {
            this.logger.error("ia.GIFT.IaInsurancelistServiceImpl.makeIaInsurancelistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<IaInsurancelist> queryInsurancelistModelPage(Map<String, Object> parammap) {
        try {
            return this.iaInsurancelistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ia.GIFT.IaInsurancelistServiceImpl.queryInsurancelistModel", (Throwable)e);
            return null;
        }
    }

    private int countInsurancelist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.iaInsurancelistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ia.GIFT.IaInsurancelistServiceImpl.countInsurancelist", (Throwable)e);
        }
        return i;
    }

    private IaInsurancelist createIaInsurancelist(IaInsurancelistDomain iaInsurancelistDomain) {
        String msg = this.checkInsurancelist(iaInsurancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.saveInsurancelist.checkInsurancelist", msg);
        }
        IaInsurancelist iaInsurancelist = this.makeInsurancelist(iaInsurancelistDomain, null);
        this.setInsurancelistDefault(iaInsurancelist);
        return iaInsurancelist;
    }

    @Override
    public String saveInsurancelist(IaInsurancelistDomain iaInsurancelistDomain) throws ApiException {
        IaInsurancelist iaInsurancelist = this.createIaInsurancelist(iaInsurancelistDomain);
        this.saveInsurancelistModel(iaInsurancelist);
        return iaInsurancelist.getInsurancelistCode();
    }

    @Override
    public String saveInsurancelistBatch(List<IaInsurancelistDomain> iaInsurancelistDomainList) throws ApiException {
        if (null == iaInsurancelistDomainList || iaInsurancelistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<IaInsurancelist> iaInsurancelistList = new ArrayList<IaInsurancelist>();
        String code = "";
        for (IaInsurancelistDomain iaInsurancelistDomain : iaInsurancelistDomainList) {
            IaInsurancelist iaInsurancelist = this.createIaInsurancelist(iaInsurancelistDomain);
            code = iaInsurancelist.getInsurancelistCode();
            iaInsurancelistList.add(iaInsurancelist);
        }
        this.saveInsurancelistBatchModel(iaInsurancelistList);
        return code;
    }

    @Override
    public void updateInsurancelistState(Integer insurancelistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == insurancelistId) {
            return;
        }
        this.updateStateInsurancelistModel(insurancelistId, dataState, oldDataState, map);
    }

    @Override
    public void updateInsurancelistStateByCode(String tenantCode, String insurancelistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)insurancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateInsurancelistModelByCode(tenantCode, insurancelistCode, dataState, oldDataState, map);
    }

    @Override
    public void updateInsurancelist(IaInsurancelistDomain iaInsurancelistDomain) throws ApiException {
        String msg = this.checkInsurancelist(iaInsurancelistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.updateInsurancelist.checkInsurancelist", msg);
        }
        IaInsurancelist oldIaInsurancelist = this.getInsurancelistModelById(iaInsurancelistDomain.getInsurancelistId());
        if (null == oldIaInsurancelist) {
            throw new ApiException("ia.GIFT.IaInsurancelistServiceImpl.updateInsurancelist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        IaInsurancelist iaInsurancelist = this.makeInsurancelist(iaInsurancelistDomain, oldIaInsurancelist);
        this.setInsurancelistUpdataDefault(iaInsurancelist);
        this.updateInsurancelistModel(iaInsurancelist);
    }

    @Override
    public IaInsurancelist getInsurancelist(Integer insurancelistId) {
        if (null == insurancelistId) {
            return null;
        }
        return this.getInsurancelistModelById(insurancelistId);
    }

    @Override
    public void deleteInsurancelist(Integer insurancelistId) throws ApiException {
        if (null == insurancelistId) {
            return;
        }
        this.deleteInsurancelistModel(insurancelistId);
    }

    @Override
    public QueryResult<IaInsurancelist> queryInsurancelistPage(Map<String, Object> map) {
        List<IaInsurancelist> iaInsurancelistList = this.queryInsurancelistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countInsurancelist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(iaInsurancelistList);
        return queryResult;
    }

    @Override
    public IaInsurancelist getInsurancelistByCode(String tenantCode, String insurancelistCode) throws ApiException {
        if (StringUtils.isBlank((String)insurancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("insurancelistCode", insurancelistCode);
        return this.getInsurancelistModelByCode(map);
    }

    @Override
    public void deleteInsurancelistByCode(String tenantCode, String insurancelistCode) throws ApiException {
        if (StringUtils.isBlank((String)insurancelistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("insurancelistCode", insurancelistCode);
        this.delInsurancelistModelByCode(map);
    }
}

