/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.id.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.flow.SoaUtil;
import com.yqbsoft.laser.service.esb.core.flow.UddiUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.id.dao.IdIdpmMapper;
import com.yqbsoft.laser.service.id.domain.IdIdpmDomain;
import com.yqbsoft.laser.service.id.domain.IdIdpmReDomain;
import com.yqbsoft.laser.service.id.domain.OcReorderDomain;
import com.yqbsoft.laser.service.id.domain.PmPromotionDomain;
import com.yqbsoft.laser.service.id.model.IdIdpm;
import com.yqbsoft.laser.service.id.pmes.PmSendPollThread;
import com.yqbsoft.laser.service.id.pmes.PmSendService;
import com.yqbsoft.laser.service.id.service.IdIdpmService;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IdIdpmServiceImpl
extends BaseServiceImpl
implements IdIdpmService {
    private static final String SYS_CODE = "id.tk.IdIdpmServiceImpl";
    private IdIdpmMapper idIdpmMapper;
    private static PmSendService sendService;
    private static Object lock;

    public void setIdIdpmMapper(IdIdpmMapper idIdpmMapper) {
        this.idIdpmMapper = idIdpmMapper;
    }

    private Date getSysDate() {
        try {
            return this.idIdpmMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("id.tk.IdIdpmServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkIdpm(IdIdpmDomain idIdpmDomain) {
        if (null == idIdpmDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)idIdpmDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setIdpmDefault(IdIdpm idIdpm) {
        if (null == idIdpm) {
            return;
        }
        if (null == idIdpm.getDataState()) {
            idIdpm.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == idIdpm.getGmtCreate()) {
            idIdpm.setGmtCreate(date);
        }
        idIdpm.setGmtModified(date);
        if (StringUtils.isBlank((String)idIdpm.getIdpmCode())) {
            idIdpm.setIdpmCode(this.getNo(null, "IdIdpm", "idIdpm", idIdpm.getTenantCode()));
        }
    }

    private int getIdpmMaxCode() {
        int code = 0;
        try {
            return this.idIdpmMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("id.tk.IdIdpmServiceImpl.getIdpmMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setIdpmUpdataDefault(IdIdpm idIdpm) {
        if (null == idIdpm) {
            return;
        }
        idIdpm.setGmtModified(this.getSysDate());
    }

    private void saveIdpmModel(IdIdpm idIdpm) throws ApiException {
        if (null == idIdpm) {
            return;
        }
        try {
            this.idIdpmMapper.insert(idIdpm);
        }
        catch (Exception e) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.saveIdpmModel.ex", (Throwable)e);
        }
    }

    private void saveIdpmBatchModel(List<IdIdpm> idIdpmList) throws ApiException {
        if (null == idIdpmList || idIdpmList.isEmpty()) {
            return;
        }
        try {
            this.idIdpmMapper.insertBatch(idIdpmList);
        }
        catch (Exception e) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.saveIdpmBatchModel.ex", (Throwable)e);
        }
    }

    private IdIdpm getIdpmModelById(Integer ididPmId) {
        if (null == ididPmId) {
            return null;
        }
        try {
            return this.idIdpmMapper.selectByPrimaryKey(ididPmId);
        }
        catch (Exception e) {
            this.logger.error("id.tk.IdIdpmServiceImpl.getIdpmModelById", (Throwable)e);
            return null;
        }
    }

    private IdIdpm getIdpmModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.idIdpmMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("id.tk.IdIdpmServiceImpl.getIdpmModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delIdpmModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.idIdpmMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.delIdpmModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.delIdpmModelByCode.num");
        }
    }

    private void deleteIdpmModel(Integer ididPmId) throws ApiException {
        if (null == ididPmId) {
            return;
        }
        int i = 0;
        try {
            i = this.idIdpmMapper.deleteByPrimaryKey(ididPmId);
        }
        catch (Exception e) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.deleteIdpmModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.deleteIdpmModel.num");
        }
    }

    private void updateIdpmModel(IdIdpm idIdpm) throws ApiException {
        if (null == idIdpm) {
            return;
        }
        int i = 0;
        try {
            i = this.idIdpmMapper.updateByPrimaryKey(idIdpm);
        }
        catch (Exception e) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.updateIdpmModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.updateIdpmModel.num");
        }
    }

    private void updateStateIdpmModel(Integer ididPmId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ididPmId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ididPmId", ididPmId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.idIdpmMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.updateStateIdpmModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.updateStateIdpmModel.null");
        }
    }

    private void updateStateIdpmModelByCode(String tenantCode, String ididPmCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ididPmCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("idpmCode", ididPmCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.idIdpmMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.updateStateIdpmModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.updateStateIdpmModelByCode.null");
        }
    }

    private IdIdpm makeIdpm(IdIdpmDomain idIdpmDomain, IdIdpm idIdpm) {
        if (null == idIdpmDomain) {
            return null;
        }
        if (null == idIdpm) {
            idIdpm = new IdIdpm();
        }
        try {
            BeanUtils.copyAllPropertys((Object)idIdpm, (Object)idIdpmDomain);
            return idIdpm;
        }
        catch (Exception e) {
            this.logger.error("id.tk.IdIdpmServiceImpl.makeIdpm", (Throwable)e);
            return null;
        }
    }

    private IdIdpmReDomain makeIdIdpmReDomain(IdIdpm idIdpm) {
        if (null == idIdpm) {
            return null;
        }
        IdIdpmReDomain idIdpmReDomain = new IdIdpmReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)idIdpmReDomain, (Object)idIdpm);
            return idIdpmReDomain;
        }
        catch (Exception e) {
            this.logger.error("id.tk.IdIdpmServiceImpl.makeIdIdpmReDomain", (Throwable)e);
            return null;
        }
    }

    private List<IdIdpm> queryIdpmModelPage(Map<String, Object> parammap) {
        try {
            return this.idIdpmMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("id.tk.IdIdpmServiceImpl.queryIdpmModel", (Throwable)e);
            return null;
        }
    }

    private int countIdpm(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.idIdpmMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("id.tk.IdIdpmServiceImpl.countIdpm", (Throwable)e);
        }
        return i;
    }

    private IdIdpm createIdIdpm(IdIdpmDomain idIdpmDomain) {
        String msg = this.checkIdpm(idIdpmDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.saveIdpm.checkIdpm", msg);
        }
        IdIdpm idIdpm = this.makeIdpm(idIdpmDomain, null);
        this.setIdpmDefault(idIdpm);
        return idIdpm;
    }

    @Override
    public String saveIdpm(IdIdpmDomain idIdpmDomain) throws ApiException {
        IdIdpm idIdpm = this.createIdIdpm(idIdpmDomain);
        this.saveIdpmModel(idIdpm);
        return idIdpm.getIdpmCode();
    }

    @Override
    public List<IdIdpm> saveIdpmBatch(List<IdIdpmDomain> idIdpmDomainList) throws ApiException {
        if (null == idIdpmDomainList || idIdpmDomainList.isEmpty()) {
            return null;
        }
        ArrayList<IdIdpm> idIdpmList = new ArrayList<IdIdpm>();
        for (IdIdpmDomain idIdpmDomain : idIdpmDomainList) {
            IdIdpm idIdpm = this.createIdIdpm(idIdpmDomain);
            idIdpmList.add(idIdpm);
        }
        this.saveIdpmBatchModel(idIdpmList);
        return idIdpmList;
    }

    @Override
    public void updateIdpmState(Integer ididPmId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ididPmId) {
            return;
        }
        this.updateStateIdpmModel(ididPmId, dataState, oldDataState, map);
    }

    @Override
    public void updateIdpmStateByCode(String tenantCode, String ididPmCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ididPmCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateIdpmModelByCode(tenantCode, ididPmCode, dataState, oldDataState, map);
    }

    @Override
    public void updateIdpm(IdIdpmDomain idIdpmDomain) throws ApiException {
        String msg = this.checkIdpm(idIdpmDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.updateIdpm.checkIdpm", msg);
        }
        IdIdpm oldIdIdpm = this.getIdpmModelById(idIdpmDomain.getIdpmId());
        if (null == oldIdIdpm) {
            throw new ApiException("id.tk.IdIdpmServiceImpl.updateIdpm.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        IdIdpm idIdpm = this.makeIdpm(idIdpmDomain, oldIdIdpm);
        this.setIdpmUpdataDefault(idIdpm);
        this.updateIdpmModel(idIdpm);
    }

    @Override
    public IdIdpm getIdpm(Integer ididPmId) {
        if (null == ididPmId) {
            return null;
        }
        return this.getIdpmModelById(ididPmId);
    }

    @Override
    public void deleteIdpm(Integer ididPmId) throws ApiException {
        if (null == ididPmId) {
            return;
        }
        this.deleteIdpmModel(ididPmId);
    }

    @Override
    public QueryResult<IdIdpm> queryIdpmPage(Map<String, Object> map) {
        List<IdIdpm> idIdpmList = this.queryIdpmModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countIdpm(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(idIdpmList);
        return queryResult;
    }

    @Override
    public IdIdpm getIdpmByCode(String tenantCode, String ididPmCode) throws ApiException {
        if (StringUtils.isBlank((String)ididPmCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("idpmCode", ididPmCode);
        return this.getIdpmModelByCode(map);
    }

    @Override
    public void deleteIdpmByCode(String tenantCode, String ididPmCode) throws ApiException {
        if (StringUtils.isBlank((String)ididPmCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("idpmCode", ididPmCode);
        this.delIdpmModelByCode(map);
    }

    @Override
    public String saveSendIdpm(IdIdpm idIdpm) throws ApiException {
        this.logger.error("id.tk.IdIdpmServiceImpl.saveSendIdpm.res", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)idIdpm));
        if (null == idIdpm) {
            return "error";
        }
        PmPromotionDomain pmPromotionDomain = (PmPromotionDomain)JsonUtil.buildNormalBinder().getJsonToObject(idIdpm.getIdpmOldtxt(), PmPromotionDomain.class);
        if (null == pmPromotionDomain) {
            return "error";
        }
        idIdpm.setIdpmNewtxt(JsonUtil.buildNormalBinder().toJson((Object)pmPromotionDomain));
        IdIdpm idpmByCode = this.getIdpmByCode(idIdpm.getTenantCode(), idIdpm.getIdpmCode());
        pmPromotionDomain.setTenantCode(idIdpm.getTenantCode());
        idIdpm.setIdpmId(idpmByCode.getIdpmId());
        this.updateIdpmModel(idIdpm);
        String res = this.invoke(idIdpm, pmPromotionDomain);
        this.logger.error("id.tk.IdIdpmServiceImpl.saveSendIdpm.res", (Object)res);
        if ("success".equals(res)) {
            this.updateIdpmStateByCode(idIdpm.getTenantCode(), idIdpm.getIdpmCode(), 1, 0, null);
        }
        return null;
    }

    private String invoke(IdIdpm idIdpm, PmPromotionDomain pmPromotionDomain) {
        String res;
        String paramStr;
        if (null == idIdpm || null == pmPromotionDomain) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pmPromotionDomain", pmPromotionDomain);
        map.put("tenantCode", idIdpm.getTenantCode());
        if (!"pmPromotionDomain".equals(idIdpm.getDataParam())) {
            paramStr = SoaUtil.makeParam((String)idIdpm.getDataParam(), (String)idIdpm.getDataCom(), map);
        } else {
            HashMap<String, PmPromotionDomain> callmap = new HashMap<String, PmPromotionDomain>();
            callmap.put("pmPromotionDomain", pmPromotionDomain);
            paramStr = JsonUtil.buildNormalBinder().toJson(callmap);
        }
        Object obj = null;
        try {
            obj = UddiUtil.invokeUrl((String)"API", (String)idIdpm.getIdpmApi(), (String)paramStr, null);
        }
        catch (Exception e) {
            return "success";
        }
        OutMessage outMessage = null;
        if (obj instanceof OutMessage) {
            outMessage = (OutMessage)obj;
            if (outMessage.isError() || null == outMessage.getReObj()) {
                return "error";
            }
            res = outMessage.getReObj().toString();
        } else {
            res = (String)obj;
        }
        if (StringUtils.isBlank((String)res)) {
            this.logger.error("id.tk.IdIdpmServiceImpl.callService.res", (Object)paramStr);
            return "error";
        }
        if (res.equals(idIdpm.getDataFlag())) {
            return "error";
        }
        if (res.indexOf("{") >= 0) {
            OcReorderDomain ocReorderDomain = (OcReorderDomain)JsonUtil.buildNormalBinder().getJsonToObject(res, OcReorderDomain.class);
            if (ocReorderDomain.isError()) {
                this.logger.error(paramStr);
                return "error";
            }
            if (ocReorderDomain.isSuccess()) {
                return "success";
            }
        }
        return "success";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PmSendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new PmSendService((InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter"));
                for (int i = 0; i < 100; ++i) {
                    sendService.addPollPool(new PmSendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    static {
        lock = new Object();
    }
}

