/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.job.schedule;

import com.yqbsoft.laser.service.job.schedule.BaseExecuteServiceImpl;
import com.yqbsoft.laser.service.job.schedule.PointUtil;
import com.yqbsoft.laser.service.job.schedule.ScheduleExeErrorCache;
import com.yqbsoft.laser.service.job.schedule.ScheduleExeSuccessCache;
import com.yqbsoft.laser.service.job.schedule.ScheduleExecuteService;
import com.yqbsoft.laser.service.job.schedule.ScheduleJobEntity;
import com.yqbsoft.laser.service.job.schedule.ScheduleManager;
import com.yqbsoft.laser.service.suppercore.core.JsonReBean;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.TokenUtil;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.HashMap;
import java.util.Map;

public class DefaultScheduleExecuteServiceImpl
extends BaseExecuteServiceImpl
implements ScheduleExecuteService {
    public static final String SYS_CODE = "job.JOB.DefaultScheduleExecuteServiceImpl";
    public static final Long REGEDIT_OVER_TIME = 360000L;

    @Override
    public void execute(ScheduleJobEntity scheduleJobEntity) {
        String jobId = scheduleJobEntity.getJobId();
        String jobGroupId = scheduleJobEntity.getJobGroup();
        String scheduleTappkey = scheduleJobEntity.getScheduleTappkey();
        String url = "";
        if (!this.checkExJob(scheduleJobEntity)) {
            this.logger.info("job.JOB.DefaultScheduleExecuteServiceImpl.execute.noex", (Object)scheduleJobEntity.getJobName());
            return;
        }
        if (StringUtils.isNotBlank((String)scheduleTappkey) && !PointUtil.isAppOnline(scheduleTappkey)) {
            this.logger.info("job.JOB.DefaultScheduleExecuteServiceImpl.execute.nostart", (Object)(scheduleJobEntity.getJobName() + "\uff1a" + scheduleTappkey + " \u670d\u52a1\u672a\u542f\u52a8"));
            this.updateScheduleMsg(jobId, scheduleTappkey + " \u670d\u52a1\u672a\u542f\u52a8");
            return;
        }
        try {
            this.setScheduleService(scheduleJobEntity.getScheduleService());
            Map<String, Object> pmap = scheduleJobEntity.getParamMap();
            if (pmap == null || pmap.isEmpty() || StringUtils.isBlank((String)((String)pmap.get("url")))) {
                if (ScheduleManager.disableSchedule(jobId, jobGroupId)) {
                    this.updateScheduleMsg(jobId, "\u8c03\u7528\u53c2\u6570\u4e3a\u7a7a");
                }
                this.logger.info("job.JOB.DefaultScheduleExecuteServiceImpl.execute.null", (Object)scheduleJobEntity.getJobName());
                return;
            }
            url = (String)pmap.get("url");
            String param = (String)pmap.get("param");
            String type = (String)pmap.get("type");
            if (StringUtils.isBlank((String)type)) {
                type = "GET";
            }
            Map<String, String> params = this.getParams(param);
            String restr = "";
            this.logger.info("job.JOB.DefaultScheduleExecuteServiceImpl.execute.run", (Object)(scheduleJobEntity.getJobName() + "\uff1a" + url));
            restr = type.equals("GET") ? WebUtils.doGet((String)url, params, (int)3000, (int)0) : WebUtils.doPost((String)url, params, (int)3000, (int)0);
            this.logger.info("job.JOB.DefaultScheduleExecuteServiceImpl.execute.end", (Object)(scheduleJobEntity.getJobName() + "\uff1a" + restr));
            boolean flag = true;
            if (null != restr) {
                JsonReBean jrb = (JsonReBean)JsonUtil.buildNormalBinder().getJsonToObject(restr, JsonReBean.class);
                if (null == jrb || !jrb.isSuccess()) {
                    flag = false;
                    this.logger.error("job.JOB.DefaultScheduleExecuteServiceImpl.execute.jrb", (Object)("(" + url + ")" + restr));
                    this.exceptionUpdateScheduleMsg(scheduleJobEntity, restr);
                } else {
                    flag = true;
                }
            }
            if (flag) {
                this.updateScheduleMsg(jobId, "");
                String successKey = TokenUtil.genToken((Object[])new Object[]{scheduleJobEntity.getJobName(), scheduleJobEntity.getScheduleTappkey()});
                ScheduleExeSuccessCache.getInstance().put(successKey, scheduleJobEntity.getScheduleTappkeyUUID());
                this.logger.info("job.JOB.DefaultScheduleExecuteServiceImpl.execute.successKey", (Object)(successKey + "=" + scheduleJobEntity.getScheduleTappkeyUUID()));
                ScheduleExeErrorCache.getInstance().getErrorJobMap().remove(jobId);
            }
        }
        catch (Exception e) {
            this.logger.error("job.JOB.DefaultScheduleExecuteServiceImpl.execute.e", (Object)(scheduleJobEntity.getJobName() + "=" + url), (Throwable)e);
            this.exceptionUpdateScheduleMsg(scheduleJobEntity, e.getMessage());
        }
    }

    private Map<String, String> getParams(String param) {
        if (StringUtils.isBlank((String)param)) {
            return null;
        }
        HashMap<String, String> params = null;
        String[] paramStrs = param.split("&");
        if (paramStrs != null && paramStrs.length > 0) {
            params = new HashMap<String, String>();
            for (int i = 0; i < paramStrs.length; ++i) {
                params.put(paramStrs[i].split("=")[0], paramStrs[i].split("=")[1]);
            }
        }
        return params;
    }

    public boolean checkExJob(ScheduleJobEntity scheduleJobEntity) {
        String[] exJobIds = scheduleJobEntity.getExJobIds();
        if (exJobIds != null && exJobIds.length > 0) {
            String exuuid = null;
            String successKey = "";
            ScheduleJobEntity pscheduling = null;
            for (int i = 0; i < exJobIds.length; ++i) {
                pscheduling = ScheduleExeSuccessCache.getInstance().getjobNameMap().get(exJobIds[i]);
                if (null == pscheduling) {
                    this.logger.error("job.JOB.DefaultScheduleExecuteServiceImpl.null", (Object)(scheduleJobEntity.getJobName() + "==" + exJobIds[i] + "==" + exuuid + "==" + scheduleJobEntity.getScheduleTappkeyUUID()));
                    return false;
                }
                if (pscheduling.getScheduleTappkey().equals(scheduleJobEntity.getScheduleTappkey()) && !pscheduling.getScheduleTappkeyUUID().equals(scheduleJobEntity.getScheduleTappkeyUUID())) {
                    this.logger.error("job.JOB.DefaultScheduleExecuteServiceImpl.uuid", (Object)(scheduleJobEntity.getJobName() + "==" + exJobIds[i] + "==" + pscheduling.getScheduleTappkeyUUID() + "==" + scheduleJobEntity.getScheduleTappkeyUUID()));
                    return false;
                }
                successKey = TokenUtil.genToken((Object[])new Object[]{exJobIds[i], pscheduling.getScheduleTappkey()});
                exuuid = ScheduleExeSuccessCache.getInstance().getSuccessJobMap().get(successKey);
                if (!StringUtils.isBlank((String)exuuid) && exuuid.equals(pscheduling.getScheduleTappkeyUUID())) continue;
                this.logger.error("job.JOB.DefaultScheduleExecuteServiceImpl.error", (Object)(scheduleJobEntity.getJobName() + "==" + exJobIds[i] + "==" + successKey + "==" + "==" + exuuid + "==" + pscheduling.getScheduleTappkeyUUID()));
                return false;
            }
        }
        return true;
    }
}

