/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.job.schedule;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PointUtil {
    public static final Long REGEDIT_OVER_TIME = 40000L;
    public static final String APPMANAGE_KEY = "Appmanage-key-line";
    public static final String VFOAPPMANAGE_LINEINFO = "EcoreAppmanage-lineInfo";

    public static boolean isAppOnline(String appmanageAppkey) {
        if (StringUtils.isBlank((String)appmanageAppkey)) {
            return false;
        }
        RegeditBean regeditBean = null;
        if (null != ServletMain.regeditBean && appmanageAppkey.equals(ServletMain.regeditBean.getAppkey())) {
            regeditBean = ServletMain.regeditBean;
        }
        if (null == regeditBean) {
            regeditBean = PointUtil.getRegeditBean(appmanageAppkey);
        }
        if (regeditBean == null) {
            return false;
        }
        return System.currentTimeMillis() <= regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME;
    }

    public static RegeditBean getRegeditBean(String appmanageAppkey) {
        String js = DisUtil.getRemotMap((String)VFOAPPMANAGE_LINEINFO, (String)appmanageAppkey);
        if (StringUtils.isBlank((String)js)) {
            return null;
        }
        RegeditBean regeditBean = (RegeditBean)JsonUtil.buildNormalBinder().getJsonToObject(js, RegeditBean.class);
        return regeditBean;
    }

    public static Set<String> getPointAppKeys(String appmanageIcode, String appmanageAppkey) {
        if (StringUtils.isBlank((String)appmanageIcode) || StringUtils.isBlank((String)appmanageAppkey)) {
            return null;
        }
        Map appkeyMap = DisUtil.getRemotMapAll((String)APPMANAGE_KEY);
        if ("all".equals(appmanageIcode) && null != appkeyMap) {
            return appkeyMap.keySet();
        }
        HashSet<String> newAppKey = new HashSet<String>();
        if (null == appkeyMap || appkeyMap.isEmpty()) {
            RegeditBean regeditBean = PointUtil.getRegeditBean(appmanageAppkey);
            if (null != regeditBean && System.currentTimeMillis() <= regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME) {
                newAppKey.add(appmanageAppkey);
            }
        } else {
            for (String key : appkeyMap.keySet()) {
                RegeditBean regeditBean;
                if (!appmanageIcode.equals(appkeyMap.get(key)) || (regeditBean = PointUtil.getRegeditBean(key)) == null || System.currentTimeMillis() > regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME) continue;
                newAppKey.add(key);
            }
        }
        if (newAppKey.isEmpty()) {
            newAppKey.add(appmanageAppkey);
        }
        return newAppKey;
    }
}

