/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.logistics.service.impl;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.logistics.LogisticsConstants;
import com.yqbsoft.laser.service.logistics.domain.WlTraceDomain;
import com.yqbsoft.laser.service.logistics.domain.WlTraceReDomain;
import com.yqbsoft.laser.service.logistics.kdniao.api.KdniaoInterfaceAPI;
import com.yqbsoft.laser.service.logistics.kdniao.bean.KdniaoCommodity;
import com.yqbsoft.laser.service.logistics.kdniao.bean.KdniaoEOrder;
import com.yqbsoft.laser.service.logistics.kdniao.bean.KdniaoLogistic;
import com.yqbsoft.laser.service.logistics.kdniao.bean.KdniaoOrder;
import com.yqbsoft.laser.service.logistics.kdniao.bean.KdniaoPush;
import com.yqbsoft.laser.service.logistics.kdniao.bean.KdniaoResponse;
import com.yqbsoft.laser.service.logistics.kdniao.bean.KdniaoWaybill;
import com.yqbsoft.laser.service.logistics.kdniao.bean.Kdniaopeople;
import com.yqbsoft.laser.service.logistics.kdniao.enums.KdniaoResponseCodeEnum;
import com.yqbsoft.laser.service.logistics.model.WlTrace;
import com.yqbsoft.laser.service.logistics.service.WlThirdService;
import com.yqbsoft.laser.service.logistics.service.WlTraceService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class WlThirdServiceImpl
extends BaseServiceImpl
implements WlThirdService {
    public static final String SYS_CODE = "wl.LOGISTICS.WlThirdServiceImpl";
    @Autowired
    WlTraceService wlTraceService;

    @Override
    public void sendTraceToThird(WlTrace wlTrace) {
        if (wlTrace == null) {
            this.logger.error("wl.LOGISTICS.WlThirdServiceImpl.sendTraceToThird", (Object)"\u53c2\u6570\u4e3a\u7a7a!");
            return;
        }
        this.sendSendTrace(wlTrace.getTenantCode(), wlTrace.getTraceCode());
    }

    public void sendSendTrace(String tenantCode, String traceCode) {
        WlTrace wlTrace = this.getTrace(tenantCode, traceCode);
        if (wlTrace == null) {
            this.logger.error("wl.LOGISTICS.WlThirdServiceImpl.sendTraceToThird", (Object)"\u53c2\u6570\u4e3a\u7a7a!");
            return;
        }
        KdniaoWaybill kdniaoWaybill = this.makeKdnWaybill(wlTrace);
        String result = new KdniaoInterfaceAPI().orderOnlineByJson(kdniaoWaybill, wlTrace.getTenantCode());
        if (StringUtils.isBlank((CharSequence)result)) {
            return;
        }
        KdniaoEOrder kdniaoEOrder = (KdniaoEOrder)JsonUtil.buildNormalBinder().getJsonToObject(result, KdniaoEOrder.class);
        String resultCode = kdniaoEOrder.getResultCode();
        if (KdniaoResponseCodeEnum.CODE_100.getCode().equals(resultCode)) {
            WlTraceDomain wlTraceDomain = new WlTraceDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)wlTraceDomain, (Object)wlTrace);
            }
            catch (Exception e) {
                // empty catch block
            }
            KdniaoOrder order = kdniaoEOrder.getOrder();
            if (order == null) {
                this.logger.error("wl.LOGISTICS.WlThirdServiceImpl.sendTraceToThird", (Object)"KdniaoOrder is null");
                return;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("traceBillno", order.getLogisticCode());
            map.put("tracePrintTemplate", kdniaoEOrder.getPrintTemplate());
            map.put("traceState", 0);
            map.put("dataState", LogisticsConstants.TRACE_DATA_STATE_1);
            this.wlTraceService.updateTraceMap(wlTrace.getTraceId(), LogisticsConstants.TRACE_DATA_STATE_0, map);
            this.orderTraces(wlTrace.getTraceId(), wlTrace.getExpressCode(), order.getLogisticCode(), wlTrace.getTenantCode());
        } else {
            this.logger.error("wl.LOGISTICS.WlThirdServiceImpl.sendTraceToThird", (Object)KdniaoResponseCodeEnum.valueOf(resultCode).getMsg());
        }
    }

    @Override
    public void orderTraces(Integer traceId, String expressCode, String traceBillno, String tenantCode) {
        String edition;
        this.logger.info("\u8ba2\u9605\u5f00\u59cb,\u3010" + expressCode + "\u3011\u8fd0\u5355\u53f7:" + traceBillno);
        if (traceId == null || StringUtil.isBlank((String)expressCode) || StringUtil.isBlank((String)traceBillno) || StringUtil.isBlank((String)tenantCode)) {
            this.logger.error("wl.LOGISTICS.WlThirdServiceImpl.orderTraces", (Object)"\u53c2\u6570\u4e3a\u7a7a");
        }
        String result = StringUtils.isNotBlank((CharSequence)(edition = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-wl-edition")))) && "pay".equals(edition) ? new KdniaoInterfaceAPI().orderTracesSubByJsonWithCharge(expressCode, traceBillno, tenantCode) : new KdniaoInterfaceAPI().orderTracesSubByJson(expressCode, traceBillno, tenantCode);
        KdniaoResponse kdniaoResponse = (KdniaoResponse)JsonUtil.buildNormalBinder().getJsonToObject(result, KdniaoResponse.class);
        if (kdniaoResponse.getSuccess().booleanValue()) {
            this.wlTraceService.updateTraceState(traceId, LogisticsConstants.TRACE_DATA_STATE_2, LogisticsConstants.TRACE_DATA_STATE_1);
            this.logger.info("wl.LOGISTICS.WlThirdServiceImpl.orderTraces", (Object)("\u3010" + expressCode + "\u3011\u8fd0\u5355\u53f7:" + traceBillno + ",\u8ba2\u9605\u6210\u529f"));
        } else {
            this.logger.error("wl.LOGISTICS.WlThirdServiceImpl.orderTraces", (Object)kdniaoResponse.getReason());
        }
        this.logger.info("\u8ba2\u9605\u7ed3\u675f,\u3010" + expressCode + "\u3011\u8fd0\u5355\u53f7:" + traceBillno);
    }

    private KdniaoWaybill makeKdnWaybill(WlTrace wlTrace) {
        KdniaoWaybill kdniaoWaybill = new KdniaoWaybill();
        kdniaoWaybill.setShipperCode(wlTrace.getExpressCode());
        kdniaoWaybill.setOrderCode(wlTrace.getTraceCode());
        kdniaoWaybill.setPayType(wlTrace.getTracePaytype());
        Kdniaopeople receiver = new Kdniaopeople();
        receiver.setName(wlTrace.getTraceRName());
        receiver.setMobile(wlTrace.getTraceRMobile());
        receiver.setTel(wlTrace.getTraceRTel());
        receiver.setProvinceName(wlTrace.getTraceRProvincename());
        receiver.setCityName(wlTrace.getTraceRAreaname());
        receiver.setExpAreaName(wlTrace.getTraceRCityname());
        receiver.setAddress(wlTrace.getTraceRAddress());
        Kdniaopeople sender = new Kdniaopeople();
        sender.setName(wlTrace.getTraceSName());
        sender.setMobile(wlTrace.getTraceSMobile());
        sender.setTel(wlTrace.getTraceSTel());
        sender.setProvinceName(wlTrace.getTraceSProvincename());
        sender.setCityName(wlTrace.getTraceSAreaname());
        sender.setExpAreaName(wlTrace.getTraceSCityname());
        sender.setAddress(wlTrace.getTraceSAddress());
        kdniaoWaybill.setReceiver(receiver);
        kdniaoWaybill.setSender(sender);
        String goodsStr = wlTrace.getTraceGoods();
        kdniaoWaybill.setCommodity((List)JsonUtil.buildNormalBinder().getJsonToList(goodsStr, KdniaoCommodity.class));
        return kdniaoWaybill;
    }

    private WlTrace getTrace(String tenantCode, String traceCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("traceCode", traceCode);
        return this.wlTraceService.getTraceByCode(map);
    }

    @Override
    public synchronized void loadOrderTraces() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", LogisticsConstants.TRACE_DATA_STATE_1);
        QueryResult<WlTrace> queryResult = this.wlTraceService.queryTracePage(map);
        if (queryResult == null || queryResult.getList().isEmpty() || queryResult.getList() == null) {
            return;
        }
        for (WlTrace wlTrace : queryResult.getList()) {
            try {
                this.orderTraces(wlTrace.getTraceId(), wlTrace.getExpressCode(), wlTrace.getTraceBillno(), wlTrace.getTenantCode());
            }
            catch (Exception e) {
                this.logger.error("\u5b9a\u65f6\u8865\u5355\u8ba2\u9605\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public void loadSendTraces() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", LogisticsConstants.TRACE_DATA_STATE_0);
        QueryResult<WlTrace> queryResult = this.wlTraceService.queryTracePage(map);
        if (queryResult == null || queryResult.getList().isEmpty() || queryResult.getList() == null) {
            return;
        }
        for (WlTrace wlTrace : queryResult.getList()) {
            try {
                this.sendSendTrace(wlTrace.getTenantCode(), wlTrace.getTraceCode());
            }
            catch (Exception e) {
                this.logger.error("\u5b9a\u65f6\u8865\u5355\u8ba2\u9605\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public String getThirdTraceByCode(String tenantCode, String expressCode, String traceBillno) {
        if (StringUtil.isBlank((String)tenantCode) || StringUtil.isBlank((String)expressCode) || StringUtil.isBlank((String)traceBillno)) {
            this.logger.error("wl.LOGISTICS.WlThirdServiceImpl.getThirdTraceByCode", (Object)(" param is null. \u3010tenantCode=" + tenantCode + "\u3011\u3010expressCode=" + expressCode + "\u3011\u3010traceBillno=" + traceBillno + "\u3011"));
            return null;
        }
        String key = tenantCode + expressCode + traceBillno;
        String result = SupDisUtil.get((String)key);
        String edition = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-wl-edition"));
        if (StringUtil.isBlank((String)result)) {
            result = StringUtils.isNotBlank((CharSequence)edition) && "pay".equals(edition) ? new KdniaoInterfaceAPI().getOrderTracesByJsonWithCharge(expressCode, traceBillno, tenantCode) : new KdniaoInterfaceAPI().getOrderTracesByJson(expressCode, traceBillno, tenantCode);
            SupDisUtil.set((String)key, (String)result, (int)3600);
        }
        KdniaoResponse resultResponse = (KdniaoResponse)JsonUtil.buildNormalBinder().getJsonToObject(result, KdniaoResponse.class);
        ArrayList<KdniaoLogistic> traces = new ArrayList<KdniaoLogistic>();
        List<KdniaoLogistic> list = resultResponse.getTraces();
        if (list != null && !list.isEmpty()) {
            for (int i = list.size() - 1; i > -1; --i) {
                traces.add(list.get(i));
            }
        }
        resultResponse.setTraces(traces);
        return JsonUtil.buildNormalBinder().toJson((Object)resultResponse);
    }

    @Override
    public void pushTraces(String EBusinessID, String RequestData, HttpServletResponse response) {
        if (StringUtils.isBlank((CharSequence)RequestData) || StringUtils.isBlank((CharSequence)EBusinessID)) {
            this.logger.error("wl.LOGISTICS.WlThirdServiceImplpushTraces", (Object)("param is null  \u3010RequestData" + RequestData + "\u3011\u3010EBusinessID" + EBusinessID + "\u3011"));
        } else {
            KdniaoPush kdniaoPush = (KdniaoPush)JsonUtil.buildNormalBinder().getJsonToObject(RequestData, KdniaoPush.class);
            this.logger.error("pushTraces", (Object)("kdniaoPush" + kdniaoPush));
            List<KdniaoResponse> data = kdniaoPush.getData();
            WlTraceReDomain wlTrace = new WlTraceReDomain();
            ArrayList<WlTraceDomain> traceList = new ArrayList<WlTraceDomain>();
            ArrayList<KdniaoLogistic> traces = new ArrayList<KdniaoLogistic>();
            for (KdniaoResponse kdniaoResponse : data) {
                List<KdniaoLogistic> list = kdniaoResponse.getTraces();
                if (list != null && !list.isEmpty()) {
                    for (int i = list.size() - 1; i > -1; --i) {
                        traces.add(list.get(i));
                    }
                }
                kdniaoResponse.setTraces(traces);
                String jsonTrace = JsonUtil.buildNormalBinder().toJson((Object)kdniaoResponse);
                wlTrace.setTraceBillno(kdniaoResponse.getLogisticCode());
                wlTrace.setExpressCode(kdniaoResponse.getShipperCode());
                wlTrace.setTraceDynamic(jsonTrace);
                traceList.add(wlTrace);
                this.logger.error("pushTraces", (Object)("traceList" + traceList));
                traces.clear();
            }
            this.wlTraceService.updateTraceList(traceList);
            EBusinessID = kdniaoPush.getEBusinessID();
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        String responseResult = "{\"EBusinessID\":\"" + EBusinessID + "\",\"UpdateTime\":\"" + sdf.format(date) + "\",\"Success\":true,\"Reason\":\"\"}";
        this.logger.error("pushTraces", (Object)("responseResult---" + responseResult));
        try {
            this.logger.error("pushTraces", (Object)("response---" + response));
            response.getWriter().write(responseResult);
        }
        catch (IOException e) {
            this.logger.error("\u5411\u5feb\u9012\u9e1f\u53d1\u9001\u54cd\u5e94\u5931\u8d25", (Throwable)e);
        }
    }
}

