/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.lt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.lt.dao.LtLtinfoGoodsMapper;
import com.yqbsoft.laser.service.lt.dao.LtLtinfoLevelMapper;
import com.yqbsoft.laser.service.lt.dao.LtLtinfoMapper;
import com.yqbsoft.laser.service.lt.domain.LtLtinfoDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtinfoGoodsDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtinfoGoodsReDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtinfoLevelDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtinfoLevelReDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtinfoReDomain;
import com.yqbsoft.laser.service.lt.model.LtLtinfo;
import com.yqbsoft.laser.service.lt.model.LtLtinfoGoods;
import com.yqbsoft.laser.service.lt.model.LtLtinfoLevel;
import com.yqbsoft.laser.service.lt.service.LtLtinfoService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LtLtinfoServiceImpl
extends BaseServiceImpl
implements LtLtinfoService {
    private static final String SYS_CODE = "lt.LtLtinfoServiceImpl";
    private LtLtinfoMapper ltLtinfoMapper;
    private LtLtinfoLevelMapper ltLtinfoLevelMapper;
    private LtLtinfoGoodsMapper ltLtinfoGoodsMapper;

    public void setLtLtinfoMapper(LtLtinfoMapper ltLtinfoMapper) {
        this.ltLtinfoMapper = ltLtinfoMapper;
    }

    public void setLtLtinfoLevelMapper(LtLtinfoLevelMapper ltLtinfoLevelMapper) {
        this.ltLtinfoLevelMapper = ltLtinfoLevelMapper;
    }

    public void setLtLtinfoGoodsMapper(LtLtinfoGoodsMapper ltLtinfoGoodsMapper) {
        this.ltLtinfoGoodsMapper = ltLtinfoGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ltLtinfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkLtinfo(LtLtinfoDomain ltLtinfoDomain) {
        if (null == ltLtinfoDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ltLtinfoDomain.getMemberCode())) {
            msg = msg + "MemberCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ltLtinfoDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLtinfoDefault(LtLtinfo ltLtinfo) {
        if (null == ltLtinfo) {
            return;
        }
        if (null == ltLtinfo.getDataState()) {
            ltLtinfo.setDataState(0);
        }
        if (null == ltLtinfo.getGmtCreate()) {
            ltLtinfo.setGmtCreate(this.getSysDate());
        }
        ltLtinfo.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ltLtinfo.getLtinfoCode())) {
            ltLtinfo.setLtinfoCode(this.createUUIDString());
        }
    }

    private int getLtinfoMaxCode() {
        int code = 0;
        try {
            return this.ltLtinfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getLtinfoMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLtinfoUpdataDefault(LtLtinfo ltLtinfo) {
        if (null == ltLtinfo) {
            return;
        }
        ltLtinfo.setGmtModified(this.getSysDate());
    }

    private void saveLtinfoModel(LtLtinfo ltLtinfo) throws ApiException {
        if (null == ltLtinfo) {
            return;
        }
        try {
            this.ltLtinfoMapper.insert(ltLtinfo);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.saveLtinfoModel.ex", (Throwable)e);
        }
    }

    private void saveLtinfoBatchModel(List<LtLtinfo> ltLtinfoList) throws ApiException {
        if (null == ltLtinfoList || ltLtinfoList.isEmpty()) {
            return;
        }
        try {
            this.ltLtinfoMapper.insertBatch(ltLtinfoList);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.saveLtinfoBatchModel.ex", (Throwable)e);
        }
    }

    private LtLtinfo getLtinfoModelById(Integer ltinfoId) {
        if (null == ltinfoId) {
            return null;
        }
        try {
            return this.ltLtinfoMapper.selectByPrimaryKey(ltinfoId);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getLtinfoModelById", (Throwable)e);
            return null;
        }
    }

    private LtLtinfo getLtinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ltLtinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getLtinfoModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delLtinfoModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtinfoMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.delLtinfoModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtinfoServiceImpl.delLtinfoModelByCode.num");
        }
    }

    private void deleteLtinfoModel(Integer ltinfoId) throws ApiException {
        if (null == ltinfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtinfoMapper.deleteByPrimaryKey(ltinfoId);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.deleteLtinfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtinfoServiceImpl.deleteLtinfoModel.num");
        }
    }

    private void updateLtinfoModel(LtLtinfo ltLtinfo) throws ApiException {
        if (null == ltLtinfo) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtinfoMapper.updateByPrimaryKey(ltLtinfo);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoModel.num");
        }
    }

    private void updateStateLtinfoModel(Integer ltinfoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ltinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ltinfoId", ltinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoModel.null");
        }
    }

    private void updateStateLtinfoModelByCode(String tenantCode, String ltinfoCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ltinfoCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoCode", ltinfoCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtinfoMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoModelByCode.null");
        }
    }

    private LtLtinfo makeLtinfo(LtLtinfoDomain ltLtinfoDomain, LtLtinfo ltLtinfo) {
        if (null == ltLtinfoDomain) {
            return null;
        }
        if (null == ltLtinfo) {
            ltLtinfo = new LtLtinfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ltLtinfo, (Object)ltLtinfoDomain);
            return ltLtinfo;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.makeLtinfo", (Throwable)e);
            return null;
        }
    }

    private LtLtinfoReDomain makeLtLtinfoReDomain(LtLtinfo ltLtinfo) {
        if (null == ltLtinfo) {
            return null;
        }
        LtLtinfoReDomain ltLtinfoReDomain = new LtLtinfoReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ltLtinfoReDomain, (Object)ltLtinfo);
            return ltLtinfoReDomain;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.makeLtLtinfoReDomain", (Throwable)e);
            return null;
        }
    }

    private List<LtLtinfo> queryLtinfoModelPage(Map<String, Object> parammap) {
        try {
            return this.ltLtinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.queryLtinfoModel", (Throwable)e);
            return null;
        }
    }

    private int countLtinfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ltLtinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.countLtinfo", (Throwable)e);
        }
        return i;
    }

    private LtLtinfo createLtLtinfo(LtLtinfoDomain ltLtinfoDomain) {
        String msg = this.checkLtinfo(ltLtinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtinfoServiceImpl.saveLtinfo.checkLtinfo", msg);
        }
        LtLtinfo ltLtinfo = this.makeLtinfo(ltLtinfoDomain, null);
        this.setLtinfoDefault(ltLtinfo);
        return ltLtinfo;
    }

    private String checkLtinfoLevel(LtLtinfoLevelDomain ltLtinfoLevelDomain) {
        if (null == ltLtinfoLevelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ltLtinfoLevelDomain.getLtinfoLevelName())) {
            msg = msg + "LtinfoLevelName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ltLtinfoLevelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLtinfoLevelDefault(LtLtinfoLevel ltLtinfoLevel) {
        if (null == ltLtinfoLevel) {
            return;
        }
        if (null == ltLtinfoLevel.getDataState()) {
            ltLtinfoLevel.setDataState(0);
        }
        if (null == ltLtinfoLevel.getGmtCreate()) {
            ltLtinfoLevel.setGmtCreate(this.getSysDate());
        }
        ltLtinfoLevel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ltLtinfoLevel.getLtinfoLevelCode())) {
            ltLtinfoLevel.setLtinfoLevelCode(this.createUUIDString());
        }
    }

    private int getLtinfoLevelMaxCode() {
        int code = 0;
        try {
            return this.ltLtinfoLevelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getLtinfoLevelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLtinfoLevelUpdataDefault(LtLtinfoLevel ltLtinfoLevel) {
        if (null == ltLtinfoLevel) {
            return;
        }
        ltLtinfoLevel.setGmtModified(this.getSysDate());
    }

    private void saveLtinfoLevelModel(LtLtinfoLevel ltLtinfoLevel) throws ApiException {
        if (null == ltLtinfoLevel) {
            return;
        }
        try {
            this.ltLtinfoLevelMapper.insert(ltLtinfoLevel);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.saveLtinfoLevelModel.ex", (Throwable)e);
        }
    }

    private void saveLtinfoLevelBatchModel(List<LtLtinfoLevel> ltLtinfoLevelList) throws ApiException {
        if (null == ltLtinfoLevelList || ltLtinfoLevelList.isEmpty()) {
            return;
        }
        try {
            this.ltLtinfoLevelMapper.insertBatch(ltLtinfoLevelList);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.saveLtinfoLevelBatchModel.ex", (Throwable)e);
        }
    }

    private LtLtinfoLevel getLtinfoLevelModelById(Integer ltinfoLevelId) {
        if (null == ltinfoLevelId) {
            return null;
        }
        try {
            return this.ltLtinfoLevelMapper.selectByPrimaryKey(ltinfoLevelId);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getLtinfoLevelModelById", (Throwable)e);
            return null;
        }
    }

    private LtLtinfoLevel getLtinfoLevelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ltLtinfoLevelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getLtinfoLevelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delLtinfoLevelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtinfoLevelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.delLtinfoLevelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtinfoServiceImpl.delLtinfoLevelModelByCode.num");
        }
    }

    private void deleteLtinfoLevelModel(Integer ltinfoLevelId) throws ApiException {
        if (null == ltinfoLevelId) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtinfoLevelMapper.deleteByPrimaryKey(ltinfoLevelId);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.deleteLtinfoLevelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtinfoServiceImpl.deleteLtinfoLevelModel.num");
        }
    }

    private void updateLtinfoLevelModel(LtLtinfoLevel ltLtinfoLevel) throws ApiException {
        if (null == ltLtinfoLevel) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtinfoLevelMapper.updateByPrimaryKey(ltLtinfoLevel);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoLevelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoLevelModel.num");
        }
    }

    private void updateStateLtinfoLevelModel(Integer ltinfoLevelId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ltinfoLevelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ltinfoLevelId", ltinfoLevelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtinfoLevelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoLevelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoLevelModel.null");
        }
    }

    private void updateStateLtinfoLevelModelByCode(String tenantCode, String ltinfoLevelCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ltinfoLevelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoLevelCode", ltinfoLevelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtinfoLevelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoLevelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoLevelModelByCode.null");
        }
    }

    private LtLtinfoLevel makeLtinfoLevel(LtLtinfoLevelDomain ltLtinfoLevelDomain, LtLtinfoLevel ltLtinfoLevel) {
        if (null == ltLtinfoLevelDomain) {
            return null;
        }
        if (null == ltLtinfoLevel) {
            ltLtinfoLevel = new LtLtinfoLevel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ltLtinfoLevel, (Object)ltLtinfoLevelDomain);
            return ltLtinfoLevel;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.makeLtinfoLevel", (Throwable)e);
            return null;
        }
    }

    private LtLtinfoLevelReDomain makeLtLtinfoLevelReDomain(LtLtinfoLevel ltLtinfoLevel) {
        if (null == ltLtinfoLevel) {
            return null;
        }
        LtLtinfoLevelReDomain ltLtinfoLevelReDomain = new LtLtinfoLevelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ltLtinfoLevelReDomain, (Object)ltLtinfoLevel);
            return ltLtinfoLevelReDomain;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.makeLtLtinfoLevelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<LtLtinfoLevel> queryLtinfoLevelModelPage(Map<String, Object> parammap) {
        try {
            return this.ltLtinfoLevelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.queryLtinfoLevelModel", (Throwable)e);
            return null;
        }
    }

    private int countLtinfoLevel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ltLtinfoLevelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.countLtinfoLevel", (Throwable)e);
        }
        return i;
    }

    private LtLtinfoLevel createLtLtinfoLevel(LtLtinfoLevelDomain ltLtinfoLevelDomain) {
        String msg = this.checkLtinfoLevel(ltLtinfoLevelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtinfoServiceImpl.saveLtinfoLevel.checkLtinfoLevel", msg);
        }
        LtLtinfoLevel ltLtinfoLevel = this.makeLtinfoLevel(ltLtinfoLevelDomain, null);
        this.setLtinfoLevelDefault(ltLtinfoLevel);
        return ltLtinfoLevel;
    }

    private String checkLtinfoGoods(LtLtinfoGoodsDomain ltLtinfoGoodsDomain) {
        if (null == ltLtinfoGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((Integer)ltLtinfoGoodsDomain.getLtinfoGoodsVnum())) {
            msg = msg + "LtinfoGoodsVnum\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ltLtinfoGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLtinfoGoodsDefault(LtLtinfoGoods ltLtinfoGoods) {
        if (null == ltLtinfoGoods) {
            return;
        }
        if (null == ltLtinfoGoods.getDataState()) {
            ltLtinfoGoods.setDataState(0);
        }
        if (null == ltLtinfoGoods.getGmtCreate()) {
            ltLtinfoGoods.setGmtCreate(this.getSysDate());
        }
        ltLtinfoGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ltLtinfoGoods.getLtinfoGoodsCode())) {
            ltLtinfoGoods.setLtinfoGoodsCode(this.createUUIDString());
        }
    }

    private int getLtinfoGoodsMaxCode() {
        int code = 0;
        try {
            return this.ltLtinfoGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getLtinfoGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLtinfoGoodsUpdataDefault(LtLtinfoGoods ltLtinfoGoods) {
        if (null == ltLtinfoGoods) {
            return;
        }
        ltLtinfoGoods.setGmtModified(this.getSysDate());
    }

    private void saveLtinfoGoodsModel(LtLtinfoGoods ltLtinfoGoods) throws ApiException {
        if (null == ltLtinfoGoods) {
            return;
        }
        try {
            this.ltLtinfoGoodsMapper.insert(ltLtinfoGoods);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.saveLtinfoGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveLtinfoGoodsBatchModel(List<LtLtinfoGoods> ltLtinfoGoodsList) throws ApiException {
        if (null == ltLtinfoGoodsList || ltLtinfoGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ltLtinfoGoodsMapper.insertBatch(ltLtinfoGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.saveLtinfoGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private LtLtinfoGoods getLtinfoGoodsModelById(Integer ltinfoGoodsId) {
        if (null == ltinfoGoodsId) {
            return null;
        }
        try {
            return this.ltLtinfoGoodsMapper.selectByPrimaryKey(ltinfoGoodsId);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getLtinfoGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private LtLtinfoGoods getLtinfoGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ltLtinfoGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.getLtinfoGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delLtinfoGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtinfoGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.delLtinfoGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtinfoServiceImpl.delLtinfoGoodsModelByCode.num");
        }
    }

    private void deleteLtinfoGoodsModel(Integer ltinfoGoodsId) throws ApiException {
        if (null == ltinfoGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtinfoGoodsMapper.deleteByPrimaryKey(ltinfoGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.deleteLtinfoGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtinfoServiceImpl.deleteLtinfoGoodsModel.num");
        }
    }

    private void updateLtinfoGoodsModel(LtLtinfoGoods ltLtinfoGoods) throws ApiException {
        if (null == ltLtinfoGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtinfoGoodsMapper.updateByPrimaryKey(ltLtinfoGoods);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoGoodsModel.num");
        }
    }

    private void updateStateLtinfoGoodsModel(Integer ltinfoGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ltinfoGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ltinfoGoodsId", ltinfoGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtinfoGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoGoodsModel.null");
        }
    }

    private void updateStateLtinfoGoodsModelByCode(String tenantCode, String ltinfoGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ltinfoGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoGoodsCode", ltinfoGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtinfoGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateStateLtinfoGoodsModelByCode.null");
        }
    }

    private LtLtinfoGoods makeLtinfoGoods(LtLtinfoGoodsDomain ltLtinfoGoodsDomain, LtLtinfoGoods ltLtinfoGoods) {
        if (null == ltLtinfoGoodsDomain) {
            return null;
        }
        if (null == ltLtinfoGoods) {
            ltLtinfoGoods = new LtLtinfoGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ltLtinfoGoods, (Object)ltLtinfoGoodsDomain);
            return ltLtinfoGoods;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.makeLtinfoGoods", (Throwable)e);
            return null;
        }
    }

    private LtLtinfoGoodsReDomain makeLtLtinfoGoodsReDomain(LtLtinfoGoods ltLtinfoGoods) {
        if (null == ltLtinfoGoods) {
            return null;
        }
        LtLtinfoGoodsReDomain ltLtinfoGoodsReDomain = new LtLtinfoGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ltLtinfoGoodsReDomain, (Object)ltLtinfoGoods);
            return ltLtinfoGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.makeLtLtinfoGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<LtLtinfoGoods> queryLtinfoGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ltLtinfoGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.queryLtinfoGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countLtinfoGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ltLtinfoGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtinfoServiceImpl.countLtinfoGoods", (Throwable)e);
        }
        return i;
    }

    private LtLtinfoGoods createLtLtinfoGoods(LtLtinfoGoodsDomain ltLtinfoGoodsDomain) {
        String msg = this.checkLtinfoGoods(ltLtinfoGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtinfoServiceImpl.saveLtinfoGoods.checkLtinfoGoods", msg);
        }
        LtLtinfoGoods ltLtinfoGoods = this.makeLtinfoGoods(ltLtinfoGoodsDomain, null);
        this.setLtinfoGoodsDefault(ltLtinfoGoods);
        return ltLtinfoGoods;
    }

    @Override
    public String saveLtinfo(LtLtinfoDomain ltLtinfoDomain) throws ApiException {
        LtLtinfo ltLtinfo = this.createLtLtinfo(ltLtinfoDomain);
        this.saveLtinfoModel(ltLtinfo);
        return ltLtinfo.getLtinfoCode();
    }

    @Override
    public String saveLtinfoBatch(List<LtLtinfoDomain> ltLtinfoDomainList) throws ApiException {
        if (null == ltLtinfoDomainList || ltLtinfoDomainList.isEmpty()) {
            return null;
        }
        ArrayList<LtLtinfo> ltLtinfoList = new ArrayList<LtLtinfo>();
        String code = "";
        for (LtLtinfoDomain ltLtinfoDomain : ltLtinfoDomainList) {
            LtLtinfo ltLtinfo = this.createLtLtinfo(ltLtinfoDomain);
            code = ltLtinfo.getLtinfoCode();
            ltLtinfoList.add(ltLtinfo);
        }
        this.saveLtinfoBatchModel(ltLtinfoList);
        return code;
    }

    @Override
    public void updateLtinfoState(Integer ltinfoId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtinfoModel(ltinfoId, dataState, oldDataState, map);
    }

    @Override
    public void updateLtinfoStateByCode(String tenantCode, String ltinfoCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtinfoModelByCode(tenantCode, ltinfoCode, dataState, oldDataState, map);
    }

    @Override
    public void updateLtinfo(LtLtinfoDomain ltLtinfoDomain) throws ApiException {
        String msg = this.checkLtinfo(ltLtinfoDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfo.checkLtinfo", msg);
        }
        LtLtinfo oldLtLtinfo = this.getLtinfoModelById(ltLtinfoDomain.getLtinfoId());
        if (null == oldLtLtinfo) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        LtLtinfo ltLtinfo = this.makeLtinfo(ltLtinfoDomain, oldLtLtinfo);
        this.setLtinfoUpdataDefault(ltLtinfo);
        this.updateLtinfoModel(ltLtinfo);
    }

    @Override
    public LtLtinfo getLtinfo(Integer ltinfoId) {
        return this.getLtinfoModelById(ltinfoId);
    }

    @Override
    public void deleteLtinfo(Integer ltinfoId) throws ApiException {
        this.deleteLtinfoModel(ltinfoId);
    }

    @Override
    public QueryResult<LtLtinfo> queryLtinfoPage(Map<String, Object> map) {
        List<LtLtinfo> ltLtinfoList = this.queryLtinfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLtinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ltLtinfoList);
        return queryResult;
    }

    @Override
    public LtLtinfoReDomain getLtinfoByCode(String tenantCode, String ltinfoCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoCode", ltinfoCode);
        return this.makeLtLtinfoReDomainAll(this.getLtinfoModelByCode(map));
    }

    private LtLtinfoReDomain makeLtLtinfoReDomainAll(LtLtinfo ltLtinfo) {
        if (null == ltLtinfo) {
            return null;
        }
        LtLtinfoReDomain ltLtinfoReDomain = this.makeLtLtinfoReDomain(ltLtinfo);
        if (null == ltLtinfoReDomain) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("ltinfoCode", ltLtinfo.getLtinfoCode());
        parammap.put("tenantCode", ltLtinfo.getTenantCode());
        ltLtinfoReDomain.setLtLtinfoLevelList(this.queryLtinfoLevelModelPage(parammap));
        ltLtinfoReDomain.setLtLtinfoGoodsList(this.queryLtinfoGoodsModelPage(parammap));
        return ltLtinfoReDomain;
    }

    @Override
    public void deleteLtinfoByCode(String tenantCode, String ltinfoCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoCode", ltinfoCode);
        this.delLtinfoModelByCode(map);
    }

    @Override
    public String saveLtinfoLevel(LtLtinfoLevelDomain ltLtinfoLevelDomain) throws ApiException {
        LtLtinfoLevel ltLtinfoLevel = this.createLtLtinfoLevel(ltLtinfoLevelDomain);
        this.saveLtinfoLevelModel(ltLtinfoLevel);
        return ltLtinfoLevel.getLtinfoLevelCode();
    }

    @Override
    public String saveLtinfoLevelBatch(List<LtLtinfoLevelDomain> ltLtinfoLevelDomainList) throws ApiException {
        if (null == ltLtinfoLevelDomainList || ltLtinfoLevelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<LtLtinfoLevel> ltLtinfoLevelList = new ArrayList<LtLtinfoLevel>();
        String code = "";
        for (LtLtinfoLevelDomain ltLtinfoLevelDomain : ltLtinfoLevelDomainList) {
            LtLtinfoLevel ltLtinfoLevel = this.createLtLtinfoLevel(ltLtinfoLevelDomain);
            code = ltLtinfoLevel.getLtinfoLevelCode();
            ltLtinfoLevelList.add(ltLtinfoLevel);
        }
        this.saveLtinfoLevelBatchModel(ltLtinfoLevelList);
        return code;
    }

    @Override
    public void updateLtinfoLevelState(Integer ltinfoLevelId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtinfoLevelModel(ltinfoLevelId, dataState, oldDataState, map);
    }

    @Override
    public void updateLtinfoLevelStateByCode(String tenantCode, String ltinfoLevelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtinfoLevelModelByCode(tenantCode, ltinfoLevelCode, dataState, oldDataState, map);
    }

    @Override
    public void updateLtinfoLevel(LtLtinfoLevelDomain ltLtinfoLevelDomain) throws ApiException {
        String msg = this.checkLtinfoLevel(ltLtinfoLevelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoLevel.checkLtinfoLevel", msg);
        }
        LtLtinfoLevel oldLtLtinfoLevel = this.getLtinfoLevelModelById(ltLtinfoLevelDomain.getLtinfoLevelId());
        if (null == oldLtLtinfoLevel) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoLevel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        LtLtinfoLevel ltLtinfoLevel = this.makeLtinfoLevel(ltLtinfoLevelDomain, oldLtLtinfoLevel);
        this.setLtinfoLevelUpdataDefault(ltLtinfoLevel);
        this.updateLtinfoLevelModel(ltLtinfoLevel);
    }

    @Override
    public LtLtinfoLevel getLtinfoLevel(Integer ltinfoLevelId) {
        return this.getLtinfoLevelModelById(ltinfoLevelId);
    }

    @Override
    public void deleteLtinfoLevel(Integer ltinfoLevelId) throws ApiException {
        this.deleteLtinfoLevelModel(ltinfoLevelId);
    }

    @Override
    public QueryResult<LtLtinfoLevel> queryLtinfoLevelPage(Map<String, Object> map) {
        List<LtLtinfoLevel> ltLtinfoLevelList = this.queryLtinfoLevelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLtinfoLevel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ltLtinfoLevelList);
        return queryResult;
    }

    @Override
    public LtLtinfoLevel getLtinfoLevelByCode(String tenantCode, String ltinfoLevelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoLevelCode", ltinfoLevelCode);
        return this.getLtinfoLevelModelByCode(map);
    }

    @Override
    public void deleteLtinfoLevelByCode(String tenantCode, String ltinfoLevelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoLevelCode", ltinfoLevelCode);
        this.delLtinfoLevelModelByCode(map);
    }

    @Override
    public String saveLtinfoGoods(LtLtinfoGoodsDomain ltLtinfoGoodsDomain) throws ApiException {
        LtLtinfoGoods ltLtinfoGoods = this.createLtLtinfoGoods(ltLtinfoGoodsDomain);
        this.saveLtinfoGoodsModel(ltLtinfoGoods);
        return ltLtinfoGoods.getLtinfoGoodsCode();
    }

    @Override
    public String saveLtinfoGoodsBatch(List<LtLtinfoGoodsDomain> ltLtinfoGoodsDomainList) throws ApiException {
        if (null == ltLtinfoGoodsDomainList || ltLtinfoGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<LtLtinfoGoods> ltLtinfoGoodsList = new ArrayList<LtLtinfoGoods>();
        String code = "";
        for (LtLtinfoGoodsDomain ltLtinfoGoodsDomain : ltLtinfoGoodsDomainList) {
            LtLtinfoGoods ltLtinfoGoods = this.createLtLtinfoGoods(ltLtinfoGoodsDomain);
            code = ltLtinfoGoods.getLtinfoGoodsCode();
            ltLtinfoGoodsList.add(ltLtinfoGoods);
        }
        this.saveLtinfoGoodsBatchModel(ltLtinfoGoodsList);
        return code;
    }

    @Override
    public void updateLtinfoGoodsState(Integer ltinfoGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtinfoGoodsModel(ltinfoGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateLtinfoGoodsStateByCode(String tenantCode, String ltinfoGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtinfoGoodsModelByCode(tenantCode, ltinfoGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateLtinfoGoods(LtLtinfoGoodsDomain ltLtinfoGoodsDomain) throws ApiException {
        String msg = this.checkLtinfoGoods(ltLtinfoGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoGoods.checkLtinfoGoods", msg);
        }
        LtLtinfoGoods oldLtLtinfoGoods = this.getLtinfoGoodsModelById(ltLtinfoGoodsDomain.getLtinfoGoodsId());
        if (null == oldLtLtinfoGoods) {
            throw new ApiException("lt.LtLtinfoServiceImpl.updateLtinfoGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        LtLtinfoGoods ltLtinfoGoods = this.makeLtinfoGoods(ltLtinfoGoodsDomain, oldLtLtinfoGoods);
        this.setLtinfoGoodsUpdataDefault(ltLtinfoGoods);
        this.updateLtinfoGoodsModel(ltLtinfoGoods);
    }

    @Override
    public LtLtinfoGoods getLtinfoGoods(Integer ltinfoGoodsId) {
        return this.getLtinfoGoodsModelById(ltinfoGoodsId);
    }

    @Override
    public void deleteLtinfoGoods(Integer ltinfoGoodsId) throws ApiException {
        this.deleteLtinfoGoodsModel(ltinfoGoodsId);
    }

    @Override
    public QueryResult<LtLtinfoGoods> queryLtinfoGoodsPage(Map<String, Object> map) {
        List<LtLtinfoGoods> ltLtinfoGoodsList = this.queryLtinfoGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLtinfoGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ltLtinfoGoodsList);
        return queryResult;
    }

    @Override
    public LtLtinfoGoods getLtinfoGoodsByCode(String tenantCode, String ltinfoGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoGoodsCode", ltinfoGoodsCode);
        return this.getLtinfoGoodsModelByCode(map);
    }

    @Override
    public void deleteLtinfoGoodsByCode(String tenantCode, String ltinfoGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoGoodsCode", ltinfoGoodsCode);
        this.delLtinfoGoodsModelByCode(map);
    }

    @Override
    public List<LtLtinfoGoods> queryLtinfoGoodsByInfoCode(String tenantCode, String ltinfoCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltinfoCode", ltinfoCode);
        return this.queryLtinfoGoodsModelPage(map);
    }
}

