/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.lt.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.lt.dao.LtLtuserGoodsMapper;
import com.yqbsoft.laser.service.lt.dao.LtLtuserListMapper;
import com.yqbsoft.laser.service.lt.dao.LtLtuserMapper;
import com.yqbsoft.laser.service.lt.domain.LtLtuserDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtuserGoodsDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtuserGoodsReDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtuserListDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtuserListReDomain;
import com.yqbsoft.laser.service.lt.domain.LtLtuserReDomain;
import com.yqbsoft.laser.service.lt.model.LtLtuser;
import com.yqbsoft.laser.service.lt.model.LtLtuserGoods;
import com.yqbsoft.laser.service.lt.model.LtLtuserList;
import com.yqbsoft.laser.service.lt.service.LtLtuserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LtLtuserServiceImpl
extends BaseServiceImpl
implements LtLtuserService {
    private static final String SYS_CODE = "lt.LtLtuserServiceImpl";
    private LtLtuserMapper ltLtuserMapper;
    private LtLtuserListMapper ltLtuserListMapper;
    private LtLtuserGoodsMapper ltLtuserGoodsMapper;

    public void setLtLtuserMapper(LtLtuserMapper ltLtuserMapper) {
        this.ltLtuserMapper = ltLtuserMapper;
    }

    public void setLtLtuserListMapper(LtLtuserListMapper ltLtuserListMapper) {
        this.ltLtuserListMapper = ltLtuserListMapper;
    }

    public void setLtLtuserGoodsMapper(LtLtuserGoodsMapper ltLtuserGoodsMapper) {
        this.ltLtuserGoodsMapper = ltLtuserGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ltLtuserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkLtuser(LtLtuserDomain ltLtuserDomain) {
        if (null == ltLtuserDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ltLtuserDomain.getLtinfoCode())) {
            msg = msg + "LtinfoCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ltLtuserDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLtuserDefault(LtLtuser ltLtuser) {
        if (null == ltLtuser) {
            return;
        }
        if (null == ltLtuser.getDataState()) {
            ltLtuser.setDataState(0);
        }
        if (null == ltLtuser.getGmtCreate()) {
            ltLtuser.setGmtCreate(this.getSysDate());
        }
        ltLtuser.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ltLtuser.getLtuserCode())) {
            ltLtuser.setLtuserCode(this.createUUIDString());
        }
    }

    private int getLtuserMaxCode() {
        int code = 0;
        try {
            return this.ltLtuserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getLtuserMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLtuserUpdataDefault(LtLtuser ltLtuser) {
        if (null == ltLtuser) {
            return;
        }
        ltLtuser.setGmtModified(this.getSysDate());
    }

    private void saveLtuserModel(LtLtuser ltLtuser) throws ApiException {
        if (null == ltLtuser) {
            return;
        }
        try {
            this.ltLtuserMapper.insert(ltLtuser);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.saveLtuserModel.ex", (Throwable)e);
        }
    }

    private void saveLtuserBatchModel(List<LtLtuser> ltLtuserList) throws ApiException {
        if (null == ltLtuserList || ltLtuserList.isEmpty()) {
            return;
        }
        try {
            this.ltLtuserMapper.insertBatch(ltLtuserList);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.saveLtuserBatchModel.ex", (Throwable)e);
        }
    }

    private LtLtuser getLtuserModelById(Integer ltuserId) {
        if (null == ltuserId) {
            return null;
        }
        try {
            return this.ltLtuserMapper.selectByPrimaryKey(ltuserId);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getLtuserModelById", (Throwable)e);
            return null;
        }
    }

    private LtLtuser getLtuserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ltLtuserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getLtuserModelByCode", (Throwable)e);
            return null;
        }
    }

    private LtLtuser getModelByInfoCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ltLtuserMapper.getByInfoCode(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getModelByInfoCode", (Throwable)e);
            return null;
        }
    }

    private void updateModelSunnumByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserMapper.updateSunnumByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateModelSunnumByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateModelSunnumByCode.num");
        }
    }

    private void delLtuserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.delLtuserModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.delLtuserModelByCode.num");
        }
    }

    private void deleteLtuserModel(Integer ltuserId) throws ApiException {
        if (null == ltuserId) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserMapper.deleteByPrimaryKey(ltuserId);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.deleteLtuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.deleteLtuserModel.num");
        }
    }

    private void updateLtuserModel(LtLtuser ltLtuser) throws ApiException {
        if (null == ltLtuser) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserMapper.updateByPrimaryKey(ltLtuser);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserModel.num");
        }
    }

    private void updateStateLtuserModel(Integer ltuserId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ltuserId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ltuserId", ltuserId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtuserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserModel.null");
        }
    }

    private void updateStateLtuserModelByCode(String tenantCode, String ltuserCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ltuserCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltuserCode", ltuserCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtuserMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserModelByCode.null");
        }
    }

    private LtLtuser makeLtuser(LtLtuserDomain ltLtuserDomain, LtLtuser ltLtuser) {
        if (null == ltLtuserDomain) {
            return null;
        }
        if (null == ltLtuser) {
            ltLtuser = new LtLtuser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ltLtuser, (Object)ltLtuserDomain);
            return ltLtuser;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.makeLtuser", (Throwable)e);
            return null;
        }
    }

    private LtLtuserReDomain makeLtLtuserReDomain(LtLtuser ltLtuser) {
        if (null == ltLtuser) {
            return null;
        }
        LtLtuserReDomain ltLtuserReDomain = new LtLtuserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ltLtuserReDomain, (Object)ltLtuser);
            return ltLtuserReDomain;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.makeLtLtuserReDomain", (Throwable)e);
            return null;
        }
    }

    private List<LtLtuser> queryLtuserModelPage(Map<String, Object> parammap) {
        try {
            return this.ltLtuserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.queryLtuserModel", (Throwable)e);
            return null;
        }
    }

    private int countLtuser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ltLtuserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.countLtuser", (Throwable)e);
        }
        return i;
    }

    private LtLtuser createLtLtuser(LtLtuserDomain ltLtuserDomain) {
        String msg = this.checkLtuser(ltLtuserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtuserServiceImpl.saveLtuser.checkLtuser", msg);
        }
        LtLtuser ltLtuser = this.makeLtuser(ltLtuserDomain, null);
        this.setLtuserDefault(ltLtuser);
        return ltLtuser;
    }

    private String checkLtuserList(LtLtuserListDomain ltLtuserListDomain) {
        if (null == ltLtuserListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ltLtuserListDomain.getMemberBcode())) {
            msg = msg + "MemberBcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ltLtuserListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLtuserListDefault(LtLtuserList ltLtuserList) {
        if (null == ltLtuserList) {
            return;
        }
        if (null == ltLtuserList.getDataState()) {
            ltLtuserList.setDataState(0);
        }
        if (null == ltLtuserList.getGmtCreate()) {
            ltLtuserList.setGmtCreate(this.getSysDate());
        }
        ltLtuserList.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ltLtuserList.getLtuserListCode())) {
            ltLtuserList.setLtuserListCode(this.createUUIDString());
        }
    }

    private int getLtuserListMaxCode() {
        int code = 0;
        try {
            return this.ltLtuserListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getLtuserListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLtuserListUpdataDefault(LtLtuserList ltLtuserList) {
        if (null == ltLtuserList) {
            return;
        }
        ltLtuserList.setGmtModified(this.getSysDate());
    }

    private void saveLtuserListModel(LtLtuserList ltLtuserList) throws ApiException {
        if (null == ltLtuserList) {
            return;
        }
        try {
            this.ltLtuserListMapper.insert(ltLtuserList);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.saveLtuserListModel.ex", (Throwable)e);
        }
    }

    private void saveLtuserListBatchModel(List<LtLtuserList> ltLtuserListList) throws ApiException {
        if (null == ltLtuserListList || ltLtuserListList.isEmpty()) {
            return;
        }
        try {
            this.ltLtuserListMapper.insertBatch(ltLtuserListList);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.saveLtuserListBatchModel.ex", (Throwable)e);
        }
    }

    private LtLtuserList getLtuserListModelById(Integer ltuserListId) {
        if (null == ltuserListId) {
            return null;
        }
        try {
            return this.ltLtuserListMapper.selectByPrimaryKey(ltuserListId);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getLtuserListModelById", (Throwable)e);
            return null;
        }
    }

    private LtLtuserList getLtuserListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ltLtuserListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getLtuserListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delLtuserListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.delLtuserListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.delLtuserListModelByCode.num");
        }
    }

    private void deleteLtuserListModel(Integer ltuserListId) throws ApiException {
        if (null == ltuserListId) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserListMapper.deleteByPrimaryKey(ltuserListId);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.deleteLtuserListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.deleteLtuserListModel.num");
        }
    }

    private void updateLtuserListModel(LtLtuserList ltLtuserList) throws ApiException {
        if (null == ltLtuserList) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserListMapper.updateByPrimaryKey(ltLtuserList);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserListModel.num");
        }
    }

    private void updateStateLtuserListModel(Integer ltuserListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ltuserListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ltuserListId", ltuserListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtuserListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserListModel.null");
        }
    }

    private void updateStateLtuserListModelByCode(String tenantCode, String ltuserListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ltuserListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltuserListCode", ltuserListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtuserListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserListModelByCode.null");
        }
    }

    private LtLtuserList makeLtuserList(LtLtuserListDomain ltLtuserListDomain, LtLtuserList ltLtuserList) {
        if (null == ltLtuserListDomain) {
            return null;
        }
        if (null == ltLtuserList) {
            ltLtuserList = new LtLtuserList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ltLtuserList, (Object)ltLtuserListDomain);
            return ltLtuserList;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.makeLtuserList", (Throwable)e);
            return null;
        }
    }

    private LtLtuserListReDomain makeLtLtuserListReDomain(LtLtuserList ltLtuserList) {
        if (null == ltLtuserList) {
            return null;
        }
        LtLtuserListReDomain ltLtuserListReDomain = new LtLtuserListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ltLtuserListReDomain, (Object)ltLtuserList);
            return ltLtuserListReDomain;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.makeLtLtuserListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<LtLtuserList> queryLtuserListModelPage(Map<String, Object> parammap) {
        try {
            return this.ltLtuserListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.queryLtuserListModel", (Throwable)e);
            return null;
        }
    }

    private int countLtuserList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ltLtuserListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.countLtuserList", (Throwable)e);
        }
        return i;
    }

    private LtLtuserList createLtLtuserList(LtLtuserListDomain ltLtuserListDomain) {
        String msg = this.checkLtuserList(ltLtuserListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtuserServiceImpl.saveLtuserList.checkLtuserList", msg);
        }
        LtLtuserList ltLtuserList = this.makeLtuserList(ltLtuserListDomain, null);
        this.setLtuserListDefault(ltLtuserList);
        return ltLtuserList;
    }

    private String checkLtuserGoods(LtLtuserGoodsDomain ltLtuserGoodsDomain) {
        if (null == ltLtuserGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ltLtuserGoodsDomain.getMemberBcode())) {
            msg = msg + "MemberBcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ltLtuserGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setLtuserGoodsDefault(LtLtuserGoods ltLtuserGoods) {
        if (null == ltLtuserGoods) {
            return;
        }
        if (null == ltLtuserGoods.getDataState()) {
            ltLtuserGoods.setDataState(0);
        }
        if (null == ltLtuserGoods.getGmtCreate()) {
            ltLtuserGoods.setGmtCreate(this.getSysDate());
        }
        ltLtuserGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ltLtuserGoods.getLtuserGoodsCode())) {
            ltLtuserGoods.setLtuserGoodsCode(this.createUUIDString());
        }
    }

    private int getLtuserGoodsMaxCode() {
        int code = 0;
        try {
            return this.ltLtuserGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getLtuserGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setLtuserGoodsUpdataDefault(LtLtuserGoods ltLtuserGoods) {
        if (null == ltLtuserGoods) {
            return;
        }
        ltLtuserGoods.setGmtModified(this.getSysDate());
    }

    private void saveLtuserGoodsModel(LtLtuserGoods ltLtuserGoods) throws ApiException {
        if (null == ltLtuserGoods) {
            return;
        }
        try {
            this.ltLtuserGoodsMapper.insert(ltLtuserGoods);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.saveLtuserGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveLtuserGoodsBatchModel(List<LtLtuserGoods> ltLtuserGoodsList) throws ApiException {
        if (null == ltLtuserGoodsList || ltLtuserGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ltLtuserGoodsMapper.insertBatch(ltLtuserGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.saveLtuserGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private LtLtuserGoods getLtuserGoodsModelById(Integer ltuserGoodsId) {
        if (null == ltuserGoodsId) {
            return null;
        }
        try {
            return this.ltLtuserGoodsMapper.selectByPrimaryKey(ltuserGoodsId);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getLtuserGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private LtLtuserGoods getLtuserGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ltLtuserGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.getLtuserGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delLtuserGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.delLtuserGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.delLtuserGoodsModelByCode.num");
        }
    }

    private void deleteLtuserGoodsModel(Integer ltuserGoodsId) throws ApiException {
        if (null == ltuserGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserGoodsMapper.deleteByPrimaryKey(ltuserGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.deleteLtuserGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.deleteLtuserGoodsModel.num");
        }
    }

    private void updateLtuserGoodsModel(LtLtuserGoods ltLtuserGoods) throws ApiException {
        if (null == ltLtuserGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.ltLtuserGoodsMapper.updateByPrimaryKey(ltLtuserGoods);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserGoodsModel.num");
        }
    }

    private void updateStateLtuserGoodsModel(Integer ltuserGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ltuserGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ltuserGoodsId", ltuserGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtuserGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserGoodsModel.null");
        }
    }

    private void updateStateLtuserGoodsModelByCode(String tenantCode, String ltuserGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ltuserGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltuserGoodsCode", ltuserGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ltLtuserGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateStateLtuserGoodsModelByCode.null");
        }
    }

    private LtLtuserGoods makeLtuserGoods(LtLtuserGoodsDomain ltLtuserGoodsDomain, LtLtuserGoods ltLtuserGoods) {
        if (null == ltLtuserGoodsDomain) {
            return null;
        }
        if (null == ltLtuserGoods) {
            ltLtuserGoods = new LtLtuserGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ltLtuserGoods, (Object)ltLtuserGoodsDomain);
            return ltLtuserGoods;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.makeLtuserGoods", (Throwable)e);
            return null;
        }
    }

    private LtLtuserGoodsReDomain makeLtLtuserGoodsReDomain(LtLtuserGoods ltLtuserGoods) {
        if (null == ltLtuserGoods) {
            return null;
        }
        LtLtuserGoodsReDomain ltLtuserGoodsReDomain = new LtLtuserGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ltLtuserGoodsReDomain, (Object)ltLtuserGoods);
            return ltLtuserGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.makeLtLtuserGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<LtLtuserGoods> queryLtuserGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ltLtuserGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.queryLtuserGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countLtuserGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ltLtuserGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("lt.LtLtuserServiceImpl.countLtuserGoods", (Throwable)e);
        }
        return i;
    }

    private LtLtuserGoods createLtLtuserGoods(LtLtuserGoodsDomain ltLtuserGoodsDomain) {
        String msg = this.checkLtuserGoods(ltLtuserGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtuserServiceImpl.saveLtuserGoods.checkLtuserGoods", msg);
        }
        LtLtuserGoods ltLtuserGoods = this.makeLtuserGoods(ltLtuserGoodsDomain, null);
        this.setLtuserGoodsDefault(ltLtuserGoods);
        return ltLtuserGoods;
    }

    @Override
    public String saveLtuser(LtLtuserDomain ltLtuserDomain) throws ApiException {
        LtLtuser ltLtuser = this.createLtLtuser(ltLtuserDomain);
        this.saveLtuserModel(ltLtuser);
        return ltLtuser.getLtuserCode();
    }

    @Override
    public String saveLtuserBatch(List<LtLtuserDomain> ltLtuserDomainList) throws ApiException {
        if (null == ltLtuserDomainList || ltLtuserDomainList.isEmpty()) {
            return null;
        }
        ArrayList<LtLtuser> ltLtuserList = new ArrayList<LtLtuser>();
        String code = "";
        for (LtLtuserDomain ltLtuserDomain : ltLtuserDomainList) {
            LtLtuser ltLtuser = this.createLtLtuser(ltLtuserDomain);
            code = ltLtuser.getLtuserCode();
            ltLtuserList.add(ltLtuser);
        }
        this.saveLtuserBatchModel(ltLtuserList);
        return code;
    }

    @Override
    public void updateLtuserState(Integer ltuserId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtuserModel(ltuserId, dataState, oldDataState, map);
    }

    @Override
    public void updateLtuserStateByCode(String tenantCode, String ltuserCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtuserModelByCode(tenantCode, ltuserCode, dataState, oldDataState, map);
    }

    @Override
    public void updateLtuser(LtLtuserDomain ltLtuserDomain) throws ApiException {
        String msg = this.checkLtuser(ltLtuserDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuser.checkLtuser", msg);
        }
        LtLtuser oldLtLtuser = this.getLtuserModelById(ltLtuserDomain.getLtuserId());
        if (null == oldLtLtuser) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        LtLtuser ltLtuser = this.makeLtuser(ltLtuserDomain, oldLtLtuser);
        this.setLtuserUpdataDefault(ltLtuser);
        this.updateLtuserModel(ltLtuser);
    }

    @Override
    public LtLtuser getLtuser(Integer ltuserId) {
        return this.getLtuserModelById(ltuserId);
    }

    @Override
    public void deleteLtuser(Integer ltuserId) throws ApiException {
        this.deleteLtuserModel(ltuserId);
    }

    @Override
    public QueryResult<LtLtuser> queryLtuserPage(Map<String, Object> map) {
        List<LtLtuser> ltLtuserList = this.queryLtuserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLtuser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ltLtuserList);
        return queryResult;
    }

    @Override
    public LtLtuser getLtuserByCode(String tenantCode, String ltuserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltuserCode", ltuserCode);
        return this.getLtuserModelByCode(map);
    }

    @Override
    public void deleteLtuserByCode(String tenantCode, String ltuserCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltuserCode", ltuserCode);
        this.delLtuserModelByCode(map);
    }

    @Override
    public String saveLtuserList(LtLtuserListDomain ltLtuserListDomain) throws ApiException {
        LtLtuserList ltLtuserList = this.createLtLtuserList(ltLtuserListDomain);
        this.saveLtuserListModel(ltLtuserList);
        this.saveOrUpdateLtuser(ltLtuserList);
        return ltLtuserList.getLtuserListCode();
    }

    private void saveOrUpdateLtuser(LtLtuserList ltLtuserList) {
        if (null == ltLtuserList) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ltinfoCode", ltLtuserList.getLtinfoCode());
        map.put("memberBcode", ltLtuserList.getMemberBcode());
        map.put("tenantCode", ltLtuserList.getTenantCode());
        LtLtuser ltLtuser = this.getModelByInfoCode(map);
        if (null == ltLtuser) {
            this.saveLtuser(this.makeLtLtuser(ltLtuserList));
        } else {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            map.put("ltuserCode", ltLtuserList.getLtuserCode());
            map.put("tenantCode", ltLtuserList.getTenantCode());
            if ("0".equals(ltLtuserList.getLtuserListDc())) {
                map.put("ltuserSunnum", ltLtuserList.getLtuserListNum());
            } else {
                map.put("ltuserNum", ltLtuserList.getLtuserListNum());
            }
            this.updateModelSunnumByCode(parammap);
        }
    }

    private LtLtuserDomain makeLtLtuser(LtLtuserList ltLtuserList) {
        if (null == ltLtuserList) {
            return null;
        }
        LtLtuserDomain ltLtuserDomain = new LtLtuserDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ltLtuserDomain, (Object)ltLtuserList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ltLtuserDomain.setLtuserSunnum(ltLtuserList.getLtuserListNum());
        return ltLtuserDomain;
    }

    @Override
    public String saveLtuserListBatch(List<LtLtuserListDomain> ltLtuserListDomainList) throws ApiException {
        if (null == ltLtuserListDomainList || ltLtuserListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<LtLtuserList> ltLtuserListList = new ArrayList<LtLtuserList>();
        String code = "";
        for (LtLtuserListDomain ltLtuserListDomain : ltLtuserListDomainList) {
            LtLtuserList ltLtuserList = this.createLtLtuserList(ltLtuserListDomain);
            code = ltLtuserList.getLtuserListCode();
            ltLtuserListList.add(ltLtuserList);
        }
        this.saveLtuserListBatchModel(ltLtuserListList);
        for (LtLtuserList ltLtuserList2 : ltLtuserListList) {
            this.saveOrUpdateLtuser(ltLtuserList2);
        }
        return code;
    }

    @Override
    public void updateLtuserListState(Integer ltuserListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtuserListModel(ltuserListId, dataState, oldDataState, map);
    }

    @Override
    public void updateLtuserListStateByCode(String tenantCode, String ltuserListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtuserListModelByCode(tenantCode, ltuserListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateLtuserList(LtLtuserListDomain ltLtuserListDomain) throws ApiException {
        String msg = this.checkLtuserList(ltLtuserListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserList.checkLtuserList", msg);
        }
        LtLtuserList oldLtLtuserList = this.getLtuserListModelById(ltLtuserListDomain.getLtuserListId());
        if (null == oldLtLtuserList) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        LtLtuserList ltLtuserList = this.makeLtuserList(ltLtuserListDomain, oldLtLtuserList);
        this.setLtuserListUpdataDefault(ltLtuserList);
        this.updateLtuserListModel(ltLtuserList);
    }

    @Override
    public LtLtuserList getLtuserList(Integer ltuserListId) {
        return this.getLtuserListModelById(ltuserListId);
    }

    @Override
    public void deleteLtuserList(Integer ltuserListId) throws ApiException {
        this.deleteLtuserListModel(ltuserListId);
    }

    @Override
    public QueryResult<LtLtuserList> queryLtuserListPage(Map<String, Object> map) {
        List<LtLtuserList> ltLtuserListList = this.queryLtuserListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLtuserList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ltLtuserListList);
        return queryResult;
    }

    @Override
    public LtLtuserList getLtuserListByCode(String tenantCode, String ltuserListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltuserListCode", ltuserListCode);
        return this.getLtuserListModelByCode(map);
    }

    @Override
    public void deleteLtuserListByCode(String tenantCode, String ltuserListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltuserListCode", ltuserListCode);
        this.delLtuserListModelByCode(map);
    }

    @Override
    public String saveLtuserGoods(LtLtuserGoodsDomain ltLtuserGoodsDomain) throws ApiException {
        LtLtuserGoods ltLtuserGoods = this.createLtLtuserGoods(ltLtuserGoodsDomain);
        this.saveLtuserGoodsModel(ltLtuserGoods);
        return ltLtuserGoods.getLtuserGoodsCode();
    }

    @Override
    public String saveLtuserGoodsBatch(List<LtLtuserGoodsDomain> ltLtuserGoodsDomainList) throws ApiException {
        if (null == ltLtuserGoodsDomainList || ltLtuserGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<LtLtuserGoods> ltLtuserGoodsList = new ArrayList<LtLtuserGoods>();
        String code = "";
        for (LtLtuserGoodsDomain ltLtuserGoodsDomain : ltLtuserGoodsDomainList) {
            LtLtuserGoods ltLtuserGoods = this.createLtLtuserGoods(ltLtuserGoodsDomain);
            code = ltLtuserGoods.getLtuserGoodsCode();
            ltLtuserGoodsList.add(ltLtuserGoods);
        }
        this.saveLtuserGoodsBatchModel(ltLtuserGoodsList);
        return code;
    }

    @Override
    public void updateLtuserGoodsState(Integer ltuserGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtuserGoodsModel(ltuserGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateLtuserGoodsStateByCode(String tenantCode, String ltuserGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateLtuserGoodsModelByCode(tenantCode, ltuserGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateLtuserGoods(LtLtuserGoodsDomain ltLtuserGoodsDomain) throws ApiException {
        String msg = this.checkLtuserGoods(ltLtuserGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserGoods.checkLtuserGoods", msg);
        }
        LtLtuserGoods oldLtLtuserGoods = this.getLtuserGoodsModelById(ltLtuserGoodsDomain.getLtuserGoodsId());
        if (null == oldLtLtuserGoods) {
            throw new ApiException("lt.LtLtuserServiceImpl.updateLtuserGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        LtLtuserGoods ltLtuserGoods = this.makeLtuserGoods(ltLtuserGoodsDomain, oldLtLtuserGoods);
        this.setLtuserGoodsUpdataDefault(ltLtuserGoods);
        this.updateLtuserGoodsModel(ltLtuserGoods);
    }

    @Override
    public LtLtuserGoods getLtuserGoods(Integer ltuserGoodsId) {
        return this.getLtuserGoodsModelById(ltuserGoodsId);
    }

    @Override
    public void deleteLtuserGoods(Integer ltuserGoodsId) throws ApiException {
        this.deleteLtuserGoodsModel(ltuserGoodsId);
    }

    @Override
    public QueryResult<LtLtuserGoods> queryLtuserGoodsPage(Map<String, Object> map) {
        List<LtLtuserGoods> ltLtuserGoodsList = this.queryLtuserGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countLtuserGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ltLtuserGoodsList);
        return queryResult;
    }

    @Override
    public LtLtuserGoods getLtuserGoodsByCode(String tenantCode, String ltuserGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltuserGoodsCode", ltuserGoodsCode);
        return this.getLtuserGoodsModelByCode(map);
    }

    @Override
    public void deleteLtuserGoodsByCode(String tenantCode, String ltuserGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ltuserGoodsCode", ltuserGoodsCode);
        this.delLtuserGoodsModelByCode(map);
    }

    @Override
    public String updateGoodsUser(String tenantCode, String ltuserGoodsCode) throws ApiException {
        this.updateLtuserGoodsStateByCode(tenantCode, ltuserGoodsCode, 2, 1, null);
        return "success";
    }
}

