/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.manager.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.manager.dao.MuMuserMapper;
import com.yqbsoft.laser.service.manager.dao.MuMuserinfoMapper;
import com.yqbsoft.laser.service.manager.domain.MuMuserDomainBean;
import com.yqbsoft.laser.service.manager.domain.MuMuserinfoDomainBean;
import com.yqbsoft.laser.service.manager.model.MuMuser;
import com.yqbsoft.laser.service.manager.model.MuMuserinfo;
import com.yqbsoft.laser.service.manager.service.MuserService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MuserServiceImpl
extends BaseServiceImpl
implements MuserService {
    public static final String SYS_CODE = "mu.MANAGER.MuserServiceImpl";
    private MuMuserMapper muMuserMapper;
    private MuMuserinfoMapper muMuserinfoMapper;

    public MuMuserinfoMapper getMuMuserinfoMapper() {
        return this.muMuserinfoMapper;
    }

    public void setMuMuserinfoMapper(MuMuserinfoMapper muMuserinfoMapper) {
        this.muMuserinfoMapper = muMuserinfoMapper;
    }

    public MuMuserMapper getMuMuserMapper() {
        return this.muMuserMapper;
    }

    public void setMuMuserMapper(MuMuserMapper muMuserMapper) {
        this.muMuserMapper = muMuserMapper;
    }

    private int saveMuserModel(MuMuser muMuser) throws ApiException {
        if (null == muMuser) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.saveMuserModel.ex");
        }
        try {
            return this.muMuserMapper.insert(muMuser);
        }
        catch (Exception e) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.saveMuserModel.ex");
        }
    }

    @Override
    public void saveMuser(MuMuserDomainBean muMuserDomainBean) throws ApiException {
        String msg = this.check(muMuserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.saveMuser.check", msg);
        }
        MuMuser muMuser = new MuMuser();
        muMuser = this.makeModel(muMuser, muMuserDomainBean);
        this.setInsertDefaultValue(muMuser);
        this.saveMuserModel(muMuser);
    }

    private List<MuMuser> queryMuser(Map<String, Object> parammap) {
        try {
            return this.muMuserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    private MuMuser queryMuserByName(Map<String, Object> parammap) {
        try {
            return this.muMuserMapper.queryMuserByName(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public MuMuser getMuser(Integer muserId) {
        return this.muMuserMapper.selectByPrimaryKey(muserId);
    }

    @Override
    public void updateMuser(MuMuserDomainBean muMuserDomainBean) throws ApiException {
        String msg = this.check(muMuserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.updateMuser.check", msg);
        }
        MuMuser muMuser = this.getMuser(muMuserDomainBean.getUserId());
        if (muMuser == null) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.muMuser.exsit", "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        muMuser = this.makeModel(muMuser, muMuserDomainBean);
        this.setUpdateDefaultValue(muMuser);
        this.updateMqService(muMuser);
    }

    private void setUpdateDefaultValue(MuMuser muMuser) {
        if (null == muMuser) {
            return;
        }
        if (null == muMuser.getDataState()) {
            muMuser.setDataState(0);
        }
        if (null == muMuser.getGmtModified()) {
            muMuser.setGmtModified(this.getSysDate());
        }
    }

    private void setUpdateDefaultValue(MuMuserinfo info) {
        if (null == info) {
            return;
        }
        if (null == info.getDataState()) {
            info.setDataState(0);
        }
        if (null == info.getGmtModified()) {
            info.setGmtModified(this.getSysDate());
        }
    }

    private void updateMqService(MuMuser muMuser) throws ApiException {
        try {
            this.muMuserMapper.updateByPrimaryKey(muMuser);
        }
        catch (Exception e) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.updateMqService", "", (Throwable)e);
        }
    }

    @Override
    public QueryResult<MuMuser> queryMuMuser(Map<String, Object> map) {
        List<MuMuser> MuserList = this.queryMuser(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMroleList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(MuserList);
        return queryResult;
    }

    @Override
    public List<MuMuser> queryMuserList(Map<String, Object> map) {
        List<MuMuser> MuserList = this.queryMuser(map);
        return MuserList;
    }

    private int countMroleList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.muMuserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mu.MANAGER.MuserServiceImpl.countMroleList", (Throwable)e);
        }
        return i;
    }

    @Override
    public MuMuser queryMuMuserByName(Map<String, Object> map) {
        return this.queryMuserByName(map);
    }

    @Override
    public void updateMuserState(Integer userId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMuser(userId, dataState, oldDataState);
    }

    private void updateStateMuser(Integer userId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.muMuserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.updateStateMuser.ex");
        }
        if (i <= 0) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.updateStateMuser.null");
        }
    }

    @Override
    public void updateMuserinfoState(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMuserinfo(userinfoId, dataState, oldDataState);
    }

    private void updateStateMuserinfo(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoId", userinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.muMuserinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.updateStateMuser.ex");
        }
        if (i <= 0) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.updateStateMuser.null");
        }
    }

    private void saveMuserinfoModel(MuMuserinfo muMuserinfo) throws ApiException {
        if (null == muMuserinfo) {
            return;
        }
        try {
            this.muMuserinfoMapper.insert(muMuserinfo);
        }
        catch (Exception e) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.saveMuserinfoModel.ex");
        }
    }

    @Override
    public void saveMuserinfo(MuMuserinfoDomainBean muMuserinfoDomainBean) throws ApiException {
        String msg = this.check(muMuserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.saveMuserinfo.check", msg);
        }
        MuMuserinfo muMuserinfo = new MuMuserinfo();
        muMuserinfo = this.makeModel(muMuserinfo, muMuserinfoDomainBean);
        this.setInsertDefaultValue(muMuserinfo);
        this.saveMuserinfoModel(muMuserinfo);
    }

    private MuMuserinfo makeModel(MuMuserinfo muMuserinfo, MuMuserinfoDomainBean muMuserinfoDomainBean) {
        if (muMuserinfoDomainBean == null) {
            return null;
        }
        if (muMuserinfo == null) {
            muMuserinfo = new MuMuserinfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)muMuserinfo, (Object)muMuserinfoDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return muMuserinfo;
    }

    private MuMuser makeModel(MuMuser muMuser, MuMuserDomainBean muMuserDomainBean) {
        if (muMuserDomainBean == null) {
            return null;
        }
        if (muMuser == null) {
            muMuser = new MuMuser();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)muMuser, (Object)muMuserDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return muMuser;
    }

    private String check(MuMuserinfoDomainBean muMuserinfo) {
        if (null == muMuserinfo) {
            return "\u6570\u636e\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)muMuserinfo.getUserinfoCompname())) {
            msg = msg + "UserinfoCompname\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)muMuserinfo.getUserCode())) {
            msg = msg + "UserCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private String check(MuMuserDomainBean muMuser) {
        if (null == muMuser) {
            return "\u6570\u636e\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)muMuser.getUserName())) {
            msg = msg + "UserName\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setInsertDefaultValue(MuMuserinfo muMuserinfo) {
        if (null == muMuserinfo) {
            return;
        }
        if (null == muMuserinfo.getDataState()) {
            muMuserinfo.setDataState(0);
        }
        if (null == muMuserinfo.getGmtCreate()) {
            muMuserinfo.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)muMuserinfo.getUserinfoCode())) {
            int code = this.getMuserInfoMaxCode();
            muMuserinfo.setUserinfoCode(this.makeMaxCode8(++code));
        }
    }

    private void setInsertDefaultValue(MuMuser muMuser) {
        if (null == muMuser) {
            return;
        }
        if (null == muMuser.getDataState()) {
            muMuser.setDataState(0);
        }
        if (null == muMuser.getGmtCreate()) {
            muMuser.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)muMuser.getUserCode())) {
            int code = this.getMuserMaxCode();
            muMuser.setUserCode(this.makeMaxCode8(++code));
        }
    }

    private int getMuserMaxCode() {
        int code = 0;
        try {
            code = this.muMuserMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private int getMuserInfoMaxCode() {
        int code = 0;
        try {
            code = this.muMuserinfoMapper.getMaxCode();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return code;
    }

    private Date getSysDate() {
        try {
            return this.muMuserinfoMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mu.MANAGER.MuserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private List<MuMuserinfo> queryMuserinfo(Map<String, Object> parammap) {
        try {
            return this.muMuserinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
            return null;
        }
    }

    @Override
    public MuMuserinfo getMuserinfo(Integer muserinfoId) {
        return this.muMuserinfoMapper.selectByPrimaryKey(muserinfoId);
    }

    public void updateMuserinfo(MuMuserinfo muMuserinfo) throws ApiException {
        try {
            this.muMuserinfoMapper.updateByPrimaryKey(muMuserinfo);
        }
        catch (Exception e) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.updateMqService", "", (Throwable)e);
        }
    }

    @Override
    public void updateMuserinfo(MuMuserinfoDomainBean muMuserinfoDomainBean) throws ApiException {
        String msg = this.check(muMuserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.updateMuserinfo.check", msg);
        }
        MuMuserinfo muMuserinfo = this.getMuserinfo(muMuserinfoDomainBean.getUserinfoId());
        if (muMuserinfo == null) {
            throw new ApiException("mu.MANAGER.MuserServiceImpl.updateMuserinfo.exsit", "\u6570\u636e\u4e0d\u5b58\u5728");
        }
        muMuserinfo = this.makeModel(muMuserinfo, muMuserinfoDomainBean);
        this.setUpdateDefaultValue(muMuserinfo);
        this.updateMuserinfo(muMuserinfo);
    }

    @Override
    public QueryResult<MuMuserinfo> queryMuMuserinfo(Map<String, Object> map) {
        List<MuMuserinfo> MuserinfoList = this.queryMuserinfo(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMroleinfoList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(MuserinfoList);
        return queryResult;
    }

    @Override
    public List<MuMuserinfo> queryMuMuserinfoList(Map<String, Object> map) {
        List<MuMuserinfo> MuserinfoList = this.queryMuserinfo(map);
        return MuserinfoList;
    }

    private int countMroleinfoList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.muMuserinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mu.MANAGER.MuserServiceImpl.countMroleinfoList", (Throwable)e);
        }
        return i;
    }

    @Override
    public void deleteMuser(Integer muserId) {
        MuMuser vm = this.getMuser(muserId);
        this.muMuserMapper.deleteByPrimaryKey(muserId);
        this.muMuserinfoMapper.deleteByUserCode(vm.getUserCode());
    }

    @Override
    public void deleteMuserinfo(Integer muserinfoId) {
        this.muMuserinfoMapper.deleteByPrimaryKey(muserinfoId);
    }

    @Override
    public void updateMuserSelective(MuMuserDomainBean muMuserDomainBean) throws ApiException {
        if (muMuserDomainBean != null && muMuserDomainBean.getUserId() != null) {
            MuMuser muMuser = this.makeModel(null, muMuserDomainBean);
            this.muMuserMapper.updateByPrimaryKeySelective(muMuser);
        }
    }

    @Override
    public Map<String, Object> queryMuMuserCheck(String userName, String password, String appmanageIcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        map.put("userName", userName);
        map.put("appmanageIcode", appmanageIcode);
        MuMuser muser = this.queryMuserByName(map);
        if (null == muser || !MD5Util.saltMD5Verify((String)password, (String)muser.getUserPwsswd())) {
            result.put("flag", false);
            result.put("message", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
            return result;
        }
        result.put("flag", true);
        result.put("message", JsonUtil.getAllJsonUtil().toJson((Object)muser));
        return result;
    }
}

