/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mcompany.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mcompany.dao.OmMcompanyMapper;
import com.yqbsoft.laser.service.mcompany.domain.OmMcompanyDomain;
import com.yqbsoft.laser.service.mcompany.model.OmMcompany;
import com.yqbsoft.laser.service.mcompany.service.McompanyService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class McompanyServiceImpl
extends BaseServiceImpl
implements McompanyService {
    public static final String SYS_CODE = "om.POS.BASEINFO.McompanyServiceImpl";
    private OmMcompanyMapper omMcompanyMapper;

    public void setOmMcompanyMapper(OmMcompanyMapper omMcompanyMapper) {
        this.omMcompanyMapper = omMcompanyMapper;
    }

    private Date getSysDate() {
        try {
            return this.omMcompanyMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.McompanyServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMcompany(OmMcompanyDomain omMcompanyDomain) {
        if (null == omMcompanyDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMcompanyDefault(OmMcompany omMcompany) {
        if (null == omMcompany) {
            return;
        }
        if (null == omMcompany.getDataState()) {
            omMcompany.setDataState(0);
        }
        if (null == omMcompany.getGmtCreate()) {
            omMcompany.setGmtCreate(this.getSysDate());
        }
        omMcompany.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)omMcompany.getCompanyCode())) {
            int code = this.getMaxCode();
            omMcompany.setCompanyCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.omMcompanyMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.McompanyServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMcompanyUpdataDefault(OmMcompany omMcompany) {
        if (null == omMcompany) {
            return;
        }
        omMcompany.setGmtModified(this.getSysDate());
    }

    private void saveMcompanyModel(OmMcompany omMcompany) throws ApiException {
        if (null == omMcompany) {
            return;
        }
        try {
            this.omMcompanyMapper.insert(omMcompany);
        }
        catch (Exception e) {
            throw new ApiException("om.POS.BASEINFO.McompanyServiceImpl.saveFtpserverModel.ex");
        }
    }

    private OmMcompany getMcompanyModelById(Integer companyId) {
        if (null == companyId) {
            return null;
        }
        try {
            return this.omMcompanyMapper.selectByPrimaryKey(companyId);
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.McompanyServiceImpl.getMcompanyModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMcompanyModel(Integer companyId) throws ApiException {
        if (null == companyId) {
            return;
        }
        int i = 0;
        try {
            i = this.omMcompanyMapper.deleteByPrimaryKey(companyId);
        }
        catch (Exception e) {
            throw new ApiException("om.POS.BASEINFO.McompanyServiceImpl.deleteMcompanyModel.ex");
        }
        if (1 != i) {
            throw new ApiException("om.POS.BASEINFO.McompanyServiceImpl.deleteMcompanyModel.num");
        }
    }

    private void updateMcompanyModel(OmMcompany omMcompany) throws ApiException {
        if (null == omMcompany) {
            return;
        }
        try {
            this.omMcompanyMapper.updateByPrimaryKeySelective(omMcompany);
        }
        catch (Exception e) {
            throw new ApiException("om.POS.BASEINFO.McompanyServiceImpl.updateMcompanyModel.ex");
        }
    }

    private void updateStateMcompanyModel(Integer companyId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == companyId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyId", companyId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.omMcompanyMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("om.POS.BASEINFO.McompanyServiceImpl.updateStateMcompanyModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("om.POS.BASEINFO.McompanyServiceImpl.updateStateMcompanyModel.null");
        }
    }

    private OmMcompany makeMcompany(OmMcompanyDomain omMcompanyDomain, OmMcompany omMcompany) {
        if (null == omMcompanyDomain) {
            return null;
        }
        if (null == omMcompany) {
            omMcompany = new OmMcompany();
        }
        try {
            BeanUtils.copyAllPropertys((Object)omMcompany, (Object)omMcompanyDomain);
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.McompanyServiceImpl.makeMcompany", (Throwable)e);
        }
        return omMcompany;
    }

    private List<OmMcompany> queryMcompanyModelPage(Map<String, Object> parammap) {
        try {
            return this.omMcompanyMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.McompanyServiceImpl.queryMcompanyModel", (Throwable)e);
            return null;
        }
    }

    private int countMcompany(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.omMcompanyMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.McompanyServiceImpl.countMcompany", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMcompany(OmMcompanyDomain omMcompanyDomain) throws ApiException {
        String msg = this.checkMcompany(omMcompanyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.POS.BASEINFO.McompanyServiceImpl.saveMcompany.checkMcompany", msg);
        }
        OmMcompany omMcompany = this.makeMcompany(omMcompanyDomain, null);
        this.setMcompanyDefault(omMcompany);
        this.saveMcompanyModel(omMcompany);
    }

    @Override
    public void updateMcompanyState(Integer companyId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMcompanyModel(companyId, dataState, oldDataState);
    }

    @Override
    public void updateMcompany(OmMcompanyDomain omMcompanyDomain) throws ApiException {
        String msg = this.checkMcompany(omMcompanyDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.POS.BASEINFO.McompanyServiceImpl.updateMcompany.checkMcompany", msg);
        }
        OmMcompany oldOmMcompany = this.getMcompanyModelById(omMcompanyDomain.getCompanyId());
        if (null == oldOmMcompany) {
            throw new ApiException("om.POS.BASEINFO.McompanyServiceImpl.updateMcompany.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OmMcompany omMcompany = this.makeMcompany(omMcompanyDomain, oldOmMcompany);
        this.setMcompanyUpdataDefault(omMcompany);
        this.updateMcompanyModel(omMcompany);
    }

    @Override
    public OmMcompany getMcompany(Integer companyId) {
        return this.getMcompanyModelById(companyId);
    }

    @Override
    public void deleteMcompany(Integer companyId) throws ApiException {
        this.deleteMcompanyModel(companyId);
    }

    @Override
    public QueryResult<OmMcompany> queryMcompanyPage(Map<String, Object> map) {
        List<OmMcompany> omMcompanyList = this.queryMcompanyModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMcompany(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(omMcompanyList);
        return queryResult;
    }
}

