/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mcompany.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mcompany.dao.OmMdepartmentMapper;
import com.yqbsoft.laser.service.mcompany.domain.OmMdepartmentDomain;
import com.yqbsoft.laser.service.mcompany.model.OmMdepartment;
import com.yqbsoft.laser.service.mcompany.service.MdepartmentService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MdepartmentServiceImpl
extends BaseServiceImpl
implements MdepartmentService {
    public static final String SYS_CODE = "om.POS.BASEINFO.MdepartmentServiceImpl";
    private OmMdepartmentMapper omMdepartmentMapper;

    public void setOmMdepartmentMapper(OmMdepartmentMapper omMdepartmentMapper) {
        this.omMdepartmentMapper = omMdepartmentMapper;
    }

    private Date getSysDate() {
        try {
            return this.omMdepartmentMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.MdepartmentServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMdepartment(OmMdepartmentDomain omMdepartmentDomain) {
        if (null == omMdepartmentDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMdepartmentDefault(OmMdepartment omMdepartment) {
        if (null == omMdepartment) {
            return;
        }
        if (null == omMdepartment.getDataState()) {
            omMdepartment.setDataState(0);
        }
        if (null == omMdepartment.getGmtCreate()) {
            omMdepartment.setGmtCreate(this.getSysDate());
        }
        omMdepartment.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)omMdepartment.getDepartmentCode())) {
            int code = this.getMaxCode();
            omMdepartment.setDepartmentCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.omMdepartmentMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.MdepartmentServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMdepartmentUpdataDefault(OmMdepartment omMdepartment) {
        if (null == omMdepartment) {
            return;
        }
        omMdepartment.setGmtModified(this.getSysDate());
    }

    private void saveMdepartmentModel(OmMdepartment omMdepartment) throws ApiException {
        if (null == omMdepartment) {
            return;
        }
        try {
            this.omMdepartmentMapper.insert(omMdepartment);
        }
        catch (Exception e) {
            throw new ApiException("om.POS.BASEINFO.MdepartmentServiceImpl.saveFtpserverModel.ex");
        }
    }

    private OmMdepartment getMdepartmentModelById(Integer departmentId) {
        if (null == departmentId) {
            return null;
        }
        try {
            return this.omMdepartmentMapper.selectByPrimaryKey(departmentId);
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.MdepartmentServiceImpl.getMdepartmentModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMdepartmentModel(Integer departmentId) throws ApiException {
        if (null == departmentId) {
            return;
        }
        int i = 0;
        try {
            i = this.omMdepartmentMapper.deleteByPrimaryKey(departmentId);
        }
        catch (Exception e) {
            throw new ApiException("om.POS.BASEINFO.MdepartmentServiceImpl.deleteMdepartmentModel.ex");
        }
        if (1 != i) {
            throw new ApiException("om.POS.BASEINFO.MdepartmentServiceImpl.deleteMdepartmentModel.num");
        }
    }

    private void updateMdepartmentModel(OmMdepartment omMdepartment) throws ApiException {
        if (null == omMdepartment) {
            return;
        }
        try {
            this.omMdepartmentMapper.updateByPrimaryKeySelective(omMdepartment);
        }
        catch (Exception e) {
            throw new ApiException("om.POS.BASEINFO.MdepartmentServiceImpl.updateMdepartmentModel.ex");
        }
    }

    private void updateStateMdepartmentModel(Integer departmentId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == departmentId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("departmentId", departmentId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.omMdepartmentMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("om.POS.BASEINFO.MdepartmentServiceImpl.updateStateMdepartmentModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("om.POS.BASEINFO.MdepartmentServiceImpl.updateStateMdepartmentModel.null");
        }
    }

    private OmMdepartment makeMdepartment(OmMdepartmentDomain omMdepartmentDomain, OmMdepartment omMdepartment) {
        if (null == omMdepartmentDomain) {
            return null;
        }
        if (null == omMdepartment) {
            omMdepartment = new OmMdepartment();
        }
        try {
            BeanUtils.copyAllPropertys((Object)omMdepartment, (Object)omMdepartmentDomain);
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.MdepartmentServiceImpl.makeMdepartment", (Throwable)e);
        }
        return omMdepartment;
    }

    private List<OmMdepartment> queryMdepartmentModelPage(Map<String, Object> parammap) {
        try {
            return this.omMdepartmentMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.MdepartmentServiceImpl.queryMdepartmentModel", (Throwable)e);
            return null;
        }
    }

    private int countMdepartment(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.omMdepartmentMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("om.POS.BASEINFO.MdepartmentServiceImpl.countMdepartment", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMdepartment(OmMdepartmentDomain omMdepartmentDomain) throws ApiException {
        String msg = this.checkMdepartment(omMdepartmentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.POS.BASEINFO.MdepartmentServiceImpl.saveMdepartment.checkMdepartment", msg);
        }
        OmMdepartment omMdepartment = this.makeMdepartment(omMdepartmentDomain, null);
        this.setMdepartmentDefault(omMdepartment);
        this.saveMdepartmentModel(omMdepartment);
    }

    @Override
    public void updateMdepartmentState(Integer departmentId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMdepartmentModel(departmentId, dataState, oldDataState);
    }

    @Override
    public void updateMdepartment(OmMdepartmentDomain omMdepartmentDomain) throws ApiException {
        String msg = this.checkMdepartment(omMdepartmentDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("om.POS.BASEINFO.MdepartmentServiceImpl.updateMdepartment.checkMdepartment", msg);
        }
        OmMdepartment oldOmMdepartment = this.getMdepartmentModelById(omMdepartmentDomain.getDepartmentId());
        if (null == oldOmMdepartment) {
            throw new ApiException("om.POS.BASEINFO.MdepartmentServiceImpl.updateMdepartment.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OmMdepartment omMdepartment = this.makeMdepartment(omMdepartmentDomain, oldOmMdepartment);
        this.setMdepartmentUpdataDefault(omMdepartment);
        this.updateMdepartmentModel(omMdepartment);
    }

    @Override
    public OmMdepartment getMdepartment(Integer departmentId) {
        return this.getMdepartmentModelById(departmentId);
    }

    @Override
    public void deleteMdepartment(Integer departmentId) throws ApiException {
        this.deleteMdepartmentModel(departmentId);
    }

    @Override
    public QueryResult<OmMdepartment> queryMdepartmentPage(Map<String, Object> map) {
        List<OmMdepartment> omMdepartmentList = this.queryMdepartmentModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMdepartment(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(omMdepartmentList);
        return queryResult;
    }
}

