/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.mns.service.impl;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.v20170525.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.mns.MnsConstants;
import com.yqbsoft.laser.service.mns.dao.MnsMnslistMapper;
import com.yqbsoft.laser.service.mns.domain.MnsMnsblistDomainBean;
import com.yqbsoft.laser.service.mns.domain.MnsMnsblistReDomainBean;
import com.yqbsoft.laser.service.mns.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.mns.domain.UmUserDomain;
import com.yqbsoft.laser.service.mns.domain.UmUserinfo;
import com.yqbsoft.laser.service.mns.domain.UpmUpointsList;
import com.yqbsoft.laser.service.mns.model.MnsMnschannel;
import com.yqbsoft.laser.service.mns.model.MnsMnsconfig;
import com.yqbsoft.laser.service.mns.model.MnsMnsfee;
import com.yqbsoft.laser.service.mns.model.MnsMnslist;
import com.yqbsoft.laser.service.mns.model.MnsMnsmemfee;
import com.yqbsoft.laser.service.mns.model.MnsMnstemplate;
import com.yqbsoft.laser.service.mns.model.PteBalancelist;
import com.yqbsoft.laser.service.mns.model.SubUsersub;
import com.yqbsoft.laser.service.mns.send.SendPollThread;
import com.yqbsoft.laser.service.mns.send.SendPutThread;
import com.yqbsoft.laser.service.mns.send.SendService;
import com.yqbsoft.laser.service.mns.service.MnsMnsmemlistService;
import com.yqbsoft.laser.service.mns.service.MnsSendPhoneService;
import com.yqbsoft.laser.service.mns.service.MnsService;
import com.yqbsoft.laser.service.mns.service.MnsblistService;
import com.yqbsoft.laser.service.mns.service.MnschannelService;
import com.yqbsoft.laser.service.mns.service.MnsconfigService;
import com.yqbsoft.laser.service.mns.service.MnslistService;
import com.yqbsoft.laser.service.mns.service.MnstemplateService;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class MnslistServiceImpl
extends BaseServiceImpl
implements MnslistService {
    public static final String SYS_CODE = "mns.MNS.MnslistServiceImpl";
    private static SendService sendService;
    private static Object lock;
    private MnsMnslistMapper mnsMnslistMapper;
    private MnstemplateService mnstemplateService;
    private MnschannelService mnschannelService;
    private MnsconfigService mnsconfigService;
    private MnsSendPhoneService mnsSendPhoneService;
    private MnsblistService mnsblistService;
    private MnsMnsmemlistService mnsMnsmemlistService;
    private static final Long TWENTY_FOUR_HOURS_IN_MILLIS;

    public static void main(String[] args) {
        System.out.println(MnslistServiceImpl.getDay());
    }

    public static String getDay() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int dayOfMonth = calendar.get(5);
        String dateMsg = year + "-" + month + "-" + dayOfMonth;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = dateFormat.parse(dateMsg);
            calendar.setTime(date);
            calendar.add(5, 0);
            dateMsg = dateFormat.format(calendar.getTime());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dateMsg;
    }

    private String getContent(Map<String, Object> map, String mnsContent) {
        try {
            StringWriter writer = this.getTemplateContent(map, mnsContent);
            return writer.toString();
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.getContent", (Object)(mnsContent + "=" + map), (Throwable)e);
            return null;
        }
    }

    private StringWriter getTemplateContent(Map<String, Object> map, String content) throws IOException, TemplateException {
        Configuration cfg = new Configuration();
        cfg.setClassicCompatible(true);
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        stringTemplateLoader.putTemplate(VfinOpenConstants.FREEMAKER_STR_KEY, content);
        cfg.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        cfg.setDefaultEncoding("UTF-8");
        Template template = cfg.getTemplate(VfinOpenConstants.FREEMAKER_STR_KEY);
        StringWriter writer = new StringWriter();
        template.process(map, (Writer)writer);
        return writer;
    }

    public void setMnsSendPhoneService(MnsSendPhoneService mnsSendPhoneService) {
        this.mnsSendPhoneService = mnsSendPhoneService;
    }

    public void setMnschannelService(MnschannelService mnschannelService) {
        this.mnschannelService = mnschannelService;
    }

    public void setMnsblistService(MnsblistService mnsblistService) {
        this.mnsblistService = mnsblistService;
    }

    public void setMnstemplateService(MnstemplateService mnstemplateService) {
        this.mnstemplateService = mnstemplateService;
    }

    public void setMnsMnsmemlistService(MnsMnsmemlistService mnsMnsmemlistService) {
        this.mnsMnsmemlistService = mnsMnsmemlistService;
    }

    public void setMnsconfigService(MnsconfigService mnsconfigService) {
        this.mnsconfigService = mnsconfigService;
    }

    public void setMnsMnslistMapper(MnsMnslistMapper mnsMnslistMapper) {
        this.mnsMnslistMapper = mnsMnslistMapper;
    }

    private Date getSysDate() {
        try {
            return this.mnsMnslistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) {
        if (null == mnsMnslistDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private String checkBusinessMnslist(Map<String, Object> map) {
        if (null == map) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)((String)map.get("businessType")))) {
            msg = msg + "\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMnslistDefault(MnsMnslist mnsMnslist) {
        if (null == mnsMnslist) {
            return;
        }
        if (null == mnsMnslist.getDataState()) {
            mnsMnslist.setDataState(0);
        }
        if (null == mnsMnslist.getGmtCreate()) {
            mnsMnslist.setGmtCreate(this.getSysDate());
        }
        if (null == mnsMnslist.getMnslistSource()) {
            mnsMnslist.setMnslistSource(0);
        }
        if (StringUtils.isNotBlank((String)mnsMnslist.getMemberCode())) {
            String dataTenant = DisUtil.getMap((String)"tmtenant-mem-code", (String)mnsMnslist.getMemberCode());
            mnsMnslist.setDataTenant(dataTenant);
        }
        if (StringUtils.isBlank((String)mnsMnslist.getDataTenant())) {
            mnsMnslist.setDataTenant(mnsMnslist.getTenantCode());
        }
        if (StringUtils.isBlank((String)mnsMnslist.getMnslistCode())) {
            mnsMnslist.setMnslistCode(this.getNo(null, "MnsList", "MnsMnsList", "00000001"));
        }
    }

    private void setMnslistUpdataDefault(MnsMnslist mnsMnslist) {
        if (null == mnsMnslist) {
            return;
        }
        mnsMnslist.setGmtModified(this.getSysDate());
    }

    private void saveMnslistModel(MnsMnslist mnsMnslist) throws ApiException {
        if (null == mnsMnslist) {
            return;
        }
        try {
            this.mnsMnslistMapper.insert(mnsMnslist);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveMnslistModel.ex" + e);
        }
    }

    private MnsMnslist getMnslistModelById(Integer mnslistId) {
        if (null == mnslistId) {
            return null;
        }
        try {
            return this.mnsMnslistMapper.selectByPrimaryKey(mnslistId);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.getMnslistModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMnslistModel(Integer mnslistId) throws ApiException {
        if (null == mnslistId) {
            return;
        }
        int i = 0;
        try {
            i = this.mnsMnslistMapper.deleteByPrimaryKey(mnslistId);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.deleteMnslistModel.ex");
        }
        if (1 != i) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.deleteMnslistModel.num");
        }
    }

    private void deleteMnslistModelByCode(String mnslistCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)mnslistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnslistCode", mnslistCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.mnsMnslistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.deleteMnslistModelByCode.ex", ((Object)map).toString());
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.deleteMnslistModelByCode.num", i + "=" + ((Object)map).toString());
        }
    }

    private void updateMnslistModel(MnsMnslist mnsMnslist) throws ApiException {
        if (null == mnsMnslist) {
            return;
        }
        try {
            this.mnsMnslistMapper.updateByPrimaryKeyWithBLOBs(mnsMnslist);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateMnslistModel.ex");
        }
    }

    private void updateStateMnslistModel(Integer mnslistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mnslistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnslistId", mnslistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mnsMnslistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateMnslistModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateMnslistModel.null");
        }
    }

    private void updateStateMnslistModelSend(Integer mnslistId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mnslistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnslistId", mnslistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("mnslistSenddate", this.getSysDate());
        int i = 0;
        try {
            i = this.mnsMnslistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateMnslistModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateMnslistModel.null" + map);
        }
    }

    private void updateStateByCodeMnslistState(String mnslistCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == mnslistCode || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("mnslistCode", mnslistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.mnsMnslistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateByCodeMnslistState.ex");
        }
        if (i <= 0) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateStateByCodeMnslistState.null" + map);
        }
    }

    private MnsMnslist makeMnslist(MnsMnslistDomainBean mnsMnslistDomainBean, MnsMnslist mnsMnslist) {
        if (null == mnsMnslistDomainBean) {
            return null;
        }
        if (null == mnsMnslist) {
            mnsMnslist = new MnsMnslist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnslist, (Object)mnsMnslistDomainBean);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.makeMnslist", (Throwable)e);
        }
        return mnsMnslist;
    }

    private MnsMnslist makeBusinessMnslist(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        MnsMnslist mnsMnslist = new MnsMnslist();
        try {
            String sendSys = (String)map.get("sendSys");
            mnsMnslist.setMnslistBustype((String)map.get("businessType"));
            mnsMnslist.setMnslistSubject((String)map.get("theme"));
            HashMap<String, String> expMap = new HashMap<String, String>();
            expMap.put("businessType", (String)map.get("businessType"));
            expMap.put("sender", (String)map.get("sender"));
            expMap.put("receiverList", (String)map.get("receiverList"));
            expMap.put("paramMap", (String)map.get("paramMap"));
            if (StringUtils.isNotBlank((String)sendSys)) {
                HashMap<String, String> mapSender = new HashMap<String, String>();
                mapSender.put("code", "sys");
                mapSender.put("name", "sys");
                map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
                ArrayList listReceiver = new ArrayList();
                HashMap<String, String> mapReceiver = new HashMap<String, String>();
                mapReceiver.put("code", "");
                mapReceiver.put("name", "sys");
                String email = DisUtil.getMap((String)"PosCstSysParam-list", (String)"OPEN_EMAIL_SERVER-01-00");
                if (StringUtils.isBlank((String)email)) {
                    this.logger.info(SYS_CODE, (Object)"sys email is null");
                    return null;
                }
                mapReceiver.put("email", email);
                mapReceiver.put("telphone", "");
                listReceiver.add(mapReceiver);
                map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
                expMap.put("sender", (String)map.get("sender"));
                expMap.put("receiverList", (String)map.get("receiverList"));
            }
            mnsMnslist.setMnslistSource(0);
            mnsMnslist.setMnslistExp(JsonUtil.buildNormalBinder().toJson(expMap));
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.makeBusinessMnslist", (Throwable)e);
        }
        return mnsMnslist;
    }

    private List<MnsMnslist> queryMnslistModelPage(Map<String, Object> parammap) {
        try {
            return this.mnsMnslistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.queryMnslistModel", (Throwable)e);
            return null;
        }
    }

    private List<MnsMnslist> queryMnslistModel(Map<String, Object> parammap) {
        try {
            return this.mnsMnslistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.queryMnslistModel", (Throwable)e);
            return null;
        }
    }

    private int countMnslist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.mnsMnslistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.countMnslist", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        String msg = this.checkMnslist(mnsMnslistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveMnslist.checkMnslist", msg);
        }
        MnsMnslist mnsMnslist = this.makeMnslist(mnsMnslistDomainBean, null);
        this.setMnslistDefault(mnsMnslist);
        this.saveMnslistModel(mnsMnslist);
        mnsMnslistDomainBean.setMnslistId(mnsMnslist.getMnslistId());
        mnsMnslistDomainBean.setMnslistCode(mnsMnslist.getMnslistCode());
        mnsMnslistDomainBean.setDataTenant(mnsMnslist.getDataTenant());
    }

    @Override
    public void saveSendMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        if (null == mnsMnslistDomainBean) {
            return;
        }
        this.saveMnslist(mnsMnslistDomainBean);
        if (null != mnsMnslistDomainBean.getMnslistPush() && 0 == mnsMnslistDomainBean.getMnslistPush()) {
            this.getSendService().putQueue(mnsMnslistDomainBean);
        }
    }

    @Override
    public void saveBusinessMnslist(Map<String, Object> map) throws ApiException {
        String msg = this.checkBusinessMnslist(map);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveBusinessMnslist.checkMnslist", msg);
        }
        MnsMnslist mnsMnslist = this.makeBusinessMnslist(map);
        this.setMnslistDefault(mnsMnslist);
        this.saveMnslistModel(mnsMnslist);
    }

    @Override
    public void saveMnslistBatch(List<MnsMnslistDomainBean> list) throws ApiException {
        if (null != list && list.size() > 0) {
            for (MnsMnslistDomainBean mnsMnslist : list) {
                this.saveMnslist(mnsMnslist);
            }
        }
    }

    @Override
    public void updateMnslistState(Integer mnslistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMnslistModel(mnslistId, dataState, oldDataState);
    }

    @Override
    public void updateMnslistStateSend(Integer mnslistId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMnslistModelSend(mnslistId, dataState, oldDataState);
    }

    public void updateMnslistStateSendByCode(String mnslistCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateByCodeMnslistState(mnslistCode, dataState, oldDataState);
    }

    @Override
    public void updateMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        String msg = this.checkMnslist(mnsMnslistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateMnslist.checkMnslist", msg);
        }
        MnsMnslist oldMnsMnslist = this.getMnslistModelById(mnsMnslistDomainBean.getMnslistId());
        if (null == oldMnsMnslist) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateMnslist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsMnslist mnsMnslist = this.makeMnslist(mnsMnslistDomainBean, oldMnsMnslist);
        this.setMnslistUpdataDefault(mnsMnslist);
        this.updateMnslistModel(mnsMnslist);
    }

    @Override
    public MnsMnslist getMnslist(Integer mnslistId) {
        return this.getMnslistModelById(mnslistId);
    }

    @Override
    public void deleteMnslist(Integer mnslistId) throws ApiException {
        this.deleteMnslistModel(mnslistId);
    }

    @Override
    public QueryResult<MnsMnslist> queryMnslistPage(Map<String, Object> map) {
        this.logger.error("sendMns.queryMnslistPage", (Object)("queryMnslistPage\u67e5\u8be2\u6761\u4ef6" + map));
        List<MnsMnslist> mnsMnslistList = this.queryMnslistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMnslist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mnsMnslistList);
        return queryResult;
    }

    @Override
    public List<MnsMnslist> queryMnslist(Map<String, Object> map) {
        List<MnsMnslist> mnsMnslistList = this.queryMnslistModel(map);
        return mnsMnslistList;
    }

    @Override
    public void updateFail(Map<String, Object> map) throws ApiException {
        this.updateMnslistFail(map);
    }

    @Override
    public void saveMnsBlistSend(MnsMnsblistDomainBean mnsMnsblistDomainBean) throws ApiException {
        String listContent;
        String first;
        this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSend.mnsMnsconfig====mnsMnsblistDomainBean=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnsblistDomainBean));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> maps = new HashMap<String, String>();
        String busType = mnsMnsblistDomainBean.getMnslistBustype();
        if (busType == null) {
            return;
        }
        MnsMnsconfig mnsMnsconfig = null;
        if (StringUtils.isNotBlank((String)mnsMnsblistDomainBean.getAppmanageIcode())) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnsblistDomainBean.getAppmanageIcode() + "-" + mnsMnsblistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnsblistDomainBean.getDataTenant() + "-" + mnsMnsblistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnsblistDomainBean.getDataTenant() + "-" + "00000000"), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-all-" + mnsMnsblistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnsblistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + "00000000"), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSend.mnsMnsconfig", (Object)("\u672a\u627e\u5230\u914d\u7f6e\u4fe1\u606fmnsMnsconfig" + busType + "-" + mnsMnsblistDomainBean.getTenantCode()));
            return;
        }
        this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSend.mnsMnsconfig====mnsMnsconfig=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnsconfig));
        MnsMnstemplate mnsMnstemplate = null;
        if (!"smail".equals(busType)) {
            if (StringUtils.isBlank((String)mnsMnsconfig.getDataTenant())) {
                mnsMnsconfig.setDataTenant("");
            }
            if (null == (mnsMnstemplate = (MnsMnstemplate)DisUtil.getMapJson((String)"Mnstemplate-mnstemplateCode", (String)(mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getTenantCode()), MnsMnstemplate.class))) {
                mnsMnstemplate = (MnsMnstemplate)DisUtil.getMapJson((String)"Mnstemplate-mnstemplateCode", (String)(mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getDataTenant()), MnsMnstemplate.class);
            }
            if (null == mnsMnstemplate) {
                this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSend.mnsMnstemplate", (Object)("\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606fmnsMnstemplate:" + mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getDataTenant() + "-" + mnsMnsconfig.getTenantCode()));
                return;
            }
        }
        if ((first = (listContent = mnsMnsblistDomainBean.getMnslistContent()).substring(0, 1)).contains("\u3010")) {
            String memoSign = listContent.substring(1, listContent.indexOf("\u3011"));
            listContent = listContent.substring(listContent.indexOf("\u3011") + 1, listContent.length());
            mnsMnsconfig.setMemo(memoSign);
        }
        mnsMnsconfig.setMnsMnstemplate(mnsMnstemplate);
        maps.put(mnsMnsconfig.getMnsMnstemplate().getMnstemplateKey(), listContent);
        paramMap.put("accessKeyId", mnsMnsconfig.getMnsMnstemplate().getMnstemplatePrekey());
        paramMap.put("accessKeySecret", mnsMnsconfig.getMnsMnstemplate().getMnstemplatePubkey());
        paramMap.put("content", mnsMnsconfig.getMnsMnstemplate().getMnstemplateOcode());
        paramMap.put("signName", mnsMnsconfig.getMemo());
        paramMap.put("paramMap", JsonUtil.buildNormalBinder().toJson(maps));
        paramMap.put("phone", mnsMnsblistDomainBean.getMnslistPhone());
        paramMap.put("mnslistCode", mnsMnsblistDomainBean.getMnslistCode());
        paramMap.put("memberCode", mnsMnsblistDomainBean.getMemberCode());
        String ress = "";
        try {
            this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSend.1", (Object)(mnsMnsblistDomainBean.getAppapiCode() + "=" + ((Object)paramMap).toString()));
            ress = (String)this.getInternalRouter().inInvoke(mnsMnsblistDomainBean.getAppapiCode(), mnsMnsblistDomainBean.getAppapiVersion(), "0", paramMap);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSend.e", (Object)(mnsMnsblistDomainBean.getAppapiCode() + "=" + ((Object)paramMap).toString()));
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveMnsBlistSend.e", mnsMnsblistDomainBean.getAppapiCode() + "=" + ((Object)paramMap).toString(), (Throwable)e);
        }
        if (StringUtils.isBlank((String)ress)) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveMnsBlistSend.ress");
        }
        this.mnsblistService.updateMnsblistOcode(mnsMnsblistDomainBean.getMnslistCode(), ress, mnsMnsblistDomainBean.getTenantCode());
        this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSend.2", (Object)(mnsMnsblistDomainBean.getAppapiCode() + "=" + ((Object)paramMap).toString()));
    }

    @Override
    public void saveMnsBlistSendAliSDK(MnsMnsblistDomainBean mnsMnsblistDomainBean) throws ApiException {
        String listContent;
        String first;
        this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSendAliSDK.mnsMnsconfig====mnsMnsblistDomainBean=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnsblistDomainBean));
        HashMap paramMap = new HashMap();
        String busType = mnsMnsblistDomainBean.getMnslistBustype();
        if (busType == null) {
            return;
        }
        MnsMnsconfig mnsMnsconfig = null;
        if (StringUtils.isNotBlank((String)mnsMnsblistDomainBean.getAppmanageIcode())) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnsblistDomainBean.getAppmanageIcode() + "-" + mnsMnsblistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnsblistDomainBean.getDataTenant() + "-" + mnsMnsblistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnsblistDomainBean.getDataTenant() + "-" + "00000000"), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-all-" + mnsMnsblistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnsblistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + "00000000"), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSendAliSDK.mnsMnsconfig", (Object)("\u672a\u627e\u5230\u914d\u7f6e\u4fe1\u606fmnsMnsconfig" + busType + "-" + mnsMnsblistDomainBean.getTenantCode()));
            return;
        }
        this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSendAliSDK.mnsMnsconfig====mnsMnsconfig=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnsconfig));
        MnsMnstemplate mnsMnstemplate = null;
        if (!"smail".equals(busType)) {
            if (StringUtils.isBlank((String)mnsMnsconfig.getDataTenant())) {
                mnsMnsconfig.setDataTenant("");
            }
            if (null == (mnsMnstemplate = (MnsMnstemplate)DisUtil.getMapJson((String)"Mnstemplate-mnstemplateCode", (String)(mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getTenantCode()), MnsMnstemplate.class))) {
                mnsMnstemplate = (MnsMnstemplate)DisUtil.getMapJson((String)"Mnstemplate-mnstemplateCode", (String)(mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getDataTenant()), MnsMnstemplate.class);
            }
            if (null == mnsMnstemplate) {
                this.logger.error("mns.MNS.MnslistServiceImpl.saveMnsBlistSendAliSDK.mnsMnstemplate", (Object)("\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606fmnsMnstemplate:" + mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getDataTenant() + "-" + mnsMnsconfig.getTenantCode()));
                return;
            }
        }
        if ((first = (listContent = mnsMnsblistDomainBean.getMnslistContent()).substring(0, 1)).contains("\u3010")) {
            String memoSign = listContent.substring(1, listContent.indexOf("\u3011"));
            listContent = listContent.substring(listContent.indexOf("\u3011") + 1, listContent.length());
            mnsMnsconfig.setMemo(memoSign);
        }
        mnsMnsconfig.setMnsMnstemplate(mnsMnstemplate);
        this.sendSMSAliSDK(mnsMnsblistDomainBean, mnsMnsconfig);
        this.mnsblistService.updateMnsblistOcode(mnsMnsblistDomainBean.getMnslistCode(), "", mnsMnsblistDomainBean.getTenantCode());
    }

    private void sendSMSAliSDK(MnsMnsblistDomainBean mnsMnsblistDomainBean, MnsMnsconfig mnsMnsconfig) {
        DefaultProfile profile = DefaultProfile.getProfile((String)mnsMnsconfig.getMnsMnstemplate().getMnstemplateUrl(), (String)mnsMnsconfig.getMnsMnstemplate().getMnstemplatePrekey(), (String)mnsMnsconfig.getMnsMnstemplate().getMnstemplatePubkey());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        SendSmsRequest request = new SendSmsRequest();
        request.setPhoneNumbers(mnsMnsblistDomainBean.getMnslistPhone());
        request.setSignName(mnsMnsconfig.getMnsMnstemplate().getMnstemplateMname());
        request.setTemplateCode(mnsMnsconfig.getMnsMnstemplate().getMnstemplateOcode());
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(mnsMnsblistDomainBean.getMnslistExp(), String.class, String.class);
        if (map != null && map.get("paramMap") != null) {
            request.setTemplateParam(JsonUtil.buildNormalBinder().toJson(map.get("paramMap")));
        } else {
            this.logger.error("mns.MNS.MnslistServiceImpl.sendSMSAliSDK", (Object)"paramMap:null");
        }
        try {
            SendSmsResponse response = (SendSmsResponse)client.getAcsResponse((AcsRequest)request);
            this.logger.error("mns.MNS.MnslistServiceImpl.sendSMSAliSDK.response", (Object)JsonUtil.buildNormalBinder().toJson((Object)response));
            if (!"ok".equals(response.getCode())) {
                mnsMnsblistDomainBean.setMemo(JsonUtil.buildNormalBinder().toJson((Object)response));
                this.mnsblistService.updateMnsblistByCode(mnsMnsblistDomainBean);
            }
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (ClientException e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.sendSMSAliSDK.ErrCode:", (Object)e.getErrCode());
            this.logger.error("mns.MNS.MnslistServiceImpl.sendSMSAliSDK.ErrMsg:", (Object)e.getErrMsg());
            this.logger.error("mns.MNS.MnslistServiceImpl.sendSMSAliSDK.RequestId:", (Object)e.getRequestId());
        }
    }

    private void updateMnslistFail(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        this.logger.error("mns.MNS.MnslistServiceImpl.updateMnslistFail.map", (Object)JsonUtil.buildNormalBinder().toJson(map));
        try {
            this.mnsMnslistMapper.updateMnslistFail(map);
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.updateMnslistModel.ex");
        }
    }

    @Override
    public void saveMnslistByNotContent(MnsMnslistDomainBean mnsMnslistDomainBean, Map<String, Object> map, String mnstemplateCode, boolean sendflag) throws ApiException {
        if (null != mnstemplateCode) {
            String content = this.mnstemplateService.getMnstemplateContent(mnstemplateCode, map);
            if (mnsMnslistDomainBean != null) {
                mnsMnslistDomainBean.setMnslistContent(content);
            }
        }
        this.saveMnslist(mnsMnslistDomainBean);
        if (mnsMnslistDomainBean.getMnslistId() != null && sendflag) {
            this.updateMnslistState(mnsMnslistDomainBean.getMnslistId(), MnsConstants.DATA_STATE_SUCCESS, null);
            this.sendMns(mnsMnslistDomainBean);
        }
    }

    public MnsMnsblistDomainBean makeMnsMnsblistDomainBean(MnsMnslistDomainBean mnsMnslistDomainBean) {
        if (null == mnsMnslistDomainBean) {
            return null;
        }
        MnsMnsblistDomainBean mnsMnsblistDomainBean = new MnsMnsblistDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnsblistDomainBean, (Object)mnsMnslistDomainBean);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.makeMnsMnsblistDomainBean", (Throwable)e);
        }
        return mnsMnsblistDomainBean;
    }

    private void getMnstemplateProperty(MnsMnsconfig mnsconfig, Map<String, String> paramMap) {
        Map mnstemplateProperty = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnsconfig.getMnstemplateProperty(), String.class, String.class);
        if (MapUtil.isNotEmpty((Map)mnstemplateProperty)) {
            for (String key : mnstemplateProperty.keySet()) {
                paramMap.put(key, (String)mnstemplateProperty.get(key));
            }
        }
    }

    private List<String> getEmployee(Map map) {
        String apiCode = "org.employee.queryEmployeePage";
        HashMap paramMap = new HashMap();
        QueryResult queryResult = this.sendReSupObject(apiCode, map, Object.class);
        List list = queryResult.getList();
        String json = JsonUtil.buildNonDefaultBinder().toJson((Object)list);
        List jsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(json, Map.class);
        ArrayList<String> res = new ArrayList<String>();
        for (Map stringStringMap : jsonToList) {
            res.add((String)stringStringMap.get("userinfoCode"));
        }
        return res;
    }

    private static Map<String, Object> stringMapToObject(Map<String, String> marapusermap) {
        HashMap<String, Object> mapObject = new HashMap<String, Object>();
        for (String key : marapusermap.keySet()) {
            if (marapusermap.get(key).indexOf("{") >= 0) {
                mapObject.put(key, JsonUtil.buildNormalBinder().getJsonToObject(marapusermap.get(key), Map.class));
                continue;
            }
            mapObject.put(key, marapusermap.get(key));
        }
        return mapObject;
    }

    public void makeMapKv(Map<String, String> map) {
        Map<String, Object> stringObjectMap = MnslistServiceImpl.stringMapToObject(map);
        for (String s : stringObjectMap.keySet()) {
            if (!(stringObjectMap.get(s) instanceof Map)) continue;
            Map object = (Map)stringObjectMap.get(s);
            for (String string : object.keySet()) {
                map.put(string, (String)object.get(string));
            }
            map.remove(s);
        }
    }

    private List<Map<String, String>> getManualmsgList(MnsMnslistDomainBean mnsMnslistDomain, MnsMnsconfig mnsconfig) {
        String manualmsgSubject = StringUtils.isEmpty((String)mnsMnslistDomain.getMnslistSubject()) ? mnsconfig.getMnstemplateDes() : mnsMnslistDomain.getMnslistSubject();
        String manualmsgContent = mnsconfig.getMnstemplateContent();
        String mnslistExp = mnsMnslistDomain.getMnslistExp();
        if (mnslistExp == null) {
            return null;
        }
        Map mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class);
        if (mapExp == null) {
            return null;
        }
        List auserList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
        if ("0006".equals(mnsconfig.getMnschannelCode())) {
            LinkedList<Map<String, String>> res = new LinkedList<Map<String, String>>();
            if ("pm002".equals(mnsMnslistDomain.getMnslistBustype())) {
                List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
                String disJson = (String)((Map)receiverList.get(0)).get("dis");
                ArrayList dislist = disJson == null ? new ArrayList() : JsonUtil.buildNonDefaultBinder().getList(disJson, List.class, String.class);
                String targetJson = (String)((Map)receiverList.get(1)).get("target");
                ArrayList targetlist = targetJson == null ? new ArrayList() : JsonUtil.buildNonDefaultBinder().getList(targetJson, List.class, String.class);
                String promotionCode = mnsMnslistDomain.getMnslistContent();
                HashMap channel_company_map = new HashMap();
                HashMap company_user_map = new HashMap();
                HashMap channel_user_map = new HashMap();
                ArrayList userInfoCodeSet = new ArrayList();
                ArrayList<String> companyCodeSet = new ArrayList<String>();
                StringBuilder userInfoCodeBuilder = new StringBuilder();
                StringBuilder companyCodeBuilder = new StringBuilder();
                for (String userinfoCode : targetlist) {
                    if (!StringUtils.isNotBlank((String)userinfoCode)) continue;
                    userInfoCodeBuilder.append(userinfoCode).append(",");
                }
                if (userInfoCodeBuilder.length() > 0) {
                    userInfoCodeBuilder.deleteCharAt(userInfoCodeBuilder.length() - 1);
                }
                for (String disCode : dislist) {
                    if (!StringUtils.isNotBlank((String)disCode)) continue;
                    companyCodeSet.add(disCode);
                    companyCodeBuilder.append(disCode).append(",");
                }
                if (companyCodeBuilder.length() > 0) {
                    companyCodeBuilder.deleteCharAt(companyCodeBuilder.length() - 1);
                }
                HashMap<String, String> paramMap = new HashMap<String, String>();
                HashMap<String, String> map = new HashMap<String, String>();
                paramMap.put("companyCode", companyCodeBuilder.toString());
                paramMap.put("userinfoCode", userInfoCodeBuilder.toString());
                map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
                QueryResult queryResult = this.sendReSupObject("org.employee.queryEmployeePage", map, Object.class);
                List list = queryResult.getList();
                String json = JsonUtil.buildNonDefaultBinder().toJson((Object)list);
                this.logger.error("\u67e5\u8be2\u5339\u914d\u7684\u516c\u53f8\u5458\u5de5", (Object)json);
                List jsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(json, Map.class);
                for (Map stringStringMap : jsonToList) {
                    String companyCode = (String)stringStringMap.get("companyCode");
                    String userCode = (String)stringStringMap.get("userinfoCode");
                    if (!company_user_map.containsKey(companyCode)) {
                        company_user_map.put(companyCode, new ArrayList());
                    }
                    ((List)company_user_map.get(companyCode)).add(userCode);
                    userInfoCodeSet.add(stringStringMap.get("userinfoCode"));
                }
                this.logger.error("\u516c\u53f8-\u7528\u6237", (Object)JsonUtil.buildNormalBinder().toJson(company_user_map));
                HashMap<String, String> pmParamMap = new HashMap<String, String>();
                HashMap<String, String> pmMap = new HashMap<String, String>();
                StringBuilder skuCode = new StringBuilder();
                pmParamMap.put("promotionCode", promotionCode);
                pmMap.put("map", JsonUtil.buildNormalBinder().toJson(pmParamMap));
                QueryResult pmQueryResult = this.sendReSupObject("pm.PmPromotion.queryPromotionPage", pmMap, Object.class);
                List pmList = pmQueryResult.getList();
                String pmJson = JsonUtil.buildNonDefaultBinder().toJson((Object)pmList);
                List pmJsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(pmJson, Map.class);
                for (Map stringStringMap : pmJsonToList) {
                    skuCode.append((String)stringStringMap.get("skuCode")).append(",");
                }
                if (skuCode.length() > 0) {
                    skuCode.deleteCharAt(skuCode.length() - 1);
                }
                this.logger.error("\u8425\u9500\u5546\u54c1sku", (Object)JsonUtil.buildNormalBinder().toJson((Object)skuCode));
                HashMap<String, String> channelParamMap = new HashMap<String, String>();
                HashMap<String, String> channelMap = new HashMap<String, String>();
                StringBuilder companyCodeBuilder2 = new StringBuilder();
                StringBuilder channelCodeBuilder = new StringBuilder();
                for (String companyCode : company_user_map.keySet()) {
                    if (!StringUtils.isNotBlank((String)companyCode)) continue;
                    companyCodeBuilder2.append(companyCode).append(",");
                }
                if (companyCodeBuilder2.length() > 0) {
                    companyCodeBuilder2.deleteCharAt(companyCodeBuilder2.length() - 1);
                }
                channelParamMap.put("memberCode", companyCodeBuilder2.toString());
                channelMap.put("map", JsonUtil.buildNormalBinder().toJson(channelParamMap));
                QueryResult channelQueryResult = this.sendReSupObject("dis.channel.queryChannelPage", channelMap, Object.class);
                List channelList = channelQueryResult.getList();
                String channelJson = JsonUtil.buildNonDefaultBinder().toJson((Object)channelList);
                List channelJsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(channelJson, Map.class);
                for (Map stringStringMap : channelJsonToList) {
                    channel_company_map.put(stringStringMap.get("channelCode"), stringStringMap.get("memberCode"));
                    channelCodeBuilder.append((String)stringStringMap.get("channelCode")).append(",");
                }
                if (channelCodeBuilder.length() > 0) {
                    channelCodeBuilder.deleteCharAt(channelCodeBuilder.length() - 1);
                }
                this.logger.error("\u6240\u6709\u516c\u53f8\u7684\u6e20\u9053", (Object)JsonUtil.buildNormalBinder().toJson((Object)channelCodeBuilder));
                this.logger.error("\u6e20\u9053-\u516c\u53f8", (Object)JsonUtil.buildNormalBinder().toJson(channel_company_map));
                HashSet channelCodeSet = new HashSet();
                HashMap<String, String> skuParamMap = new HashMap<String, String>();
                HashMap<String, String> skuMap = new HashMap<String, String>();
                skuParamMap.put("channelCode", channelCodeBuilder.toString());
                skuParamMap.put("skuCodes", skuCode.toString());
                skuMap.put("map", JsonUtil.buildNormalBinder().toJson(skuParamMap));
                QueryResult skuQueryResult = this.sendReSupObject("rs.sku.querySkuOnePage", skuMap, Object.class);
                List skuList = skuQueryResult.getList();
                String skuJson = JsonUtil.buildNonDefaultBinder().toJson((Object)skuList);
                List skuJsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(skuJson, Map.class);
                for (Map stringStringMap : skuJsonToList) {
                    channelCodeSet.add(stringStringMap.get("channelCode"));
                }
                this.logger.error("\u53ef\u63a8\u6e20\u9053:", (Object)JsonUtil.buildNormalBinder().toJson(channelCodeSet));
                for (String channelCode : channel_company_map.keySet()) {
                    if (channelCodeSet.contains(channelCode)) continue;
                    channel_company_map.remove(channelCode);
                }
                for (String channelCode : channel_company_map.keySet()) {
                    String companyCode = (String)channel_company_map.get(channelCode);
                    if (!company_user_map.containsKey(companyCode)) continue;
                    channel_user_map.put(channelCode, company_user_map.get(companyCode));
                }
                this.logger.error("\u6e20\u9053-\u7528\u6237", (Object)JsonUtil.buildNormalBinder().toJson(channel_user_map));
                ArrayList stoppedUserList = (ArrayList)this.stoppedUserList();
                for (String code : userInfoCodeSet) {
                    MnsMnsblistReDomainBean mnsMnsblistDomainBean = new MnsMnsblistReDomainBean();
                    mnsMnsblistDomainBean.setDataState(0);
                    mnsMnsblistDomainBean.setMnschannelCode(mnsconfig.getMnschannelCode());
                    mnsMnsblistDomainBean.setMnschannelName(mnsconfig.getMnschannelName());
                    mnsMnsblistDomainBean.setAppapiCode(mnsconfig.getAppapiCode());
                    mnsMnsblistDomainBean.setAppapiVersion(mnsconfig.getAppapiVersion());
                    mnsMnsblistDomainBean.setMnslistContent(mnsMnslistDomain.getMnslistContent());
                    mnsMnsblistDomainBean.setTenantCode(mnsconfig.getTenantCode());
                    mnsMnsblistDomainBean.setMnslistBustype(mnsconfig.getMnsconfigBustype());
                    mnsMnsblistDomainBean.setMnslistBusname(mnsconfig.getMnsconfigBusname());
                    mnsMnsblistDomainBean.setMnslistSource(0);
                    mnsMnsblistDomainBean.setMemberCode(mnsMnslistDomain.getMemberCode());
                    mnsMnsblistDomainBean.setMnslistExp(mnslistExp);
                    mnsMnsblistDomainBean.setAppmanageIcode(mnsconfig.getAppmanageIcode());
                    mnsMnsblistDomainBean.setDataState(0);
                    mnsMnsblistDomainBean.setMnslistCode(mnsMnslistDomain.getMnslistCode());
                    mnsMnsblistDomainBean.setMemberCode(code);
                    if (!channel_user_map.values().toString().contains(code)) {
                        mnsMnsblistDomainBean.setMnslistState("\u6e20\u9053\u5185\u65e0\u6d3b\u52a8\u5546\u54c1");
                        mnsMnsblistDomainBean.setDataState(-1);
                        this.mnsblistService.saveMnsblist(mnsMnsblistDomainBean);
                        continue;
                    }
                    if (stoppedUserList.contains(code)) {
                        mnsMnsblistDomainBean.setMnslistState("\u5458\u5de5\u88ab\u505c\u7528");
                        mnsMnsblistDomainBean.setDataState(-1);
                        this.mnsblistService.saveMnsblist(mnsMnsblistDomainBean);
                        continue;
                    }
                    mnsMnsblistDomainBean.setMnslistState("");
                    this.mnsblistService.saveMnsblist(mnsMnsblistDomainBean);
                    this.logger.error("\u4fdd\u5b58\u63a8\u9001\u8bb0\u5f55\u6210\u529f--->", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnsblistDomainBean.getMnsblistId()));
                    HashMap<String, String> m = new HashMap<String, String>();
                    if (code == null) continue;
                    m.put("code", code);
                    m.put("mnslistContent", mnsMnslistDomain.getMnslistContent());
                    m.put("mnslistBustype", mnsMnslistDomain.getMnslistBustype());
                    m.put("mnslistCode", mnsMnslistDomain.getMnslistCode());
                    m.put("memberCode", code);
                    m.put("promotion", (String)((Map)receiverList.get(receiverList.size() - 1)).get("promotion"));
                    m.put("mnsblistId", String.valueOf(mnsMnsblistDomainBean.getMnsblistId()));
                    this.makeMapKv(m);
                    m.put("mnslistExp", mnslistExp);
                    res.add(m);
                }
                return res;
            }
        }
        Map paramMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap((String)mapExp.get("paramMap"), String.class, String.class);
        this.getMnstemplateProperty(mnsconfig, paramMap);
        mapExp.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson((Object)paramMap));
        mapExp.put("mnsMsgType", String.valueOf(mnsconfig.getMnsMsgType()));
        mapExp.put("appFlag", String.valueOf(mnsMnslistDomain.getAppFlag()));
        mapExp.put("picUrl", String.valueOf(mnsMnslistDomain.getPicUrl()));
        ArrayList<Map<String, String>> mnsList = new ArrayList<Map<String, String>>();
        String mnslistBusType = mnsMnslistDomain.getMnslistBustype();
        String mnslistBusName = mnsMnslistDomain.getMnslistBusname();
        Integer mnschannelType = mnsconfig.getMnschannelType();
        String appmanageIcode = mnsconfig.getAppmanageIcode();
        Integer hasInstantPush = mnsconfig.getHasInstantPush();
        Integer validDay = mnsconfig.getValidDay();
        String tenantCode = mnsMnslistDomain.getTenantCode();
        String memberCode = mnsMnslistDomain.getMemberCode();
        if (hasInstantPush == null) {
            hasInstantPush = 0;
        }
        String allcontent = "";
        mnsMnslistDomain.setMnslistSubject(manualmsgSubject);
        String concatCode = mnsMnslistDomain.getDataTenantname();
        for (int i = 0; i < auserList.size(); ++i) {
            Map mapAuser = (Map)auserList.get(i);
            HashMap<String, Object> amap = new HashMap<String, Object>();
            String manualmsgContentNew = this.getMnsContent(amap, mapAuser, paramMap, manualmsgContent);
            allcontent = allcontent + (null == manualmsgContentNew ? "" : manualmsgContentNew);
            String auserCode = (String)mapAuser.get("code");
            String auserName = (String)mapAuser.get("name");
            String callValidateUrl = mnsconfig.getCallValidateUrl();
            String code = (String)paramMap.get("code");
            HashMap<String, String> callMap = new HashMap<String, String>();
            String url = "";
            if (!StringUtils.isEmpty((String)callValidateUrl) && !StringUtils.isEmpty((String)code)) {
                callMap.putAll(paramMap);
                callMap.put("callValidateUrl", callValidateUrl);
                callMap.put("tenantCode", tenantCode);
                callMap.put("acceptCode", auserCode);
                callMap.put("mnschannelType", String.valueOf(mnschannelType));
                url = JsonUtil.buildNonDefaultBinder().toJson(callMap);
            }
            if (null != mnschannelType && mnschannelType == 3 || mnschannelType == 2) {
                this.makeMnsList(mnsList, manualmsgSubject, manualmsgContentNew, mapExp, auserCode, auserName, tenantCode, hasInstantPush, mnsconfig, appmanageIcode, url, mnschannelType, validDay, mapAuser, memberCode, concatCode);
                continue;
            }
            HashMap<String, String> mnsMap = new HashMap<String, String>();
            mnsMap.put("mnschannelType", String.valueOf(mnschannelType));
            mnsMap.put("mnslistSubject", manualmsgSubject);
            mnsMap.put("mnslistContent", manualmsgContentNew);
            mnsMap.put("mnslistCode", mnsMnslistDomain.getMnslistCode());
            mnsMap.put("mnslistSource", "0");
            mnsMap.put("mnslistBusType", mnslistBusType);
            mnsMap.put("mnslistBusName", mnslistBusName);
            mnsMap.put("mnslistActiveid", mnsMnslistDomain.getMnslistActiveid());
            mnsMap.put("tenantCode", tenantCode);
            mnsMap.put("memberCode", memberCode);
            mnsMap.put("dataTenant", mnsMnslistDomain.getDataTenant());
            mapExp.remove("receiverList");
            ArrayList listReceiver = new ArrayList();
            HashMap<String, String> mapReceiver = new HashMap<String, String>();
            mapReceiver.put("code", auserCode);
            mapReceiver.put("name", auserName);
            mapReceiver.put("telphone", (String)mapAuser.get("telphone"));
            mapReceiver.put("email", (String)mapAuser.get("email"));
            listReceiver.add(mapReceiver);
            mapExp.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
            mnsMap.put("mnslistExp", JsonUtil.buildNonDefaultBinder().toJson((Object)mapExp));
            mnsList.add(mnsMap);
        }
        mnsMnslistDomain.setMnslistContent(allcontent);
        return mnsList;
    }

    private List<String> stoppedUserList() {
        ArrayList<String> res = new ArrayList<String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> map = new HashMap<String, String>();
        paramMap.put("dataState", "-1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        QueryResult queryResult = this.sendReSupObject("org.employee.queryEmployeePage", map, Object.class);
        List list = queryResult.getList();
        String json = JsonUtil.buildNonDefaultBinder().toJson((Object)list);
        List jsonToList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(json, Map.class);
        for (Map stringStringMap : jsonToList) {
            res.add((String)stringStringMap.get("userinfoCode"));
        }
        return res;
    }

    private void makeMnsList(List<Map<String, String>> mnsList, String manualmsgSubject, String manualmsgContentNew, Map<String, String> mapExp, String auserCode, String auserName, String tenantCode, Integer hasInstantPush, MnsMnsconfig mnsconfig, String appmanageIcode, String url, Integer mnschannelType, Integer validDay, Map<String, String> mapAuser, String memberCode, String concatCode) {
        List<UmUserinfo> userinfoList = this.getUserinfoList(mapAuser, tenantCode, memberCode);
        if (ListUtil.isNotEmpty(userinfoList)) {
            for (UmUserinfo umUserinfo : userinfoList) {
                Map<String, String> imsgMap = this.makeMnsList(manualmsgSubject, manualmsgContentNew, mapExp, umUserinfo.getUserinfoCode(), umUserinfo.getUserinfoCompname(), tenantCode, hasInstantPush, mnsconfig, appmanageIcode, url, mnschannelType, validDay, concatCode);
                mnsList.add(imsgMap);
            }
        } else {
            Map<String, String> imsgMap = this.makeMnsList(manualmsgSubject, manualmsgContentNew, mapExp, auserCode, auserName, tenantCode, hasInstantPush, mnsconfig, appmanageIcode, url, mnschannelType, validDay, concatCode);
            mnsList.add(imsgMap);
        }
    }

    private List<UmUserinfo> getUserinfoList(Map<String, String> mapAuser, String tenantCode, String memberCode) {
        if (null != mapAuser.get("code") && "all".equals(String.valueOf(mapAuser.get("code"))) && null != mapAuser.get("key") && null != mapAuser.get("value")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tenantCode", tenantCode);
            map.put(mapAuser.get("key"), mapAuser.get("value"));
            this.logger.error("mns.MNS.MnslistServiceImpl.makeMnsMnsblistDomainBean", (Object)memberCode);
            this.logger.error("mns.MNS.MnslistServiceImpl.makeMnsMnsblistDomainBean", (Object)mapAuser.get("keys"));
            if (null != mapAuser.get("keys")) {
                map.put("userinfoParentCode", memberCode);
                this.logger.error("mns.MNS.MnslistServiceImpl.makeMnsMnsblistDomainBean2", (Object)mapAuser.get("keys"));
            }
            map.put("fuzzy", true);
            this.logger.error("mns.MNS.MnslistServiceImpl.makeMnsMnsblistDomainBean3", map);
            String apiCode = "um.user.queryUserinfoPage";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            QueryResult queryResult = this.sendReSupObject(apiCode, paramMap, UmUserinfo.class);
            this.logger.error("mns.MNS.MnslistServiceImpl.makeMnsMnsblistDomainBea5", (Object)queryResult.getList());
            if (null != queryResult && ListUtil.isNotEmpty((Collection)queryResult.getList())) {
                return queryResult.getList();
            }
        }
        return null;
    }

    private Map<String, String> makeMnsList(String manualmsgSubject, String manualmsgContentNew, Map<String, String> mapExp, String auserCode, String auserName, String tenantCode, Integer hasInstantPush, MnsMnsconfig mnsconfig, String appmanageIcode, String url, Integer mnschannelType, Integer validDay, String concatCode) {
        HashMap<String, String> imsgMap = new HashMap<String, String>();
        imsgMap.put("memo", mapExp.get("appFlag"));
        mapExp.remove("appFlag");
        imsgMap.put("pushmsgSubject", manualmsgSubject);
        imsgMap.put("pushmsgContent", concatCode);
        imsgMap.put("pushmsgType", mapExp.get("pushmsgType"));
        imsgMap.put("pushmsgJpushType", mapExp.get("picUrl"));
        mapExp.remove("picUrl");
        imsgMap.put("pushmsgSuserCode", this.imsgSenders(mapExp)[0]);
        imsgMap.put("pushmsgSuserName", this.imsgSenders(mapExp)[1]);
        imsgMap.put("pushmsgAuserCode", auserCode);
        imsgMap.put("pushmsgAuserName", auserName);
        imsgMap.put("pushmsgSenddate", mapExp.get("pushmsgSenddate"));
        imsgMap.put("pushmsgExp", JsonUtil.buildNonDefaultBinder().toJson(mapExp));
        imsgMap.put("tenantCode", tenantCode);
        imsgMap.put("hasInstantPush", hasInstantPush.toString());
        imsgMap.put("mnsMsgType", String.valueOf(mnsconfig.getMnsMsgType()));
        imsgMap.put("appmanageIcode", appmanageIcode);
        imsgMap.put("callValidateUrl", url);
        imsgMap.put("mnschannelType", String.valueOf(mnschannelType));
        if (validDay != null) {
            imsgMap.put("validDay", validDay.toString());
        }
        return imsgMap;
    }

    private String[] imsgSenders(Map<String, String> mapExp) {
        String[] imsgSenders = new String[]{"sys", "sys"};
        if (StringUtils.isBlank((String)mapExp.get("imsgSuserCode")) || StringUtils.isBlank((String)mapExp.get("imsgSuserName"))) {
            Map senderMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mapExp.get("sender"), String.class, String.class);
            if (MapUtil.isNotEmpty((Map)senderMap)) {
                imsgSenders[0] = (String)senderMap.get("code");
                imsgSenders[1] = (String)senderMap.get("name");
            }
        } else {
            imsgSenders[0] = mapExp.get("imsgSuserCode");
            imsgSenders[1] = mapExp.get("imsgSuserName");
        }
        return imsgSenders;
    }

    private String getMnsContent(Map<String, Object> amap, Map<String, String> mapAuser, Map<String, String> paramMap, String manualmsgContent) {
        if (MapUtil.isNotEmpty(paramMap)) {
            for (String key : paramMap.keySet()) {
                amap.put(key, paramMap.get(key));
            }
        }
        if (MapUtil.isNotEmpty(mapAuser)) {
            for (String key : mapAuser.keySet()) {
                amap.put(key, mapAuser.get(key));
            }
        }
        return this.getContent(amap, manualmsgContent);
    }

    @Override
    public void autoSendMsg() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.logger.error("mns.MNS.MnslistServiceImpl.loadDb", (Object)"\u5b9a\u65f6\u6267\u884c");
            map.put("dataState", MnsConstants.DATA_STATE_WAITSEND);
            map.put("mnslistPush", 0);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<MnsMnslist> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getSendService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getSendService().getPage());
                result = this.queryMnslistPage(map);
                this.logger.error("mns.MNS.MnslistServiceImpl.loadDb", (Object)("result" + result));
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    ArrayList<MnsMnslist> rows = new ArrayList<MnsMnslist>();
                    for (MnsMnslist row : result.getRows()) {
                        if (!MnslistServiceImpl.getRemainingTime(row.getGmtCreate()).booleanValue()) continue;
                        rows.add(row);
                    }
                    if (ListUtil.isEmpty(rows)) {
                        rows = null;
                        continue;
                    }
                    this.getSendService().addPutPool(new SendPutThread(this.getSendService(), rows));
                    if (result.getRows().size() == this.getSendService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getSendService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    public static Boolean getRemainingTime(Date createTime) {
        long currentTimeMillis = System.currentTimeMillis();
        long createTimeMillis = createTime.getTime();
        long remainingMillis = TWENTY_FOUR_HOURS_IN_MILLIS - (currentTimeMillis - createTimeMillis);
        if (remainingMillis <= 0L) {
            return false;
        }
        return true;
    }

    @Override
    public void autoSendMsgPage() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.logger.error("mns.MNS.MnslistServiceImpl.loadDb", (Object)"\u5b9a\u65f6\u6267\u884c");
            map.put("dataState", MnsConstants.DATA_STATE_WAITSEND);
            map.put("mnslistPush", 1);
            map.put("mnslistPushdateQend", this.getSysDate());
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<MnsMnslist> result = this.queryMnslistPage(map);
            if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                this.getSendService().addPutPool(new SendPutThread(this.getSendService(), result.getRows()));
            }
        }
        catch (Exception e) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    public List<MnsMnsconfig> getMnsconfig(String busType, String tenantCode, boolean exeFlag) {
        if (StringUtils.isBlank((String)busType)) {
            this.logger.error("mns.MNS.MnslistServiceImpl.getMnsconfig", (Object)"busType is null");
            return null;
        }
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        map.put("mnsconfigBustype", busType);
        map.put("dataState", "1");
        map.put("tenantCode", tenantCode);
        this.logger.error("mns.MNS.MnslistServiceImpl.getMnsconfig", map);
        QueryResult<MnsMnsconfig> mnsconfigResult = this.mnsconfigService.queryMnsconfigPage(map);
        List mnsMnsconfigList = null;
        if (null != mnsconfigResult) {
            mnsMnsconfigList = mnsconfigResult.getList();
            if (CollectionUtils.isEmpty((Collection)mnsMnsconfigList) && exeFlag) {
                exeFlag = false;
                if (!"00000000".equals(tenantCode)) {
                    return this.getMnsconfig(busType, "00000000", exeFlag);
                }
                return null;
            }
            for (MnsMnsconfig mnsMnsconfig : mnsMnsconfigList) {
                MnsMnstemplate mnstemplate = this.mnstemplateService.getMnstemplate(mnsMnsconfig.getMnstemplateCode(), tenantCode);
                if (null == mnstemplate) {
                    mnstemplate = this.mnstemplateService.getMnstemplate(mnsMnsconfig.getMnstemplateCode(), "00000000");
                }
                mnsMnsconfig.setMnsMnstemplate(mnstemplate);
            }
            return mnsMnsconfigList;
        }
        if (!"00000000".equals(tenantCode)) {
            return this.getMnsconfig(busType, "00000000", exeFlag);
        }
        return null;
    }

    @Override
    public List<MnsMnsblistDomainBean> saveSend(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        return this.sendMns(mnsMnslistDomainBean);
    }

    @Override
    public String saveSendPlus(String templateParam, String phoneNumbers, String businessType, String app_id, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)templateParam) && StringUtils.isBlank((String)phoneNumbers) && StringUtils.isBlank((String)businessType) && StringUtils.isBlank((String)app_id) && StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("mns.MNS.MnslistServiceImplsaveSendPlus.json", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return "\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a";
        }
        AppProperty inApp = null;
        List appPropertyList = (List)MapUtil.get((Map)LocalCache.getAppManagerMap(), (Object)app_id);
        if (CollectionUtils.isEmpty((Collection)appPropertyList)) {
            this.logger.error("mns.MNS.MnslistServiceImplsaveSendPlus.appPropertyList", (Object)("app_id:" + app_id + "----" + LocalCache.getAppManagerMap().toString()));
            return "-APP not exist!";
        }
        inApp = (AppProperty)appPropertyList.get(0);
        String dataTenant = DisUtil.getMap((String)"tmtenant-mem-code", (String)inApp.getMemberCode());
        if (dataTenant == null) {
            this.logger.error("mns.MNS.MnslistServiceImplsaveSendPlus.dataTenant", (Object)("memberCode:" + inApp.getMemberCode()));
            return "dataTenant not exist!";
        }
        Map param = null;
        try {
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(templateParam, String.class, Object.class);
            String paramMap = (String)map.get("TemplateParam");
            param = (Map)JsonUtil.buildNormalBinder().getJsonToMap(paramMap, String.class, Object.class);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImplsaveSendPlus.map", (Object)("templateParam:" + templateParam));
            return "\u6570\u636e\u9519\u8bef";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnschannelType(0);
        mnsMnslistDomainBean.setMnslistBustype(businessType);
        mnsMnslistDomainBean.setMemberCode(inApp.getMemberCode());
        mnsMnslistDomainBean.setMemberName(inApp.getMemberName());
        mnsMnslistDomainBean.setDataTenant(dataTenant);
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> mape = new HashMap<String, String>();
        mape.put("telphone", phoneNumbers);
        mape.put("name", phoneNumbers);
        receiverList.add(mape);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("phone", phoneNumbers);
        contentMap.putAll(param);
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(contentMap));
        expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        String params = JsonUtil.buildNonDefaultBinder().toJson(expMap);
        mnsMnslistDomainBean.setMnslistExp(params);
        mnsMnslistDomainBean.setTenantCode(tenantCode);
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    @Override
    public void sendMnslist(MnsMnslistDomainBean mnsMnslistDomainBean) {
        if (null == mnsMnslistDomainBean) {
            return;
        }
        this.saveMnslist(mnsMnslistDomainBean);
        this.getSendService().putQueue(mnsMnslistDomainBean);
    }

    private static String getMnslistExp(String host, String random, String businessType, String time, String appName, SubUsersub subUsersub) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)random)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        ArrayList listReceiver = new ArrayList();
        HashMap<String, String> mapReceiver = new HashMap<String, String>();
        mapReceiver.put("code", "memberCode");
        mapReceiver.put("name", "memberName");
        mapReceiver.put("telphone", host);
        mapReceiver.put("email", "651023757@qq.com");
        listReceiver.add(mapReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
        map.put("theme", "\u4e3b\u9898\u63cf\u8ff0");
        map.put("businessType", "1");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("random", random);
        paramMap.put("time", time);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)appName)) {
            paramMap.put("appName", appName);
        }
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }

    private MnsMnsconfig getConfig(MnsMnslistDomainBean mnsMnslistDomainBean) {
        MnsMnsconfig mnsMnsconfig = new MnsMnsconfig();
        mnsMnsconfig.setMnstemplateCode("httpemail");
        mnsMnsconfig.setMnschannelType(0);
        mnsMnsconfig.setTenantCode(mnsMnslistDomainBean.getTenantCode());
        mnsMnsconfig.setDataTenant(mnsMnslistDomainBean.getDataTenant());
        mnsMnsconfig.setMnsconfigCode("100000001");
        mnsMnsconfig.setMnschannelCode("0007");
        mnsMnsconfig.setMemberName("memberName");
        return mnsMnsconfig;
    }

    private MnsMnstemplate getMnsMnstemplate() {
        MnsMnstemplate mnsMnstemplate = new MnsMnstemplate();
        mnsMnstemplate.setMnstemplateCode("httpemail");
        mnsMnstemplate.setDataTenant("2020062200000054");
        mnsMnstemplate.setTenantCode("2020062200000054");
        mnsMnstemplate.setMnstemplateContent("pppppppppppp");
        mnsMnstemplate.setMemberName("memberName");
        return mnsMnstemplate;
    }

    private List<MnsMnsblistDomainBean> sendMns(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        String mnstemplateDes;
        if (null == mnsMnslistDomainBean) {
            return null;
        }
        String busType = mnsMnslistDomainBean.getMnslistBustype();
        if (null == busType) {
            this.logger.error("mns.MNS.MnslistServiceImpl.sendMns", (Object)"busType is null");
            return null;
        }
        MnsMnsconfig mnsMnsconfig = null;
        if (StringUtils.isNotBlank((String)mnsMnslistDomainBean.getAppmanageIcode())) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnslistDomainBean.getAppmanageIcode() + "-" + mnsMnslistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnslistDomainBean.getDataTenant() + "-" + mnsMnslistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnslistDomainBean.getDataTenant() + "-" + "00000000"), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-all-" + mnsMnslistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + mnsMnslistDomainBean.getTenantCode()), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            mnsMnsconfig = (MnsMnsconfig)DisUtil.getMapJson((String)"Mnsconfig-mnsconfigBustype", (String)(busType + "-" + "00000000"), MnsMnsconfig.class);
        }
        if (null == mnsMnsconfig) {
            this.logger.error("mns.MNS.MnslistServiceImpl.sendMns", (Object)("\u672a\u627e\u5230\u914d\u7f6e\u4fe1\u606fmnsMnsconfig" + busType + "-" + mnsMnslistDomainBean.getTenantCode()));
            return null;
        }
        if ("1001".equals(busType) && StringUtils.isNotBlank((String)(mnstemplateDes = mnsMnsconfig.getMnstemplateDes())) && mnstemplateDes.endsWith("-")) {
            mnstemplateDes = mnstemplateDes + new SimpleDateFormat("ddMMyyyy").format(new Date());
            mnsMnsconfig.setMnstemplateDes(mnstemplateDes);
        }
        MnsMnstemplate mnsMnstemplate = null;
        if (!"smail".equals(busType)) {
            if (StringUtils.isBlank((String)mnsMnsconfig.getDataTenant())) {
                mnsMnsconfig.setDataTenant("");
            }
            if (null == (mnsMnstemplate = (MnsMnstemplate)DisUtil.getMapJson((String)"Mnstemplate-mnstemplateCode", (String)(mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getTenantCode()), MnsMnstemplate.class))) {
                mnsMnstemplate = (MnsMnstemplate)DisUtil.getMapJson((String)"Mnstemplate-mnstemplateCode", (String)(mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getDataTenant()), MnsMnstemplate.class);
            }
            if (null == mnsMnstemplate) {
                this.logger.error("mns.MNS.MnslistServiceImpl.sendMns", (Object)("\u672a\u627e\u5230\u6a21\u677f\u4fe1\u606fmnsMnstemplate:" + mnsMnsconfig.getMnstemplateCode() + "-" + mnsMnsconfig.getDataTenant() + "-" + mnsMnsconfig.getTenantCode()));
                return null;
            }
        }
        mnsMnsconfig.setMnsMnstemplate(mnsMnstemplate);
        MnsMnsfee mnsMnsfeeChannel = (MnsMnsfee)DisUtil.getMapJson((String)"Mnsfee-mnschannelCode", (String)(mnsMnsconfig.getMnschannelCode() + "-0-" + mnsMnsconfig.getTenantCode()), MnsMnsfee.class);
        if (null == mnsMnsfeeChannel) {
            mnsMnsfeeChannel = (MnsMnsfee)DisUtil.getMapJson((String)"Mnsfee-mnschannelCode", (String)("all-0-" + mnsMnsconfig.getTenantCode()), MnsMnsfee.class);
        }
        if (null != mnsMnsfeeChannel) {
            MnsMnsmemfee mnsmnsmemfee = this.mnsMnsmemlistService.getMnsmnsmemfeeByDatetenant(mnsMnsconfig.getMemberCode(), mnsMnslistDomainBean.getDataTenant(), mnsMnsconfig.getTenantCode());
            if (null == mnsmnsmemfee) {
                mnsmnsmemfee = this.mnsMnsmemlistService.getMnsmnsmemfeeByMemberCode(mnsMnslistDomainBean.getDataTenant(), mnsMnsconfig.getTenantCode());
            }
            if (null != mnsmnsmemfee && mnsmnsmemfee.getMnsmemfeeSnum().compareTo(new BigDecimal(0)) != 1) {
                this.updateMnslistState(mnsMnslistDomainBean.getMnslistId(), 2, 0);
                throw new ApiException("\u77ed\u4fe1\u4f59\u989d\u4e0d\u8db3");
            }
        }
        Map paramMap = null;
        if (StringUtils.isNotBlank((String)mnsMnslistDomainBean.getMnslistExp())) {
            paramMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(mnsMnslistDomainBean.getMnslistExp(), String.class, String.class);
        }
        if (MapUtil.isEmpty(paramMap)) {
            this.logger.error("mns.MNS.MnslistServiceImplsendMns.paramMap");
            return null;
        }
        String concatCode = this.createUUIDString();
        mnsMnslistDomainBean.setDataTenantname(concatCode);
        List<MnsMnsblistDomainBean> relist = null;
        try {
            relist = this.sendMns(mnsMnslistDomainBean, paramMap, mnsMnsconfig);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.sendMns.e", (Object)(mnsMnslistDomainBean.getMnslistCode() + "=" + mnsMnslistDomainBean.getTenantCode()), (Throwable)e);
        }
        return relist;
    }

    private List<MnsMnsblistDomainBean> sendMns(MnsMnslistDomainBean mnsMnslistDomainBean, Map<String, String> paramMap, MnsMnsconfig mnsconfig) {
        if (null == mnsMnslistDomainBean || null == paramMap || null == mnsconfig) {
            return null;
        }
        paramMap.put("mnslistSubject", null == mnsMnslistDomainBean.getMnslistSubject() ? mnsconfig.getMnstemplateDes() : mnsMnslistDomainBean.getMnslistSubject());
        paramMap.put("mnslistContent", mnsconfig.getMnstemplateContent());
        ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
        sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        Integer mnschannelType = mnsconfig.getMnschannelType();
        if (null == mnschannelType) {
            this.logger.error("mns.MNS.MnslistServiceImplsendMns.mnschannelType");
            return null;
        }
        List<Map<String, String>> mnsList = this.getManualmsgList(mnsMnslistDomainBean, mnsconfig);
        if (CollectionUtils.isEmpty(mnsList)) {
            this.logger.error("mns.MNS.MnslistServiceImplsendMns.mnsList");
            return null;
        }
        this.logger.info("mns.MNS.MnslistServiceImplsendMns.mnschannelType", (Object)("======>" + mnschannelType));
        List<MnsMnsblistDomainBean> relist = null;
        if (MnsConstants.MNSLIST_TYPE_INNERMES.equals(mnschannelType)) {
            for (Map<String, String> imsgMap : mnsList) {
                sendMap.put("imsgPushmsgDomain", JsonUtil.buildNormalBinder().toJson(imsgMap));
                this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
                this.cackmail(mnsMnslistDomainBean);
                this.logger.error("mns.MNS.MnslistServiceImplsendMns.mnsList5" + mnsMnslistDomainBean);
                relist = this.saveBatchMnslist(mnsMnslistDomainBean, mnsconfig, "1", imsgMap);
            }
        } else if (MnsConstants.MNSLIST_TYPE_APP.equals(mnschannelType)) {
            for (Map<String, String> pushmsgMap : mnsList) {
                sendMap.put("imsgPushmsgDomain", JsonUtil.buildNormalBinder().toJson(pushmsgMap));
                this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
                relist = this.saveBatchMnslist(mnsMnslistDomainBean, mnsconfig, "1", pushmsgMap);
            }
        } else if (MnsConstants.MNSLIST_TYPE_SHORTMES.equals(mnschannelType)) {
            relist = this.mnsSendPhoneService.saveSendMsg(mnsList, mnsconfig);
            if (ListUtil.isEmpty(relist)) {
                MnsMnsblistReDomainBean mnsMnsblistDomainBean = new MnsMnsblistReDomainBean();
                try {
                    BeanUtils.copyAllPropertys((Object)mnsMnsblistDomainBean, (Object)mnsMnslistDomainBean);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mnsblistService.saveMnsblist(mnsMnsblistDomainBean);
            }
        } else if (MnsConstants.MNSLIST_TYPE_EMAIL.equals(mnschannelType)) {
            this.sendEmailBatch(mnsList, mnsconfig);
        }
        return relist;
    }

    private void sendShortMesBatch(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        for (Map<String, String> map : mnsList) {
            Map mapExp;
            ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
            String apikey = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(mnsconfig.getTenantCode() + "-mns-" + "phoneApiKey"));
            if (StringUtils.isEmpty((String)apikey)) continue;
            sendMap.put("apikey", apikey);
            String context = map.get("mnslistContent");
            if (StringUtils.isEmpty((String)context)) continue;
            sendMap.put("text", context);
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null || (mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class)) == null) continue;
            List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
            for (Map receiverMap : receiverList) {
                String telphone = (String)receiverMap.get("telphone");
                if (StringUtils.isEmpty((String)telphone)) continue;
                sendMap.put("mobile", telphone);
                this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
            }
        }
    }

    private void sendEmailBatch(List<Map<String, String>> mnsList, MnsMnsconfig mnsconfig) {
        if (CollectionUtils.isEmpty(mnsList) || null == mnsconfig) {
            return;
        }
        for (Map<String, String> map : mnsList) {
            ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
            ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
            String mnslistSubject = map.get("mnslistSubject");
            if (StringUtils.isEmpty((String)mnslistSubject)) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.mnslistSubject");
                continue;
            }
            paramMap.put("mnslistSubject", mnslistSubject);
            String mnslistContent = map.get("mnslistContent");
            if (StringUtils.isEmpty((String)mnslistContent)) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.mnslistContent");
                continue;
            }
            paramMap.put("mnslistContent", mnslistContent);
            String mnslistExp = map.get("mnslistExp");
            if (mnslistExp == null) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.mnslistExp");
                continue;
            }
            Map mapExp = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(mnslistExp, String.class, String.class);
            if (mapExp == null) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.mapExp");
                continue;
            }
            List receiverList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList((String)mapExp.get("receiverList"), Map.class);
            Map random = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap((String)mapExp.get("paramMap"), String.class, String.class);
            String random1 = (String)random.get("random");
            paramMap.put("mnslistContent", random1);
            ArrayList<String> listMns = new ArrayList<String>();
            for (Map receiverMap : receiverList) {
                String email = (String)receiverMap.get("email");
                if (StringUtils.isEmpty((String)email)) {
                    this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.email");
                    continue;
                }
                listMns.add(email);
            }
            if (CollectionUtils.isEmpty(listMns)) {
                this.logger.error("mns.MNS.MnslistServiceImplsendEmailBatch.listMns");
                continue;
            }
            paramMap.put("mnstemplateCode", mnsconfig.getMnstemplateCode());
            paramMap.put("tenantCode", mnsconfig.getTenantCode());
            paramMap.put("to", JsonUtil.buildNormalBinder().toJson(listMns));
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            this.getInternalRouter().inInvoke(mnsconfig.getAppapiCode(), mnsconfig.getAppapiVersion(), "0", sendMap);
        }
    }

    public void cackmail(MnsMnslistDomainBean mnsMnslistDomainBean) {
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(mnsMnslistDomainBean.getMnslistExp(), String.class, Object.class);
        String param = (String)map.get("paramMap");
        Map maps = (Map)JsonUtil.buildNormalBinder().getJsonToMap(param, String.class, Object.class);
        mnsMnslistDomainBean.setMnslistSubject((String)maps.get("title"));
        mnsMnslistDomainBean.setMnslistContent((String)maps.get("content"));
        this.logger.error("mns.MNS.MnslistServiceImplcackmail.mnsMnslistDomainBean", (Object)JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
    }

    public List<MnsMnsblistDomainBean> saveBatchMnslist(MnsMnslistDomainBean mnsMnslistDomainBean, MnsMnsconfig mnsconfig, String flag, Map<String, String> pushmsgMap) {
        if (null == mnsMnslistDomainBean || null == mnsconfig) {
            return null;
        }
        MnsMnslistDomainBean mnsMnslist = new MnsMnslistDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)mnsMnslist, (Object)mnsMnslistDomainBean);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<MnsMnsblistDomainBean> relist = new ArrayList<MnsMnsblistDomainBean>();
        mnsMnslist.setMnschannelType(mnsconfig.getMnschannelType());
        mnsMnslist.setMnslistSubject(mnsMnslistDomainBean.getMnslistSubject());
        mnsMnslist.setMnslistContent(mnsMnslistDomainBean.getMnslistContent());
        mnsMnslist.setMnslistSource(mnsMnslistDomainBean.getMnslistSource());
        mnsMnslist.setMnslistBustype(mnsMnslistDomainBean.getMnslistBustype());
        mnsMnslist.setMnslistBusname(mnsMnslistDomainBean.getMnslistBusname());
        mnsMnslist.setMnslistActiveid(mnsMnslistDomainBean.getMnslistActiveid());
        mnsMnslist.setMnslistExp(mnsMnslistDomainBean.getMnslistExp());
        mnsMnslist.setMnschannelCode(mnsconfig.getMnschannelCode());
        mnsMnslist.setMnschannelName(mnsconfig.getMnschannelName());
        if (StringUtils.isNotBlank((String)flag) && "1".equals(flag)) {
            MnsMnsblistDomainBean mnsMnsblistDomainBean = this.makeMnsMnsblistDomainBean(mnsMnslist);
            mnsMnsblistDomainBean.setMemo(String.valueOf(mnsMnslistDomainBean.getAppFlag()));
            mnsMnsblistDomainBean.setDataTenantname(String.valueOf(mnsMnslistDomainBean.getDataTenantname()));
            mnsMnsblistDomainBean.setMemberName(String.valueOf(mnsMnslistDomainBean.getPicUrl()));
            this.mnsblistService.saveMnsblist(mnsMnsblistDomainBean);
            relist.add(mnsMnsblistDomainBean);
        }
        return relist;
    }

    @Override
    public void saveMnslistByCode(String mnschannelCode, String mnstemplateCode, Map<String, Object> map, boolean sendflag) throws ApiException {
        MnsMnslistDomainBean mnslistDomainBean = new MnsMnslistDomainBean();
        mnslistDomainBean.setMnslistExp(JsonUtil.buildNormalBinder().toJson(map));
        mnslistDomainBean.setMnslistSubject(map.get("mnslistSubject").toString());
        mnslistDomainBean.setMnslistBustype(map.get("mnslistBusType").toString());
        Map mnschannel = this.getQueryParamMap("mnschannelCode", new Object[]{mnschannelCode});
        QueryResult<MnsMnschannel> qr = this.mnschannelService.queryMnschannelPage(mnschannel);
        if (ListUtil.isEmpty((Collection)qr.getList())) {
            throw new ApiException("mns.MNS.MnslistServiceImpl.saveMnslistByCode.mnsMnschannel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        MnsMnschannel mnsMnschannel = (MnsMnschannel)qr.getList().get(0);
        if (map.get("tenantCode") != null) {
            mnsMnschannel.setTenantCode((String)map.get("tenantCode"));
        }
        try {
            BeanUtils.copyAllPropertys((Object)mnslistDomainBean, (Object)mnsMnschannel);
        }
        catch (Exception e) {
            this.logger.error("mns.MNS.MnslistServiceImpl.saveMnslistByCode.mnsMnschannel.null", (Object)"\u6570\u636e\u8f6c\u6362\u4e3aDomian\u9519\u8bef");
        }
        this.saveMnslistByNotContent(mnslistDomainBean, map, mnstemplateCode, sendflag);
    }

    @Override
    public List<Map<String, Object>> queryNumByTenantCode(Map<String, Object> map) {
        return this.queryNumByTenantCodeModel(map);
    }

    private List<Map<String, Object>> queryNumByTenantCodeModel(Map<String, Object> map) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SendService getSendService() {
        Object object = lock;
        synchronized (object) {
            if (null == sendService) {
                sendService = new SendService((MnsService)SpringApplicationContextUtil.getBean((String)"mnsService"));
                for (int i = 0; i < 20; ++i) {
                    sendService.addPollPool(new SendPollThread(sendService));
                }
            }
            return sendService;
        }
    }

    @Override
    public String sendPteToMnslist(PteBalancelist pteBalancelist) {
        this.logger.error("mns.MNS.MnslistServiceImpl.savesendTransferList", (Object)JsonUtil.buildNormalBinder().toJson((Object)pteBalancelist));
        if (null == pteBalancelist) {
            return "error";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnschannelType(4);
        mnsMnslistDomainBean.setMnslistBustype("pte" + pteBalancelist.getDataState());
        mnsMnslistDomainBean.setMnslistContent("\u7ed3\u7b97\u901a\u77e5");
        mnsMnslistDomainBean.setMnslistSubject("\u7ed3\u7b97\u901a\u77e5");
        mnsMnslistDomainBean.setTenantCode(pteBalancelist.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("code", pteBalancelist.getMemberCode());
        listReceiver.put("name", pteBalancelist.getMemberName());
        listReceiver.put("pteBalancelist", JsonUtil.buildNormalBinder().toJson((Object)pteBalancelist));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    @Override
    public String sendUmToMnslist(UmUserinfo umUserinfo, UmUserDomain umUser, String optype) {
        this.logger.error("mns.MNS.MnslistServiceImpl.sendUmToMnslist", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserinfo));
        if (null == umUserinfo) {
            return "error";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnschannelType(4);
        mnsMnslistDomainBean.setMnslistBustype("um" + umUserinfo.getDataState());
        mnsMnslistDomainBean.setMnslistContent("\u7528\u6237\u8ba2\u9605\u6d88\u606f\u901a\u77e5");
        mnsMnslistDomainBean.setMnslistSubject("\u7528\u6237\u8ba2\u9605\u6d88\u606f\u901a\u77e5");
        mnsMnslistDomainBean.setTenantCode(umUserinfo.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("code", umUserinfo.getUserinfoCacode());
        listReceiver.put("name", umUserinfo.getUserinfoCompname());
        listReceiver.put("umUserinfo", JsonUtil.buildNormalBinder().toJson((Object)umUserinfo));
        listReceiver.put("umUser", JsonUtil.buildNormalBinder().toJson((Object)umUser));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    @Override
    public String sendDiscountVolumeNotice(UmUserinfo umUserinfo) throws ApiException {
        this.logger.error("mns.MNS.MnslistServiceImpl.sendDiscountVolumeNotice", (Object)"============================================\u4f18\u60e0\u5377\u8fc7\u671f\u7ad9\u5185\u4fe1============================================");
        if (umUserinfo == null) {
            this.logger.error("mns.MNS.MnslistServiceImpl.sendDiscountVolumeNotice", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01umUserinfo\uff1a" + umUserinfo));
            return null;
        }
        List mnsMnstemplates = null;
        try {
            HashMap<String, String> queryMnstemplateMap = new HashMap<String, String>();
            queryMnstemplateMap.put("mnstemplateCode", "yhj00001");
            HashMap<String, String> mnsMap = new HashMap<String, String>();
            mnsMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryMnstemplateMap));
            String str = (String)this.getInternalRouter().inInvoke("mns.mns.queryMnstemplateList", mnsMap);
            this.logger.error("mns.MNS.MnslistServiceImpl.sendDiscountVolumeNotice", (Object)("============================================str->" + str + "============================================"));
            mnsMnstemplates = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(str, MnsMnstemplate.class);
        }
        catch (ApiException e) {
            throw new ApiException("MnslistServiceImpl.sendDiscountVolumeNotice", "\u83b7\u53d6\u7ad9\u5185\u4fe1\u53d1\u9001\u6a21\u677f\u5931\u8d25\uff01", (Throwable)e);
        }
        if (mnsMnstemplates != null && mnsMnstemplates.get(0) != null && !mnsMnstemplates.isEmpty()) {
            MnsMnslistDomainBean mnslistDomainBean = new MnsMnslistDomainBean();
            mnslistDomainBean.setMnslistSource(0);
            mnslistDomainBean.setMnschannelType(3);
            mnslistDomainBean.setMnslistBustype("smail");
            mnslistDomainBean.setMnslistBusname("\u4f18\u60e0\u5377\u8fc7\u671f\u7ad9\u5185\u4fe1");
            mnslistDomainBean.setMemberCode(umUserinfo.getUserinfoCode());
            mnslistDomainBean.setTenantCode(umUserinfo.getTenantCode());
            mnslistDomainBean.setMnslistPush(0);
            mnslistDomainBean.setMnslistContent(((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateContent());
            mnslistDomainBean.setMnslistSubject(((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateName());
            HashMap<String, Object> peopleMap = new HashMap<String, Object>();
            peopleMap.put("name", umUserinfo.getUserinfoCompname());
            peopleMap.put("code", umUserinfo.getUserinfoCode());
            peopleMap.put("keys", true);
            List<Map> receiverList = Arrays.asList(peopleMap);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("title", ((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateName());
            paramMap.put("content", ((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateContent());
            paramMap.put("mnstemplateCode", ((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateCode());
            paramMap.put("url1", null);
            paramMap.put("url", null);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("receiverList", JsonUtil.buildNonEmptyBinder().toJson(receiverList));
            map.put("paramMap", JsonUtil.buildNonEmptyBinder().toJson(paramMap));
            String s = JsonUtil.buildNonEmptyBinder().toJson(map);
            this.logger.error("mns.MNS.MnslistServiceImpl.sendDiscountVolumeNotice", (Object)("============================================MnslistExp->" + s + "============================================"));
            mnslistDomainBean.setMnslistExp(s);
            this.logger.error("mns.MNS.MnslistServiceImpl.sendDiscountVolumeNotice", (Object)"============================================\u53d1\u9001\u7ad9\u5185\u4fe1============================================");
            this.saveSendMnslist(mnslistDomainBean);
            return "success";
        }
        this.logger.error("mns.MNS.MnslistServiceImpl.sendDiscountVolumeNotice", (Object)"\u6ca1\u6709\u627e\u5230\u7ad9\u5185\u4fe1\u6a21\u677f\uff01");
        return "error";
    }

    @Override
    public String sendUserLevelChangeNotice(UmUserinfo umUserinfo, String levelName) throws ApiException {
        this.logger.error("mns.MNS.MnslistServiceImpl.sendUserLevelChangeNotice", (Object)"============================================\u7528\u6237\u7b49\u7ea7\u53d8\u66f4\u901a\u77e5\u7ad9\u5185\u4fe1============================================");
        if (umUserinfo == null) {
            this.logger.error("mns.MNS.MnslistServiceImpl.sendUserLevelChangeNotice", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01umUserinfo\uff1a" + umUserinfo));
            return null;
        }
        List mnsMnstemplates = null;
        try {
            HashMap<String, String> queryMnstemplateMap = new HashMap<String, String>();
            queryMnstemplateMap.put("mnstemplateCode", "mddj00001");
            HashMap<String, String> mnsMap = new HashMap<String, String>();
            mnsMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryMnstemplateMap));
            String str = (String)this.getInternalRouter().inInvoke("mns.mns.queryMnstemplateList", mnsMap);
            if (StringUtils.isBlank((String)str)) {
                this.logger.error("mns.MNS.MnslistServiceImpl.sendUserLevelChangeNotice", (Object)("str!!!!!" + ((Object)mnsMap).toString()));
                return null;
            }
            mnsMnstemplates = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(str, MnsMnstemplate.class);
            if (ListUtil.isEmpty((Collection)mnsMnstemplates)) {
                this.logger.error("mns.MNS.MnslistServiceImpl.sendUserLevelChangeNotice", (Object)("mnsMnstemplates!!!!!" + ((Object)mnsMap).toString()));
                return null;
            }
        }
        catch (ApiException e) {
            throw new ApiException("MnslistServiceImpl.sendUserLevelChangeNotice", "\u83b7\u53d6\u7ad9\u5185\u4fe1\u53d1\u9001\u6a21\u677f\u5931\u8d25\uff01", (Throwable)e);
        }
        if (mnsMnstemplates != null && mnsMnstemplates.get(0) != null && !mnsMnstemplates.isEmpty()) {
            MnsMnslistDomainBean mnslistDomainBean = new MnsMnslistDomainBean();
            mnslistDomainBean.setMnslistSource(0);
            mnslistDomainBean.setMnschannelType(3);
            mnslistDomainBean.setMnslistBustype("smail");
            mnslistDomainBean.setMnslistBusname("\u7528\u6237\u7b49\u7ea7\u53d8\u66f4\u901a\u77e5\u7ad9\u5185\u4fe1");
            mnslistDomainBean.setMemberCode(umUserinfo.getUserinfoCode());
            mnslistDomainBean.setTenantCode(umUserinfo.getTenantCode());
            mnslistDomainBean.setMnslistPush(0);
            mnslistDomainBean.setMnslistContent(((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateContent());
            mnslistDomainBean.setMnslistSubject(((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateName());
            HashMap<String, Object> peopleMap = new HashMap<String, Object>();
            peopleMap.put("name", umUserinfo.getUserinfoCompname());
            peopleMap.put("code", umUserinfo.getUserinfoCode());
            peopleMap.put("keys", true);
            List<Map> receiverList = Arrays.asList(peopleMap);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("title", ((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateName());
            paramMap.put("content", ((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateContent().replace("${levelName}", levelName));
            paramMap.put("mnstemplateCode", ((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateCode());
            paramMap.put("url1", null);
            paramMap.put("url", null);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("receiverList", JsonUtil.buildNonEmptyBinder().toJson(receiverList));
            map.put("paramMap", JsonUtil.buildNonEmptyBinder().toJson(paramMap));
            String s = JsonUtil.buildNonEmptyBinder().toJson(map);
            this.logger.error("mns.MNS.MnslistServiceImpl.sendUserLevelChangeNotice", (Object)("============================================MnslistExp->" + s + "============================================"));
            mnslistDomainBean.setMnslistExp(s);
            this.logger.error("mns.MNS.MnslistServiceImpl.sendUserLevelChangeNotice", (Object)"============================================\u53d1\u9001\u7ad9\u5185\u4fe1============================================");
            this.saveSendMnslist(mnslistDomainBean);
            return "success";
        }
        this.logger.error("mns.MNS.MnslistServiceImpl.sendUserLevelChangeNotice", (Object)"\u6ca1\u6709\u627e\u5230\u7ad9\u5185\u4fe1\u6a21\u677f\uff01");
        return "error";
    }

    @Override
    public String sendUserChangePointsNotice(UpmUpointsList upmUpointsList) throws ApiException {
        this.logger.error("mns.MNS.MnslistServiceImpl.sendUserChangePointsNotice", (Object)"============================================\u7528\u6237\u79ef\u5206\u53d8\u66f4\u901a\u77e5\u7ad9\u5185\u4fe1============================================");
        if (upmUpointsList == null) {
            this.logger.error("mns.MNS.MnslistServiceImpl.sendUserChangePointsNotice", (Object)("\u5165\u53c2\u4e3a\u7a7a\uff01upmUpointsList\uff1a" + upmUpointsList));
            return null;
        }
        List mnsMnstemplates = null;
        try {
            HashMap<String, String> queryMnstemplateMap = new HashMap<String, String>();
            if ("4".equals(upmUpointsList.getUpointsListDirection())) {
                queryMnstemplateMap.put("mnstemplateCode", "jfye00001");
            } else if ("3".equals(upmUpointsList.getUpointsListDirection())) {
                queryMnstemplateMap.put("mnstemplateCode", "jfye00002");
            } else {
                this.logger.error("mns.MNS.MnslistServiceImpl.sendUserChangePointsNotice", (Object)("============================================\u5f53\u524d\u79ef\u5206\u65b9\u5411\u4e3a" + upmUpointsList.getUpointsListDirection() + "============================================"));
                return null;
            }
            HashMap<String, String> mnsMap = new HashMap<String, String>();
            mnsMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryMnstemplateMap));
            String str = (String)this.getInternalRouter().inInvoke("mns.mns.queryMnstemplateList", mnsMap);
            this.logger.error("mns.MNS.MnslistServiceImpl.sendUserChangePointsNotice", (Object)("============================================str->" + str + "============================================"));
            mnsMnstemplates = (List)JsonUtil.buildNonEmptyBinder().getJsonToList(str, MnsMnstemplate.class);
        }
        catch (ApiException e) {
            throw new ApiException("MnslistServiceImpl.sendUserChangePointsNotice", "\u83b7\u53d6\u7ad9\u5185\u4fe1\u53d1\u9001\u6a21\u677f\u5931\u8d25\uff01", (Throwable)e);
        }
        if (mnsMnstemplates != null && mnsMnstemplates.get(0) != null && !mnsMnstemplates.isEmpty()) {
            MnsMnslistDomainBean mnslistDomainBean = new MnsMnslistDomainBean();
            mnslistDomainBean.setMnslistSource(0);
            mnslistDomainBean.setMnschannelType(3);
            mnslistDomainBean.setMnslistBustype("smail");
            mnslistDomainBean.setMnslistBusname("\u7528\u6237\u79ef\u5206\u53d8\u66f4\u901a\u77e5\u7ad9\u5185\u4fe1");
            mnslistDomainBean.setMemberCode(upmUpointsList.getMemberCode());
            mnslistDomainBean.setTenantCode(upmUpointsList.getTenantCode());
            mnslistDomainBean.setMnslistPush(0);
            mnslistDomainBean.setMnslistContent(((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateContent());
            mnslistDomainBean.setMnslistSubject(((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateName());
            HashMap<String, Object> peopleMap = new HashMap<String, Object>();
            peopleMap.put("name", upmUpointsList.getMemberName());
            peopleMap.put("code", upmUpointsList.getMemberCode());
            peopleMap.put("keys", true);
            List<Map> receiverList = Arrays.asList(peopleMap);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("title", ((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateName());
            String num = "";
            if (upmUpointsList.getUpointsListNum() != null) {
                num = upmUpointsList.getUpointsListNum().toString();
            }
            paramMap.put("content", ((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateContent().replace("${num}", num));
            paramMap.put("mnstemplateCode", ((MnsMnstemplate)mnsMnstemplates.get(0)).getMnstemplateCode());
            paramMap.put("url1", null);
            paramMap.put("url", null);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("receiverList", JsonUtil.buildNonEmptyBinder().toJson(receiverList));
            map.put("paramMap", JsonUtil.buildNonEmptyBinder().toJson(paramMap));
            String s = JsonUtil.buildNonEmptyBinder().toJson(map);
            this.logger.error("mns.MNS.MnslistServiceImpl.sendUserChangePointsNotice", (Object)("============================================MnslistExp->" + s + "============================================"));
            mnslistDomainBean.setMnslistExp(s);
            this.logger.error("mns.MNS.MnslistServiceImpl.sendUserChangePointsNotice", (Object)"============================================\u53d1\u9001\u7ad9\u5185\u4fe1============================================");
            this.saveSendMnslist(mnslistDomainBean);
            return "success";
        }
        this.logger.error("mns.MNS.MnslistServiceImpl.sendUserChangePointsNotice", (Object)"\u6ca1\u6709\u627e\u5230\u7ad9\u5185\u4fe1\u6a21\u677f\uff01");
        return "error";
    }

    @Override
    public String sendMnsMnslistDomainBeanNotice(MnsMnslistDomainBean mnsMnslistDomainBean) throws ApiException {
        this.logger.error("mns.MNS.MnslistServiceImpl.sendTestForJsonNotice", (Object)"============================================\u53d1\u9001\u63a8\u9001\u6d88\u606f============================================");
        if (mnsMnslistDomainBean == null) {
            return "mnsMnslistDomainBean\u5165\u53c2\u4e3a\u7a7a\uff01";
        }
        this.logger.error("mns.MNS.MnslistServiceImpl.sendTestForJsonNotice", (Object)("============================================mnsMnslistDomainBean->" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslistDomainBean) + "============================================"));
        this.sendMnslist(mnsMnslistDomainBean);
        return "success";
    }

    static {
        lock = new Object();
        TWENTY_FOUR_HOURS_IN_MILLIS = 86400000L;
    }
}

