/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.service;

import com.yqbsoft.laser.service.monitor.domain.AmmMEvtInfoDomain;
import com.yqbsoft.laser.service.monitor.engine.RuleContext;
import com.yqbsoft.laser.service.monitor.engine.RuleEngine;
import com.yqbsoft.laser.service.monitor.service.AnalyseService;
import com.yqbsoft.laser.service.monitor.support.ApiTree;
import com.yqbsoft.laser.service.monitor.support.Field;
import com.yqbsoft.laser.service.monitor.support.MatchUtil;
import com.yqbsoft.laser.service.monitor.support.Point;
import com.yqbsoft.laser.service.monitor.support.PointCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AnalyseServiceImpl
implements AnalyseService {
    private RuleEngine javaRuleEngine;
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 100, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10000), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public void submit(ApiTree tree, boolean sync) {
        Map<String, Map<String, List<Integer>>> pointMap = PointCache.getApi2PointsMap();
        if (pointMap == null) {
            return;
        }
        AmmMEvtInfoDomain info = tree.getRoot().getOuter();
        Map<String, List<Integer>> points = pointMap.get(info.getApiKey());
        if (points == null) {
            return;
        }
        List<Point> list = MatchUtil.match(points, info);
        if (list.isEmpty()) {
            return;
        }
        HashMap<String, Point> ruleIds = new HashMap<String, Point>();
        for (Point point : list) {
            for (Map.Entry<String, Field> entry : point.getFields().entrySet()) {
                ruleIds.put(entry.getValue().getRuleId(), point);
            }
        }
        RuleContext ctx = new RuleContext();
        ctx.setRuleIds(ruleIds);
        if (sync) {
            this.javaRuleEngine.execute(ctx, tree);
        } else {
            this.executor.execute(new AnalyzeRunner(ctx, tree));
        }
    }

    public RuleEngine getJavaRuleEngine() {
        return this.javaRuleEngine;
    }

    public void setJavaRuleEngine(RuleEngine javaRuleEngine) {
        this.javaRuleEngine = javaRuleEngine;
    }

    class AnalyzeRunner
    implements Runnable {
        private ApiTree tree;
        private RuleContext ctx;

        AnalyzeRunner(RuleContext ctx, ApiTree tree) {
            this.ctx = ctx;
            this.tree = tree;
        }

        @Override
        public void run() {
            AnalyseServiceImpl.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AnalyseServiceImpl.this.javaRuleEngine.execute(AnalyzeRunner.this.ctx, AnalyzeRunner.this.tree);
                }
            });
        }
    }
}

