/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.monitor.dao.AmmMGroupMapper;
import com.yqbsoft.laser.service.monitor.domain.AmmMGroupDomain;
import com.yqbsoft.laser.service.monitor.model.AmmMGroup;
import com.yqbsoft.laser.service.monitor.service.AmmMGroupService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmmMGroupServiceImpl
extends BaseServiceImpl
implements AmmMGroupService {
    public static final String SYS_CODE = "amm.MConstants.AmmMGroupServiceImpl";
    private AmmMGroupMapper ammMGroupMapper;

    public void setAmmMGroupMapper(AmmMGroupMapper ammMGroupMapper) {
        this.ammMGroupMapper = ammMGroupMapper;
    }

    private Date getSysDate() {
        try {
            return this.ammMGroupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMGroupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMGroup(AmmMGroupDomain ammMGroupDomain) {
        if (null == ammMGroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setMGroupDefault(AmmMGroup ammMGroup) {
        if (null == ammMGroup) {
            return;
        }
        if (null == ammMGroup.getDataState()) {
            ammMGroup.setDataState(0);
        }
        if (null == ammMGroup.getGmtCreate()) {
            ammMGroup.setGmtCreate(this.getSysDate());
        }
        ammMGroup.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.ammMGroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMGroupServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMGroupUpdataDefault(AmmMGroup ammMGroup) {
        if (null == ammMGroup) {
            return;
        }
        ammMGroup.setGmtModified(this.getSysDate());
    }

    private void saveMGroupModel(AmmMGroup ammMGroup) throws ApiException {
        if (null == ammMGroup) {
            return;
        }
        try {
            this.ammMGroupMapper.insert(ammMGroup);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMGroupServiceImpl.saveMGroupModel.ex", (Throwable)e);
        }
    }

    private AmmMGroup getMGroupModelById(Integer groupId) {
        if (null == groupId) {
            return null;
        }
        try {
            return this.ammMGroupMapper.selectByPrimaryKey(groupId);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMGroupServiceImpl.getMGroupModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteMGroupModel(Integer groupId) throws ApiException {
        if (null == groupId) {
            return;
        }
        int i = 0;
        try {
            i = this.ammMGroupMapper.deleteByPrimaryKey(groupId);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMGroupServiceImpl.deleteMGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("amm.MConstants.AmmMGroupServiceImpl.deleteMGroupModel.num");
        }
    }

    private void updateMGroupModel(AmmMGroup ammMGroup) throws ApiException {
        if (null == ammMGroup) {
            return;
        }
        try {
            this.ammMGroupMapper.updateByPrimaryKeySelective(ammMGroup);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMGroupServiceImpl.updateMGroupModel.ex", (Throwable)e);
        }
    }

    private void updateStateMGroupModel(Integer groupId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == groupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupId", groupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ammMGroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("amm.MConstants.AmmMGroupServiceImpl.updateStateMGroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("amm.MConstants.AmmMGroupServiceImpl.updateStateMGroupModel.null");
        }
    }

    private AmmMGroup makeMGroup(AmmMGroupDomain ammMGroupDomain, AmmMGroup ammMGroup) {
        if (null == ammMGroupDomain) {
            return null;
        }
        if (null == ammMGroup) {
            ammMGroup = new AmmMGroup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ammMGroup, (Object)ammMGroupDomain);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMGroupServiceImpl.makeMGroup", (Throwable)e);
        }
        return ammMGroup;
    }

    private List<AmmMGroup> queryMGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.ammMGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMGroupServiceImpl.queryMGroupModel", (Throwable)e);
            return null;
        }
    }

    private int countMGroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ammMGroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("amm.MConstants.AmmMGroupServiceImpl.countMGroup", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveMGroup(AmmMGroupDomain ammMGroupDomain) throws ApiException {
        String msg = this.checkMGroup(ammMGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMGroupServiceImpl.saveMGroup.checkMGroup", msg);
        }
        AmmMGroup ammMGroup = this.makeMGroup(ammMGroupDomain, null);
        this.setMGroupDefault(ammMGroup);
        this.saveMGroupModel(ammMGroup);
    }

    @Override
    public void updateMGroupState(Integer groupId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateMGroupModel(groupId, dataState, oldDataState);
    }

    @Override
    public void updateMGroup(AmmMGroupDomain ammMGroupDomain) throws ApiException {
        String msg = this.checkMGroup(ammMGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("amm.MConstants.AmmMGroupServiceImpl.updateMGroup.checkMGroup", msg);
        }
        AmmMGroup oldAmmMGroup = this.getMGroupModelById(ammMGroupDomain.getGroupId());
        if (null == oldAmmMGroup) {
            throw new ApiException("amm.MConstants.AmmMGroupServiceImpl.updateMGroup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmmMGroup ammMGroup = this.makeMGroup(ammMGroupDomain, oldAmmMGroup);
        this.setMGroupUpdataDefault(ammMGroup);
        this.updateMGroupModel(ammMGroup);
    }

    @Override
    public AmmMGroup getMGroup(Integer groupId) {
        return this.getMGroupModelById(groupId);
    }

    @Override
    public void deleteMGroup(Integer groupId) throws ApiException {
        this.deleteMGroupModel(groupId);
    }

    @Override
    public QueryResult<AmmMGroup> queryMGroupPage(Map<String, Object> map) {
        List<AmmMGroup> ammMGroupList = this.queryMGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMGroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ammMGroupList);
        return queryResult;
    }
}

