/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.monitor.support;

import com.yqbsoft.laser.service.monitor.enums.DataType;
import com.yqbsoft.laser.service.monitor.support.Field;
import com.yqbsoft.laser.service.monitor.support.Point;
import com.yqbsoft.laser.service.monitor.support.ValidateResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ValidateUtil {
    public static ValidateResult checkValve(Point point, String json) {
        Field field = null;
        String realValue = null;
        String valveValue = null;
        boolean success = true;
        boolean failOnMax = false;
        boolean failOnMin = false;
        Map<String, Field> fields = point.getFields();
        Map map = (Map)JsonUtil.buildNonNullBinder().getJsonToMap(json, String.class, String.class);
        for (Map.Entry entry : map.entrySet()) {
            Number min;
            Number max;
            Number value;
            field = fields.get(entry.getKey());
            if (field == null) continue;
            valveValue = field.getMaxValve();
            realValue = (String)map.get(field.getFieldName());
            if (DataType.LONG.getType().equals(field.getValveType())) {
                value = new Long((String)map.get(field.getFieldName()));
                if (StringUtils.isNotBlank((CharSequence)field.getMaxValve()) && ((Long)value).compareTo((Long)(max = new Long(field.getMaxValve()))) > 0) {
                    success = false;
                    failOnMax = true;
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)field.getMinValve()) || ((Long)value).compareTo((Long)(min = new Long(field.getMinValve()))) >= 0) continue;
                success = false;
                failOnMin = true;
                break;
            }
            if (!DataType.DOUBLE.getType().equals(field.getValveType()) && !DataType.PERCENT.getType().equals(field.getValveType())) continue;
            value = new Double((String)map.get(field.getFieldName()));
            if (StringUtils.isNotBlank((CharSequence)field.getMaxValve()) && ((Double)value).compareTo((Double)(max = new Double(field.getMaxValve()))) > 0) {
                success = false;
                failOnMax = true;
                break;
            }
            if (!StringUtils.isNotBlank((CharSequence)field.getMinValve()) || ((Double)value).compareTo((Double)(min = new Double(field.getMinValve()))) >= 0) continue;
            success = false;
            failOnMin = true;
            break;
        }
        ValidateResult res = new ValidateResult();
        if (!success) {
            res.setSuccess(false);
            res.setFailField(field);
            res.setFailOnMaxValve(failOnMax);
            res.setFailOnMinValve(failOnMin);
            res.setRealValue(realValue);
            res.setValveValue(valveValue);
        }
        return res;
    }
}

