/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.oauthserver.token.cache;

import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.oauthserver.domain.OsOAuthConfigListReDomain;
import com.yqbsoft.laser.service.oauthserver.domain.ResponseInfo;
import com.yqbsoft.laser.service.oauthserver.domain.UserSessionBean;
import com.yqbsoft.laser.service.oauthserver.model.OsOAuthToken;
import com.yqbsoft.laser.service.oauthserver.service.OsOAuthTokenService;
import com.yqbsoft.laser.service.oauthserver.token.cache.GroupUtil;
import com.yqbsoft.laser.service.oauthserver.token.cache.OAuthTokenCache;
import com.yqbsoft.laser.service.oauthserver.token.issuer.SaasOAuthTokenProducerImpl;
import com.yqbsoft.laser.service.oauthserver.token.validate.SaasOAuthTokenValidator;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OAuthTokenCacheImpl
extends BaseServiceImpl
implements OAuthTokenCache<OsOAuthToken> {
    OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private static OAuthTokenCacheImpl instance = null;
    private static volatile OsOAuthTokenService oauthTokenService;
    private static final String VFOOAUTHTOKEN_PRO = "OsOauthToken-pro";
    private static final String VFOOAUTHTOKENSWITCH_PRO = "OsOauthTokenSwitch-pro";
    private static final String VFOOAUTHTOKENCSS_PRO = "OsOauthTokenCss-pro";
    private static final String VFOOAUTHTOKENMEMBER_PRO = "OsOauthTokenMember-pro";
    private static final String VFOOAUTHTOKENEXTERNALMERCHANT_PRO = "OsOauthTokenExternalMerchant-pro";
    private static final String SWITCH_STATUS_FAILED = "load_failed";
    private static final String SWITCH_STATUS_LOADING = "loading";
    private static final String SWITCH_STATUS_SUCCESS = "load_success";
    private static final String SYS_CODE = "os.oauthserver.OAuthTokenCacheImpl";
    private static InternalRouter internalRouter;
    private static String TokenLogin;

    private OAuthTokenCacheImpl() {
        if (internalRouter == null) {
            internalRouter = (InternalRouter)SpringApplicationContextUtil.getBean((String)"internalRouter");
            this.setInternalRouter(internalRouter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OAuthTokenCacheImpl getInstance() {
        if (instance != null) return instance;
        Class<OAuthTokenCacheImpl> clazz = OAuthTokenCacheImpl.class;
        synchronized (OAuthTokenCacheImpl.class) {
            if (instance != null) return instance;
            instance = new OAuthTokenCacheImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public OsOAuthTokenService getOauthTokenService() {
        return oauthTokenService;
    }

    @Override
    public void initialize() {
        this.clearAll();
        this.setInitFlag(SWITCH_STATUS_LOADING);
        if (oauthTokenService == null) {
            oauthTokenService = (OsOAuthTokenService)ApplicationContextUtil.getService((String)"oauthTokenService");
        }
        if (oauthTokenService == null) {
            this.logger.debug(SYS_CODE, (Object)".initizlize.oauthTokenService.null\u3002afterInit");
            this.setInitFlag(SWITCH_STATUS_FAILED);
            return;
        }
        List<OsOAuthToken> list = null;
        try {
            list = oauthTokenService.queryOAuthTokenList(new HashMap<String, Object>());
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE, (Object)".initialize.list.queryError", (Throwable)e);
            this.setInitFlag(SWITCH_STATUS_FAILED);
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (ListUtil.isEmpty(list)) {
            this.logger.debug(SYS_CODE, (Object)".initizlize.list.null");
            DisUtil.setMap((String)VFOOAUTHTOKEN_PRO, map);
            this.setInitFlag(SWITCH_STATUS_SUCCESS);
            return;
        }
        for (OsOAuthToken v : list) {
            if (v == null) continue;
            String key = v.getTenantCode() + "_" + v.getOauthTokenAppKey() + "_" + v.getOauthTokenUserAccount();
            String json = JsonUtil.buildNormalBinder().toJson((Object)v);
            map.put(key, json);
        }
        DisUtil.setMap((String)VFOOAUTHTOKEN_PRO, map);
        this.setInitFlag(SWITCH_STATUS_SUCCESS);
    }

    private void clearAll() {
        DisUtil.del((String)VFOOAUTHTOKEN_PRO);
        DisUtil.del((String)VFOOAUTHTOKENSWITCH_PRO);
        DisUtil.del((String)VFOOAUTHTOKENCSS_PRO);
        DisUtil.del((String)VFOOAUTHTOKENMEMBER_PRO);
        DisUtil.del((String)VFOOAUTHTOKENEXTERNALMERCHANT_PRO);
    }

    public AppProperty getAppProperty(String key) {
        List l;
        Map m;
        String json = DisUtil.get((String)"EcoreAppmanage-pro");
        if (StringUtils.isNotBlank((String)json) && MapUtil.isNotEmpty((Map)(m = (Map)JsonUtil.buildNormalBinder().getJsonToMapByList(json, String.class, AppProperty.class))) && ListUtil.isNotEmpty((Collection)(l = (List)m.get(key)))) {
            return (AppProperty)l.get(0);
        }
        return null;
    }

    @Override
    public OsOAuthToken getToken(String key) {
        String json = DisUtil.getMap((String)VFOOAUTHTOKEN_PRO, (String)key);
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        OsOAuthToken osOAuthToken = (OsOAuthToken)JsonUtil.buildNormalBinder().getJsonToObject(json, OsOAuthToken.class);
        return osOAuthToken;
    }

    @Override
    public boolean addToken(String key, OsOAuthToken t) {
        if (t == null) {
            return false;
        }
        DisUtil.setMap((String)VFOOAUTHTOKEN_PRO, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)t));
        return true;
    }

    @Override
    public void removeToken(String key) {
        DisUtil.delMap((String)VFOOAUTHTOKEN_PRO, (String[])new String[]{key});
    }

    public Map<String, String> getAllToken() {
        Map map = DisUtil.getMapAll((String)VFOOAUTHTOKEN_PRO);
        return map;
    }

    public String getCss(String key) {
        String json = DisUtil.getMap((String)VFOOAUTHTOKENCSS_PRO, (String)key);
        if (StringUtils.isEmpty((String)json)) {
            return null;
        }
        return json;
    }

    public boolean addCss(String key, String cssUrl) {
        if (StringUtils.isEmpty((String)cssUrl)) {
            this.logger.debug(SYS_CODE, (Object)".addCss.cssurl.null");
            return false;
        }
        DisUtil.setMap((String)VFOOAUTHTOKENCSS_PRO, (String)key, (String)cssUrl);
        return true;
    }

    public void removeCss(String key) {
        DisUtil.delMap((String)VFOOAUTHTOKENCSS_PRO, (String[])new String[]{key});
    }

    public ResponseInfo getMemberInfo(String key) {
        String json = DisUtil.getMap((String)VFOOAUTHTOKENMEMBER_PRO, (String)key);
        if (StringUtils.isEmpty((String)json)) {
            this.logger.debug(SYS_CODE, (Object)".getMemberInfo.json.null");
            return null;
        }
        ResponseInfo responseInfo = (ResponseInfo)JsonUtil.buildNormalBinder().getJsonToObject(json, ResponseInfo.class);
        return responseInfo;
    }

    public boolean addMemberInfo(String key, ResponseInfo t) {
        if (t == null) {
            this.logger.debug(SYS_CODE, (Object)".addMemberInfo.ResponseInfo.null");
            return false;
        }
        DisUtil.setMap((String)VFOOAUTHTOKENMEMBER_PRO, (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)t));
        return true;
    }

    public void removeMemberInfo(String key) {
        DisUtil.delMap((String)VFOOAUTHTOKENMEMBER_PRO, (String[])new String[]{key});
    }

    public String getExternalMerchant(String key) {
        String json = DisUtil.getMap((String)VFOOAUTHTOKENEXTERNALMERCHANT_PRO, (String)key);
        if (StringUtils.isEmpty((String)json)) {
            this.logger.debug(SYS_CODE, (Object)".getExternalMerchant.json.null");
            return null;
        }
        return json;
    }

    public boolean addExternalMerchant(String key, String parterId) {
        if (StringUtils.isEmpty((String)parterId)) {
            this.logger.debug(SYS_CODE, (Object)".addExternalMerchant.parterId.null");
            return false;
        }
        DisUtil.setMap((String)VFOOAUTHTOKENEXTERNALMERCHANT_PRO, (String)key, (String)parterId);
        return true;
    }

    public void removeExternalMerchant(String key) {
        DisUtil.delMap((String)VFOOAUTHTOKENEXTERNALMERCHANT_PRO, (String[])new String[]{key});
    }

    public boolean needToInit() {
        String flag = this.getInitFlag();
        if (StringUtils.isEmpty((String)flag)) {
            this.logger.debug(SYS_CODE, (Object)".needToInit.flag.null");
            return true;
        }
        if (flag.equals(SWITCH_STATUS_SUCCESS) || flag.equals(SWITCH_STATUS_LOADING)) {
            return false;
        }
        return flag.equals(SWITCH_STATUS_FAILED);
    }

    public boolean isSuccess() {
        String flag = this.getInitFlag();
        return flag.equals(SWITCH_STATUS_SUCCESS);
    }

    public String getInitFlag() {
        return DisUtil.get((String)VFOOAUTHTOKENSWITCH_PRO);
    }

    public void setInitFlag(String flag) {
        DisUtil.set((String)VFOOAUTHTOKENSWITCH_PRO, (String)flag);
    }

    public String getTokenExit(String userName, String tenantCode, String browType) {
        String key = tenantCode + "_" + browType + "_" + userName;
        String tokenid = DisUtil.getMap((String)TokenLogin, (String)key);
        return tokenid;
    }

    public void ClearTokenExit(String userName, String tenantCode, String browType) {
        String key = tenantCode + "_" + browType + "_" + userName;
        DisUtil.delMap((String)TokenLogin, (String[])new String[]{key});
    }

    public void setTokenExit(String userName, String tenantCode, String browType, String tokenID) {
        String key = tenantCode + "_" + browType + "_" + userName;
        DisUtil.setMap((String)TokenLogin, (String)key, (String)tokenID);
    }

    public UserSessionBean getSessionbyType(UserSessionBean userSesionBean, String browType, OsOAuthConfigListReDomain osOAuthConfigList) {
        String tokenid;
        String loginTenantCode = userSesionBean.getTenantCode();
        String oldTokenId = tokenid = this.getTokenExit(userSesionBean.getUserName(), loginTenantCode, browType);
        String accTokenType = osOAuthConfigList.getOauthConfigTokenplo();
        String group = GroupUtil.getGroupByCache(userSesionBean.getProappCode(), userSesionBean.getTenantCode());
        switch (Integer.valueOf(accTokenType)) {
            case 0: {
                this.removeToken(tokenid);
                this.ClearTokenExit(userSesionBean.getUserName(), loginTenantCode, browType);
                this.delUserSession(tokenid + "-" + group);
                OsOAuthToken osOAuthToken = new SaasOAuthTokenProducerImpl().accessToken(userSesionBean.getProappCode(), userSesionBean.getUserId().toString(), osOAuthConfigList.getOauthConfigTime().toString(), browType, loginTenantCode);
                tokenid = osOAuthToken.getOauthTokenToken();
                userSesionBean.setTicketTokenid(tokenid);
                this.addToken(tokenid, osOAuthToken);
                this.sendMnsOut(oldTokenId, userSesionBean.getUserRelname(), loginTenantCode);
                break;
            }
            case 1: {
                userSesionBean = this.getUserSession(tokenid + "-" + group);
                OsOAuthToken osOAuthToken = this.getToken(tokenid);
                if (osOAuthToken == null) {
                    osOAuthToken = new SaasOAuthTokenProducerImpl().accessToken(userSesionBean.getProappCode(), userSesionBean.getUserId().toString(), osOAuthConfigList.getOauthConfigTime().toString(), browType, loginTenantCode);
                    tokenid = osOAuthToken.getOauthTokenToken();
                    userSesionBean.setTicketTokenid(tokenid);
                    this.addToken(tokenid, osOAuthToken);
                }
                SaasOAuthTokenValidator saasOAuthTokenValidator = new SaasOAuthTokenValidator();
                saasOAuthTokenValidator.delay(osOAuthToken);
                break;
            }
            default: {
                userSesionBean = (UserSessionBean)DisUtil.getObjectJson((String)(tokenid + "-" + group), UserSessionBean.class);
                OsOAuthToken osOAuthToken = this.getToken(tokenid);
                if (osOAuthToken == null) {
                    osOAuthToken = new SaasOAuthTokenProducerImpl().accessToken(userSesionBean.getProappCode(), userSesionBean.getUserId().toString(), osOAuthConfigList.getOauthConfigTime().toString(), browType, loginTenantCode);
                    tokenid = osOAuthToken.getOauthTokenToken();
                    userSesionBean.setTicketTokenid(tokenid);
                    this.addToken(tokenid, osOAuthToken);
                }
                SaasOAuthTokenValidator saasOAuthTokenValidator = new SaasOAuthTokenValidator();
                saasOAuthTokenValidator.delay(osOAuthToken);
            }
        }
        return userSesionBean;
    }

    public void setUserSession(String key, UserSessionBean userSession) {
        DisUtil.setMap((String)"UserSession_key", (String)key, (String)JsonUtil.buildNormalBinder().toJson((Object)userSession));
    }

    public UserSessionBean getUserSession(String key) {
        String json = DisUtil.getMap((String)"UserSession_key", (String)key);
        return (UserSessionBean)JsonUtil.buildNormalBinder().getJsonToObject(json, UserSessionBean.class);
    }

    public void delUserSession(String key) {
        DisUtil.delMapVer((String)"UserSession_key", (String[])new String[]{key});
    }

    private void sendMnsOut(String tokenid, String userRelname, String tenantCode) {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("datetime", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
        String mnsconfigBusType = "12";
        mnsMap.put("mnslistSubject", "\u88ab\u8feb\u4e0b\u7ebf\u63d0\u9192");
        mnsMap.put("mnslistSource", "0");
        mnsMap.put("mnslistBusType", mnsconfigBusType);
        mnsMap.put("mnslistBusName", "\u88ab\u8feb\u4e0b\u7ebf\u63d0\u9192");
        mnsMap.put("mnslistExp", this.getMnslistExp(contentMap, "sys", "sys", tokenid, userRelname, "1", "1", DateUtil.getDateStr((String)"yyyy-MM-dd HH:mm:ss"), mnsconfigBusType));
        mnsMap.put("tenantCode", tenantCode);
        ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
        sendMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(mnsMap));
        this.inAsyncInvoke("mns.mns.saveSendMnslist", sendMap);
    }

    private String getMnslistExp(Map<String, String> contentMap, String imsgSuserCode, String imsgSuserName, String acceptCode, String acceptName, String pushObjType, String pushmsgJpushType, String pushSendDate, String businessObject) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(contentMap);
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> parm = new HashMap<String, String>();
        parm.put("code", acceptCode);
        parm.put("name", acceptName);
        receiverList.add(parm);
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("receiverList", JsonUtil.buildNormalBinder().toJson(receiverList));
        expMap.put("pushmsgType", pushObjType);
        expMap.put("pushmsgJpushType", pushmsgJpushType);
        expMap.put("pushmsgSenddate", pushSendDate);
        expMap.put("imsgSuserCode", imsgSuserCode);
        expMap.put("imsgSuserName", imsgSuserName);
        expMap.put("mnsconfigBusType", businessObject);
        expMap.put("paramMap", JsonUtil.buildNormalBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(expMap);
    }

    static {
        internalRouter = null;
        TokenLogin = "TokenLogin_pk";
    }
}

